/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.event;

import hardcorequesting.config.ModConfig;
import hardcorequesting.death.DeathType;
import hardcorequesting.items.ModItems;
import hardcorequesting.quests.QuestingData;
import java.util.Iterator;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class PlayerDeathEventListener {
    public PlayerDeathEventListener() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntityLiving();
            QuestingData.getQuestingData((EntityPlayer)player).die((EntityPlayer)player);
            DeathType.onDeath((EntityPlayer)player, event.getSource());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerDropItemsOnDeath(PlayerDropsEvent event) {
        if (event.getEntityPlayer() == null || event.getEntityPlayer() instanceof FakePlayer || event.isCanceled() || event.getEntityPlayer().field_70170_p.func_82736_K().func_82766_b("keepInventory") || ModConfig.LOSE_QUEST_BOOK_ON_DEATH) {
            return;
        }
        Iterator iter = event.getDrops().iterator();
        while (iter.hasNext()) {
            EntityItem entityItem = (EntityItem)iter.next();
            ItemStack stack = entityItem.func_92059_d();
            if (stack == null || !stack.func_77973_b().equals((Object)ModItems.book)) continue;
            event.getEntityPlayer().field_71071_by.func_70441_a(stack);
            iter.remove();
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.Clone event) {
        if (event.getEntityPlayer() == null || event.getEntityPlayer() instanceof FakePlayer || !event.isWasDeath() || event.isCanceled() || event.getEntityPlayer().field_70170_p.func_82736_K().func_82766_b("keepInventory") || ModConfig.LOSE_QUEST_BOOK_ON_DEATH) {
            return;
        }
        if (event.getOriginal().field_71071_by.func_70431_c(new ItemStack((Item)ModItems.book))) {
            ItemStack bookStack = new ItemStack((Item)ModItems.book);
            for (ItemStack stack : event.getOriginal().field_71071_by.field_70462_a) {
                if (!bookStack.func_77969_a(stack)) continue;
                bookStack = stack.func_77946_l();
                break;
            }
            event.getEntityPlayer().field_71071_by.func_70441_a(bookStack);
        }
    }
}

