/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.event;

import hardcorequesting.quests.QuestingData;
import hardcorequesting.quests.task.QuestTask;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class EventHandler {
    private static EventHandler instance;
    private List<QuestTask>[] registeredTasks = new List[Type.values().length];

    public EventHandler() {
        for (int i = 0; i < this.registeredTasks.length; ++i) {
            this.registeredTasks[i] = new ArrayList<QuestTask>();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        instance = this;
    }

    public static EventHandler instance() {
        return instance;
    }

    public void clear() {
        for (List<QuestTask> registeredTask : this.registeredTasks) {
            registeredTask.clear();
        }
    }

    public void add(QuestTask task, Type ... types) {
        for (Type type : types) {
            this.registeredTasks[type.ordinal()].add(task);
        }
    }

    public void remove(QuestTask task) {
        for (List<QuestTask> registeredTask : this.registeredTasks) {
            registeredTask.remove(task);
        }
    }

    @SubscribeEvent
    public void onEvent(TickEvent.ServerTickEvent event) {
        for (QuestTask task : this.getTasks(Type.SERVER)) {
            task.onServerTick(event);
        }
    }

    @SubscribeEvent
    public void onEvent(TickEvent.PlayerTickEvent event) {
        for (QuestTask task : this.getTasks(Type.PLAYER)) {
            task.onPlayerTick(event);
        }
    }

    @SubscribeEvent
    public void onEvent(LivingDeathEvent event) {
        for (QuestTask task : this.getTasks(Type.DEATH)) {
            task.onLivingDeath(event);
        }
    }

    @SubscribeEvent
    public void onEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (QuestingData.isQuestActive()) {
            QuestingData.spawnBook(event.player);
        }
    }

    @SubscribeEvent
    public void onEvent(PlayerEvent.ItemCraftedEvent event) {
        for (QuestTask task : this.getTasks(Type.CRAFTING)) {
            task.onCrafting(event);
        }
    }

    @SubscribeEvent
    public void onEvent(EntityItemPickupEvent event) {
        for (QuestTask task : this.getTasks(Type.PICK_UP)) {
            task.onItemPickUp(event);
        }
    }

    public void onEvent(BookOpeningEvent event) {
        for (QuestTask task : this.getTasks(Type.OPEN_BOOK)) {
            task.onOpenBook(event);
        }
    }

    public void onEvent(ReputationEvent event) {
        for (QuestTask task : this.getTasks(Type.REPUTATION_CHANGE)) {
            task.onReputationChange(event);
        }
    }

    private List<QuestTask> getTasks(Type type) {
        return this.registeredTasks[type.ordinal()];
    }

    public static class ReputationEvent {
        private EntityPlayer player;

        public ReputationEvent(EntityPlayer player) {
            this.player = player;
        }

        public EntityPlayer getPlayer() {
            return this.player;
        }
    }

    public static class BookOpeningEvent {
        private String playerName;
        private boolean isOpBook;
        private boolean isRealName;

        public BookOpeningEvent(String playerName, boolean isOpBook, boolean isRealName) {
            this.playerName = playerName;
            this.isOpBook = isOpBook;
            this.isRealName = isRealName;
        }

        public String getPlayerName() {
            return this.playerName;
        }

        public boolean isOpBook() {
            return this.isOpBook;
        }

        public boolean isRealName() {
            return this.isRealName;
        }

        public EntityPlayer getPlayer() {
            return QuestingData.getPlayerFromUsername(this.playerName);
        }
    }

    public static enum Type {
        SERVER,
        PLAYER,
        DEATH,
        CRAFTING,
        PICK_UP,
        OPEN_BOOK,
        REPUTATION_CHANGE;

    }
}

