/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.death;

import hardcorequesting.client.interfaces.GuiColor;
import hardcorequesting.death.DeathType;
import hardcorequesting.io.SaveHandler;
import hardcorequesting.network.NetworkManager;
import hardcorequesting.network.message.DeathStatsMessage;
import hardcorequesting.quests.QuestingData;
import hardcorequesting.util.Translator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class DeathStats {
    private static final DeathComparator deathComparator = new DeathComparator(-1);
    private static final DeathComparator[] deathTypeComparator = new DeathComparator[DeathType.values().length];
    private static Map<String, DeathStats> deathMap;
    private static DeathStats[] clientDeathList;
    private static DeathStats clientBest;
    private static DeathStats clientTotal;
    protected int[] deaths = new int[DeathType.values().length];
    private String uuid;
    private int totalDeaths = -1;

    public DeathStats(String uuid) {
        this.uuid = uuid;
    }

    public static DeathStats getBest() {
        return clientBest;
    }

    public static DeathStats getTotal() {
        return clientTotal;
    }

    public static List<DeathStats> getDeathStatsList() {
        return QuestingData.getData().values().stream().map(QuestingData::getDeathStat).collect(Collectors.toList());
    }

    public static void loadAll(boolean isClient, boolean remote) {
        deathMap = new HashMap<String, DeathStats>();
        try {
            for (DeathStats stats : SaveHandler.loadDeaths(SaveHandler.getFile("deaths", remote))) {
                deathMap.put(stats.uuid, stats);
            }
            if (isClient) {
                DeathStats.updateClientDeathList();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveAll() {
        try {
            SaveHandler.saveDeaths(SaveHandler.getLocalFile("deaths"));
        }
        catch (IOException e) {
            FMLLog.log((String)"HQM", (Level)Level.INFO, (String)"Failed saving bags", (Object[])new Object[0]);
        }
    }

    public static void resync() {
        NetworkManager.sendToAllPlayers(new DeathStatsMessage(FMLCommonHandler.instance().getMinecraftServerInstance().func_71264_H()));
    }

    private static void updateClientDeathList() {
        clientDeathList = new DeathStats[deathMap.size()];
        int id = 0;
        for (DeathStats deathStats : deathMap.values()) {
            deathStats.totalDeaths = -1;
            DeathStats.clientDeathList[id++] = deathStats;
        }
        clientBest = new DeathStatsBest();
        clientTotal = new DeathStatsTotal();
        Arrays.sort(clientDeathList, deathComparator);
    }

    public static DeathStats getDeathStats(String uuid) {
        DeathStats stats = deathMap.get(uuid);
        return stats == null ? new DeathStats(uuid) : stats;
    }

    public static DeathStats[] getDeathStats() {
        return clientDeathList;
    }

    public String getUuid() {
        return this.uuid;
    }

    @SideOnly(value=Side.CLIENT)
    public String getName() {
        if (Minecraft.func_71410_x().field_71441_e != null) {
            try {
                UUID uuid = UUID.fromString(this.uuid);
                EntityPlayer player = Minecraft.func_71410_x().field_71441_e.func_152378_a(uuid);
                if (player == null) {
                    return "<invalid>";
                }
                return player.getDisplayNameString();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this.uuid;
    }

    public String getDescription(int id) {
        return DeathType.values()[id].getName() + ": " + this.deaths[id];
    }

    public void increaseDeath(int id) {
        int n = id;
        this.deaths[n] = this.deaths[n] + 1;
        this.totalDeaths = -1;
        DeathStats.resync();
    }

    public void increaseDeath(int id, int count, boolean resync) {
        int n = id;
        this.deaths[n] = this.deaths[n] + count;
        this.totalDeaths = -1;
        if (resync) {
            DeathStats.resync();
        }
    }

    public int getTotalDeaths() {
        if (this.totalDeaths == -1) {
            this.totalDeaths = 0;
            for (int death : this.deaths) {
                this.totalDeaths += death;
            }
        }
        return this.totalDeaths;
    }

    public int getDeaths(int id) {
        return this.deaths[id];
    }

    static {
        for (int i = 0; i < deathTypeComparator.length; ++i) {
            DeathStats.deathTypeComparator[i] = new DeathComparator(i);
        }
    }

    private static class DeathStatsTotal
    extends DeathStats {
        private int[] count = new int[DeathType.values().length];

        private DeathStatsTotal() {
            super("hqm.deathStat.everyone");
            for (int i = 0; i < this.count.length; ++i) {
                for (DeathStats deathStats : clientDeathList) {
                    int n = i;
                    this.deaths[n] = this.deaths[n] + deathStats.getDeaths(i);
                    if (deathStats.getDeaths(i) <= 0) continue;
                    int n2 = i;
                    this.count[n2] = this.count[n2] + 1;
                }
            }
        }

        @Override
        public String getDescription(int id) {
            return super.getDescription(id) + "\n\n" + (this.count[id] == 0 ? (Object)((Object)GuiColor.RED) + Translator.translate("hqm.deathStat.noOneDied") : GuiColor.GREEN.toString() + this.count[id] + " " + Translator.translate("hqm.deathStat.player" + (this.count[id] == 1 ? "" : "s")) + " " + Translator.translate("hqm.deathStat.diedThisWay"));
        }

        @Override
        public String getName() {
            return Translator.translate(this.getUuid());
        }
    }

    private static class DeathStatsBest
    extends DeathStats {
        private static final String[] colourPrefixes = new String[]{GuiColor.YELLOW.toString(), GuiColor.LIGHT_GRAY.toString(), GuiColor.ORANGE.toString()};
        private static final String[] placePrefixes = new String[]{"first", "second", "third"};
        private String[] messages = new String[DeathType.values().length];

        private DeathStatsBest() {
            super("hqm.deathStat.worstPlayers");
            block0: for (int i = 0; i < this.messages.length; ++i) {
                Arrays.sort(clientDeathList, deathTypeComparator[i]);
                if (clientDeathList.length < 1) {
                    this.deaths[i] = 0;
                    this.messages[i] = (Object)((Object)GuiColor.RED) + Translator.translate("hqm.deathStat.noOneDied");
                    continue;
                }
                this.deaths[i] = clientDeathList[0].getDeaths(i);
                this.messages[i] = "";
                int currentValue = 0;
                int standing = 0;
                for (int j = 0; j < clientDeathList.length; ++j) {
                    int value = clientDeathList[j].getDeaths(i);
                    if (value < currentValue) {
                        standing = j;
                        if (value == 0 || standing >= 3) continue block0;
                    }
                    currentValue = value;
                    if (j != 0) {
                        int n = i;
                        this.messages[n] = this.messages[n] + "\n";
                    }
                    int n = i;
                    this.messages[n] = this.messages[n] + colourPrefixes[standing] + Translator.translate("hqm.deathStat." + placePrefixes[standing]);
                    int n2 = i;
                    this.messages[n2] = this.messages[n2] + (Object)((Object)GuiColor.WHITE) + " " + clientDeathList[j].getName() + ": " + clientDeathList[j].getDeaths(i);
                }
            }
        }

        @Override
        public String getName() {
            return Translator.translate(this.getUuid());
        }

        @Override
        public String getDescription(int id) {
            return DeathType.values()[id].getName() + "\n\n" + this.messages[id];
        }
    }

    private static class DeathComparator
    implements Comparator<DeathStats> {
        private int id;

        private DeathComparator(int id) {
            this.id = id;
        }

        @Override
        public int compare(DeathStats o1, DeathStats o2) {
            if (this.id == -1) {
                return Integer.valueOf(o2.getTotalDeaths()).compareTo(o1.getTotalDeaths());
            }
            return Integer.valueOf(o2.getDeaths(this.id)).compareTo(o1.getDeaths(this.id));
        }
    }
}

