/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.config;

import com.google.common.collect.Lists;
import hardcorequesting.HardcoreQuesting;
import hardcorequesting.client.KeyboardHandler;
import hardcorequesting.config.ModConfig;
import hardcorequesting.quests.Quest;
import java.io.File;
import java.io.IOException;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.io.FileUtils;

public class ConfigHandler {
    private static final String EDITOR_KEY = "UseEditor";
    private static final boolean EDITOR_DEFAULT = false;
    private static final String EDITOR_COMMENT = "Only use this as a map maker who wants to create quests. Leaving this off allows you the play the existing quests.";
    private static final String SAVE_DEFAULT_KEY = "SaveDefault";
    private static final boolean SAVE_DEFAULT_DEFAULT = true;
    private static final String SAVE_DEFAULT_COMMENT = "This will save quests in an general map used upon world creation";
    private static final String USE_DEFAULT_KEY = "UseDefault";
    private static final boolean USE_DEFAULT_DEFAULT = true;
    private static final String USE_DEFAULT_COMMENT = "Upon world load quests will be reloaded from the default";
    private static final String KEYMAP_KEY = "KeyMap";
    private static final String KEYMAP_COMMENT = "Hotkeys used in the book, one entry per line(Format: [key]:[mode]";
    public static Configuration syncConfig;
    private static String[] KEYMAP_DEFAULT;
    private static List<String> readMeText;

    public static void initModConfig(String configPath) {
        ModConfig.init(new File(configPath + "hqmconfig.cfg"));
        MinecraftForge.EVENT_BUS.register((Object)new ModConfig());
    }

    public static void initEditConfig(String configPath) {
        if (new File(configPath, "default").exists()) {
            FMLLog.warning((String)"[HQM] Detected old HQM quest files! These aren't fully compatible with the newer versions. To disable this message, delete the 'default' folder.", (Object[])new Object[0]);
        }
        try {
            FileUtils.writeLines((File)new File(configPath, "ReadMe.txt"), readMeText);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (syncConfig == null) {
            syncConfig = new Configuration(new File(configPath + "editmode.cfg"));
            ConfigHandler.loadSyncConfig();
        }
    }

    public static void loadSyncConfig() {
        Quest.isEditing = syncConfig.get("general", EDITOR_KEY, false, EDITOR_COMMENT).getBoolean(false);
        Quest.saveDefault = syncConfig.get("general", SAVE_DEFAULT_KEY, true, SAVE_DEFAULT_COMMENT).getBoolean(true);
        Quest.useDefault = syncConfig.get("general", USE_DEFAULT_KEY, true, USE_DEFAULT_COMMENT).getBoolean(true);
        if (HardcoreQuesting.proxy.isClient()) {
            if (KEYMAP_DEFAULT == null) {
                KEYMAP_DEFAULT = KeyboardHandler.getDefault();
            }
            KeyboardHandler.fromConfig(syncConfig.get("general", KEYMAP_KEY, KEYMAP_DEFAULT, KEYMAP_COMMENT).getStringList());
        }
        if (syncConfig.hasChanged()) {
            syncConfig.save();
        }
    }

    static {
        KEYMAP_DEFAULT = null;
        readMeText = Lists.newArrayList((Object[])new String[]{"How to copy quests to a server:", "In HQM for 1.11.2 the file copying to a server works again. Copy the hqm/quests to the server side config hqm/quests.", "There is a config option to automatically sync the server quests to the client."});
    }
}

