/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.commands;

import com.google.gson.reflect.TypeToken;
import hardcorequesting.HardcoreQuesting;
import hardcorequesting.bag.GroupTier;
import hardcorequesting.commands.CommandBase;
import hardcorequesting.io.SaveHandler;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestSet;
import hardcorequesting.reputation.Reputation;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;

public class CommandSave
extends CommandBase {
    public CommandSave() {
        super("save", "all", "bags");
    }

    private static boolean stringsMatch(String[] sub, String[] search) {
        for (int i = 0; i < sub.length; ++i) {
            if (sub[i].equalsIgnoreCase(search[i])) continue;
            return false;
        }
        return true;
    }

    private static void save(ICommandSender sender, Object object, Type type, String name) throws CommandException {
        try {
            File file = SaveHandler.save(SaveHandler.getExportFile(name), object, type);
            sender.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74837_a((String)"hqm.command.savedTo", (Object[])new Object[]{file.getPath().substring(HardcoreQuesting.configDir.getParentFile().getParent().length())})));
        }
        catch (IOException e) {
            throw new CommandException("hqm.command.saveFailed", new Object[]{name});
        }
    }

    @Override
    public void handleCommand(ICommandSender sender, String[] arguments) throws CommandException {
        if (arguments.length == 1 && arguments[0].equals("all")) {
            try {
                CommandSave.save(sender, Reputation.getReputations(), new TypeToken<List<Reputation>>(){}.getType(), "reputations");
                CommandSave.save(sender, GroupTier.getTiers(), new TypeToken<List<GroupTier>>(){}.getType(), "bags");
            }
            catch (CommandException commandException) {
                // empty catch block
            }
            for (QuestSet set : Quest.getQuestSets()) {
                try {
                    CommandSave.save(sender, set, new TypeToken<QuestSet>(){}.getType(), set.getFilename());
                }
                catch (CommandException commandException) {}
            }
            try {
                SaveHandler.saveQuestSetList(Quest.getQuestSets(), SaveHandler.getExportFile("sets"));
            }
            catch (IOException iOException) {}
        } else if (arguments.length == 1 && arguments[0].equals("bags")) {
            CommandSave.save(sender, GroupTier.getTiers(), new TypeToken<List<GroupTier>>(){}.getType(), "bags");
        } else if (arguments.length > 0) {
            for (QuestSet set : Quest.getQuestSets()) {
                String[] name = set.getName().split(" ");
                if (name.length < arguments.length && CommandSave.stringsMatch(name, arguments)) {
                    String fileName = "";
                    for (String subName : Arrays.copyOfRange(arguments, name.length, arguments.length)) {
                        fileName = fileName + subName + " ";
                    }
                    fileName = fileName.substring(0, fileName.length() - 1);
                    CommandSave.save(sender, set, new TypeToken<QuestSet>(){}.getType(), fileName);
                    return;
                }
                if (name.length != arguments.length || !CommandSave.stringsMatch(name, arguments)) continue;
                CommandSave.save(sender, set, new TypeToken<QuestSet>(){}.getType(), set.getName());
                return;
            }
            String arg = "";
            for (String subName : arguments) {
                arg = arg + subName + " ";
            }
            arg = arg.substring(0, arg.length() - 1);
            throw new CommandException("hqm.command.questNotFound", new Object[]{arg});
        }
    }

    @Override
    public List<String> addTabCompletionOptions(ICommandSender sender, String[] args) {
        String text = this.getCombinedArgs(args);
        Pattern pattern = Pattern.compile("^" + Pattern.quote(text), 2);
        List<String> results = super.addTabCompletionOptions(sender, args);
        for (QuestSet set : Quest.getQuestSets()) {
            if (!pattern.matcher(set.getName()).find()) continue;
            results.add(set.getName());
        }
        return results;
    }

    @Override
    public int[] getSyntaxOptions(ICommandSender sender) {
        return new int[]{0, 1, 2};
    }
}

