/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.commands;

import hardcorequesting.HardcoreQuesting;
import hardcorequesting.bag.GroupTier;
import hardcorequesting.commands.CommandBase;
import hardcorequesting.io.SaveHandler;
import hardcorequesting.io.adapter.QuestAdapter;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestSet;
import hardcorequesting.quests.QuestingData;
import hardcorequesting.reputation.Reputation;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;

public class CommandLoad
extends CommandBase {
    public CommandLoad() {
        super("load", "all");
    }

    @Override
    public void handleCommand(ICommandSender sender, String[] arguments) throws CommandException {
        try {
            if (arguments.length == 1 && arguments[0].equals("all")) {
                this.loadReputation(sender, SaveHandler.getExportFile("reputations"));
                for (File file : this.getPossibleFiles(SaveHandler.QUEST_SET_FILTER)) {
                    this.loadSet(sender, file);
                }
                QuestAdapter.postLoad();
                QuestSet.orderAll(HardcoreQuesting.loadingSide.isServer());
            } else if (arguments.length == 1 && arguments[0].equals("bags")) {
                this.loadBags(sender, SaveHandler.getExportFile("bags"));
            } else if (arguments.length > 0) {
                String file = this.getCombinedArgs(arguments);
                this.loadSet(sender, SaveHandler.getExportFile(file));
                QuestAdapter.postLoad();
            }
        }
        catch (IOException e) {
            throw new CommandException(e.getMessage(), new Object[0]);
        }
    }

    private File[] getPossibleFiles(FileFilter filter) {
        return SaveHandler.getExportFolder().listFiles(filter);
    }

    private void loadSet(ICommandSender sender, File file) throws CommandException {
        if (!file.exists()) {
            throw new CommandException("hqm.command.fileNotFound", new Object[0]);
        }
        try {
            QuestSet set;
            if (sender instanceof EntityPlayer) {
                HardcoreQuesting.setPlayer((EntityPlayer)sender);
            }
            if ((set = SaveHandler.loadQuestSet(file)) == null) {
                throw new CommandException("hqm.command.loadFailed", new Object[0]);
            }
            sender.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74837_a((String)"hqm.command.loadSuccess", (Object[])new Object[]{set.getName()})));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommandException("hqm.command.loadFailed", new Object[0]);
        }
    }

    private void loadReputation(ICommandSender sender, File file) throws CommandException {
        if (!file.exists()) {
            throw new CommandException("hqm.command.fileNotFound", new Object[0]);
        }
        try {
            if (sender instanceof EntityPlayer) {
                HardcoreQuesting.setPlayer((EntityPlayer)sender);
            }
            List<Reputation> reputations = SaveHandler.loadReputations(file);
            Reputation.clear();
            for (Reputation reputation : reputations) {
                if (reputation != null) {
                    Reputation.addReputation(reputation);
                    sender.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74837_a((String)"hqm.command.loadSuccess", (Object[])new Object[]{"Reputation: " + reputation.getName()})));
                    continue;
                }
                throw new CommandException("hqm.command.loadFailed", new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommandException("hqm.command.loadFailed", new Object[0]);
        }
    }

    private void loadBags(ICommandSender sender, File file) throws CommandException {
        if (!file.exists()) {
            throw new CommandException("hqm.command.fileNotFound", new Object[0]);
        }
        try {
            List<GroupTier> bags;
            if (sender instanceof EntityPlayer) {
                HardcoreQuesting.setPlayer((EntityPlayer)sender);
            }
            if ((bags = SaveHandler.loadBags(file)) == null) {
                throw new CommandException("hqm.command.loadFailed", new Object[0]);
            }
            GroupTier.getTiers().clear();
            GroupTier.getTiers().addAll(bags);
            sender.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74837_a((String)"hqm.command.loadSuccess", (Object[])new Object[]{"Bags"})));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommandException("hqm.command.loadFailed", new Object[0]);
        }
    }

    @Override
    public List<String> addTabCompletionOptions(ICommandSender sender, String[] args) {
        String text = this.getCombinedArgs(args);
        Pattern pattern = Pattern.compile("^" + Pattern.quote(text), 2);
        List<String> results = super.addTabCompletionOptions(sender, args);
        for (File file : this.getPossibleFiles(SaveHandler.QUEST_SET_FILTER)) {
            if (!pattern.matcher(file.getName()).find()) continue;
            results.add(file.getName().replace(".json", ""));
        }
        return results;
    }

    @Override
    public boolean isVisible(ICommandSender sender) {
        return Quest.isEditing && sender instanceof EntityPlayer && QuestingData.hasData((EntityPlayer)sender) && super.isVisible(sender);
    }

    @Override
    public int[] getSyntaxOptions(ICommandSender sender) {
        return new int[]{0, 1, 2};
    }
}

