/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.commands;

import hardcorequesting.commands.CommandBase;
import hardcorequesting.config.ModConfig;
import hardcorequesting.quests.QuestingData;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class CommandLives
extends CommandBase {
    private static String ADD = "add";
    private static String REMOVE = "remove";

    public CommandLives() {
        super("lives", ADD, REMOVE);
        this.permissionLevel = 0;
    }

    @Override
    public List<String> addTabCompletionOptions(ICommandSender sender, String[] args) {
        if (this.isPlayerOp(sender)) {
            return super.addTabCompletionOptions(sender, args);
        }
        return null;
    }

    @Override
    public boolean isVisible(ICommandSender sender) {
        return true;
    }

    @Override
    public int[] getSyntaxOptions(ICommandSender sender) {
        int[] nArray;
        if (this.isPlayerOp(sender)) {
            int[] nArray2 = new int[4];
            nArray2[0] = 0;
            nArray2[1] = 1;
            nArray2[2] = 2;
            nArray = nArray2;
            nArray2[3] = 3;
        } else {
            nArray = super.getSyntaxOptions(sender);
        }
        return nArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleCommand(ICommandSender sender, String[] arguments) throws CommandException {
        if (!QuestingData.isHardcoreActive()) {
            this.sendChat(sender, "hqm.message.noHardcoreYet", new Object[0]);
            return;
        }
        if (arguments.length == 0 && sender instanceof EntityPlayer) {
            this.currentLives((EntityPlayer)sender);
        }
        if (!this.isPlayerOp(sender)) {
            throw new CommandException("hqm.command.noPermission", new Object[0]);
        }
        if (arguments.length == 1) {
            if (arguments[0].matches(REMOVE)) {
                if (!(sender instanceof EntityPlayer)) return;
                this.removeLives((EntityPlayer)sender, 1);
                return;
            } else if (arguments[0].matches(ADD)) {
                if (!(sender instanceof EntityPlayer)) return;
                this.addLives((EntityPlayer)sender, 1);
                return;
            } else {
                this.getPlayerLives(sender, arguments[0]);
            }
            return;
        }
        if (arguments.length == 2) {
            if (arguments[0].matches(REMOVE)) {
                try {
                    int amount = Integer.parseInt(arguments[1]);
                    if (amount < 0) {
                        throw new WrongUsageException("hqm.message.positiveNumbers", new Object[0]);
                    }
                    if (!(sender instanceof EntityPlayer)) return;
                    this.removeLives((EntityPlayer)sender, amount);
                    return;
                }
                catch (Exception e) {
                    throw new WrongUsageException("hqm.message.posNumberAndPlayer", new Object[0]);
                }
            } else if (arguments[1].matches(REMOVE)) {
                try {
                    this.removeLivesFrom(sender, arguments[1], 1);
                    return;
                }
                catch (Exception e) {
                    throw new WrongUsageException("hqm.message.posNumberAndPlayer", new Object[0]);
                }
            } else if (arguments[0].matches(ADD)) {
                try {
                    int amount = Integer.parseInt(arguments[1]);
                    if (amount < 0) {
                        throw new WrongUsageException("hqm.message.positiveNumbers", new Object[0]);
                    }
                    if (!(sender instanceof EntityPlayer)) return;
                    this.addLives((EntityPlayer)sender, amount);
                    return;
                }
                catch (Exception e) {
                    throw new WrongUsageException("hqm.message.positiveNumbers", new Object[0]);
                }
            } else {
                if (!arguments[0].matches(ADD)) return;
                try {
                    this.addLivesTo(sender, arguments[1], 1);
                    return;
                }
                catch (Exception e) {
                    throw new WrongUsageException("hqm.message.posNumberAndPlayer", new Object[0]);
                }
            }
        }
        if (arguments.length != 3) return;
        if (arguments[0].matches(REMOVE)) {
            try {
                int amount = Integer.parseInt(arguments[2]);
                if (amount < 0) {
                    throw new WrongUsageException("hqm.message.positiveNumbers", new Object[0]);
                }
                this.removeLivesFrom(sender, arguments[1], amount);
                return;
            }
            catch (Exception e) {
                throw new WrongUsageException("hqm.message.posNumberAndPlayer", new Object[0]);
            }
        }
        if (!arguments[0].matches(ADD)) return;
        try {
            int amount = Integer.parseInt(arguments[2]);
            if (amount < 0) {
                throw new WrongUsageException("hqm.message.positiveNumbers", new Object[0]);
            }
            this.addLivesTo(sender, arguments[1], amount);
            return;
        }
        catch (Exception e) {
            throw new WrongUsageException("hqm.message.posNumberAndPlayer", new Object[0]);
        }
    }

    private void removeLives(EntityPlayer player, int amount) {
        if (QuestingData.getQuestingData(player).getLives() - amount < QuestingData.getQuestingData(player).getLivesToStayAlive()) {
            int lives = QuestingData.getQuestingData(player).getLives();
            this.sendChat((ICommandSender)player, lives != 1, "hqm.message.cantRemoveLives", lives);
        } else {
            QuestingData.getQuestingData(player).removeLives(player, amount);
            this.sendChat((ICommandSender)player, amount != 1, "hqm.message.removeLives", amount);
            this.currentLives(player);
        }
    }

    private void removeLivesFrom(ICommandSender sender, String playerName, int amount) {
        EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(playerName);
        QuestingData.getQuestingData((EntityPlayer)player).removeLives((EntityPlayer)((EntityPlayerMP)sender), amount);
        this.sendChat(sender, amount != 1, "hqm.message.removeLivesFrom", amount, playerName);
        this.sendChat((ICommandSender)player, amount != 1, "hqm.message.removeLivesBy", amount, sender.func_70005_c_());
        this.currentLives((EntityPlayer)player);
    }

    private void addLives(EntityPlayer player, int amount) {
        if (QuestingData.getQuestingData(player).getRawLives() + amount <= ModConfig.MAXLIVES) {
            QuestingData.getQuestingData(player).addLives(player, amount);
            this.sendChat((ICommandSender)player, amount != 1, "hqm.message.addLives", amount);
            this.currentLives(player);
        } else {
            QuestingData.getQuestingData(player).addLives(player, amount);
            this.sendChat((ICommandSender)player, ModConfig.MAXLIVES != 1, "hqm.message.cantAddLives", ModConfig.MAXLIVES);
            this.currentLives(player);
        }
    }

    private void addLivesTo(ICommandSender sender, String playerName, int amount) {
        EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(playerName);
        if (QuestingData.getQuestingData((EntityPlayer)player).getRawLives() + amount <= ModConfig.MAXLIVES) {
            QuestingData.getQuestingData((EntityPlayer)player).addLives((EntityPlayer)player, amount);
            this.sendChat(sender, amount != 1, "hqm.message.addLivesTo", amount, playerName);
            this.sendChat((ICommandSender)player, amount != 1, "hqm.message.addLivesBy", amount, sender.func_70005_c_());
            this.currentLives((EntityPlayer)player);
        } else {
            QuestingData.getQuestingData((EntityPlayer)player).addLives((EntityPlayer)player, amount);
            this.sendChat(sender, "hqm.message.cantGiveMoreLives", playerName, ModConfig.MAXLIVES);
            this.sendChat(sender, "hqm.massage.setLivesInstead", player, ModConfig.MAXLIVES);
            this.sendChat((ICommandSender)player, "hqm.massage.setLivesBy", ModConfig.MAXLIVES, sender.func_70005_c_());
            this.currentLives((EntityPlayer)player);
        }
    }

    private void getPlayerLives(ICommandSender sender, String playerName) throws CommandException {
        EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(playerName);
        if (player == null) {
            throw new CommandException("hqm.message.noPlayer", new Object[0]);
        }
        int lives = QuestingData.getQuestingData((EntityPlayer)player).getLives();
        this.sendChat(sender, lives != 1, "hqm.message.hasLivesRemaining", playerName, lives);
    }
}

