/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.commands;

import com.mojang.authlib.GameProfile;
import hardcorequesting.commands.CommandEdit;
import hardcorequesting.commands.CommandEnable;
import hardcorequesting.commands.CommandHardcore;
import hardcorequesting.commands.CommandHelp;
import hardcorequesting.commands.CommandLives;
import hardcorequesting.commands.CommandLoad;
import hardcorequesting.commands.CommandQuest;
import hardcorequesting.commands.CommandSave;
import hardcorequesting.commands.CommandVersion;
import hardcorequesting.commands.ISubCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandNotFoundException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class CommandHandler
extends CommandBase {
    public static Map<String, ISubCommand> commands = new LinkedHashMap<String, ISubCommand>();
    public static CommandHandler instance = new CommandHandler();

    public static void register(ISubCommand command) {
        commands.put(command.getCommandName(), command);
    }

    public static boolean commandExists(String name) {
        return commands.containsKey(name);
    }

    public static boolean isOwnerOrOp(ICommandSender sender) {
        if (sender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender;
            GameProfile username = player.func_146103_bH();
            return CommandHandler.isCommandsAllowedOrOwner(sender, username);
        }
        return true;
    }

    public static boolean isCommandsAllowedOrOwner(ICommandSender sender, GameProfile username) {
        return sender.func_184102_h().func_184103_al().func_152596_g(username) || sender.func_184102_h().func_71264_H() && sender.func_184102_h().func_71214_G().equals(username.getName());
    }

    public static ISubCommand getCommand(String commandName) {
        return commands.get(commandName);
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            String subCommand = args[0];
            ArrayList<String> result = new ArrayList<String>();
            for (ISubCommand command : commands.values()) {
                if (!command.isVisible(sender) || !command.getCommandName().startsWith(subCommand)) continue;
                result.add(command.getCommandName());
            }
            return result;
        }
        if (commands.containsKey(args[0]) && commands.get(args[0]).isVisible(sender)) {
            return commands.get(args[0]).addTabCompletionOptions(sender, Arrays.copyOfRange(args, 1, args.length));
        }
        return new ArrayList<String>();
    }

    public String func_71517_b() {
        return "hqm";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/" + this.func_71517_b() + " help";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        ISubCommand command;
        if (args.length < 1) {
            args = new String[]{"help"};
        }
        if ((command = commands.get(args[0])) != null) {
            if (command.isVisible(sender) && (sender.func_70003_b(command.getPermissionLevel(), this.func_71517_b() + " " + command.getCommandName()) || sender.func_70005_c_().equals(server.func_71214_G()))) {
                command.handleCommand(sender, Arrays.copyOfRange(args, 1, args.length));
                return;
            }
            throw new CommandException("hqm.command.noPermission", new Object[0]);
        }
        throw new CommandNotFoundException("hqm.command.notFound", new Object[0]);
    }

    static {
        CommandHandler.register(new CommandHelp());
        CommandHandler.register(new CommandVersion());
        CommandHandler.register(new CommandQuest());
        CommandHandler.register(new CommandHardcore());
        CommandHandler.register(new CommandLives());
        CommandHandler.register(new CommandEdit());
        CommandHandler.register(new CommandEnable());
        CommandHandler.register(new CommandSave());
        CommandHandler.register(new CommandLoad());
    }
}

