/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.commands;

import hardcorequesting.commands.CommandHandler;
import hardcorequesting.commands.ISubCommand;
import hardcorequesting.quests.QuestingData;
import hardcorequesting.util.Translator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public abstract class CommandBase
implements ISubCommand {
    protected int permissionLevel = 3;
    private String name;
    private List<String> subCommands = new ArrayList<String>();

    public CommandBase(String name, String ... subCommands) {
        this.name = name;
        this.subCommands = Arrays.asList(subCommands);
    }

    @Override
    public int getPermissionLevel() {
        return this.permissionLevel;
    }

    @Override
    public String getCommandName() {
        return this.name;
    }

    @Override
    public List<String> addTabCompletionOptions(ICommandSender sender, String[] args) {
        ArrayList<String> results = new ArrayList<String>();
        if (args.length == 1) {
            for (String subCommand : this.subCommands) {
                if (!subCommand.startsWith(args[0])) continue;
                results.add(subCommand);
            }
        }
        return results;
    }

    @Override
    public boolean isVisible(ICommandSender sender) {
        return this.getPermissionLevel() <= 0 || this.isPlayerOp(sender);
    }

    @Override
    public int[] getSyntaxOptions(ICommandSender sender) {
        return new int[]{0};
    }

    public String getCombinedArgs(String[] args) {
        String text = "";
        for (String arg : args) {
            text = text + arg + " ";
        }
        return text.substring(0, text.length() - 1);
    }

    protected void sendChat(ICommandSender sender, String key, Object ... args) {
        this.sendChat(sender, false, key, args);
    }

    protected void sendChat(ICommandSender sender, boolean plural, String key, Object ... args) {
        sender.func_145747_a((ITextComponent)new TextComponentString(Translator.translate(plural, key, args)));
    }

    protected boolean isPlayerOp(ICommandSender sender) {
        return CommandHandler.isOwnerOrOp(sender);
    }

    protected void currentLives(EntityPlayer player) {
        this.sendChat((ICommandSender)player, "You currently have " + QuestingData.getQuestingData(player).getLives() + " live(s) left.", new Object[0]);
    }
}

