/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.client.sounds;

import com.google.common.collect.Lists;
import hardcorequesting.client.ClientChange;
import hardcorequesting.client.sounds.ClientSound;
import hardcorequesting.client.sounds.LoreResourcePack;
import hardcorequesting.client.sounds.Sounds;
import hardcorequesting.network.NetworkManager;
import hardcorequesting.quests.QuestingData;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundList;
import net.minecraft.client.resources.FallbackResourceManager;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SoundHandler {
    private static final String LABEL = "lore";
    private static List<String> paths = new ArrayList<String>();
    private static int loreNumber;
    private static boolean loreMusic;
    @SideOnly(value=Side.CLIENT)
    private static ISound loreSound;

    private SoundHandler() {
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean loadLoreReading(String path) {
        loreMusic = false;
        loreNumber = -1;
        int index = paths.indexOf(path);
        if (index == -1) {
            if (new File(path + "lore.ogg").exists()) {
                int number = paths.size();
                Map resourceManagers = (Map)ReflectionHelper.getPrivateValue(SimpleReloadableResourceManager.class, (Object)((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()), (int)2);
                FallbackResourceManager resourceManager = (FallbackResourceManager)resourceManagers.get("hardcorequesting");
                resourceManager.func_110538_a((IResourcePack)new LoreResourcePack(new File(path)));
                net.minecraft.client.audio.SoundHandler handler = Minecraft.func_71410_x().func_147118_V();
                Sound entry = new Sound(LABEL + number, 1.0f, 1.0f, 0, Sound.Type.SOUND_EVENT, true);
                SoundList list = new SoundList((List)Lists.newArrayList((Object[])new Sound[]{entry}), true, "sub");
                Method method = ReflectionHelper.findMethod(net.minecraft.client.audio.SoundHandler.class, (Object)handler, (String[])new String[]{"loadSoundResource", "func_147693_a", "a"}, (Class[])new Class[]{ResourceLocation.class, SoundList.class});
                if (method == null || handler == null) {
                    return false;
                }
                try {
                    method.invoke((Object)handler, new ResourceLocation("hardcorequesting", LABEL + number), list);
                    loreMusic = true;
                    loreNumber = number;
                    paths.add(path);
                    return true;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
        } else {
            loreNumber = index;
            loreMusic = true;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void playLoreMusic() {
        loreSound = SoundHandler.play(LABEL + loreNumber, 4.0f, 1.0f);
    }

    public static void play(Sounds sound, EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            NetworkManager.sendToPlayer(ClientChange.SOUND.build((Object)sound), (EntityPlayerMP)player);
        }
    }

    public static void playToAll(Sounds sound) {
        NetworkManager.sendToAllPlayers(ClientChange.SOUND.build((Object)sound));
    }

    @SideOnly(value=Side.CLIENT)
    private static ISound play(String sound, float volume, float pitch) {
        return SoundHandler.play(new ResourceLocation("hardcorequesting", sound), volume, pitch);
    }

    @SideOnly(value=Side.CLIENT)
    private static ISound play(ResourceLocation resource, float volume, float pitch) {
        ClientSound soundObj = new ClientSound(resource, volume, pitch);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)soundObj);
        return soundObj;
    }

    public static void stopLoreMusic() {
        if (SoundHandler.isLorePlaying()) {
            new Thread(() -> {
                while (SoundHandler.isLorePlaying()) {
                    Minecraft.func_71410_x().func_147118_V().func_147683_b(loreSound);
                }
                loreSound = null;
            }).start();
        }
    }

    public static boolean isLorePlaying() {
        boolean value;
        boolean bl = value = loreSound != null && Minecraft.func_71410_x().func_147118_V().func_147692_c(loreSound);
        if (!value) {
            loreSound = null;
        }
        return value;
    }

    public static boolean hasLoreMusic() {
        return loreMusic;
    }

    public static void handleSoundPacket(Sounds sound) {
        SoundHandler.play(sound.getSoundName(), 1.0f, 1.0f);
    }

    public static void triggerFirstLore() {
        NetworkManager.sendToServer(ClientChange.LORE.build(null));
        SoundHandler.playLoreMusic();
    }

    public static void handleLorePacket(EntityPlayer player) {
        QuestingData.getQuestingData((EntityPlayer)player).playedLore = true;
    }

    static {
        loreMusic = false;
    }
}

