/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.client.interfaces.edit;

import hardcorequesting.bag.BagTier;
import hardcorequesting.bag.GroupTier;
import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiColor;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.client.interfaces.ResourceHelper;
import hardcorequesting.client.interfaces.TextBoxGroup;
import hardcorequesting.client.interfaces.edit.GuiEditMenu;
import hardcorequesting.util.SaveHelper;
import hardcorequesting.util.Translator;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;

public class GuiEditMenuTier
extends GuiEditMenu {
    private static final int ARROW_X_LEFT = 20;
    private static final int ARROW_X_RIGHT = 150;
    private static final int ARROW_Y = 40;
    private static final int ARROW_SRC_X = 244;
    private static final int ARROW_SRC_Y = 176;
    private static final int ARROW_W = 6;
    private static final int ARROW_H = 10;
    private static final int TIERS_TEXT_X = 20;
    private static final int TIERS_TEXT_Y = 20;
    private static final int TIERS_WEIGHTS_X = 30;
    private static final int TIERS_WEIGHTS_Y = 80;
    private static final int TIERS_WEIGHTS_SPACING = 15;
    private static final int TIERS_TEXT_BOX_X = 65;
    private static final int TIERS_TEXT_BOX_Y = -2;
    private static final int TIERS_WEIGHTS_TEXT_Y = 65;
    private GroupTier tier;
    private GroupTier original;
    private TextBoxGroup textBoxes;
    private boolean clicked;

    public GuiEditMenuTier(GuiQuestBook gui, EntityPlayer player, GroupTier original) {
        super(gui, player, true);
        this.original = original;
        this.tier = original.copy();
        this.textBoxes = new TextBoxGroup();
        BagTier[] values = BagTier.values();
        int i = 0;
        while (i < values.length) {
            final int id = i++;
            this.textBoxes.add(new TextBoxGroup.TextBox(gui, String.valueOf(this.tier.getWeights()[id]), 95, 80 + 15 * id + -2, false){

                @Override
                protected boolean isCharacterValid(char c) {
                    return this.getText().length() < 6 && Character.isDigit(c);
                }

                @Override
                public void textChanged(GuiBase gui) {
                    try {
                        int number = this.getText().equals("") ? 1 : Integer.parseInt(this.getText());
                        ((GuiEditMenuTier)GuiEditMenuTier.this).tier.getWeights()[id] = number;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    @Override
    public void draw(GuiBase gui, int mX, int mY) {
        super.draw(gui, mX, mY);
        gui.drawString(this.tier.getName(), 20, 20, this.tier.getColor().getHexColor());
        gui.drawString(Translator.translate("hqm.menuTier.weights"), 20, 65, 0x404040);
        BagTier[] values = BagTier.values();
        for (int i = 0; i < values.length; ++i) {
            BagTier bagTier = values[i];
            int posY = 80 + i * 15;
            gui.drawString(bagTier.getColor().toString() + bagTier.getName(), 30, posY, 0x404040);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
        this.drawArrow(gui, mX, mY, true);
        this.drawArrow(gui, mX, mY, false);
        gui.drawCenteredString(this.tier.getColor().getName(), 26, 40, 1.0f, 124, 10, 0x404040);
        this.textBoxes.draw(gui);
    }

    @Override
    public void onClick(GuiBase gui, int mX, int mY, int b) {
        super.onClick(gui, mX, mY, b);
        if (this.inArrowBounds(gui, mX, mY, true)) {
            this.tier.setColor(GuiColor.values()[(this.tier.getColor().ordinal() + GuiColor.values().length - 1) % GuiColor.values().length]);
            this.clicked = true;
        } else if (this.inArrowBounds(gui, mX, mY, false)) {
            this.tier.setColor(GuiColor.values()[(this.tier.getColor().ordinal() + 1) % GuiColor.values().length]);
            this.clicked = true;
        }
        this.textBoxes.onClick(gui, mX, mY);
    }

    @Override
    public void onKeyTyped(GuiBase gui, char c, int k) {
        super.onKeyTyped(gui, c, k);
        this.textBoxes.onKeyStroke(gui, c, k);
    }

    @Override
    public void onRelease(GuiBase gui, int mX, int mY) {
        super.onRelease(gui, mX, mY);
        this.clicked = false;
    }

    @Override
    public void save(GuiBase gui) {
        this.original.load(this.tier);
        SaveHelper.add(SaveHelper.EditType.TIER_CHANGE);
    }

    private boolean inArrowBounds(GuiBase gui, int mX, int mY, boolean left) {
        return gui.inBounds(left ? 20 : 150, 40, 6, 10, mX, mY);
    }

    private void drawArrow(GuiBase gui, int mX, int mY, boolean left) {
        int srcX = 244 + (left ? 0 : 6);
        int srcY = 176 + (this.inArrowBounds(gui, mX, mY, left) ? (this.clicked ? 1 : 2) : 0) * 10;
        gui.drawRect(left ? 20 : 150, 40, srcX, srcY, 6, 10);
    }
}

