/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.client.interfaces.edit;

import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiColor;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.client.interfaces.LargeButton;
import hardcorequesting.client.interfaces.ResourceHelper;
import hardcorequesting.client.interfaces.ScrollBar;
import hardcorequesting.client.interfaces.TextBoxGroup;
import hardcorequesting.client.interfaces.edit.GuiEditMenu;
import hardcorequesting.client.interfaces.edit.GuiEditMenuTeamList;
import hardcorequesting.quests.QuestingData;
import hardcorequesting.team.PlayerEntry;
import hardcorequesting.team.Team;
import hardcorequesting.team.TeamError;
import hardcorequesting.util.Translator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;

public class GuiEditMenuTeam
extends GuiEditMenu {
    private static final int TEXT_HEIGHT = 9;
    private static final int TITLE_X = 20;
    private static final int TITLE_Y = 20;
    private static final int PLAYER_X = 25;
    private static final int PLAYER_Y = 32;
    private static final int PLAYER_SPACING = 11;
    private static final int VISIBLE_INVITES = 16;
    private static final int VISIBLE_MEMBERS = 16;
    private static final int INFO_BOX_X = 180;
    private static final int INFO_BOX_SIZE = 16;
    private static final int INFO_BOX_TEXT_OFFSET_X = 20;
    private static final int INFO_BOX_TEXT_OFFSET_Y = 6;
    private static final int INFO_BOX_SRC_X = 240;
    private static final int INFO_BOX_SRC_Y = 224;
    private static final int REWARD_SETTING_Y = 20;
    private GuiEditMenuTeam self = this;
    private ScrollBar memberScroll;
    private ScrollBar inviteScroll;
    private List<ScrollBar> scrollBars;
    private LargeButton inviteButton;
    private Team inviteTeam;
    private TextBoxGroup textBoxes;
    private TextBoxGroup.TextBox teamName;
    private TextBoxGroup.TextBox inviteName;
    private PlayerEntry selectedEntry;

    public GuiEditMenuTeam(GuiQuestBook gui, EntityPlayer player) {
        super(gui, player);
        this.buttons.add(new LargeButton("hqm.party.create", 250, 20){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return GuiEditMenuTeam.this.teamName.getText().length() > 0;
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return GuiEditMenuTeam.this.inviteTeam == null && GuiEditMenuTeam.this.getTeam().isSingle();
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                GuiEditMenuTeam.this.getTeam().create(GuiEditMenuTeam.this.teamName.getText());
            }
        });
        this.inviteButton = new LargeButton("hqm.party.invitePlayer", 250, 20){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return GuiEditMenuTeam.this.inviteName.getText().length() > 0;
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return !GuiEditMenuTeam.this.getTeam().isSingle() && GuiEditMenuTeam.this.getEntry(GuiEditMenuTeam.this.getTeam()).isOwner();
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                GuiEditMenuTeam.this.getTeam().invite(GuiEditMenuTeam.this.inviteName.getText());
            }
        };
        this.buttons.add(this.inviteButton);
        this.buttons.add(new LargeButton("hqm.party.accept", 180, 20){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return GuiEditMenuTeam.this.inviteTeam != null;
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                GuiEditMenuTeam.this.inviteTeam.accept();
                GuiEditMenuTeam.this.inviteTeam = null;
            }
        });
        this.buttons.add(new LargeButton("hqm.party.decline", 240, 20){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return GuiEditMenuTeam.this.inviteTeam != null;
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                GuiEditMenuTeam.this.inviteTeam.decline();
                GuiEditMenuTeam.this.inviteTeam = null;
            }
        });
        this.buttons.add(new LargeButton("hqm.party.decideLater", 180, 40){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return GuiEditMenuTeam.this.inviteTeam != null;
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                GuiEditMenuTeam.this.inviteTeam = null;
            }
        });
        this.buttons.add(new LargeButton(null, 250, 50){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return !GuiEditMenuTeam.this.selectedEntry.isOwner();
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return GuiEditMenuTeam.this.selectedEntry != null && GuiEditMenuTeam.this.getEntry(GuiEditMenuTeam.this.getTeam()).isOwner();
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                GuiEditMenuTeam.this.getTeam().kick(GuiEditMenuTeam.this.selectedEntry.getUUID());
                GuiEditMenuTeam.this.selectedEntry = null;
            }

            @Override
            protected String getName() {
                return Translator.translate(GuiEditMenuTeam.this.selectedEntry.isInTeam() ? "hqm.party.kickPlayer" : "hqm.party.removeInvite");
            }
        });
        this.buttons.add(new LargeButton("hqm.party.leave", 250, 160){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return GuiScreen.func_146272_n();
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return !GuiEditMenuTeam.this.getTeam().isSingle() && !GuiEditMenuTeam.this.getEntry(GuiEditMenuTeam.this.getTeam()).isOwner();
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                GuiEditMenuTeam.this.getTeam().leave();
            }
        });
        this.buttons.add(new LargeButton("hqm.party.disband", 250, 160){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return GuiScreen.func_146272_n() && GuiScreen.func_146271_m();
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return !GuiEditMenuTeam.this.getTeam().isSingle() && GuiEditMenuTeam.this.selectedEntry != null && GuiEditMenuTeam.this.selectedEntry.isOwner();
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                GuiEditMenuTeam.this.getTeam().disband();
                GuiEditMenuTeam.this.selectedEntry = null;
            }
        });
        this.buttons.add(new LargeButton("hqm.party.list", 250, 190){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                gui.setEditMenu(new GuiEditMenuTeamList((GuiQuestBook)gui, player, GuiEditMenuTeam.this.self));
            }
        });
        this.textBoxes = new TextBoxGroup();
        this.teamName = new TextBoxName(gui, "", 180, 26){

            @Override
            protected boolean isVisible() {
                return GuiEditMenuTeam.this.getTeam().isSingle() && GuiEditMenuTeam.this.inviteTeam == null;
            }
        };
        this.textBoxes.add(this.teamName);
        this.teamName.setWidth(98);
        this.inviteName = new TextBoxName(gui, "", 180, 26){

            @Override
            protected boolean isVisible() {
                return !GuiEditMenuTeam.this.getTeam().isSingle() && GuiEditMenuTeam.this.getEntry(GuiEditMenuTeam.this.getTeam()).isOwner();
            }
        };
        this.textBoxes.add(this.inviteName);
        this.scrollBars = new ArrayList<ScrollBar>();
        this.inviteScroll = new ScrollBar(155, 22, 186, 171, 69, 25){

            @Override
            public boolean isVisible(GuiBase gui) {
                return GuiEditMenuTeam.this.inviteTeam == null && GuiEditMenuTeam.this.getTeam().isSingle() && GuiEditMenuTeam.this.getTeam().getInvites() != null && GuiEditMenuTeam.this.getTeam().getInvites().size() > 16;
            }
        };
        this.scrollBars.add(this.inviteScroll);
        this.memberScroll = new ScrollBar(155, 22, 186, 171, 69, 25){

            @Override
            public boolean isVisible(GuiBase gui) {
                return GuiEditMenuTeam.this.inviteTeam != null && GuiEditMenuTeam.this.inviteTeam.getPlayers().size() > 16 || !GuiEditMenuTeam.this.getTeam().isSingle() && GuiEditMenuTeam.this.getTeam().getPlayers().size() > 16;
            }
        };
        this.scrollBars.add(this.memberScroll);
    }

    @Override
    public void draw(GuiBase gui, int mX, int mY) {
        Team team = this.getTeam();
        PlayerEntry entry = this.getEntry(team);
        if (Team.reloadedInvites) {
            if (this.inviteTeam != null) {
                if (team.getInvites() == null) {
                    this.inviteTeam = null;
                } else {
                    boolean stillThere = false;
                    for (Team t : team.getInvites()) {
                        if (!t.getName().equals(this.inviteTeam.getName())) continue;
                        this.inviteTeam = t;
                        stillThere = true;
                    }
                    if (!stillThere) {
                        this.inviteTeam = null;
                    }
                }
            }
            Team.reloadedInvites = false;
        }
        super.draw(gui, mX, mY);
        this.textBoxes.draw(gui);
        ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (ScrollBar scrollBar : this.scrollBars) {
            scrollBar.draw(gui);
        }
        if (team.isSingle() && this.inviteTeam == null) {
            int inviteCount;
            int n = inviteCount = team.getInvites() == null ? 0 : team.getInvites().size();
            if (inviteCount > 0) {
                gui.drawString(Translator.translate("hqm.party.invites"), 20, 20, 0x404040);
                List<Team> invites = team.getInvites();
                int start = this.inviteScroll.isVisible(gui) ? Math.round((float)(team.getInvites().size() - 16) * this.inviteScroll.getScroll()) : 0;
                int end = Math.min(invites.size(), start + 16);
                for (int i = start; i < end; ++i) {
                    Team invite = invites.get(i);
                    gui.drawString(invite.getName(), 25, 32 + 11 * (i - start), 0x404040);
                }
            } else {
                gui.drawString(Translator.translate("hqm.party.noInvites"), 20, 20, 0x404040);
            }
            gui.drawString(Translator.translate("hqm.party.name"), 180, 20, 0.7f, 0x404040);
        } else {
            boolean isOwner = this.inviteTeam == null && entry.isOwner();
            String title = (this.inviteTeam == null ? team : this.inviteTeam).getName();
            gui.drawString(title, 20, 20, 0x404040);
            List<PlayerEntry> players = (this.inviteTeam == null ? team : this.inviteTeam).getPlayers();
            int y = 0;
            int start = this.memberScroll.isVisible(gui) ? Math.round((float)((isOwner ? players.size() : (this.inviteTeam == null ? team : this.inviteTeam).getPlayerCount()) - 16) * this.memberScroll.getScroll()) : 0;
            for (PlayerEntry player : players) {
                String str = player.getDisplayName();
                if (player.isOwner()) {
                    str = str + (Object)((Object)GuiColor.ORANGE) + " [" + Translator.translate("hqm.party.owner") + "]";
                } else if (!player.isInTeam()) {
                    if (!isOwner) continue;
                    str = str + (Object)((Object)GuiColor.LIGHT_GRAY) + " [" + Translator.translate("hqm.party.invite") + "]";
                }
                if (y >= start) {
                    int color = 0x404040;
                    if (isOwner) {
                        if (player.equals(this.selectedEntry)) {
                            color = 0xD0D0D0;
                        } else if (gui.inBounds(25, 32 + 11 * (y - start), (int)((float)gui.getStringWidth(player.getDisplayName()) * 0.7f), 6, mX, mY)) {
                            color = 0x808080;
                        }
                    }
                    gui.drawString(str, 25, 32 + 11 * (y - start), 0.7f, color);
                }
                if (++y != start + 16) continue;
                break;
            }
            if (this.inviteTeam == null) {
                if (entry.isOwner()) {
                    gui.drawString(Translator.translate("hqm.party.playerName"), 180, 20, 0.7f, 0x404040);
                    if (this.selectedEntry != null) {
                        gui.drawString(gui.getLinesFromText(Translator.translate("hqm.party.currentSelection", this.selectedEntry.getDisplayName()), 0.7f, 70), 177, 52, 0.7f, 0x404040);
                        if (this.selectedEntry.isOwner()) {
                            gui.drawString(gui.getLinesFromText(Translator.translate("hqm.party.shiftCtrlConfirm"), 0.6f, 70), 177, 162, 0.6f, GuiColor.RED.getHexColor());
                        }
                    }
                } else {
                    gui.drawString(gui.getLinesFromText(Translator.translate("hqm.party.shiftConfirm"), 0.7f, 70), 177, 162, 0.7f, GuiColor.RED.getHexColor());
                }
            }
            gui.drawString(gui.getLinesFromText(Translator.translate("hqm.party.stats"), 0.7f, 70), 177, 192, 0.7f, 0x404040);
            Team infoTeam = this.inviteTeam == null ? team : this.inviteTeam;
            int infoY = this.getInfoY();
            ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            gui.drawRect(180, infoY, 240, 224, 16, 16);
            gui.drawRect(180, infoY + 20, 240, 224, 16, 16);
            gui.drawString(Translator.translate("hqm.party.lifeSetting", infoTeam.getLifeSetting().getTitle()), 200, infoY + 6, 0.7f, 0x404040);
            gui.drawString(Translator.translate("hqm.party.rewardSetting", infoTeam.getRewardSetting().getTitle()), 200, infoY + 20 + 6, 0.7f, 0x404040);
        }
    }

    @Override
    public void drawMouseOver(GuiBase gui, int mX, int mY) {
        boolean isOwner;
        super.drawMouseOver(gui, mX, mY);
        Team team = this.getTeam();
        PlayerEntry entry = this.getEntry(team);
        boolean bl = isOwner = this.inviteTeam == null && entry.isOwner();
        if (!team.isSingle() || this.inviteTeam != null) {
            Team infoTeam;
            int infoY = this.getInfoY();
            Team team2 = infoTeam = this.inviteTeam == null ? team : this.inviteTeam;
            if (gui.inBounds(180, infoY, 16, 16, mX, mY)) {
                gui.drawMouseOver(gui.getLinesFromText((Object)((Object)GuiColor.GREEN) + infoTeam.getLifeSetting().getTitle() + "\n" + infoTeam.getLifeSetting().getDescription() + (isOwner ? "\n\n" + (Object)((Object)GuiColor.ORANGE) + Translator.translate("hqm.party.change") : ""), 1.0f, 200), gui.getLeft() + mX, gui.getTop() + mY);
            } else if (gui.inBounds(180, infoY + 20, 16, 16, mX, mY)) {
                gui.drawMouseOver(gui.getLinesFromText((Object)((Object)GuiColor.GREEN) + infoTeam.getRewardSetting().getTitle() + "\n" + infoTeam.getRewardSetting().getDescription() + (isOwner ? "\n\n" + (Object)((Object)GuiColor.ORANGE) + Translator.translate("hqm.party.change") : ""), 1.0f, 200), gui.getLeft() + mX, gui.getTop() + mY);
            }
        }
        if (TeamError.latestError != null) {
            if (this.inviteButton.inButtonBounds(gui, mX, mY)) {
                gui.drawMouseOver(gui.getLinesFromText((Object)((Object)GuiColor.RED) + TeamError.latestError.getHeader() + "\n" + TeamError.latestError.getMessage(), 1.0f, 150), mX + gui.getLeft(), mY + gui.getTop());
            } else {
                TeamError.latestError = null;
            }
        }
    }

    @Override
    public void onClick(GuiBase gui, int mX, int mY, int b) {
        super.onClick(gui, mX, mY, b);
        Team team = this.getTeam();
        if (team.isSingle() && this.inviteTeam == null) {
            List<Team> invites = team.getInvites();
            if (invites != null) {
                int start = this.inviteScroll.isVisible(gui) ? Math.round((float)(team.getInvites().size() - 16) * this.inviteScroll.getScroll()) : 0;
                int end = Math.min(invites.size(), start + 16);
                for (int i = start; i < end; ++i) {
                    Team invite = invites.get(i);
                    if (!gui.inBounds(25, 32 + 11 * i, (int)((float)gui.getStringWidth(invite.getName()) * 0.7f), 6, mX, mY)) continue;
                    this.inviteTeam = invite;
                    break;
                }
            }
        } else if (!team.isSingle() && this.getEntry(team).isOwner()) {
            int infoY;
            int start = this.memberScroll.isVisible(gui) ? Math.round((float)(team.getPlayers().size() - 16) * this.memberScroll.getScroll()) : 0;
            int end = Math.min(team.getPlayers().size(), start + 16);
            for (int i = start; i < end; ++i) {
                PlayerEntry entry = team.getPlayers().get(i);
                if (!gui.inBounds(25, 32 + 11 * (i - start), (int)((float)gui.getStringWidth(entry.getDisplayName()) * 0.7f), 6, mX, mY)) continue;
                this.selectedEntry = this.selectedEntry == entry ? null : entry;
                break;
            }
            if (gui.inBounds(180, infoY = this.getInfoY(), 16, 16, mX, mY)) {
                team.nextLifeSetting();
            } else if (gui.inBounds(180, infoY + 20, 16, 16, mX, mY)) {
                team.nextRewardSetting();
            }
        }
        this.textBoxes.onClick(gui, mX, mY);
        for (ScrollBar scrollBar : this.scrollBars) {
            scrollBar.onClick(gui, mX, mY);
        }
    }

    @Override
    public void onKeyTyped(GuiBase gui, char c, int k) {
        super.onKeyTyped(gui, c, k);
        this.textBoxes.onKeyStroke(gui, c, k);
    }

    @Override
    public void onDrag(GuiBase gui, int mX, int mY) {
        super.onDrag(gui, mX, mY);
        for (ScrollBar scrollBar : this.scrollBars) {
            scrollBar.onDrag(gui, mX, mY);
        }
    }

    @Override
    public void onRelease(GuiBase gui, int mX, int mY) {
        super.onRelease(gui, mX, mY);
        for (ScrollBar scrollBar : this.scrollBars) {
            scrollBar.onRelease(gui, mX, mY);
        }
    }

    @Override
    public void onScroll(GuiBase gui, int mX, int mY, int scroll) {
        super.onScroll(gui, mX, mY, scroll);
        for (ScrollBar scrollBar : this.scrollBars) {
            scrollBar.onScroll(gui, mX, mY, scroll);
        }
    }

    @Override
    public void save(GuiBase gui) {
    }

    private int getInfoY() {
        if (this.inviteTeam != null) {
            return 80;
        }
        if (this.getEntry(this.getTeam()).isOwner()) {
            return this.selectedEntry != null ? 80 : 50;
        }
        return 20;
    }

    private Team getTeam() {
        return QuestingData.getQuestingData(this.player).getTeam();
    }

    private PlayerEntry getEntry(Team team) {
        return team.getEntry(QuestingData.getUserUUID(this.player));
    }

    private class TextBoxName
    extends TextBoxGroup.TextBox {
        public TextBoxName(GuiQuestBook gui, String str, int x, int y) {
            super(gui, str, x, y, true);
            this.setMult(0.7f);
            this.offsetY = 5;
        }
    }
}

