/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.client.interfaces.edit;

import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.client.interfaces.ResourceHelper;
import hardcorequesting.client.interfaces.ScrollBar;
import hardcorequesting.client.interfaces.TextBoxGroup;
import hardcorequesting.client.interfaces.edit.GuiEditMenuExtended;
import hardcorequesting.quests.task.QuestTaskMob;
import hardcorequesting.util.Translator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class GuiEditMenuMob
extends GuiEditMenuExtended {
    private static final int START_X = 20;
    private static final int START_Y = 20;
    private static final int OFFSET_Y = 8;
    private static final int VISIBLE_MOBS = 24;
    private QuestTaskMob task;
    private QuestTaskMob.Mob mob;
    private int id;
    private ScrollBar scrollBar;
    private List<String> rawMobs;
    private List<String> mobs;

    public GuiEditMenuMob(GuiQuestBook gui, QuestTaskMob task, final QuestTaskMob.Mob mob, int id, EntityPlayer player) {
        super(gui, player, false, 180, 70, 180, 150);
        this.task = task;
        this.mob = mob;
        this.id = id;
        this.scrollBar = new ScrollBar(160, 18, 186, 171, 69, 20){

            @Override
            public boolean isVisible(GuiBase gui) {
                return GuiEditMenuMob.this.mobs.size() > 24;
            }
        };
        this.textBoxes.add(new GuiEditMenuExtended.TextBoxNumber(gui, 0, "hqm.mobTask.reqKills"){

            @Override
            protected int getValue() {
                return mob.getCount();
            }

            @Override
            protected void setValue(int number) {
                mob.setCount(number);
            }
        });
        this.textBoxes.add(new TextBoxGroup.TextBox(gui, "", 250, 18, false){

            @Override
            public void textChanged(GuiBase gui) {
                super.textChanged(gui);
                GuiEditMenuMob.this.updateMobs(this.getText());
            }
        });
        this.rawMobs = new ArrayList<String>();
        this.mobs = new ArrayList<String>();
        for (Object obj : EntityList.field_75626_c.keySet()) {
            Class clazz = (Class)obj;
            if (!EntityLivingBase.class.isAssignableFrom(clazz)) continue;
            this.rawMobs.add((String)EntityList.field_75626_c.get(clazz));
        }
        Collections.sort(this.rawMobs);
        this.updateMobs("");
    }

    private void updateMobs(String search) {
        if (this.mobs != null) {
            this.mobs.clear();
            for (String rawMob : this.rawMobs) {
                if (!rawMob.toLowerCase().contains(search.toLowerCase())) continue;
                this.mobs.add(rawMob);
            }
        }
    }

    @Override
    public void draw(GuiBase gui, int mX, int mY) {
        super.draw(gui, mX, mY);
        ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.scrollBar.draw(gui);
        int start = this.scrollBar.isVisible(gui) ? Math.round((float)(this.mobs.size() - 24) * this.scrollBar.getScroll()) : 0;
        int end = Math.min(this.mobs.size(), start + 24);
        for (int i = start; i < end; ++i) {
            boolean selected = this.mobs.get(i).equals(this.mob.getMob());
            boolean inBounds = gui.inBounds(20, 20 + (i - start) * 8, 130, 6, mX, mY);
            gui.drawString(this.mobs.get(i), 20, 20 + 8 * (i - start), 0.7f, selected ? (inBounds ? 0xC0C0C0 : 0xA0A0A0) : (inBounds ? 0x707070 : 0x404040));
        }
        gui.drawString(Translator.translate("hqm.mobTask.search"), 180, 20, 0x404040);
        gui.drawString(Translator.translate("hqm.mobTask." + (this.mob.getMob() == null ? "nothing" : "currently") + "Selected"), 180, 40, 0x404040);
        if (this.mob.getMob() != null) {
            gui.drawString(this.mob.getMob(), 180, 50, 0.7f, 0x404040);
        }
    }

    @Override
    public void onClick(GuiBase gui, int mX, int mY, int b) {
        super.onClick(gui, mX, mY, b);
        this.scrollBar.onClick(gui, mX, mY);
        int start = this.scrollBar.isVisible(gui) ? Math.round((float)(this.mobs.size() - 24) * this.scrollBar.getScroll()) : 0;
        int end = Math.min(this.mobs.size(), start + 24);
        for (int i = start; i < end; ++i) {
            if (!gui.inBounds(20, 20 + (i - start) * 8, 130, 6, mX, mY)) continue;
            if (this.mobs.get(i).equals(this.mob.getMob())) {
                this.mob.setMob(null);
                break;
            }
            this.mob.setMob(this.mobs.get(i));
            break;
        }
    }

    @Override
    public void onRelease(GuiBase gui, int mX, int mY) {
        super.onRelease(gui, mX, mY);
        this.scrollBar.onRelease(gui, mX, mY);
    }

    @Override
    protected void onArrowClick(boolean left) {
        this.mob.setExact(!this.mob.isExact());
    }

    @Override
    protected String getArrowText() {
        return Translator.translate("hqm.mobTask." + (this.mob.isExact() ? "exact" : "type") + "Match.title");
    }

    @Override
    protected String getArrowDescription() {
        return Translator.translate("hqm.mobTask." + (this.mob.isExact() ? "exact" : "type") + "Match.desc");
    }

    @Override
    public void onDrag(GuiBase gui, int mX, int mY) {
        super.onDrag(gui, mX, mY);
        this.scrollBar.onDrag(gui, mX, mY);
    }

    @Override
    public void onScroll(GuiBase gui, int mX, int mY, int scroll) {
        super.onScroll(gui, mX, mY, scroll);
        this.scrollBar.onScroll(gui, mX, mY, scroll);
    }

    @Override
    public void save(GuiBase gui) {
        EntityList.EntityEggInfo info;
        this.mob.setCount(Math.max(1, this.mob.getCount()));
        if ((this.mob.getIconStack() == null || this.mob.getIconStack().func_77973_b() == Items.field_151063_bx) && this.mob.getMob() != null && (info = (EntityList.EntityEggInfo)EntityList.field_75627_a.get(this.mob.getMob())) != null) {
            int id = EntityList.func_180122_a((String)this.mob.getMob());
            this.mob.setIconStack(new ItemStack(Items.field_151063_bx, 1, id));
        }
        this.task.setMob(this.id, this.mob, this.player);
    }
}

