/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.client.interfaces.edit;

import com.google.common.collect.ImmutableList;
import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.client.interfaces.ResourceHelper;
import hardcorequesting.client.interfaces.TextBoxGroup;
import hardcorequesting.client.interfaces.edit.GuiEditMenu;
import hardcorequesting.items.ModItems;
import hardcorequesting.quests.ItemPrecision;
import hardcorequesting.quests.Quest;
import hardcorequesting.util.SaveHelper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class GuiEditMenuItem
extends GuiEditMenu {
    private static final int ARROW_X_LEFT = 20;
    private static final int ARROW_X_RIGHT = 150;
    private static final int ARROW_Y = 40;
    private static final int ARROW_SRC_X = 244;
    private static final int ARROW_SRC_Y = 176;
    private static final int ARROW_W = 6;
    private static final int ARROW_H = 10;
    private static final int PLAYER_X = 20;
    private static final int PLAYER_Y = 80;
    private static final int SEARCH_X = 180;
    private static final int SEARCH_Y = 30;
    private static final int SIZE = 18;
    private static final int OFFSET = 20;
    private static final int ITEMS_PER_LINE = 7;
    private static final int SEARCH_LINES = 9;
    private static final int ITEMS_TO_DISPLAY = 63;
    private static final int PLAYER_LINES = 6;
    public static ThreadingHandler HANDLER = new ThreadingHandler();
    protected Element selected;
    private int id;
    private String sid;
    private Type type;
    private List<Element> playerItems;
    private List<Element> searchItems;
    private ItemPrecision precision;
    private boolean clicked;
    private TextBoxGroup.TextBox amountTextBox;
    private TextBoxGroup textBoxes;

    public GuiEditMenuItem(GuiBase gui, EntityPlayer player, Object obj, int id, Type type, int amount, ItemPrecision precision) {
        this(gui, player, obj instanceof ItemStack ? new ElementItem((ItemStack)obj) : new ElementFluid((Fluid)obj), null, id, type, amount, precision);
    }

    public GuiEditMenuItem(GuiBase gui, EntityPlayer player, Object obj, String sid, Type type, int amount, ItemPrecision precision) {
        this(gui, player, obj instanceof ItemStack ? new ElementItem((ItemStack)obj) : new ElementFluid((Fluid)obj), sid, -1, type, amount, precision);
    }

    public GuiEditMenuItem(GuiBase gui, EntityPlayer player, Element element, String sid, int id, Type type, int amount, ItemPrecision precision) {
        super(gui, player, true);
        this.selected = element;
        this.id = id;
        this.sid = sid;
        this.type = type;
        this.precision = precision;
        this.playerItems = new ArrayList<Element>();
        this.searchItems = new ArrayList<Element>();
        InventoryPlayer inventory = Minecraft.func_71410_x().field_71439_g.field_71071_by;
        int itemLength = inventory.func_70302_i_();
        for (int i = 0; i < itemLength; ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null) continue;
            stack = stack.func_77946_l();
            stack.field_77994_a = 1;
            boolean exists = false;
            for (Element other : this.playerItems) {
                if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)((ItemStack)other.getFluidStack()))) continue;
                exists = true;
                break;
            }
            if (exists || stack.func_77973_b() == ModItems.book) continue;
            this.playerItems.add(new ElementItem(stack));
        }
        if (type.allowFluids) {
            ArrayList<String> fluids = new ArrayList<String>();
            int end = this.playerItems.size();
            for (int i = 0; i < end; ++i) {
                Element item = this.playerItems.get(i);
                FluidStack fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)((ItemStack)item.getFluidStack()));
                if (fluidStack == null || fluids.contains(fluidStack.getFluid().getName())) continue;
                fluids.add(fluidStack.getFluid().getName());
                this.playerItems.add(new ElementFluid(fluidStack.getFluid()));
                if (this.playerItems.size() == 42) break;
            }
        }
        this.textBoxes = new TextBoxGroup();
        if (type.allowAmount) {
            this.amountTextBox = new TextBoxGroup.TextBox(gui, String.valueOf(amount), 100, 18, false){

                @Override
                protected boolean isCharacterValid(char c) {
                    return Character.isDigit(c);
                }

                @Override
                public void textChanged(GuiBase gui) {
                    try {
                        int number = this.getText().equals("") ? 1 : Integer.parseInt(this.getText());
                        if (number == 0) {
                            number = 1;
                        }
                        if (GuiEditMenuItem.this.getSelected() != null) {
                            GuiEditMenuItem.this.getSelected().setAmount(number);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            this.textBoxes.add(this.amountTextBox);
        }
        this.textBoxes.add(new TextBoxGroup.TextBox(gui, "", 230, 18, false){

            @Override
            public void textChanged(GuiBase gui) {
                GuiEditMenuItem.this.searchItems.clear();
                Thread thread = new Thread(new Search(this.getText(), GuiEditMenuItem.this));
                thread.start();
            }
        });
    }

    private boolean inArrowBounds(GuiBase gui, int mX, int mY, boolean left) {
        return gui.inBounds(left ? 20 : 150, 40, 6, 10, mX, mY);
    }

    private void drawArrow(GuiBase gui, int mX, int mY, boolean left) {
        int srcX = 244 + (left ? 0 : 6);
        int srcY = 176 + (this.inArrowBounds(gui, mX, mY, left) ? (this.clicked ? 1 : 2) : 0) * 10;
        gui.drawRect(left ? 20 : 150, 40, srcX, srcY, 6, 10);
    }

    private boolean usePrecision() {
        return this.type.allowPrecision && this.selected instanceof ElementItem;
    }

    public boolean showFluids() {
        return this.type.allowFluids;
    }

    private Element getSelected() {
        return this.selected;
    }

    @Override
    public void draw(GuiBase gui, int mX, int mY) {
        super.draw(gui, mX, mY);
        gui.drawString("Selected", 20, 20, 0x404040);
        this.selected.draw(gui, 70, 15, mX, mY);
        gui.drawString("Search", 180, 20, 0x404040);
        this.drawList(gui, 180, 30, this.searchItems, mX, mY);
        gui.drawString("Player inventory", 20, 70, 0x404040);
        this.drawList(gui, 20, 80, this.playerItems, mX, mY);
        this.textBoxes.draw(gui);
        if (this.usePrecision()) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
            this.drawArrow(gui, mX, mY, true);
            this.drawArrow(gui, mX, mY, false);
            gui.drawCenteredString(this.precision.getName(), 26, 40, 0.7f, 124, 10, 0x404040);
        }
    }

    @Override
    public void drawMouseOver(GuiBase gui, int mX, int mY) {
        super.drawMouseOver(gui, mX, mY);
        this.drawListMouseOver(gui, 180, 30, this.searchItems, mX, mY);
        this.drawListMouseOver(gui, 20, 80, this.playerItems, mX, mY);
    }

    @Override
    public void onClick(GuiBase gui, int mX, int mY, int b) {
        super.onClick(gui, mX, mY, b);
        this.clickList(gui, 20, 80, this.playerItems, mX, mY);
        this.clickList(gui, 180, 30, this.searchItems, mX, mY);
        this.textBoxes.onClick(gui, mX, mY);
        if (this.usePrecision()) {
            if (this.inArrowBounds(gui, mX, mY, true)) {
                ImmutableList<ItemPrecision> precisionTypes = ItemPrecision.getPrecisionTypes();
                this.precision = (ItemPrecision)precisionTypes.get((precisionTypes.indexOf(this.precision) + precisionTypes.size() - 1) % precisionTypes.size());
                this.clicked = true;
            } else if (this.inArrowBounds(gui, mX, mY, false)) {
                ImmutableList<ItemPrecision> precisionTypes = ItemPrecision.getPrecisionTypes();
                this.precision = (ItemPrecision)precisionTypes.get((precisionTypes.indexOf(this.precision) + 1) % precisionTypes.size());
                this.clicked = true;
            }
        }
    }

    @Override
    public void onKeyTyped(GuiBase gui, char c, int k) {
        super.onKeyTyped(gui, c, k);
        this.textBoxes.onKeyStroke(gui, c, k);
    }

    @Override
    public void onRelease(GuiBase gui, int mX, int mY) {
        super.onRelease(gui, mX, mY);
        this.clicked = false;
    }

    @Override
    public void save(GuiBase gui) {
        if (this.type == Type.BAG_ITEM) {
            if (GuiQuestBook.getSelectedGroup() != null && this.selected instanceof ElementItem && this.selected.getFluidStack() != null) {
                GuiQuestBook.getSelectedGroup().setItem(this.id, (ItemStack)this.selected.getFluidStack());
            }
        } else if (this.type == Type.QUEST_ICON) {
            if (Quest.getQuest(this.sid) != null && this.selected instanceof ElementItem) {
                try {
                    Quest.getQuest(this.sid).setIconStack((ItemStack)this.selected.getFluidStack());
                }
                catch (Exception e) {
                    System.out.println("Tell LordDusk that he found the issue.");
                }
                SaveHelper.add(SaveHelper.EditType.ICON_CHANGE);
            }
        } else {
            GuiQuestBook.selectedQuest.setItem(this.selected, this.id, this.type, this.precision, this.player);
        }
    }

    private void drawList(GuiBase gui, int x, int y, List<Element> items, int mX, int mY) {
        for (int i = 0; i < items.size(); ++i) {
            Element element = items.get(i);
            int xI = i % 7;
            int yI = i / 7;
            element.draw(gui, x + xI * 20, y + yI * 20, mX, mY);
        }
    }

    private void drawListMouseOver(GuiBase gui, int x, int y, List<Element> items, int mX, int mY) {
        for (int i = 0; i < items.size(); ++i) {
            Element element = items.get(i);
            int xI = i % 7;
            int yI = i / 7;
            if (!gui.inBounds(x + xI * 20, y + yI * 20, 18, 18, mX, mY)) continue;
            if (element == null) break;
            gui.drawMouseOver(element.getName(gui), mX + gui.getLeft(), mY + gui.getTop());
            break;
        }
    }

    private void clickList(GuiBase gui, int x, int y, List<Element> items, int mX, int mY) {
        for (int i = 0; i < items.size(); ++i) {
            Element element = items.get(i);
            int xI = i % 7;
            int yI = i / 7;
            if (!gui.inBounds(x + xI * 20, y + yI * 20, 18, 18, mX, mY)) continue;
            if (element == null) break;
            this.selected = element.copy();
            if (this.amountTextBox != null) {
                this.amountTextBox.textChanged(gui);
                break;
            }
            this.selected.setAmount(1);
            break;
        }
    }

    public static class ThreadingHandler {
        private Map<GuiEditMenuItem, Search> handle = new LinkedHashMap<GuiEditMenuItem, Search>();

        private ThreadingHandler() {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        private static void handle(GuiEditMenuItem menu, Search search) {
            if (!GuiEditMenuItem.HANDLER.handle.containsKey(menu) || search.isNewerThan(GuiEditMenuItem.HANDLER.handle.get(menu))) {
                GuiEditMenuItem.HANDLER.handle.put(menu, search);
            }
        }

        @SubscribeEvent
        public void renderEvent(RenderWorldLastEvent e) {
            if (!this.handle.isEmpty()) {
                for (Map.Entry<GuiEditMenuItem, Search> entry : this.handle.entrySet()) {
                    entry.getKey().searchItems = entry.getValue().elements;
                }
                this.handle.clear();
            }
        }
    }

    public static class Search
    implements Runnable {
        public static List<SearchEntry> searchItems = new ArrayList<SearchEntry>();
        public static List<SearchEntry> searchFluids = new ArrayList<SearchEntry>();
        private String search;
        private GuiEditMenuItem menu;
        private List<Element> elements;
        private long startTime;

        public Search(String search, GuiEditMenuItem menu) {
            this.search = search;
            this.menu = menu;
            this.startTime = System.currentTimeMillis();
        }

        public static void setResult(GuiEditMenuItem menu, Search search) {
            ThreadingHandler.handle(menu, search);
        }

        public static void initItems() {
            Search.clear();
            if (searchItems.isEmpty()) {
                ArrayList stacks = new ArrayList();
                for (Item item : Item.field_150901_e) {
                    try {
                        item.func_150895_a(item, item.func_77640_w(), stacks);
                    }
                    catch (Exception exception) {}
                }
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                for (ItemStack stack : stacks) {
                    try {
                        List tooltipList = stack.func_82840_a((EntityPlayer)player, false);
                        List advTooltipList = stack.func_82840_a((EntityPlayer)player, true);
                        String searchString = "";
                        for (Object string : tooltipList) {
                            if (string == null) continue;
                            searchString = searchString + string + "\n";
                        }
                        String advSearchString = "";
                        for (Object string : advTooltipList) {
                            if (string == null) continue;
                            advSearchString = advSearchString + string + "\n";
                        }
                        searchItems.add(new SearchEntry(searchString, advSearchString, new ElementItem(stack)));
                    }
                    catch (Throwable tooltipList) {}
                }
                for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                    String search = fluid.getLocalizedName(null);
                    searchFluids.add(new SearchEntry(search, search, new ElementFluid(fluid)));
                }
            }
        }

        public static void clear() {
            searchFluids.clear();
            searchItems.clear();
        }

        @Override
        public void run() {
            SearchEntry entry;
            int i;
            this.elements = new ArrayList<Element>();
            Pattern pattern = Pattern.compile(Pattern.quote(this.search), 2);
            boolean advanced = Minecraft.func_71410_x().field_71474_y.field_82882_x;
            for (i = 0; i < searchItems.size() && this.elements.size() < 63; ++i) {
                entry = searchItems.get(i);
                entry.search(pattern, this.elements, advanced);
            }
            if (this.menu.showFluids()) {
                for (i = 0; i < searchFluids.size() && this.elements.size() < 63; ++i) {
                    entry = searchFluids.get(i);
                    entry.search(pattern, this.elements, advanced);
                }
            }
            Search.setResult(this.menu, this);
        }

        public boolean isNewerThan(Search search) {
            return this.startTime > search.startTime;
        }

        public static class SearchEntry {
            private String toolTip;
            private String advToolTip;
            private Element element;

            public SearchEntry(String searchString, String advSearchString, Element element) {
                this.toolTip = searchString;
                this.advToolTip = advSearchString;
                this.element = element;
            }

            public void search(Pattern pattern, List<Element> stackList, boolean advanced) {
                if (pattern.matcher(advanced ? this.advToolTip : this.toolTip).find()) {
                    stackList.add(this.element);
                }
            }
        }
    }

    public static class ElementFluid
    extends Element<Fluid> {
        private int size;

        public ElementFluid(Fluid fluid) {
            this.item = fluid;
        }

        @Override
        public void draw(GuiBase gui, int x, int y, int mX, int mY) {
        }

        @Override
        public List<String> getName(GuiBase gui) {
            ArrayList<String> ret = new ArrayList<String>();
            ret.add(((Fluid)this.item).getLocalizedName(null));
            return ret;
        }

        @Override
        public int getAmount() {
            return this.size;
        }

        @Override
        public void setAmount(int val) {
            this.size = val;
        }

        @Override
        public Element copy() {
            ElementFluid ret = new ElementFluid(this.item == null ? null : (Fluid)this.item);
            ret.size = this.size;
            return ret;
        }
    }

    public static class ElementItem
    extends Element<ItemStack> {
        public ElementItem(ItemStack stack) {
            this.item = stack;
        }

        @Override
        public void draw(GuiBase gui, int x, int y, int mX, int mY) {
            gui.drawItemStack((ItemStack)this.item, x, y, mX, mY, false);
        }

        @Override
        public List<String> getName(GuiBase gui) {
            if (this.item != null && ((ItemStack)this.item).func_77973_b() != null) {
                return ((ItemStack)this.item).func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
            }
            ArrayList<String> ret = new ArrayList<String>();
            ret.add("Unknown");
            return ret;
        }

        @Override
        public int getAmount() {
            return this.item == null ? 0 : ((ItemStack)this.item).field_77994_a;
        }

        @Override
        public void setAmount(int val) {
            if (this.item != null) {
                ((ItemStack)this.item).field_77994_a = val;
            }
        }

        @Override
        public Element copy() {
            return new ElementItem(this.item == null ? null : ((ItemStack)this.item).func_77946_l());
        }
    }

    public static abstract class Element<T> {
        protected T item;

        protected Element() {
        }

        public abstract void draw(GuiBase var1, int var2, int var3, int var4, int var5);

        public abstract List<String> getName(GuiBase var1);

        public abstract int getAmount();

        public abstract void setAmount(int var1);

        public T getFluidStack() {
            return this.item;
        }

        public abstract Element copy();
    }

    public static enum Type {
        REWARD(false, true, false),
        PICK_REWARD(false, true, false),
        CONSUME_TASK(true, true, true),
        CRAFTING_TASK(false, true, true),
        QUEST_ICON(false, false, false),
        BAG_ITEM(false, true, false),
        LOCATION(false, false, false),
        MOB(false, false, false),
        PORTAL(false, false, false);

        private boolean allowFluids;
        private boolean allowAmount;
        private boolean allowPrecision;

        private Type(boolean allowFluids, boolean allowAmount, boolean allowPrecision) {
            this.allowFluids = allowFluids;
            this.allowAmount = allowAmount;
            this.allowPrecision = allowPrecision;
        }
    }
}

