/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.client.interfaces;

import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.client.interfaces.ResourceHelper;
import hardcorequesting.client.interfaces.TextBoxLogic;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TextBoxGroup {
    private static final int TEXT_BOX_WIDTH = 64;
    private static final int TEXT_BOX_HEIGHT = 12;
    private static final int TEXT_BOX_SRC_X = 192;
    private static final int TEXT_BOX_SRC_Y = 77;
    private TextBox selectedTextBox;
    private List<TextBox> textBoxes = new ArrayList<TextBox>();

    public void add(TextBox textBox) {
        this.textBoxes.add(textBox);
    }

    public List<TextBox> getTextBoxes() {
        return this.textBoxes;
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(GuiBase gui) {
        for (TextBox textBox : this.textBoxes) {
            if (!textBox.isVisible()) continue;
            textBox.draw(gui, this.selectedTextBox == textBox);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onClick(GuiBase gui, int mX, int mY) {
        for (TextBox textBox : this.textBoxes) {
            if (!textBox.isVisible() || !gui.inBounds(textBox.x, textBox.y, 64, 12, mX, mY)) continue;
            if (this.selectedTextBox == textBox) {
                this.selectedTextBox = null;
                break;
            }
            this.selectedTextBox = textBox;
            break;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onKeyStroke(GuiBase gui, char c, int k) {
        if (this.selectedTextBox != null && this.selectedTextBox.isVisible()) {
            this.selectedTextBox.onKeyStroke(gui, c, k);
        }
    }

    public static class TextBox
    extends TextBoxLogic {
        private static final int WIDTH = 60;
        protected int offsetY = 3;
        private int x;
        private int y;
        private int start;
        private String visibleText;
        private boolean scrollable;

        public TextBox(GuiBase gui, String str, int x, int y, boolean scrollable) {
            super(gui, str, scrollable ? Integer.MAX_VALUE : 60, false);
            this.x = x;
            this.y = y;
            this.scrollable = scrollable;
        }

        @SideOnly(value=Side.CLIENT)
        protected void draw(GuiBase gui, boolean selected) {
            ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            gui.drawRect(this.x, this.y, 192, 77 + (selected ? 12 : 0), 64, 12);
            gui.drawString(this.scrollable ? this.visibleText : this.getText(), this.x + 3, this.y + this.offsetY, this.getMult(), 0x404040);
            if (selected) {
                gui.drawCursor(this.x + this.getCursorPositionX(gui) + 2, this.y + this.getCursorPositionY(gui), 10, 1.0f, -7303024);
            }
        }

        protected boolean isVisible() {
            return true;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void textChanged(GuiBase gui) {
            super.textChanged(gui);
            if (this.scrollable) {
                this.updateVisible(gui);
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        protected void recalculateCursor(GuiBase gui) {
            if (this.scrollable) {
                if (this.updatedCursor) {
                    this.updateVisible(gui);
                    this.cursorPositionX = (int)(this.getMult() * (float)gui.getStringWidth(this.visibleText.substring(0, Math.min(this.visibleText.length(), this.cursor - this.start))));
                    this.updatedCursor = false;
                }
            } else {
                super.recalculateCursor(gui);
            }
        }

        @SideOnly(value=Side.CLIENT)
        private void updateVisible(GuiBase gui) {
            String text;
            if (this.cursor < this.start) {
                this.start = this.cursor;
            }
            while (this.start < this.cursor && (float)gui.getStringWidth(text = this.getText().substring(this.start, this.cursor)) * this.getMult() > 60.0f) {
                ++this.start;
            }
            this.visibleText = this.getText().substring(this.start);
            while ((float)gui.getStringWidth(this.visibleText) * this.getMult() > 60.0f) {
                this.visibleText = this.visibleText.substring(0, this.visibleText.length() - 2);
            }
        }

        @SideOnly(value=Side.CLIENT)
        public void reloadText(GuiBase gui) {
        }
    }
}

