/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.client.interfaces;

import hardcorequesting.HardcoreQuesting;
import hardcorequesting.bag.Group;
import hardcorequesting.bag.GroupTier;
import hardcorequesting.client.EditButton;
import hardcorequesting.client.EditMode;
import hardcorequesting.client.KeyboardHandler;
import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiColor;
import hardcorequesting.client.interfaces.LargeButton;
import hardcorequesting.client.interfaces.RenderRotation;
import hardcorequesting.client.interfaces.ResourceHelper;
import hardcorequesting.client.interfaces.ScrollBar;
import hardcorequesting.client.interfaces.TextBoxGroup;
import hardcorequesting.client.interfaces.edit.GuiEditMenu;
import hardcorequesting.client.interfaces.edit.GuiEditMenuCommandEditor;
import hardcorequesting.client.interfaces.edit.GuiEditMenuDeath;
import hardcorequesting.client.interfaces.edit.GuiEditMenuTeam;
import hardcorequesting.client.interfaces.edit.GuiEditMenuTextEditor;
import hardcorequesting.client.sounds.SoundHandler;
import hardcorequesting.death.DeathStats;
import hardcorequesting.items.ModItems;
import hardcorequesting.network.NetworkManager;
import hardcorequesting.network.message.CloseBookMessage;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestLine;
import hardcorequesting.quests.QuestSet;
import hardcorequesting.quests.QuestingData;
import hardcorequesting.reputation.Reputation;
import hardcorequesting.reputation.ReputationBar;
import hardcorequesting.reputation.ReputationMarker;
import hardcorequesting.team.PlayerEntry;
import hardcorequesting.team.Team;
import hardcorequesting.util.OPBookHelper;
import hardcorequesting.util.SaveHelper;
import hardcorequesting.util.Translator;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiQuestBook
extends GuiBase {
    public static final int PAGE_WIDTH = 170;
    public static final int VISIBLE_REPUTATION_TIERS = 9;
    public static final int VISIBLE_REPUTATIONS = 10;
    public static final int VISIBLE_DISPLAY_REPUTATIONS = 4;
    public static final int LIST_X = 25;
    public static final int LIST_Y = 20;
    public static final int TEXT_HEIGHT = 9;
    public static final int TEXT_SPACING = 20;
    public static final int DESCRIPTION_X = 180;
    public static final int DESCRIPTION_Y = 20;
    public static final int VISIBLE_DESCRIPTION_LINES = 7;
    public static final int VISIBLE_MAIN_DESCRIPTION_LINES = 21;
    public static final int VISIBLE_SETS = 7;
    public static final int TIERS_X = 180;
    public static final int TIERS_Y = 20;
    public static final int TIERS_SPACING = 25;
    public static final int TIERS_SECOND_LINE_X = -5;
    public static final int TIERS_SECOND_LINE_Y = 12;
    public static final int WEIGHT_SPACING = 25;
    public static final int VISIBLE_TIERS = 8;
    public static final int GROUPS_X = 20;
    public static final int GROUPS_Y = 20;
    public static final int GROUPS_SPACING = 25;
    public static final int GROUPS_SECOND_LINE_X = 5;
    public static final int GROUPS_SECOND_LINE_Y = 12;
    public static final int VISIBLE_GROUPS = 8;
    public static final int GROUP_ITEMS_X = 20;
    public static final int GROUP_ITEMS_Y = 40;
    public static final int GROUP_ITEMS_SPACING = 20;
    public static final int ITEMS_PER_LINE = 7;
    private static final String FRONT_KEY = "hqm_front_texture";
    private static final int TEXTURE_WIDTH = 340;
    private static final int TEXTURE_HEIGHT = 234;
    private static final int INFO_RIGHT_X = 180;
    private static final int INFO_LIVES_Y = 20;
    private static final int INFO_DEATHS_Y = 55;
    private static final int INFO_TEAM_Y = 95;
    private static final int INFO_LEFT_X = 20;
    private static final int INFO_QUESTS_Y = 20;
    private static final int INFO_REPUTATION_Y = 110;
    private static final int INFO_HEARTS_X = 5;
    private static final int INFO_HEARTS_Y = 12;
    private static final int INFO_HEARTS_SPACING = 18;
    private static final int TEAM_TEXT_Y = 12;
    private static final int TEAM_CLICK_TEXT_Y = 30;
    private static final int DEATH_TEXT_Y = 0;
    private static final int DEATH_CLICK_TEXT_Y = 10;
    private static final int QUEST_CLICK_TEXT_Y = 67;
    private static final int INFO_REPUTATION_OFFSET_X = 5;
    private static final int INFO_REPUTATION_OFFSET_Y = 12;
    private static final int BACK_ARROW_X = 9;
    private static final int BACK_ARROW_Y = 219;
    private static final int BACK_ARROW_SRC_X = 0;
    private static final int BACK_ARROW_SRC_Y = 113;
    private static final int BACK_ARROW_WIDTH = 15;
    private static final int BACK_ARROW_HEIGHT = 10;
    private static final int MENU_ARROW_X = 161;
    private static final int MENU_ARROW_Y = 217;
    private static final int MENU_ARROW_SRC_X = 0;
    private static final int MENU_ARROW_SRC_Y = 104;
    private static final int MENU_ARROW_WIDTH = 14;
    private static final int MENU_ARROW_HEIGHT = 9;
    private static final ResourceLocation BG_TEXTURE = ResourceHelper.getResource("book");
    public static QuestSet selectedSet;
    public static Quest selectedQuest;
    public static Group selectedGroup;
    public static Reputation selectedReputation;
    private static boolean isSetOpened;
    private static boolean isMainPageOpen;
    private static boolean isMenuPageOpen;
    private static boolean isBagPage;
    private static boolean isReputationPage;
    private static ItemStack selectedStack;
    public final boolean isOpBook;
    private final EntityPlayer player;
    public ScrollBar reputationDisplayScroll;
    public ScrollBar reputationScroll;
    public ScrollBar reputationTierScroll;
    public Group modifyingGroup;
    public QuestSet modifyingQuestSet;
    public Quest modifyingQuest;
    public ReputationBar modifyingBar;
    private ScrollBar setScroll;
    private ScrollBar descriptionScroll;
    private ScrollBar mainDescriptionScroll;
    private ScrollBar groupScroll;
    private ScrollBar tierScroll;
    private List<ScrollBar> scrollBars;
    private TextBoxGroup.TextBox textBoxGroupAmount;
    private TextBoxGroup textBoxes;
    private int tick;
    private GuiEditMenu editMenu;
    private LargeButton saveButton;
    private List<LargeButton> buttons = new ArrayList<LargeButton>();
    private EditMode currentMode = EditMode.NORMAL;
    private EditButton[] groupButtons = EditButton.createButtons(this, EditMode.NORMAL, EditMode.ITEM, EditMode.DELETE);
    private EditButton[] bagButtons = EditButton.createButtons(this, EditMode.NORMAL, EditMode.CREATE, EditMode.RENAME, EditMode.TIER, EditMode.DELETE);
    private EditButton[] reputationButtons = EditButton.createButtons(this, EditMode.NORMAL, EditMode.CREATE, EditMode.RENAME, EditMode.REPUTATION_VALUE, EditMode.DELETE);
    private EditButton[] mainButtons = EditButton.createButtons(this, EditMode.NORMAL, EditMode.RENAME);
    private EditButton[] menuButtons = EditButton.createButtons(this, EditMode.NORMAL, EditMode.BAG, EditMode.REPUTATION);
    private EditButton[] overviewButtons = EditButton.createButtons(this, EditMode.NORMAL, EditMode.CREATE, EditMode.RENAME, EditMode.SWAP_SELECT, EditMode.DELETE);
    private EditButton[] setButtons = EditButton.createButtons(this, EditMode.NORMAL, EditMode.MOVE, EditMode.CREATE, EditMode.REQUIREMENT, EditMode.SIZE, EditMode.ITEM, EditMode.REPEATABLE, EditMode.TRIGGER, EditMode.REQUIRED_PARENTS, EditMode.QUEST_SELECTION, EditMode.QUEST_OPTION, EditMode.SWAP, EditMode.REP_BAR_CREATE, EditMode.REP_BAR_CHANGE, EditMode.DELETE);
    private EditButton[] questButtons = EditButton.createButtons(this, EditMode.NORMAL, EditMode.RENAME, EditMode.TASK, EditMode.CHANGE_TASK, EditMode.ITEM, EditMode.LOCATION, EditMode.MOB, EditMode.REPUTATION_TASK, EditMode.REPUTATION_REWARD, EditMode.COMMAND_CREATE, EditMode.COMMAND_CHANGE, EditMode.DELETE);

    private GuiQuestBook(EntityPlayer player, boolean isOpBook) {
        this.scrollBars = new ArrayList<ScrollBar>();
        this.descriptionScroll = new ScrollBar(312, 18, 64, 249, 102, 180){

            @Override
            public boolean isVisible(GuiBase gui) {
                return !isReputationPage && !isBagPage && !isMainPageOpen && selectedSet != null && !isSetOpened && selectedSet.getDescription(gui).size() > 7;
            }
        };
        this.scrollBars.add(this.descriptionScroll);
        this.setScroll = new ScrollBar(160, 18, 186, 171, 69, 25){

            @Override
            public boolean isVisible(GuiBase gui) {
                return !isReputationPage && !isBagPage && !isMainPageOpen && (selectedSet == null || !isSetOpened) && Quest.getQuestSets().size() > 7;
            }
        };
        this.scrollBars.add(this.setScroll);
        this.mainDescriptionScroll = new ScrollBar(312, 18, 186, 171, 69, 180){

            @Override
            public boolean isVisible(GuiBase gui) {
                return !isReputationPage && !isBagPage && isMainPageOpen && Quest.getMainDescription(gui).size() > 21;
            }
        };
        this.scrollBars.add(this.mainDescriptionScroll);
        this.groupScroll = new ScrollBar(160, 18, 186, 171, 69, 20){

            @Override
            public boolean isVisible(GuiBase gui) {
                return !isReputationPage && isBagPage && selectedGroup == null && Group.getGroups().size() > 8;
            }
        };
        this.scrollBars.add(this.groupScroll);
        this.tierScroll = new ScrollBar(312, 18, 186, 171, 69, 180){

            @Override
            public boolean isVisible(GuiBase gui) {
                return !isReputationPage && isBagPage && selectedGroup == null && GroupTier.getTiers().size() > 8;
            }
        };
        this.scrollBars.add(this.tierScroll);
        this.reputationTierScroll = new ScrollBar(312, 23, 186, 171, 69, 180){

            @Override
            public boolean isVisible(GuiBase gui) {
                return isReputationPage && !isBagPage && !isMainPageOpen && selectedReputation != null && selectedReputation.getMarkerCount() > 9;
            }
        };
        this.scrollBars.add(this.reputationTierScroll);
        this.reputationScroll = new ScrollBar(160, 23, 186, 171, 69, 20){

            @Override
            public boolean isVisible(GuiBase gui) {
                return isReputationPage && !isBagPage && (GuiQuestBook.this.getCurrentMode() != EditMode.CREATE || selectedReputation == null) && Reputation.getReputations().size() > 10;
            }
        };
        this.scrollBars.add(this.reputationScroll);
        this.reputationDisplayScroll = new ScrollBar(160, 125, 87, 164, 69, 20){

            @Override
            public boolean isVisible(GuiBase gui) {
                return isMenuPageOpen && !isMainPageOpen && Reputation.getReputations().size() > 4;
            }
        };
        this.scrollBars.add(this.reputationDisplayScroll);
        this.textBoxes = new TextBoxGroup();
        this.textBoxGroupAmount = new TextBoxGroup.TextBox(this, "0", 180, 30, false){

            @Override
            protected boolean isCharacterValid(char c) {
                return this.getText().length() < 3 && Character.isDigit(c);
            }

            @Override
            public void textChanged(GuiBase gui) {
                try {
                    int number = this.getText().equals("") ? 1 : Integer.parseInt(this.getText());
                    if (selectedGroup != null) {
                        selectedGroup.setLimit(number);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.textBoxes.add(this.textBoxGroupAmount);
        this.saveButton = new LargeButton("hqm.questBook.saveAll", 360, 10){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return Quest.isEditing && SaveHelper.isLarge();
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                GuiQuestBook.this.save();
            }
        };
        this.buttons.add(this.saveButton);
        this.buttons.add(new LargeButton("hqm.questBook.open", 245, 190){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return GuiQuestBook.this.editMenu == null && selectedSet != null && !isBagPage && !isSetOpened && !isMainPageOpen && !isMenuPageOpen && !isReputationPage;
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                isSetOpened = true;
            }
        });
        this.buttons.add(new LargeButton("hqm.questBook.createSet", 185, 50){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return GuiQuestBook.this.editMenu == null && Quest.isEditing && GuiQuestBook.this.currentMode == EditMode.CREATE && !isBagPage && !isSetOpened && !isMainPageOpen && !isMenuPageOpen && !isReputationPage;
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                int i = 0;
                for (QuestSet set : Quest.getQuestSets()) {
                    if (!set.getName().startsWith("Unnamed set")) continue;
                    ++i;
                }
                Quest.getQuestSets().add(new QuestSet("Unnamed set" + (i == 0 ? "" : Integer.valueOf(i)), "No description"));
                SaveHelper.add(SaveHelper.EditType.SET_CREATE);
            }
        });
        this.buttons.add(new LargeButton("hqm.questBook.createGroup", 100, 175){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return GuiQuestBook.this.editMenu == null && isBagPage && GuiQuestBook.this.currentMode == EditMode.CREATE && selectedGroup == null && !isMainPageOpen && !isMenuPageOpen && !isReputationPage;
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                Group.add(new Group(null));
                SaveHelper.add(SaveHelper.EditType.GROUP_CREATE);
            }
        });
        this.buttons.add(new LargeButton("hqm.questBook.createTier", 100, 200){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return GuiQuestBook.this.editMenu == null && isBagPage && GuiQuestBook.this.currentMode == EditMode.CREATE && selectedGroup == null && !isMainPageOpen && !isMenuPageOpen && !isReputationPage;
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                GroupTier.getTiers().add(new GroupTier("New Tier", GuiColor.BLACK, 0, 0, 0, 0, 0));
                SaveHelper.add(SaveHelper.EditType.TIER_CREATE);
            }
        });
        this.buttons.add(new LargeButton("Reset", 90, 190){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return GuiScreen.func_146271_m() && GuiScreen.func_146272_n();
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return GuiQuestBook.this.editMenu == null && !isBagPage && !isMainPageOpen && GuiQuestBook.this.isOpBook && isMenuPageOpen && !isReputationPage;
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                OPBookHelper.reset(player);
            }
        });
        this.buttons.add(new LargeButton("Create New", 180, 20){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return GuiQuestBook.this.editMenu == null && !isBagPage && GuiQuestBook.this.currentMode == EditMode.CREATE && selectedReputation == null && !isMainPageOpen && !isMenuPageOpen && isReputationPage;
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                Reputation.addReputation(new Reputation("Unnamed", "Neutral"));
                SaveHelper.add(SaveHelper.EditType.REPUTATION_ADD);
            }
        });
        this.buttons.add(new LargeButton("hqm.questBook.createTier", 20, 20){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return GuiQuestBook.this.editMenu == null && !isBagPage && GuiQuestBook.this.currentMode == EditMode.CREATE && selectedReputation != null && !isMainPageOpen && !isMenuPageOpen && isReputationPage;
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                selectedReputation.add(new ReputationMarker("Unnamed", 0, false));
                SaveHelper.add(SaveHelper.EditType.REPUTATION_MARKER_CREATE);
            }
        });
        this.player = player;
        this.isOpBook = isOpBook;
        if (Quest.isEditing) {
            Keyboard.enableRepeatEvents((boolean)true);
        }
        QuestingData data = QuestingData.getQuestingData(player);
        if (!data.playedLore && SoundHandler.hasLoreMusic()) {
            SoundHandler.triggerFirstLore();
            data.playedLore = true;
        }
    }

    public static void resetBookPosition() {
        selectedSet = null;
        isSetOpened = false;
        selectedQuest = null;
        isMainPageOpen = true;
        isBagPage = false;
        isReputationPage = false;
        isMenuPageOpen = true;
        selectedGroup = null;
        selectedReputation = null;
    }

    public static Group getSelectedGroup() {
        return selectedGroup;
    }

    public static void displayGui(EntityPlayer player, boolean isOpBook) {
        if (!(player == null || Minecraft.func_71410_x().field_71462_r != null && Minecraft.func_71410_x().field_71462_r instanceof GuiQuestBook)) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiQuestBook(player, isOpBook));
        }
    }

    public static void setSelectedStack(ItemStack stack) {
        selectedStack = stack;
    }

    public TextBoxGroup.TextBox getTextBoxGroupAmount() {
        return this.textBoxGroupAmount;
    }

    public int getTick() {
        return this.tick;
    }

    @Override
    public void setEditMenu(GuiEditMenu editMenu) {
        this.editMenu = editMenu;
    }

    public void func_73863_a(int x0, int y0, float f) {
        selectedStack = null;
        this.left = (this.field_146294_l - 340) / 2;
        this.top = (this.field_146295_m - 234) / 2;
        int x = x0 - this.left;
        int y = y0 - this.top;
        this.applyColor(-1);
        ResourceHelper.bindResource(BG_TEXTURE);
        this.drawRect(0, 0, 0, 0, 170, 234);
        this.drawRect(170, 0, 0, 0, 170, 234, RenderRotation.FLIP_HORIZONTAL);
        if (Quest.isEditing) {
            this.applyColor(-1);
            ResourceHelper.bindResource(MAP_TEXTURE);
            SaveHelper.render(this, x, y);
        }
        for (LargeButton button2 : this.buttons) {
            button2.draw(this, this.player, x, y);
        }
        this.applyColor(-1);
        ResourceHelper.bindResource(MAP_TEXTURE);
        if (this.shouldDisplayControlArrow(false)) {
            this.drawRect(9, 219, 0 + (this.inArrowBounds(false, x, y) ? 15 : 0), 113, 15, 10);
        }
        if (this.shouldDisplayControlArrow(true)) {
            this.drawRect(161, 217, 0 + (this.inArrowBounds(true, x, y) ? 14 : 0), 104, 14, 9);
        }
        if (this.editMenu == null) {
            if (Quest.isEditing) {
                for (EditButton editButton : this.getButtons()) {
                    editButton.draw(x, y);
                }
            }
            for (ScrollBar scrollBar : this.scrollBars) {
                scrollBar.draw(this);
            }
            if (isMainPageOpen) {
                this.drawMainPage();
            } else if (isMenuPageOpen) {
                this.drawMenuPage(x, y);
            } else if (isBagPage) {
                this.drawBagPage(x, y);
            } else if (isReputationPage) {
                Reputation.drawEditPage(this, x, y);
            } else if (selectedSet == null || !isSetOpened) {
                QuestSet.drawOverview(this, this.setScroll, this.descriptionScroll, x, y);
            } else if (selectedQuest == null) {
                selectedSet.draw(this, x0, y0, x, y);
            } else {
                selectedQuest.drawMenu(this, this.player, x, y);
            }
            if (Quest.isEditing) {
                for (EditButton editButton : this.getButtons()) {
                    editButton.drawInfo(x, y);
                }
            }
            if (this.currentMode == EditMode.DELETE) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)200.0f);
                this.drawCenteredString(Translator.translate("hqm.questBook.warning"), 0, 0, 2.0f, 340, 234, 0xFF0000);
                this.drawCenteredString(Translator.translate("hqm.questBook.deleteOnClick"), 0, this.field_146289_q.field_78288_b * 2, 1.0f, 340, 234, 0xFF0000);
                this.applyColor(-1);
                ResourceHelper.bindResource(MAP_TEXTURE);
                GlStateManager.func_179121_F();
            }
        } else {
            this.editMenu.draw(this, x, y);
            this.editMenu.drawMouseOver(this, x, y);
        }
        this.buttons.forEach(button -> button.drawMouseOver(this, this.player, x, y));
        if (this.shouldDisplayAndIsInArrowBounds(false, x, y)) {
            this.drawMouseOver(Translator.translate("hqm.questBook.goBack") + "\n" + (Object)((Object)GuiColor.GRAY) + Translator.translate("hqm.questBook.rightClick"), x + this.left, y + this.top);
        } else if (this.shouldDisplayAndIsInArrowBounds(true, x, y)) {
            this.drawMouseOver(Translator.translate("hqm.questBook.backToMenu"), x + this.left, y + this.top);
        }
    }

    protected void func_73869_a(char c, int k) throws IOException {
        super.func_73869_a(c, k);
        if (this.editMenu != null) {
            this.editMenu.onKeyTyped(this, c, k);
        } else if (isBagPage && selectedGroup != null) {
            this.textBoxes.onKeyStroke(this, c, k);
        } else if (KeyboardHandler.pressedHotkey(this, k, this.getButtons())) {
            this.onButtonClicked();
        }
    }

    protected void func_73864_a(int x0, int y0, int button) throws IOException {
        super.func_73864_a(x0, y0, button);
        int x = x0 - this.left;
        int y = y0 - this.top;
        if (this.shouldDisplayAndIsInArrowBounds(false, x, y)) {
            button = 1;
            if (this.editMenu != null) {
                this.editMenu.save(this);
                this.editMenu.close(this);
                return;
            }
        } else if (this.shouldDisplayAndIsInArrowBounds(true, x, y)) {
            isMenuPageOpen = true;
            if (this.editMenu != null) {
                this.editMenu.save(this);
                this.editMenu.close(this);
                this.editMenu = null;
            }
            isBagPage = false;
            isReputationPage = false;
            return;
        }
        for (LargeButton largeButton : this.buttons) {
            if (!largeButton.isVisible(this, this.player) || !largeButton.isEnabled(this, this.player) || !largeButton.inButtonBounds(this, x, y)) continue;
            largeButton.onClick(this, this.player);
        }
        if (Quest.isEditing) {
            SaveHelper.onClick(this, x, y);
        }
        if (this.editMenu == null) {
            if (Quest.isEditing) {
                for (EditButton editButton : this.getButtons()) {
                    if (!editButton.onClick(x, y)) continue;
                    this.onButtonClicked();
                    break;
                }
            }
            for (ScrollBar scrollBar : this.scrollBars) {
                scrollBar.onClick(this, x, y);
            }
            if (isMainPageOpen) {
                this.mainPageMouseClicked(x, y);
            } else if (isMenuPageOpen) {
                this.menuPageMouseClicked(button, x, y);
            } else if (isBagPage) {
                this.bagPageMouseClicked(button, x, y);
            } else if (isReputationPage) {
                if (button == 1) {
                    isMenuPageOpen = true;
                    isReputationPage = false;
                } else {
                    Reputation.onClick(this, x, y, this.player);
                }
            } else if (selectedSet == null || !isSetOpened) {
                if (button == 1) {
                    isMenuPageOpen = true;
                    return;
                }
                QuestSet.mouseClickedOverview(this, this.setScroll, x, y);
            } else if (selectedQuest == null) {
                if (button == 1) {
                    isSetOpened = false;
                } else {
                    selectedSet.mouseClicked(this, x, y);
                }
            } else {
                selectedQuest.onClick(this, this.player, x, y, button);
            }
        } else {
            this.editMenu.onClick(this, x, y, button);
        }
    }

    protected void func_146286_b(int x0, int y0, int button) {
        super.func_146286_b(x0, y0, button);
        int x = x0 - this.left;
        int y = y0 - this.top;
        this.updatePosition(x, y);
        if (this.currentMode == EditMode.MOVE) {
            this.modifyingQuest = null;
            this.modifyingBar = null;
        }
        if (this.editMenu != null) {
            this.editMenu.onRelease(this, x, y);
        } else if (selectedQuest != null) {
            selectedQuest.onRelease(this, this.player, x, y, button);
        } else {
            for (ScrollBar scrollBar : this.scrollBars) {
                scrollBar.onRelease(this, x, y);
            }
        }
    }

    protected void func_146273_a(int x0, int y0, int button, long ticks) {
        super.func_146273_a(x0, y0, button, ticks);
        int x = x0 - this.left;
        int y = y0 - this.top;
        this.updatePosition(x, y);
        if (this.editMenu != null) {
            this.editMenu.onDrag(this, x, y);
        } else if (selectedQuest != null) {
            selectedQuest.onDrag(this, this.player, x, y, button);
        } else {
            for (ScrollBar scrollBar : this.scrollBars) {
                scrollBar.onDrag(this, x, y);
            }
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c - this.left;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1 - this.top;
        int scroll = Mouse.getEventDWheel();
        if (scroll != 0) {
            if (this.editMenu != null) {
                this.editMenu.onScroll(this, x, y, scroll);
            } else if (selectedQuest != null) {
                selectedQuest.onScroll(this, x, y, scroll);
            } else {
                for (ScrollBar scrollBar : this.scrollBars) {
                    scrollBar.onScroll(this, x, y, scroll);
                }
            }
        }
    }

    public void func_73876_c() {
        ++this.tick;
        super.func_73876_c();
    }

    public void func_146281_b() {
        NetworkManager.sendToServer(new CloseBookMessage(this.player.func_110124_au().toString()));
        Keyboard.enableRepeatEvents((boolean)true);
        SoundHandler.stopLoreMusic();
    }

    public boolean func_73868_f() {
        return false;
    }

    private void drawBagPage(int x, int y) {
        if (selectedGroup != null) {
            selectedGroup.draw(this, x, y);
            this.textBoxes.draw(this);
        } else {
            Group.drawOverview(this, this.tierScroll, this.groupScroll, x, y);
        }
    }

    private void drawMenuPage(int x, int y) {
        String str;
        this.drawString(Translator.translate("hqm.questBook.lives"), 180, 20, 0x404040);
        this.drawString(Translator.translate("hqm.questBook.party"), 180, 95, 0x404040);
        this.drawString(Translator.translate("hqm.questBook.quests"), 20, 20, 0x404040);
        this.drawString(Translator.translate("hqm.questBook.reputation"), 20, 110, 0x404040);
        QuestSet.drawQuestInfo(this, null, 20, 33);
        this.drawString(Translator.translate("hqm.questBook.showQuests"), 20, 87, 0.7f, 0x707070);
        if (QuestingData.isHardcoreActive()) {
            int spacing;
            int count;
            int heartX;
            boolean almostOut;
            boolean bl = almostOut = QuestingData.getQuestingData(this.player).getLives() == QuestingData.getQuestingData(this.player).getLivesToStayAlive();
            if (almostOut) {
                this.drawString((Object)((Object)GuiColor.RED) + Translator.translate("hqm.questBook.deadOut"), 230, 22, 0.7f, 0x404040);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int lives = QuestingData.getQuestingData(this.player).getLives();
            if (lives < 8) {
                heartX = 185;
                count = lives;
                spacing = 18;
            } else {
                heartX = 205;
                count = 3;
                spacing = 3;
                this.drawString(lives + " x", 185, 37, 0.7f, 0x404040);
            }
            for (int i = 0; i < count; ++i) {
                this.drawItemStack(new ItemStack((Item)ModItems.hearts, 1, 3), heartX + spacing * i, 32, almostOut);
            }
        } else {
            this.drawString(this.getLinesFromText(Translator.translate("hqm.questBook.infiniteLives"), 0.5f, 140), 180, 32, 0.5f, 0x707070);
        }
        int deaths = DeathStats.getDeathStats(QuestingData.getUserUUID(this.player)).getTotalDeaths();
        this.drawString(Translator.translate(deaths != 1, "hqm.questBook.deaths", deaths), 180, 55, 0.7f, 0x404040);
        this.drawString(Translator.translate("hqm.questBook.moreInfo"), 180, 65, 0.7f, 0x707070);
        Team team = QuestingData.getQuestingData(this.player).getTeam();
        if (team.isSingle()) {
            int invites;
            int n = invites = team.getInvites() == null ? 0 : team.getInvites().size();
            str = invites > 0 ? Translator.translate(invites != 1, "hqm.questBook.invites", invites) : Translator.translate("hqm.questBook.notInParty");
        } else {
            int players = 0;
            for (PlayerEntry player : team.getPlayers()) {
                if (!player.isInTeam()) continue;
                ++players;
            }
            str = Translator.translate(players != 1, "hqm.questBook.inParty", players);
        }
        this.drawString(str, 180, 107, 0.7f, 0x404040);
        this.drawString(Translator.translate("hqm.questBook.openParty"), 180, 125, 0.7f, 0x707070);
        if (this.isOpBook) {
            this.drawString(Translator.translate("hqm.questBook.resetParty"), 22, 182, 0.6f, 0x404040);
            this.drawString(this.getLinesFromText(Translator.translate("hqm.questBook.shiftCtrlConfirm"), 0.6f, 70), 22, 192, 0.6f, GuiColor.RED.getHexColor());
        }
        Reputation.drawAll(this, 25, 122, x, y, this.player);
    }

    private void drawMainPage() {
        int startLine = this.mainDescriptionScroll.isVisible(this) ? Math.round((float)(Quest.getMainDescription(this).size() - 21) * this.mainDescriptionScroll.getScroll()) : 0;
        this.drawString(Quest.getMainDescription(this), startLine, 21, 180, 20, 0.7f, 0x404040);
        this.drawCenteredString(Translator.translate("hqm.questBook.start"), 0, 195, 0.7f, 170, 39, 0x707070);
        if (SoundHandler.hasLoreMusic() && !SoundHandler.isLorePlaying()) {
            this.drawCenteredString(Translator.translate("hqm.questBook.playAgain"), 170, 195, 0.7f, 160, 39, 0x707070);
        }
        if (QuestLine.getActiveQuestLine().front == null && QuestLine.getActiveQuestLine().mainPath != null) {
            File file = new File(HardcoreQuesting.configDir, "front.png");
            if (file.exists()) {
                try {
                    BufferedImage img = ImageIO.read(file);
                    DynamicTexture dm = new DynamicTexture(img);
                    QuestLine.getActiveQuestLine().front = Minecraft.func_71410_x().func_110434_K().func_110578_a(FRONT_KEY, dm);
                }
                catch (IOException ignored) {
                    QuestLine.getActiveQuestLine().front = ResourceHelper.getResource("front");
                }
            } else {
                QuestLine.getActiveQuestLine().front = ResourceHelper.getResource("front");
            }
        }
        if (QuestLine.getActiveQuestLine().front != null) {
            ResourceHelper.bindResource(QuestLine.getActiveQuestLine().front);
            this.applyColor(-1);
            this.drawRect(20, 20, 0, 0, 140, 180);
        }
    }

    public void goBack() {
        if (isMenuPageOpen) {
            isMainPageOpen = true;
        } else if (isBagPage) {
            isBagPage = false;
            isMenuPageOpen = true;
        } else if (isReputationPage) {
            isMenuPageOpen = true;
            isReputationPage = false;
        } else if (selectedSet == null || !isSetOpened) {
            isMenuPageOpen = true;
        } else if (selectedQuest == null) {
            isSetOpened = false;
        }
    }

    private void onButtonClicked() {
        if (this.currentMode == EditMode.BAG) {
            this.currentMode = EditMode.NORMAL;
            isBagPage = true;
            isMenuPageOpen = false;
        } else if (this.currentMode == EditMode.REPUTATION) {
            this.currentMode = EditMode.NORMAL;
            isReputationPage = true;
            isMenuPageOpen = false;
        }
    }

    private void bagPageMouseClicked(int button, int x, int y) {
        if (selectedGroup != null) {
            if (button == 1) {
                selectedGroup = null;
            } else {
                selectedGroup.mouseClicked(this, x, y);
                this.textBoxes.onClick(this, x, y);
            }
        } else if (button == 1) {
            isBagPage = false;
            isMenuPageOpen = true;
        } else {
            Group.mouseClickedOverview(this, this.groupScroll, x, y);
            GroupTier.mouseClickedOverview(this, this.tierScroll, x, y);
        }
    }

    private void menuPageMouseClicked(int button, int x, int y) {
        if (button == 1) {
            isMainPageOpen = true;
        } else if (this.inBounds(180, 125, 170, 6, x, y)) {
            this.editMenu = new GuiEditMenuTeam(this, this.player);
        } else if (this.inBounds(180, 65, 170, 6, x, y)) {
            this.editMenu = new GuiEditMenuDeath(this, this.player);
        } else if (this.inBounds(20, 87, 170, 6, x, y)) {
            isMenuPageOpen = false;
        }
    }

    private void mainPageMouseClicked(int x, int y) {
        if (x > 0 && x < 170 && y > 205) {
            isMainPageOpen = false;
            SoundHandler.stopLoreMusic();
        } else if (x > 170 && x < 340 && y > 205) {
            if (SoundHandler.hasLoreMusic() && !SoundHandler.isLorePlaying()) {
                SoundHandler.playLoreMusic();
            }
        } else if (Quest.isEditing && this.currentMode == EditMode.RENAME && this.inBounds(180, 20, 130, 132, x, y)) {
            this.editMenu = new GuiEditMenuTextEditor(this, this.player);
        }
    }

    private void updatePosition(int x, int y) {
        if (Quest.isEditing && this.currentMode == EditMode.MOVE) {
            if (this.modifyingQuest != null) {
                this.modifyingQuest.setGuiCenterX(x);
                this.modifyingQuest.setGuiCenterY(y);
            }
            if (this.modifyingBar != null) {
                this.modifyingBar.moveTo(x, y);
            }
        }
    }

    public void loadMap() {
        selectedQuest = null;
    }

    public EditMode getCurrentMode() {
        return this.currentMode;
    }

    public void setCurrentMode(EditMode mode) {
        this.currentMode = mode;
        if (this.currentMode == EditMode.COMMAND_CREATE || this.currentMode == EditMode.COMMAND_CHANGE) {
            this.setEditMenu(new GuiEditMenuCommandEditor(this, this.player));
        }
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public void save() {
        QuestLine.saveAll();
        SaveHelper.onSave();
    }

    private EditButton[] getButtons() {
        return isMainPageOpen ? this.mainButtons : (isMenuPageOpen ? this.menuButtons : (isReputationPage ? this.reputationButtons : (isBagPage ? (selectedGroup != null ? this.groupButtons : this.bagButtons) : (selectedSet == null || !isSetOpened ? this.overviewButtons : (selectedQuest == null ? this.setButtons : this.questButtons)))));
    }

    private boolean shouldDisplayControlArrow(boolean isMenuArrow) {
        return !isMainPageOpen && ((!isMenuArrow || !isMenuPageOpen) && this.editMenu == null || this.editMenu != null && !this.editMenu.hasButtons());
    }

    private boolean inArrowBounds(boolean isMenuArrow, int mX, int mY) {
        if (isMenuArrow) {
            return this.inBounds(161, 217, 14, 9, mX, mY);
        }
        return this.inBounds(9, 219, 15, 10, mX, mY);
    }

    private boolean shouldDisplayAndIsInArrowBounds(boolean isMenuArrow, int mX, int mY) {
        return this.shouldDisplayControlArrow(isMenuArrow) && this.inArrowBounds(isMenuArrow, mX, mY);
    }

    static {
        isMainPageOpen = true;
        isMenuPageOpen = true;
    }
}

