/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.client.interfaces;

import hardcorequesting.client.interfaces.RenderRotation;
import hardcorequesting.client.interfaces.ResourceHelper;
import hardcorequesting.client.interfaces.edit.GuiEditMenu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiBase
extends GuiScreen {
    public static final ResourceLocation MAP_TEXTURE = ResourceHelper.getResource("questmap");
    public static final int ITEM_SIZE = 18;
    protected static final int ITEM_SRC_Y = 235;
    protected static RenderItem itemRenderer = Minecraft.func_71410_x().func_175599_af();
    protected int left;
    protected int top;

    public void setEditMenu(GuiEditMenu menu) {
    }

    public void drawRect(int x, int y, int u, int v, int w, int h) {
        this.drawRect(x, y, u, v, w, h, RenderRotation.NORMAL);
    }

    public void drawRect(int x, int y, int u, int v, int w, int h, RenderRotation rotation) {
        double[] pt4;
        double[] pt3;
        double[] pt2;
        double[] pt1;
        boolean rotate = rotation == RenderRotation.ROTATE_90 || rotation == RenderRotation.ROTATE_270 || rotation == RenderRotation.ROTATE_90_FLIP || rotation == RenderRotation.ROTATE_270_FLIP;
        int targetW = rotate ? h : w;
        int targetH = rotate ? w : h;
        x += this.left;
        y += this.top;
        float fw = 0.00390625f;
        float fy = 0.00390625f;
        double a = (float)u * fw;
        double b = (float)(u + w) * fw;
        double c = (float)(v + h) * fy;
        double d = (float)v * fy;
        double[] ptA = new double[]{a, c};
        double[] ptB = new double[]{b, c};
        double[] ptC = new double[]{b, d};
        double[] ptD = new double[]{a, d};
        switch (rotation) {
            default: {
                pt1 = ptA;
                pt2 = ptB;
                pt3 = ptC;
                pt4 = ptD;
                break;
            }
            case ROTATE_90: {
                pt1 = ptB;
                pt2 = ptC;
                pt3 = ptD;
                pt4 = ptA;
                break;
            }
            case ROTATE_180: {
                pt1 = ptC;
                pt2 = ptD;
                pt3 = ptA;
                pt4 = ptB;
                break;
            }
            case ROTATE_270: {
                pt1 = ptD;
                pt2 = ptA;
                pt3 = ptB;
                pt4 = ptC;
                break;
            }
            case FLIP_HORIZONTAL: {
                pt1 = ptB;
                pt2 = ptA;
                pt3 = ptD;
                pt4 = ptC;
                break;
            }
            case ROTATE_90_FLIP: {
                pt1 = ptA;
                pt2 = ptD;
                pt3 = ptC;
                pt4 = ptB;
                break;
            }
            case FLIP_VERTICAL: {
                pt1 = ptD;
                pt2 = ptC;
                pt3 = ptB;
                pt4 = ptA;
                break;
            }
            case ROTATE_270_FLIP: {
                pt1 = ptC;
                pt2 = ptB;
                pt3 = ptA;
                pt4 = ptD;
            }
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b((double)x, (double)(y + targetH), (double)this.field_73735_i).func_187315_a(pt1[0], pt1[1]).func_181675_d();
        worldRenderer.func_181662_b((double)(x + targetW), (double)(y + targetH), (double)this.field_73735_i).func_187315_a(pt2[0], pt2[1]).func_181675_d();
        worldRenderer.func_181662_b((double)(x + targetW), (double)y, (double)this.field_73735_i).func_187315_a(pt3[0], pt3[1]).func_181675_d();
        worldRenderer.func_181662_b((double)x, (double)y, (double)this.field_73735_i).func_187315_a(pt4[0], pt4[1]).func_181675_d();
        tessellator.func_78381_a();
    }

    public void drawMouseOver(String str, int x, int y) {
        ArrayList<String> lst = new ArrayList<String>();
        Collections.addAll(lst, str.split("\n"));
        this.drawMouseOver(lst, x, y);
    }

    public void drawMouseOver(List<String> str, int x, int y) {
        float oldZ = this.field_73735_i;
        GlStateManager.func_179097_i();
        int w = 0;
        for (String line : str) {
            int l = this.field_146289_q.func_78256_a(line);
            if (l <= w) continue;
            w = l;
        }
        x += 12;
        y -= 12;
        int h = 8;
        if (str.size() > 1) {
            h += 2 + (str.size() - 1) * 10;
        }
        if (x + w > this.field_146294_l) {
            x -= 28 + w;
        }
        if (y + h + 6 > this.field_146295_m) {
            y = this.field_146295_m - h - 6;
        }
        this.field_73735_i = 300.0f;
        int bg = -267386864;
        this.func_73733_a(x - 3, y - 4, x + w + 3, y - 3, bg, bg);
        this.func_73733_a(x - 3, y + h + 3, x + w + 3, y + h + 4, bg, bg);
        this.func_73733_a(x - 3, y - 3, x + w + 3, y + h + 3, bg, bg);
        this.func_73733_a(x - 4, y - 3, x - 3, y + h + 3, bg, bg);
        this.func_73733_a(x + w + 3, y - 3, x + w + 4, y + h + 3, bg, bg);
        int border1 = 0x505000FF;
        int border2 = (border1 & 0xFEFEFE) >> 1 | border1 & 0xFF000000;
        this.func_73733_a(x - 3, y - 3 + 1, x - 3 + 1, y + h + 3 - 1, border1, border2);
        this.func_73733_a(x + w + 2, y - 3 + 1, x + w + 3, y + h + 3 - 1, border1, border2);
        this.func_73733_a(x - 3, y - 3, x + w + 3, y - 3 + 1, border1, border1);
        this.func_73733_a(x - 3, y + h + 2, x + w + 3, y + h + 3, border2, border2);
        for (int i = 0; i < str.size(); ++i) {
            String line = str.get(i);
            this.field_146289_q.func_175063_a(line, (float)x, (float)y, -1);
            if (i == 0) {
                y += 2;
            }
            y += 10;
        }
        this.field_73735_i = oldZ;
        GlStateManager.func_179126_j();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawLine(int x1, int y1, int x2, int y2, int thickness, int color) {
        GlStateManager.func_179090_x();
        this.applyColor(color);
        GL11.glEnable((int)2848);
        GL11.glLineWidth((float)(1.0f + (float)(thickness * this.field_146294_l) / 500.0f));
        GL11.glBegin((int)1);
        GL11.glVertex3f((float)x1, (float)y1, (float)0.0f);
        GL11.glVertex3f((float)x2, (float)y2, (float)0.0f);
        GL11.glEnd();
        GlStateManager.func_179098_w();
    }

    public void applyColor(int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
    }

    public void drawIcon(ItemStack stack, int x, int y) {
        itemRenderer.func_180453_a(this.field_146289_q, stack, x, y, null);
    }

    protected void drawItemBackground(int x, int y, int mX, int mY, boolean selected) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ResourceHelper.bindResource(MAP_TEXTURE);
        this.drawRect(x, y, this.inBounds(x, y, 18, 18, mX, mY) ? 18 : 0, 235, 18, 18);
        if (selected) {
            this.drawRect(x, y, 36, 235, 18, 18);
        }
    }

    public void drawItemStack(ItemStack stack, int x, int y, int mX, int mY, boolean selected) {
        this.drawItemBackground(x, y, mX, mY, selected);
        if (stack != null) {
            this.drawItemStack(stack, x + 1, y + 1, true);
        }
    }

    protected void setColor(int color) {
        float[] colorComponents = new float[3];
        for (int i = 0; i < colorComponents.length; ++i) {
            colorComponents[i] = (float)((color & 255 << i * 8) >> i * 8) / 255.0f;
        }
        GlStateManager.func_179131_c((float)colorComponents[2], (float)colorComponents[1], (float)colorComponents[0], (float)1.0f);
    }

    public void drawItemStack(ItemStack stack, int x, int y, boolean renderEffect) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        RenderHelper.func_74520_c();
        GlStateManager.func_179126_j();
        GlStateManager.func_179091_B();
        GlStateManager.func_179109_b((float)(this.getLeft() + x), (float)(this.getTop() + y), (float)0.0f);
        Minecraft mc = Minecraft.func_71410_x();
        boolean flagBefore = mc.field_71466_p.func_82883_a();
        mc.field_71466_p.func_78264_a(false);
        Minecraft.func_71410_x().func_175599_af().func_180450_b(stack, 0, 0);
        Minecraft.func_71410_x().func_175599_af().func_180453_a(mc.field_71466_p, stack, 0, 0, null);
        mc.field_71466_p.func_78264_a(flagBefore);
        RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
    }

    public float getZLevel() {
        return this.field_73735_i;
    }

    public void setZLevel(float zLevel) {
        this.field_73735_i = zLevel;
    }

    public int getLeft() {
        return this.left;
    }

    public int getTop() {
        return this.top;
    }

    public int getStringWidth(String txt) {
        return this.field_146289_q.func_78256_a(txt);
    }

    public void drawString(String str, int x, int y, int color) {
        this.drawString(str, x, y, 1.0f, color);
    }

    public void drawString(String str, int x, int y, float mult, int color) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)mult, (float)mult, (float)1.0f);
        this.field_146289_q.func_78276_b(str, (int)((float)(x + this.left) / mult), (int)((float)(y + this.top) / mult), color);
        GlStateManager.func_179121_F();
    }

    public void drawStringWithShadow(String str, int x, int y, float mult, int color) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)mult, (float)mult, (float)1.0f);
        this.field_146289_q.func_175063_a(str, (float)((int)((float)(x + this.left) / mult)), (float)((int)((float)(y + this.top) / mult)), color);
        GlStateManager.func_179121_F();
    }

    public boolean inBounds(int x, int y, int w, int h, int mX, int mY) {
        return x <= mX && mX <= x + w && y <= mY && mY <= y + h;
    }

    public void drawCursor(int x, int y, int z, float size, int color) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)z);
        GlStateManager.func_179109_b((float)(x += this.left), (float)(y += this.top), (float)0.0f);
        GlStateManager.func_179152_a((float)size, (float)size, (float)0.0f);
        GlStateManager.func_179109_b((float)(-x), (float)(-y), (float)0.0f);
        Gui.func_73734_a((int)x, (int)(y + 1), (int)(x + 1), (int)(y + 10), (int)color);
        GlStateManager.func_179121_F();
    }

    public void drawString(List<String> str, int x, int y, float mult, int color) {
        this.drawString(str, 0, str.size(), x, y, mult, color);
    }

    public void drawString(List<String> str, int start, int length, int x, int y, float mult, int color) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)mult, (float)mult, (float)1.0f);
        start = Math.max(start, 0);
        int end = Math.min(start + length, str.size());
        for (int i = start; i < end; ++i) {
            this.field_146289_q.func_78276_b(str.get(i), (int)((float)(x + this.left) / mult), (int)((float)(y + this.top) / mult), color);
            y += this.field_146289_q.field_78288_b;
        }
        GlStateManager.func_179121_F();
    }

    public void drawCenteredString(String str, int x, int y, float mult, int width, int height, int color) {
        this.drawString(str, x + (width - (int)((float)this.field_146289_q.func_78256_a(str) * mult)) / 2, y + (height - (int)((float)(this.field_146289_q.field_78288_b - 2) * mult)) / 2, mult, color);
    }

    public List<String> getLinesFromText(String str, float mult, int width) {
        String[] lines;
        ArrayList<String> lst = new ArrayList<String>();
        if (str == null) {
            str = "Missing info";
        }
        for (String line : lines = str.split("\n")) {
            ArrayList<String> words = new ArrayList<String>();
            Collections.addAll(words, line.split(" "));
            if (line.endsWith(" ")) {
                char c;
                String spaceTail = "";
                for (int i = line.length() - 1; i >= 0 && (c = line.charAt(i)) == ' '; --i) {
                    spaceTail = spaceTail + c;
                }
                words.add(spaceTail);
            }
            for (int i = 0; i < words.size(); ++i) {
                String word = (String)words.get(i);
                String other = "";
                while (true) {
                    StringBuilder stringBuilder = new StringBuilder();
                    if (!((float)this.field_146289_q.func_78256_a(stringBuilder.append(word).append(" ").toString()) * mult >= (float)width)) break;
                    other = word.charAt(word.length() - 1) + other;
                    word = word.substring(0, word.length() - 1);
                }
                if (!other.isEmpty()) {
                    words.set(i, word);
                    words.add(i + 1, other);
                    continue;
                }
                words.set(i, word + " ");
            }
            String currentLine = null;
            for (String word : words) {
                String newLine = currentLine == null ? word : currentLine + word;
                if ((float)this.field_146289_q.func_78256_a(newLine) * mult < (float)width) {
                    currentLine = newLine;
                    continue;
                }
                lst.add(currentLine);
                currentLine = word;
            }
            lst.add(currentLine);
        }
        return lst;
    }
}

