/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.client;

import hardcorequesting.client.EditButton;
import hardcorequesting.client.EditMode;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.quests.Quest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.lwjgl.input.Keyboard;

public class KeyboardHandler {
    private static Map<Integer, Set<EditMode>> keyMap;

    public static void initDefault() {
        KeyboardHandler.addKeymap(50, EditMode.MOVE);
        KeyboardHandler.addKeymap(19, EditMode.RENAME);
        KeyboardHandler.addKeymap(49, EditMode.CREATE);
        KeyboardHandler.addKeymap(210, EditMode.CREATE);
        KeyboardHandler.addKeymap(211, EditMode.DELETE);
        KeyboardHandler.addKeymap(32, EditMode.DELETE);
        KeyboardHandler.addKeymap(31, EditMode.SWAP_SELECT);
        KeyboardHandler.addKeymap(31, EditMode.SWAP);
        KeyboardHandler.addKeymap(57, EditMode.NORMAL);
    }

    public static void clear() {
        keyMap.clear();
    }

    private static void addKeymap(int key, EditMode mode) {
        Set<EditMode> set;
        if (keyMap == null) {
            keyMap = new HashMap<Integer, Set<EditMode>>();
        }
        if ((set = keyMap.get(key)) == null) {
            set = new HashSet<EditMode>();
        }
        set.add(mode);
        keyMap.put(key, set);
    }

    public static boolean pressedHotkey(GuiQuestBook gui, int key, EditButton[] buttons) {
        if (key == 14) {
            gui.goBack();
            return true;
        }
        if (Quest.isEditing) {
            if (key >= 2 && key <= 11) {
                int i = key - 2;
                if (i < buttons.length) {
                    buttons[i].click();
                    return true;
                }
            } else if (keyMap.containsKey(key)) {
                Set<EditMode> modes = keyMap.get(key);
                for (EditButton button : buttons) {
                    for (EditMode mode : modes) {
                        if (!button.matchesMode(mode)) continue;
                        button.click();
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static String[] toConfig() {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<Integer, Set<EditMode>> entry : keyMap.entrySet()) {
            for (EditMode mode : entry.getValue()) {
                list.add(Keyboard.getKeyName((int)entry.getKey()) + ":" + mode.name().toLowerCase());
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public static void fromConfig(String[] config) {
        for (String entry : config) {
            EditMode mode;
            int key;
            String[] splitted = entry.split(":");
            if (splitted.length != 2 || (key = Keyboard.getKeyIndex((String)splitted[0])) == 0 || (mode = EditMode.valueOf(splitted[1].toUpperCase())) == null) continue;
            KeyboardHandler.addKeymap(key, mode);
        }
    }

    public static String[] getDefault() {
        KeyboardHandler.initDefault();
        String[] map = KeyboardHandler.toConfig();
        KeyboardHandler.clear();
        return map;
    }
}

