/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.client;

import hardcorequesting.client.EditMode;
import hardcorequesting.client.interfaces.GuiColor;
import hardcorequesting.client.interfaces.GuiQuestBook;
import java.util.List;

public class EditButton {
    private static final int BUTTON_SIZE = 16;
    private static final int BUTTON_ICON_SIZE = 12;
    private static final int BUTTON_ICON_SRC_X = 0;
    private static final int BUTTON_ICON_SRC_Y = 0;
    private static final int EDIT_BUTTONS_PER_ROW = 2;
    private static final int EDIT_BUTTONS_SRC_PER_ROW = 8;
    private GuiQuestBook guiQuestBook;
    private int x;
    private int y;
    private EditMode mode;
    private List<String> text;

    public EditButton(GuiQuestBook guiQuestBook, EditMode mode, int id) {
        this.guiQuestBook = guiQuestBook;
        this.mode = mode;
        int x = id % 2;
        int y = id / 2;
        this.x = -38 + x * 20;
        this.y = 5 + y * 20;
    }

    public static EditButton[] createButtons(GuiQuestBook gui, EditMode ... modes) {
        EditButton[] ret = new EditButton[modes.length];
        for (int i = 0; i < modes.length; ++i) {
            EditMode mode = modes[i];
            ret[i] = new EditButton(gui, mode, i);
        }
        return ret;
    }

    public void draw(int mX, int mY) {
        int srcY = this.guiQuestBook.getCurrentMode() == this.mode ? 2 : (this.guiQuestBook.inBounds(this.x, this.y, 16, 16, mX, mY) ? 1 : 0);
        this.guiQuestBook.drawRect(this.x, this.y, 240, srcY * 16, 16, 16);
        this.guiQuestBook.drawRect(this.x + 2, this.y + 2, 0 + this.mode.ordinal() % 8 * 12, 0 + this.mode.ordinal() / 8 * 12, 12, 12);
    }

    public void drawInfo(int mX, int mY) {
        if (this.guiQuestBook.inBounds(this.x, this.y, 16, 16, mX, mY)) {
            if (this.text == null) {
                this.text = this.guiQuestBook.getLinesFromText(this.mode.getName() + "\n\n" + this.mode.getDescription(), 1.0f, 150);
                for (int i = 1; i < this.text.size(); ++i) {
                    this.text.set(i, (Object)((Object)GuiColor.GRAY) + this.text.get(i));
                }
            }
            this.guiQuestBook.drawMouseOver(this.text, mX + this.guiQuestBook.getLeft(), mY + this.guiQuestBook.getTop());
        }
    }

    public boolean onClick(int mX, int mY) {
        if (this.guiQuestBook.inBounds(this.x, this.y, 16, 16, mX, mY)) {
            this.guiQuestBook.setCurrentMode(this.mode);
            this.guiQuestBook.modifyingQuest = null;
            this.guiQuestBook.modifyingBar = null;
            return true;
        }
        return false;
    }

    public boolean click() {
        return this.onClick(this.x, this.y);
    }

    public boolean matchesMode(EditMode mode) {
        return this.mode == mode;
    }
}

