/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.client;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import hardcorequesting.client.sounds.SoundHandler;
import hardcorequesting.client.sounds.Sounds;
import hardcorequesting.network.message.ClientUpdateMessage;
import hardcorequesting.network.message.SoundMessage;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestingData;
import hardcorequesting.quests.task.QuestTask;
import hardcorequesting.tileentity.TileEntityTracker;
import hardcorequesting.tileentity.TrackerType;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public enum ClientChange {
    SELECT_QUEST(new ClientUpdater<QuestTask>(){
        private static final String PARENT = "parent";
        private static final String TASK = "task";

        @Override
        public IMessage build(QuestTask data) throws IOException {
            StringWriter sWriter = new StringWriter();
            JsonWriter writer = new JsonWriter((Writer)sWriter);
            writer.beginObject();
            writer.name(PARENT).value(data.getParent().getId());
            writer.name(TASK).value((long)data.getId());
            writer.endObject();
            writer.close();
            return new ClientUpdateMessage(SELECT_QUEST, sWriter.toString());
        }

        @Override
        public void parse(EntityPlayer player, String data) {
            JsonParser parser = new JsonParser();
            JsonObject root = parser.parse(data).getAsJsonObject();
            QuestingData.getQuestingData((EntityPlayer)player).selectedQuest = root.get(PARENT).getAsString();
            QuestingData.getQuestingData((EntityPlayer)player).selectedTask = root.get(TASK).getAsInt();
        }
    }),
    UPDATE_TASK(new ClientUpdater<QuestTask>(){
        private static final String QUEST = "quest";
        private static final String TASK = "task";

        @Override
        public IMessage build(QuestTask questTask) throws IOException {
            StringWriter sWriter = new StringWriter();
            JsonWriter writer = new JsonWriter((Writer)sWriter);
            writer.beginObject();
            writer.name(QUEST).value(questTask.getParent().getId());
            writer.name(TASK).value((long)questTask.getId());
            writer.endObject();
            writer.close();
            return new ClientUpdateMessage(UPDATE_TASK, sWriter.toString());
        }

        @Override
        public void parse(EntityPlayer player, String data) {
            JsonParser parser = new JsonParser();
            JsonObject root = parser.parse(data).getAsJsonObject();
            Quest quest = Quest.getQuest(root.get(QUEST).getAsString());
            int task = root.get(TASK).getAsInt();
            if (quest != null && task > -1 && task < quest.getTasks().size()) {
                quest.getTasks().get(task).onUpdate(player);
            }
        }
    }),
    CLAIM_QUEST(new ClientUpdater<Tuple<String, Integer>>(){
        private static final String QUEST = "quest";
        private static final String REWARD = "reward";

        @Override
        public IMessage build(Tuple<String, Integer> data) throws IOException {
            StringWriter sWriter = new StringWriter();
            JsonWriter writer = new JsonWriter((Writer)sWriter);
            writer.beginObject();
            writer.name(QUEST).value((String)data.func_76341_a());
            writer.name(REWARD).value((Number)data.func_76340_b());
            writer.endObject();
            writer.close();
            return new ClientUpdateMessage(CLAIM_QUEST, sWriter.toString());
        }

        @Override
        public void parse(EntityPlayer player, String data) {
            JsonParser parser = new JsonParser();
            JsonObject root = parser.parse(data).getAsJsonObject();
            Quest quest = Quest.getQuest(root.get(QUEST).getAsString());
            if (quest != null) {
                quest.claimReward(player, root.get(REWARD).getAsInt());
            }
        }
    }),
    TRACKER_UPDATE(new ClientUpdater<TileEntityTracker>(){
        private static final String BLOCK_POS = "blockPos";
        private static final String RADIUS = "radius";
        private static final String TYPE = "trackerType";

        @Override
        public IMessage build(TileEntityTracker data) throws IOException {
            StringWriter sWriter = new StringWriter();
            JsonWriter writer = new JsonWriter((Writer)sWriter);
            writer.beginObject();
            writer.name(BLOCK_POS).value(data.func_174877_v().func_177986_g());
            writer.name(RADIUS).value((long)data.getRadius());
            writer.name(TYPE).value((long)data.getType().ordinal());
            writer.endObject();
            return new ClientUpdateMessage(TRACKER_UPDATE, sWriter.toString());
        }

        @Override
        public void parse(EntityPlayer player, String data) {
            JsonParser parser = new JsonParser();
            JsonObject root = parser.parse(data).getAsJsonObject();
            BlockPos pos = BlockPos.func_177969_a((long)root.get(BLOCK_POS).getAsLong());
            int radius = root.get(RADIUS).getAsInt();
            TrackerType type = TrackerType.values()[root.get(TYPE).getAsInt()];
            TileEntityTracker.saveToServer(player, pos, radius, type);
        }
    }),
    SOUND(new ClientUpdater<Sounds>(){

        @Override
        public IMessage build(Sounds data) throws IOException {
            return new SoundMessage(SOUND, data.ordinal() + "");
        }

        @Override
        public void parse(EntityPlayer player, String data) {
            SoundHandler.handleSoundPacket(Sounds.values()[Integer.parseInt(data)]);
        }
    }),
    LORE(new ClientUpdater(){

        public IMessage build(Object data) throws IOException {
            return new SoundMessage(LORE, "nothing");
        }

        @Override
        public void parse(EntityPlayer player, String data) {
            SoundHandler.handleLorePacket(player);
        }
    });

    private ClientUpdater updater;

    private ClientChange(ClientUpdater updater) {
        this.updater = updater;
    }

    public void parse(EntityPlayer player, String data) {
        this.updater.parse(player, data);
    }

    public IMessage build(Object data) {
        try {
            return this.updater.build(data);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static interface ClientUpdater<T> {
        public IMessage build(T var1) throws IOException;

        public void parse(EntityPlayer var1, String var2);
    }
}

