/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.bag;

import hardcorequesting.bag.Group;
import hardcorequesting.client.interfaces.GuiColor;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.client.interfaces.ScrollBar;
import hardcorequesting.client.interfaces.edit.GuiEditMenuTextEditor;
import hardcorequesting.client.interfaces.edit.GuiEditMenuTier;
import hardcorequesting.io.SaveHandler;
import hardcorequesting.quests.QuestLine;
import hardcorequesting.util.SaveHelper;
import hardcorequesting.util.Translator;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class GroupTier {
    private String name;
    private GuiColor color;
    private int[] weights;

    public GroupTier(String name, GuiColor color, int ... weights) {
        this.name = name;
        this.color = color;
        this.weights = Arrays.copyOf(weights, weights.length);
    }

    public static List<GroupTier> getTiers() {
        return QuestLine.getActiveQuestLine().tiers;
    }

    public static void saveAll() {
        try {
            SaveHandler.saveBags(SaveHandler.getLocalFile("bags"));
        }
        catch (IOException e) {
            FMLLog.log((String)"HQM", (Level)Level.INFO, (String)"Failed to save bags", (Object[])new Object[0]);
        }
    }

    public static void saveAllDefault() {
        try {
            SaveHandler.saveBags(SaveHandler.getDefaultFile("bags"));
        }
        catch (IOException e) {
            FMLLog.log((String)"HQM", (Level)Level.INFO, (String)"Failed to save bags", (Object[])new Object[0]);
        }
    }

    public static void loadAll(boolean remote) {
        try {
            Group.getGroups().clear();
            GroupTier.getTiers().clear();
            GroupTier.getTiers().addAll(SaveHandler.loadBags(SaveHandler.getFile("bags", remote)));
        }
        catch (IOException e) {
            FMLLog.log((String)"HQM", (Level)Level.INFO, (String)"Failed to save bags", (Object[])new Object[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void mouseClickedOverview(GuiQuestBook gui, ScrollBar tierScroll, int x, int y) {
        int start;
        List<GroupTier> tiers = GroupTier.getTiers();
        block6: for (int i = start = tierScroll.isVisible(gui) ? Math.round((float)(tiers.size() - 8) * tierScroll.getScroll()) : 0; i < Math.min(start + 8, tiers.size()); ++i) {
            int posY = 20 + 25 * (i - start);
            GroupTier groupTier = tiers.get(i);
            if (!gui.inBounds(180, posY, gui.getStringWidth(groupTier.getName()), 9, x, y)) continue;
            switch (gui.getCurrentMode()) {
                case TIER: {
                    if (gui.modifyingGroup == null) break block6;
                    gui.modifyingGroup.setTier(groupTier);
                    SaveHelper.add(SaveHelper.EditType.GROUP_CHANGE);
                    break;
                }
                case NORMAL: {
                    gui.setEditMenu(new GuiEditMenuTier(gui, gui.getPlayer(), groupTier));
                    break;
                }
                case RENAME: {
                    gui.setEditMenu(new GuiEditMenuTextEditor(gui, gui.getPlayer(), groupTier));
                    break;
                }
                case DELETE: {
                    if (tiers.size() <= 1 && Group.getGroups().size() != 0) break block6;
                    for (Group group : Group.getGroups().values()) {
                        if (group.getTier() != groupTier) continue;
                        group.setTier(i == 0 ? tiers.get(1) : tiers.get(0));
                    }
                    tiers.remove(i);
                    SaveHelper.add(SaveHelper.EditType.TIER_REMOVE);
                    break;
                }
            }
            break;
        }
    }

    public static void initBaseTiers(QuestLine questLine) {
        questLine.tiers.add(new GroupTier("Crap", GuiColor.RED, 50, 50, 50, 5, 0));
        questLine.tiers.add(new GroupTier("Plain", GuiColor.GRAY, 50, 50, 50, 30, 10));
        questLine.tiers.add(new GroupTier("Common", GuiColor.GREEN, 20, 30, 40, 30, 20));
        questLine.tiers.add(new GroupTier("Uncommon", GuiColor.BLUE, 5, 10, 15, 20, 25));
        questLine.tiers.add(new GroupTier("Rare", GuiColor.ORANGE, 3, 6, 12, 18, 21));
        questLine.tiers.add(new GroupTier("Unique", GuiColor.PURPLE, 1, 2, 3, 4, 30));
    }

    public String getName() {
        return this.name == null || this.name.equals("") ? Translator.translate("hqm.bag.unknown") : this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GuiColor getColor() {
        return this.color;
    }

    public void setColor(GuiColor color) {
        this.color = color;
    }

    public int[] getWeights() {
        return this.weights;
    }

    public GroupTier copy() {
        return new GroupTier(this.getName(), this.getColor(), this.getWeights());
    }

    public void load(GroupTier tier) {
        this.name = tier.name;
        this.color = tier.color;
        this.weights = Arrays.copyOf(tier.weights, tier.weights.length);
    }
}

