/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.bag;

import hardcorequesting.bag.BagTier;
import hardcorequesting.bag.GroupData;
import hardcorequesting.bag.GroupTier;
import hardcorequesting.client.EditMode;
import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.client.interfaces.ScrollBar;
import hardcorequesting.client.interfaces.edit.GuiEditMenuItem;
import hardcorequesting.client.interfaces.edit.GuiEditMenuTextEditor;
import hardcorequesting.quests.ItemPrecision;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestLine;
import hardcorequesting.quests.QuestingData;
import hardcorequesting.util.SaveHelper;
import hardcorequesting.util.Translator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Group {
    private GroupTier tier;
    private List<ItemStack> items;
    private String name;
    private int limit;
    private String uuid;

    public Group(String id) {
        this.uuid = id;
        while (this.uuid == null || Group.getGroups().containsKey(this.uuid)) {
            this.uuid = UUID.randomUUID().toString();
        }
        if (id == null) {
            if (GroupTier.getTiers().size() < 1) {
                GroupTier.initBaseTiers(QuestLine.getActiveQuestLine());
            }
            this.tier = GroupTier.getTiers().get(0);
        }
        this.items = new ArrayList<ItemStack>();
    }

    public static int size() {
        return QuestLine.getActiveQuestLine().groups.size();
    }

    public static Map<String, Group> getGroups() {
        return QuestLine.getActiveQuestLine().groups;
    }

    public static void remove(String id) {
        Group.getGroups().remove(id);
    }

    public static void add(Group group) {
        Group.getGroups().put(group.getId(), group);
    }

    public static Group getGroup(String id) {
        return Group.getGroups().get(id);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawOverview(GuiQuestBook gui, ScrollBar tierScroll, ScrollBar groupScroll, int x, int y) {
        int start;
        List<GroupTier> tiers = GroupTier.getTiers();
        for (int i = start = tierScroll.isVisible(gui) ? Math.round((float)(tiers.size() - 8) * tierScroll.getScroll()) : 0; i < Math.min(start + 8, tiers.size()); ++i) {
            GroupTier groupTier = tiers.get(i);
            String str = groupTier.getName();
            int yPos = 20 + 25 * (i - start);
            boolean inBounds = gui.inBounds(180, yPos, gui.getStringWidth(str), 9, x, y);
            int color = groupTier.getColor().getHexColor();
            if (inBounds) {
                color &= 0xFFFFFF;
                color |= 0xBB000000;
                GlStateManager.func_179147_l();
            }
            gui.drawString(str, 180, yPos, color);
            if (inBounds) {
                GlStateManager.func_179084_k();
            }
            for (int j = 0; j < BagTier.values().length; ++j) {
                BagTier bagTier = BagTier.values()[j];
                gui.drawCenteredString(bagTier.getColor().toString() + groupTier.getWeights()[j], 175 + j * 25, yPos + 12, 0.7f, 25, 0, 0x404040);
            }
        }
        ArrayList<Group> groups = new ArrayList<Group>(Group.getGroups().values());
        for (int i = start = groupScroll.isVisible(gui) ? Math.round((float)(groups.size() - 8) * groupScroll.getScroll()) : 0; i < Math.min(start + 8, groups.size()); ++i) {
            boolean selected;
            Group group = (Group)groups.get(i);
            String str = group.getName();
            int yPos = 20 + 25 * (i - start);
            boolean inBounds = gui.inBounds(20, yPos, gui.getStringWidth(str), 9, x, y);
            int color = group.getTier().getColor().getHexColor();
            boolean bl = selected = group == gui.modifyingGroup;
            if (inBounds || selected) {
                color &= 0xFFFFFF;
                GlStateManager.func_179147_l();
                color = selected ? (color |= 0x50000000) : (color |= 0xBB000000);
            }
            gui.drawString(str, 20, yPos, color);
            if (inBounds || selected) {
                GlStateManager.func_179084_k();
            }
            gui.drawString(Translator.translate("hqm.questBook.items", group.getItems().size()), 25, yPos + 12, 0.7f, 0x404040);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void mouseClickedOverview(GuiQuestBook gui, ScrollBar groupScroll, int x, int y) {
        int start;
        ArrayList<Group> groups = new ArrayList<Group>(Group.getGroups().values());
        for (int i = start = groupScroll.isVisible(gui) ? Math.round((float)(groups.size() - 8) * groupScroll.getScroll()) : 0; i < Math.min(start + 8, groups.size()); ++i) {
            int posY = 20 + 25 * (i - start);
            Group group = (Group)groups.get(i);
            if (!gui.inBounds(20, posY, gui.getStringWidth(group.getName()), 9, x, y)) continue;
            switch (gui.getCurrentMode()) {
                case TIER: {
                    gui.modifyingGroup = group == gui.modifyingGroup ? null : group;
                    break;
                }
                case NORMAL: {
                    GuiQuestBook.selectedGroup = group;
                    gui.getTextBoxGroupAmount().setTextAndCursor(gui, String.valueOf(GuiQuestBook.getSelectedGroup().getLimit()));
                    break;
                }
                case RENAME: {
                    gui.setEditMenu(new GuiEditMenuTextEditor(gui, gui.getPlayer(), group));
                    break;
                }
                case DELETE: {
                    Group.remove(group.getId());
                    SaveHelper.add(SaveHelper.EditType.GROUP_REMOVE);
                    break;
                }
            }
            break;
        }
    }

    public GroupTier getTier() {
        return this.tier;
    }

    public void setTier(GroupTier tier) {
        this.tier = tier;
    }

    public String getName() {
        return this.hasName() ? this.name : Translator.translate("hqm.bag.group", this.tier.getName());
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public void setItem(int id, ItemStack stack) {
        if (id >= this.items.size()) {
            this.items.add(stack);
            SaveHelper.add(SaveHelper.EditType.GROUP_ITEM_CREATE);
        } else {
            this.items.set(id, stack);
            SaveHelper.add(SaveHelper.EditType.GROUP_ITEM_CHANGE);
        }
    }

    public void open(EntityPlayer player) {
        GroupData data;
        if (this.limit > 0 && (data = QuestingData.getQuestingData(player).getGroupData(this.getId())) != null) {
            ++data.retrieved;
        }
        List<ItemStack> itemsToAdd = this.items.stream().map(ItemStack::func_77946_l).collect(Collectors.toList());
        Quest.addItems(player, itemsToAdd);
        itemsToAdd.stream().filter(item -> item.field_77994_a > 0).forEach(item -> {
            EntityItem entityItem = new EntityItem(player.func_130014_f_(), player.field_70165_t + 0.5, player.field_70163_u + 0.5, player.field_70161_v + 0.5, item);
            player.func_130014_f_().func_72838_d((Entity)entityItem);
        });
    }

    public String getId() {
        return this.uuid;
    }

    public void removeItem(int i) {
        if (i >= 0 && i < this.items.size()) {
            this.items.remove(i);
        }
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getRetrievalCount(EntityPlayer player) {
        GroupData data = QuestingData.getQuestingData(player).getGroupData(this.getId());
        return data != null ? data.retrieved : 0;
    }

    public void setRetrievalCount(EntityPlayer player, int count) {
        GroupData data = QuestingData.getQuestingData(player).getGroupData(this.getId());
        if (data != null) {
            data.retrieved = count;
        }
    }

    public boolean isValid(EntityPlayer player) {
        return this.limit == 0 || this.getRetrievalCount(player) < this.limit;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Group && Objects.equals(this.name, ((Group)obj).name) && this.limit == ((Group)obj).limit && this.items.size() == ((Group)obj).items.size()) {
            for (ItemStack stack : this.items) {
                if (this.listContains(stack, ((Group)obj).items)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean listContains(ItemStack stack, List<ItemStack> stacks) {
        for (ItemStack stack2 : stacks) {
            if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)stack2)) continue;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(GuiQuestBook gui, int x, int y) {
        int yPos;
        int xPos;
        ItemStack stack;
        int i;
        gui.drawString(this.getName(), 20, 20, this.getTier().getColor().getHexColor());
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(this.getItems());
        items.add(null);
        for (i = 0; i < items.size(); ++i) {
            stack = (ItemStack)items.get(i);
            xPos = i % 7 * 20 + 20;
            yPos = i / 7 * 20 + 40;
            gui.drawItemStack(stack, xPos, yPos, x, y, false);
        }
        for (i = 0; i < items.size(); ++i) {
            stack = (ItemStack)items.get(i);
            xPos = i % 7 * 20 + 20;
            yPos = i / 7 * 20 + 40;
            if (!gui.inBounds(xPos, yPos, 18, 18, x, y)) continue;
            if (stack == null) break;
            try {
                gui.drawMouseOver(stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x), x + gui.getLeft(), y + gui.getTop());
            }
            catch (Exception exception) {}
            break;
        }
        gui.drawString(Translator.translate("hqm.questBook.maxRetrieval"), 180, 20, 0x404040);
        gui.drawString(Translator.translate("hqm.questBook.noRestriction"), 180, 48, 0.7f, 0x404040);
    }

    @SideOnly(value=Side.CLIENT)
    public void mouseClicked(GuiQuestBook gui, int x, int y) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(this.getItems());
        items.add(null);
        for (int i = 0; i < items.size(); ++i) {
            int xPos = i % 7 * 20 + 20;
            int yPos = i / 7 * 20 + 40;
            if (!gui.inBounds(xPos, yPos, 18, 18, x, y)) continue;
            if (gui.getCurrentMode() == EditMode.ITEM) {
                int amount;
                ItemStack stack;
                ItemStack itemStack = stack = i < items.size() ? (ItemStack)items.get(i) : null;
                if (stack != null) {
                    stack = stack.func_77946_l();
                    amount = stack.field_77994_a;
                } else {
                    amount = 1;
                }
                gui.setEditMenu(new GuiEditMenuItem((GuiBase)gui, gui.getPlayer(), (Object)stack, i, GuiEditMenuItem.Type.BAG_ITEM, amount, ItemPrecision.PRECISE));
                break;
            }
            if (gui.getCurrentMode() != EditMode.DELETE) break;
            this.removeItem(i);
            SaveHelper.add(SaveHelper.EditType.GROUP_ITEM_REMOVE);
            break;
        }
    }
}

