/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting;

import hardcorequesting.HQMTab;
import hardcorequesting.blocks.ModBlocks;
import hardcorequesting.commands.CommandHandler;
import hardcorequesting.config.ConfigHandler;
import hardcorequesting.event.EventHandler;
import hardcorequesting.event.PlayerDeathEventListener;
import hardcorequesting.event.PlayerTracker;
import hardcorequesting.event.WorldEventListener;
import hardcorequesting.items.ModItems;
import hardcorequesting.network.NetworkManager;
import hardcorequesting.proxies.CommonProxy;
import hardcorequesting.quests.QuestLine;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="hardcorequesting", name="Hardcore Questing Mode", version="1.10.2-5.1.0alpha4", guiFactory="hardcorequesting.client.interfaces.HQMModGuiFactory", acceptedMinecraftVersions="[1.10.2]")
public class HardcoreQuesting {
    @Mod.Instance(value="hardcorequesting")
    public static HardcoreQuesting instance;
    @SidedProxy(clientSide="hardcorequesting.proxies.ClientProxy", serverSide="hardcorequesting.proxies.CommonProxy")
    public static CommonProxy proxy;
    public static CreativeTabs HQMTab;
    public static String path;
    public static File configDir;
    public static Side loadingSide;
    private static EntityPlayer commandUser;

    public static EntityPlayer getPlayer() {
        return commandUser;
    }

    public static void setPlayer(EntityPlayer player) {
        commandUser = player;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        loadingSide = event.getSide();
        new EventHandler();
        path = event.getModConfigurationDirectory().getAbsolutePath() + File.separator + "hqm".toLowerCase() + File.separator;
        configDir = new File(path);
        ConfigHandler.initModConfig(path);
        ConfigHandler.initEditConfig(path);
        QuestLine.init(path);
        proxy.init();
        proxy.initSounds(path);
        ModBlocks.init();
        ModBlocks.registerTileEntities();
        ModItems.init();
        proxy.initRenderers();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)instance);
        new WorldEventListener();
        new PlayerDeathEventListener();
        new PlayerTracker();
        NetworkManager.init();
        ModItems.registerRecipes();
        ModBlocks.registerRecipes();
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"hardcorequesting.waila.Provider.callbackRegister");
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)CommandHandler.instance);
    }

    @Mod.EventHandler
    public void missingMappings(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.get()) {
            ResourceLocation loc = mapping.resourceLocation;
            if (loc.func_110624_b().equals("HardcoreQuesting")) {
                if (mapping.type.equals((Object)GameRegistry.Type.BLOCK)) {
                    Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("hardcorequesting", loc.func_110623_a()));
                    if (block != null) {
                        mapping.remap(block);
                    }
                } else {
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("hardcorequesting", loc.func_110623_a()));
                    if (item != null) {
                        mapping.remap(item);
                    }
                }
            }
            if (!mapping.resourceLocation.func_110623_a().toLowerCase().equals("hqminvaliditem")) continue;
            mapping.remap((Item)ModItems.invalidItem);
        }
    }

    static {
        HQMTab = new HQMTab();
    }
}

