/*
 * Decompiled with CFR 0.152.
 */
package animalium.entities;

import animalium.configs.ConfigHandler;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityPiranha
extends EntityMob {
    private static final DataParameter<Boolean> IS_LEAPING = EntityDataManager.func_187226_a(EntityPiranha.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityPiranha(World world) {
        super(world);
        this.func_70105_a(0.9f, 0.9f);
        this.field_70765_h = new PiranhaMoveHelper(this);
        if (world != null && !world.field_72995_K) {
            if (ConfigHandler.PIRANHA_ATTACK_MOBS) {
                this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMob.class, 0, true, true, null));
            }
            if (ConfigHandler.PIRANHA_ATTACK_CREATURES) {
                this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, true, true, null));
            }
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIPiranhaAttack(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.75));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.75, 80));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, true, null));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_LEAPING, (Object)false);
    }

    public boolean isLeaping() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_LEAPING);
    }

    private void setIsLeaping(boolean leaping) {
        this.field_70180_af.func_187227_b(IS_LEAPING, (Object)leaping);
    }

    public boolean isGrounded() {
        return !this.func_70090_H() && this.field_70170_p.func_175623_d(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u + 1.0)), MathHelper.func_76128_c((double)this.field_70161_v))) && this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().func_149703_v();
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.75);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEFINED;
    }

    protected PathNavigate func_175447_b(World world) {
        return new PathNavigateSwimmer((EntityLiving)this, world);
    }

    protected boolean func_70814_o() {
        return true;
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty();
    }

    public boolean func_70601_bi() {
        return this.field_70163_u > 45.0 && this.field_70163_u <= 80.0 && super.func_70601_bi();
    }

    public int func_70641_bl() {
        return 3;
    }

    protected SoundEvent func_184639_G() {
        return this.func_70090_H() ? SoundEvents.field_187549_bG : SoundEvents.field_187684_cg;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187690_ci;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187553_bI;
    }

    public void func_70106_y() {
        super.func_70106_y();
        this.func_184185_a(SoundEvents.field_187553_bI, 1.0f, 2.0f);
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(this.func_70090_H() ? SoundEvents.field_187549_bG : SoundEvents.field_187684_cg, 0.5f, 2.0f);
    }

    public float func_180484_a(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151586_h ? 10.0f + this.field_70170_p.func_175724_o(pos) - 0.5f : super.func_180484_a(pos);
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K && this.func_70090_H()) {
            Vec3d vec3d = this.func_70676_i(0.0f);
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N - vec3d.field_72450_a * 1.5, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - vec3d.field_72448_b * 1.5, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N - vec3d.field_72449_c * 1.5, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        if (this.field_70171_ac) {
            this.func_70050_g(300);
        } else if (this.field_70122_E) {
            this.field_70181_x += 0.5;
            this.field_70159_w += (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.4f);
            this.field_70179_y += (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.4f);
            this.field_70177_z = this.field_70146_Z.nextFloat() * 360.0f;
            if (this.isLeaping()) {
                this.setIsLeaping(false);
            }
            this.field_70122_E = false;
            this.field_70160_al = true;
            if (this.field_70170_p.func_72820_D() % 5L == 0L) {
                this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187684_cg, SoundCategory.HOSTILE, 1.0f, 1.0f);
            }
            this.func_70665_d(DamageSource.field_76369_e, 0.5f);
        }
        super.func_70636_d();
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.func_70613_aW()) {
            if (this.func_70090_H()) {
                this.func_70060_a(strafe, forward, 0.1f);
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)0.9f;
                this.field_70181_x *= (double)0.9f;
                this.field_70179_y *= (double)0.9f;
                if (this.func_70638_az() == null) {
                    this.field_70181_x -= 0.005;
                }
            } else {
                super.func_70612_e(strafe, forward);
            }
        } else {
            super.func_70612_e(strafe, forward);
        }
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        if (this.field_70170_p.field_73012_v.nextInt(5) == 0) {
            ItemStack stack = new ItemStack(Items.field_151115_aP);
            if (this.func_70027_ad()) {
                stack = new ItemStack(Items.field_179566_aV);
            }
            this.func_70099_a(stack, 1.0f);
        }
    }

    public void func_70071_h_() {
        Double distance;
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && !this.field_70170_p.func_72953_d(this.func_70638_az().func_174813_aQ()) && (distance = Double.valueOf(this.func_180425_c().func_185332_f((int)this.func_70638_az().field_70165_t, (int)this.func_70638_az().field_70163_u, (int)this.func_70638_az().field_70161_v))) > 1.0 && distance < 6.0 && this.func_70090_H() && this.field_70170_p.func_175623_d(new BlockPos((int)this.field_70165_t, (int)this.field_70163_u + 1, (int)this.field_70161_v))) {
            if (!this.isLeaping()) {
                this.setIsLeaping(true);
                this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187730_dW, SoundCategory.HOSTILE, 1.0f, 2.0f);
            }
            double distanceX = this.func_70638_az().field_70165_t - this.field_70165_t;
            double distanceZ = this.func_70638_az().field_70161_v - this.field_70161_v;
            float distanceSqrRoot = MathHelper.func_76133_a((double)(distanceX * distanceX + distanceZ * distanceZ));
            this.field_70159_w = distanceX / (double)distanceSqrRoot * 0.5 * 0.900000011920929 + this.field_70159_w * 0.7000000029802322;
            this.field_70179_y = distanceZ / (double)distanceSqrRoot * 0.5 * 0.900000011920929 + this.field_70179_y * 0.7000000029802322;
            this.field_70181_x = 0.4;
        }
        super.func_70071_h_();
    }

    public boolean func_70686_a(Class entity) {
        return EntityPiranha.class != entity;
    }

    public boolean func_70652_k(Entity entity) {
        return this.func_70685_l(entity) && super.func_70652_k(entity);
    }

    static class AIPiranhaAttack
    extends EntityAIAttackMelee {
        public AIPiranhaAttack(EntityPiranha piranha) {
            super((EntityCreature)piranha, 0.75, true);
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 4.0f + attackTarget.field_70130_N;
        }
    }

    static class PiranhaMoveHelper
    extends EntityMoveHelper {
        private final EntityPiranha piranha;

        public PiranhaMoveHelper(EntityPiranha piranha) {
            super((EntityLiving)piranha);
            this.piranha = piranha;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO && !this.piranha.func_70661_as().func_75500_f()) {
                double d0 = this.field_75646_b - this.piranha.field_70165_t;
                double d1 = this.field_75647_c - this.piranha.field_70163_u;
                double d2 = this.field_75644_d - this.piranha.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                d3 = MathHelper.func_76133_a((double)d3);
                d1 /= d3;
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
                this.piranha.field_70761_aq = this.piranha.field_70177_z = this.func_75639_a(this.piranha.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.piranha.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                this.piranha.func_70659_e(this.piranha.func_70689_ay() + (f1 - this.piranha.func_70689_ay()) * 0.125f);
                double d4 = Math.sin((double)(this.piranha.field_70173_aa + this.piranha.func_145782_y()) * 0.5) * 0.05;
                double d5 = Math.cos(this.piranha.field_70177_z * ((float)Math.PI / 180));
                double d6 = Math.sin(this.piranha.field_70177_z * ((float)Math.PI / 180));
                this.piranha.field_70159_w += d4 * d5;
                this.piranha.field_70179_y += d4 * d6;
                d4 = Math.sin((double)(this.piranha.field_70173_aa + this.piranha.func_145782_y()) * 0.75) * 0.05;
                this.piranha.field_70181_x += d4 * (d6 + d5) * 0.25;
                this.piranha.field_70181_x += (double)this.piranha.func_70689_ay() * d1 * 0.1;
                EntityLookHelper entitylookhelper = this.piranha.func_70671_ap();
                double d7 = this.piranha.field_70165_t + d0 / d3 * 2.0;
                double d8 = (double)this.piranha.func_70047_e() + this.piranha.field_70163_u + d1 / d3;
                double d9 = this.piranha.field_70161_v + d2 / d3 * 2.0;
                double d10 = entitylookhelper.func_180423_e();
                double d11 = entitylookhelper.func_180422_f();
                double d12 = entitylookhelper.func_180421_g();
                if (!entitylookhelper.func_180424_b()) {
                    d10 = d7;
                    d11 = d8;
                    d12 = d9;
                }
                this.piranha.func_70671_ap().func_75650_a(d10 + (d7 - d10) * 0.125, d11 + (d8 - d11) * 0.125, d12 + (d9 - d12) * 0.125, 10.0f, 40.0f);
            } else {
                this.piranha.func_70659_e(0.0f);
            }
        }
    }
}

