/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.multiblock.energy;

import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.Configuration;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.item.ItemSatelliteIdentificationChip;
import zmaster587.libVulpes.api.IUniversalEnergyTransmitter;
import zmaster587.libVulpes.block.BlockMeta;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.multiblock.TileMultiBlock;
import zmaster587.libVulpes.tile.multiblock.TileMultiPowerProducer;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.Vector3F;

public class TileMicrowaveReciever
extends TileMultiPowerProducer
implements ITickable {
    static final BlockMeta iron_block = new BlockMeta(AdvancedRocketryBlocks.blockSolarPanel);
    static final Object[][][] structure = new Object[][][]{{{iron_block, Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), iron_block}, {Character.valueOf('*'), iron_block, iron_block, iron_block, Character.valueOf('*')}, {Character.valueOf('*'), iron_block, Character.valueOf('c'), iron_block, Character.valueOf('*')}, {Character.valueOf('*'), iron_block, iron_block, iron_block, Character.valueOf('*')}, {iron_block, Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), iron_block}}};
    List<Long> connectedSatellites = new LinkedList<Long>();
    boolean initialCheck = false;
    int powerMadeLastTick;
    int prevPowerMadeLastTick;
    ModuleText textModule = new ModuleText(40, 20, "Generating 0 RF/t", 0x2B2B2B);

    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        List modules = super.getModules(ID, player);
        modules.add(this.textModule);
        return modules;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72314_b(0.0, 2000.0, 0.0).func_72317_d(0.0, 1000.0, 0.0);
    }

    public boolean shouldHideBlock(World world, BlockPos pos, IBlockState tile) {
        return false;
    }

    public Object[][][] getStructure() {
        return structure;
    }

    public List<BlockMeta> getAllowableWildCardBlocks() {
        List blocks = super.getAllowableWildCardBlocks();
        blocks.addAll(TileMultiBlock.getMapping((char)'I'));
        blocks.add(iron_block);
        blocks.addAll(TileMultiBlock.getMapping((char)'p'));
        return blocks;
    }

    public String getMachineName() {
        return "tile.microwaveReciever.name";
    }

    public int getPowerMadeLastTick() {
        return this.powerMadeLastTick;
    }

    public void onInventoryUpdated() {
        super.onInventoryUpdated();
        LinkedList<Long> list = new LinkedList<Long>();
        for (IInventory inv : this.itemInPorts) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack == null || !(stack.func_77973_b() instanceof ItemSatelliteIdentificationChip)) continue;
                ItemSatelliteIdentificationChip item = (ItemSatelliteIdentificationChip)stack.func_77973_b();
                list.add(item.getSatelliteId(stack));
            }
        }
        this.connectedSatellites = list;
    }

    public void func_73660_a() {
        if (!this.initialCheck && !this.field_145850_b.field_72995_K) {
            this.completeStructure = this.attemptCompleteStructure(this.field_145850_b.func_180495_p(this.field_174879_c));
            this.onInventoryUpdated();
            this.initialCheck = true;
        }
        if (!this.isComplete()) {
            return;
        }
        if (!this.field_145850_b.field_72995_K && this.getPowerMadeLastTick() > 0 && this.field_145850_b.func_82737_E() % 100L == 0L) {
            Vector3F offset = this.getControllerOffset(this.getStructure());
            List entityList = this.field_145850_b.func_72872_a(Entity.class, new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - (Integer)offset.x), (double)this.func_174877_v().func_177956_o(), (double)(this.func_174877_v().func_177952_p() - (Integer)offset.z), (double)(this.func_174877_v().func_177958_n() - (Integer)offset.x + this.getStructure()[0][0].length), 256.0, (double)(this.func_174877_v().func_177952_p() - (Integer)offset.z + this.getStructure()[0].length)));
            for (Entity e : entityList) {
                e.func_70015_d(5);
            }
            for (int x = 0; x < this.getStructure()[0][0].length; ++x) {
                for (int z = 0; z < this.getStructure()[0].length; ++z) {
                    BlockPos pos2 = this.field_145850_b.func_175645_m(this.field_174879_c.func_177982_a(x - (Integer)offset.x, 128, z - (Integer)offset.z)).func_177982_a(0, -1, 0);
                    IBlockState state = this.field_145850_b.func_180495_p(pos2);
                    if (pos2.func_177956_o() <= this.func_174877_v().func_177956_o() || this.field_145850_b.func_175623_d(pos2.func_177982_a(0, 1, 0))) continue;
                    this.field_145850_b.func_175698_g(pos2);
                    this.field_145850_b.func_184134_a((double)pos2.func_177958_n(), (double)pos2.func_177956_o(), (double)pos2.func_177952_p(), new SoundEvent(new ResourceLocation("fire.fire")), SoundCategory.BLOCKS, 1.0f, 3.0f, false);
                }
            }
        }
        if (!this.field_145850_b.field_72995_K && (DimensionManager.getInstance().isDimensionCreated(this.field_145850_b.field_73011_w.getDimension()) || this.field_145850_b.field_73011_w.getDimension() == 0)) {
            DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties(this.field_145850_b.field_73011_w.getDimension());
            int energyRecieved = 0;
            if (this.enabled) {
                for (long lng : this.connectedSatellites) {
                    SatelliteBase satellite = properties.getSatellite(lng);
                    if (!(satellite instanceof IUniversalEnergyTransmitter)) continue;
                    energyRecieved += ((IUniversalEnergyTransmitter)satellite).transmitEnergy(EnumFacing.UP, false);
                }
            }
            this.powerMadeLastTick = (int)((float)energyRecieved * Configuration.microwaveRecieverMulitplier);
            if (this.powerMadeLastTick != this.prevPowerMadeLastTick) {
                this.prevPowerMadeLastTick = this.powerMadeLastTick;
                PacketHandler.sendToNearby((BasePacket)new PacketMachine((INetworkMachine)this, 1), (int)this.field_145850_b.field_73011_w.getDimension(), (BlockPos)this.field_174879_c, (double)128.0);
            }
            this.producePower(this.powerMadeLastTick);
        }
        if (this.field_145850_b.field_72995_K) {
            this.textModule.setText("Generating " + this.powerMadeLastTick + " RF/t");
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("canRender", this.canRender);
        nbt.func_74768_a("amtPwr", this.powerMadeLastTick);
        this.writeNetworkData(nbt);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        this.canRender = nbt.func_74767_n("canRender");
        this.powerMadeLastTick = nbt.func_74762_e("amtPwr");
        this.readNetworkData(nbt);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("canRender", this.canRender);
        nbt.func_74768_a("amtPwr", this.powerMadeLastTick);
        this.func_189515_b(nbt);
        return nbt;
    }

    public void handleUpdateTag(NBTTagCompound nbt) {
        this.powerMadeLastTick = nbt.func_74762_e("amtPwr");
        this.canRender = nbt.func_74767_n("canRender");
        this.readNetworkData(nbt);
    }

    public void writeDataToNetwork(ByteBuf out, byte id) {
        super.writeDataToNetwork(out, id);
        if (id == 1) {
            out.writeInt(this.powerMadeLastTick);
        }
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        super.readDataFromNetwork(in, packetId, nbt);
        if (packetId == 1) {
            nbt.func_74768_a("amtPwr", in.readInt());
        }
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        super.useNetworkData(player, side, id, nbt);
        if (id == 1) {
            this.powerMadeLastTick = nbt.func_74762_e("amtPwr");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        int[] intArray = new int[this.connectedSatellites.size() * 2];
        for (int i = 0; i < this.connectedSatellites.size() * 2; i += 2) {
            this.connectedSatellites.get(i / 2);
            intArray[i] = (int)(this.connectedSatellites.get(i / 2) & 0xFFFFFFFFFFFFFFFFL);
            intArray[i + 1] = (int)(this.connectedSatellites.get(i / 2) >>> 32 & 0xFFFFFFFFFFFFFFFFL);
        }
        nbt.func_74783_a("satilliteList", intArray);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        int[] intArray = nbt.func_74759_k("satilliteList");
        this.connectedSatellites.clear();
        for (int i = 0; i < intArray.length / 2; i += 2) {
            this.connectedSatellites.add((long)intArray[i] | (long)intArray[i + 1] << 32);
        }
    }
}

