/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.multiblock;

import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.api.Configuration;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.satellite.SatelliteLaser;
import zmaster587.advancedRocketry.satellite.SatelliteLaserNoDrill;
import zmaster587.advancedRocketry.world.provider.WorldProviderSpace;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.api.LibVulpesBlocks;
import zmaster587.libVulpes.block.RotatableBlock;
import zmaster587.libVulpes.compat.InventoryCompat;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IGuiCallback;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleImage;
import zmaster587.libVulpes.inventory.modules.ModuleNumericTextbox;
import zmaster587.libVulpes.inventory.modules.ModulePower;
import zmaster587.libVulpes.inventory.modules.ModuleSlotArray;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.inventory.modules.ModuleTextBox;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.multiblock.TileMultiPowerConsumer;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.MultiInventory;

public class TileSpaceLaser
extends TileMultiPowerConsumer
implements ISidedInventory,
IGuiCallback,
IButtonInventory {
    private static final int INVSIZE = 9;
    ItemStack glassPanel = null;
    SatelliteLaserNoDrill laserSat;
    protected boolean isRunning = false;
    protected boolean finished = false;
    protected IInventory adjInv;
    private int radius = 0;
    private int xCenter = 0;
    private int yCenter = 0;
    private int numSteps = 0;
    private EnumFacing prevDir = null;
    public int laserX = 0;
    public int laserZ = 0;
    public int tickSinceLastOperation = 0;
    private static final EnumFacing[] VALID_INVENTORY_DIRECTIONS = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST};
    private static final int POWER_PER_OPERATION = (int)(10000.0f * Configuration.spaceLaserPowerMult);
    private ModuleTextBox locationX;
    private ModuleTextBox locationZ;
    private ModuleText updateText;
    MultiInventory inv;
    Object[][][] structure = new Object[][][]{{{null, null, null, null, null}, {null, null, LibVulpesBlocks.blockAdvStructureBlock, null, null}, {null, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, null}, {null, null, LibVulpesBlocks.blockAdvStructureBlock, null, null}, {null, null, null, null, null}}, {{null, null, Character.valueOf('c'), null, null}, {null, Character.valueOf('P'), Blocks.field_150359_w, Character.valueOf('P'), null}, {Character.valueOf('P'), LibVulpesBlocks.blockAdvStructureBlock, Blocks.field_150359_w, LibVulpesBlocks.blockAdvStructureBlock, Character.valueOf('P')}, {null, Character.valueOf('P'), LibVulpesBlocks.blockAdvStructureBlock, Character.valueOf('P'), null}, {null, null, Character.valueOf('P'), null, null}}, {{null, null, LibVulpesBlocks.blockAdvStructureBlock, null, null}, {null, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, null}, {LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, Blocks.field_150359_w, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock}, {null, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, null}, {null, null, LibVulpesBlocks.blockAdvStructureBlock, null, null}}, {{null, null, Character.valueOf('O'), null, null}, {null, LibVulpesBlocks.blockAdvStructureBlock, Blocks.field_150359_w, LibVulpesBlocks.blockAdvStructureBlock, null}, {Character.valueOf('O'), Blocks.field_150359_w, Blocks.field_150359_w, Blocks.field_150359_w, Character.valueOf('O')}, {null, LibVulpesBlocks.blockAdvStructureBlock, Blocks.field_150359_w, LibVulpesBlocks.blockAdvStructureBlock, null}, {null, null, Character.valueOf('O'), null, null}}};
    private MODE mode;
    ForgeChunkManager.Ticket ticket;

    public TileSpaceLaser() {
        this.inv = new MultiInventory((List)this.itemOutPorts);
        this.laserSat = Configuration.laserDrillPlanet ? new SatelliteLaser((IInventory)this.inv) : new SatelliteLaserNoDrill((IInventory)this.inv);
        this.mode = MODE.SINGLE;
    }

    public Object[][][] getStructure() {
        return this.structure;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 5), (double)(this.field_174879_c.func_177956_o() - 100), (double)(this.field_174879_c.func_177952_p() - 5), (double)(this.field_174879_c.func_177958_n() + 5), (double)(this.field_174879_c.func_177956_o() + 5), (double)(this.field_174879_c.func_177952_p() + 5));
    }

    public String getMachineName() {
        return this.getModularInventoryName();
    }

    public void writeDataToNetwork(ByteBuf out, byte id) {
        super.writeDataToNetwork(out, id);
        if (id == 10) {
            out.writeInt(this.laserX);
        } else if (id == 11) {
            out.writeInt(this.laserZ);
        } else if (id == 12) {
            out.writeBoolean(this.isRunning);
        } else if (id == 13) {
            out.writeInt(this.mode.ordinal());
        }
    }

    public void readDataFromNetwork(ByteBuf in, byte id, NBTTagCompound nbt) {
        super.readDataFromNetwork(in, id, nbt);
        if (id == 10) {
            nbt.func_74768_a("laserX", in.readInt());
        } else if (id == 11) {
            nbt.func_74768_a("laserZ", in.readInt());
        } else if (id == 12) {
            nbt.func_74757_a("isRunning", in.readBoolean());
        } else if (id == 13) {
            nbt.func_74768_a("mode", in.readInt());
        }
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        super.useNetworkData(player, side, id, nbt);
        if (id == 10) {
            this.laserX = nbt.func_74762_e("laserX");
            this.finished = false;
            if (this.mode == MODE.SPIRAL) {
                this.resetSpiral();
            }
        } else if (id == 11) {
            this.laserZ = nbt.func_74762_e("laserZ");
            this.finished = false;
            if (this.mode == MODE.SPIRAL) {
                this.resetSpiral();
            }
        } else if (id == 12) {
            this.isRunning = nbt.func_74767_n("isRunning");
        } else if (id == 13 && !this.isRunning()) {
            this.mode = MODE.values()[nbt.func_74762_e("mode")];
        } else if (id == 14) {
            this.attempUnjam();
        }
        this.func_70296_d();
    }

    private void resetSpiral() {
        this.radius = 0;
        this.prevDir = null;
        this.xCenter = 0;
        this.yCenter = 0;
        this.numSteps = 0;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public MODE getMode() {
        return this.mode;
    }

    public void incrementMode() {
        if (this.mode == MODE.SPIRAL) {
            this.resetSpiral();
        }
        int num = this.mode.ordinal();
        if (++num >= MODE.values().length) {
            num = 0;
        }
        this.mode = MODE.values()[num];
    }

    public void decrementMode() {
        if (this.mode == MODE.SPIRAL) {
            this.resetSpiral();
        }
        int num = this.mode.ordinal();
        if (--num < 0) {
            num = MODE.values().length - 1;
        }
        this.mode = MODE.values()[num];
    }

    public void setMode(MODE m) {
        this.mode = m;
    }

    public void setFinished(boolean value) {
        this.finished = value;
    }

    public void setRunning(boolean value) {
        this.isRunning = value;
        this.func_70296_d();
    }

    public void func_73660_a() {
        if (this.timeAlive == 0 && !this.field_145850_b.field_72995_K) {
            if (this.isComplete()) {
                this.canRender = this.completeStructure = this.completeStructure(this.field_145850_b.func_180495_p(this.field_174879_c));
            }
            this.timeAlive = 1;
            this.checkCanRun();
        }
        if (!this.field_145850_b.field_72995_K) {
            ++this.tickSinceLastOperation;
            if (!this.isAllowedToRun()) {
                this.laserSat.deactivateLaser();
                this.setFinished(true);
                this.setRunning(false);
            } else if (this.hasPowerForOperation() && this.isReadyForOperation() && this.laserSat.isAlive() && !this.laserSat.getJammed()) {
                this.laserSat.performOperation();
                this.batteries.setEnergyStored(this.batteries.getEnergyStored() - POWER_PER_OPERATION);
                this.tickSinceLastOperation = 0;
            }
        }
        if (this.laserSat.isFinished()) {
            this.setRunning(false);
            this.laserSat.deactivateLaser();
            if (!this.laserSat.getJammed()) {
                if (this.mode == MODE.SINGLE) {
                    this.finished = true;
                }
                if (this.field_145850_b.func_175676_y(this.func_174877_v()) != 0) {
                    if (this.mode == MODE.LINE_X) {
                        this.laserX += 3;
                    } else if (this.mode == MODE.LINE_Z) {
                        this.laserZ += 3;
                    } else if (this.mode == MODE.SPIRAL) {
                        ++this.numSteps;
                        if (this.radius < this.numSteps) {
                            this.numSteps = 0;
                            if (this.prevDir == EnumFacing.NORTH) {
                                this.prevDir = EnumFacing.EAST;
                            } else if (this.prevDir == EnumFacing.EAST) {
                                this.prevDir = EnumFacing.SOUTH;
                                ++this.radius;
                            } else if (this.prevDir == EnumFacing.SOUTH) {
                                this.prevDir = EnumFacing.WEST;
                            } else {
                                this.prevDir = EnumFacing.NORTH;
                                ++this.radius;
                            }
                        }
                        this.laserX += 3 * this.prevDir.func_82601_c();
                        this.laserZ += 3 * this.prevDir.func_82599_e();
                    }
                }
                this.checkCanRun();
            }
        }
    }

    public boolean isReadyForOperation() {
        if (this.batteries.getEnergyStored() == 0) {
            return false;
        }
        return (float)this.tickSinceLastOperation > (float)(3 * this.batteries.getMaxEnergyStored()) / (float)this.batteries.getEnergyStored();
    }

    public void onDestroy() {
        if (this.laserSat != null) {
            this.laserSat.deactivateLaser();
        }
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
    }

    public void onChunkUnload() {
        if (this.laserSat != null) {
            this.laserSat.deactivateLaser();
        }
        this.isRunning = false;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        nbt.func_74757_a("IsRunning", this.isRunning);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.isRunning = pkt.func_148857_g().func_74767_n("IsRunning");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        NBTTagCompound laser = new NBTTagCompound();
        this.laserSat.writeToNBT(laser);
        nbt.func_74782_a("laser", (NBTBase)laser);
        if (this.glassPanel != null) {
            NBTTagCompound tag = new NBTTagCompound();
            this.glassPanel.func_77955_b(tag);
            nbt.func_74782_a("GlassPane", (NBTBase)tag);
        }
        nbt.func_74768_a("laserX", this.laserX);
        nbt.func_74768_a("laserZ", this.laserZ);
        nbt.func_74774_a("mode", (byte)this.mode.ordinal());
        if (this.mode == MODE.SPIRAL && this.prevDir != null) {
            nbt.func_74768_a("CenterX", this.xCenter);
            nbt.func_74768_a("CenterY", this.yCenter);
            nbt.func_74768_a("radius", this.radius);
            nbt.func_74768_a("numSteps", this.numSteps);
            nbt.func_74768_a("prevDir", this.prevDir.ordinal());
        }
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.laserSat.readFromNBT(nbt.func_74775_l("laser"));
        if (nbt.func_74764_b("GlassPane")) {
            NBTTagCompound tag = nbt.func_74775_l("GlassPane");
            this.glassPanel = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        this.laserX = nbt.func_74762_e("laserX");
        this.laserZ = nbt.func_74762_e("laserZ");
        this.mode = MODE.values()[nbt.func_74771_c("mode")];
        if (this.mode == MODE.SPIRAL && nbt.func_74764_b("prevDir")) {
            this.xCenter = nbt.func_74762_e("CenterX");
            this.yCenter = nbt.func_74762_e("CenterY");
            this.radius = nbt.func_74762_e("radius");
            this.numSteps = nbt.func_74762_e("numSteps");
            this.prevDir = EnumFacing.values()[nbt.func_74762_e("prevDir")];
        }
    }

    public void onLaserFinish() {
    }

    public void attempUnjam() {
        if (!this.laserSat.getJammed()) {
            return;
        }
        this.laserSat.setJammed(false);
        this.finished = false;
        this.checkCanRun();
    }

    private Object getAvalibleInv() {
        EnumFacing front = RotatableBlock.getFront((IBlockState)this.field_145850_b.func_180495_p(this.func_174877_v()));
        for (EnumFacing f : VALID_INVENTORY_DIRECTIONS) {
            TileEntity e;
            if (f == front || !InventoryCompat.canInjectItems((TileEntity)(e = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(f))))) continue;
            return (IInventory)e;
        }
        return null;
    }

    private Object getAvalibleInv(ItemStack item) {
        if (item == null) {
            return this.getAvalibleInv();
        }
        EnumFacing front = RotatableBlock.getFront((IBlockState)this.field_145850_b.func_180495_p(this.field_174879_c));
        for (EnumFacing f : VALID_INVENTORY_DIRECTIONS) {
            TileEntity e;
            if (f == front || !InventoryCompat.canInjectItems((TileEntity)(e = this.field_145850_b.func_175625_s(this.func_174877_v())), (ItemStack)item)) continue;
            return e;
        }
        return null;
    }

    private boolean canMachineSeeEarth() {
        return true;
    }

    private boolean isAllowedToRun() {
        return this.glassPanel != null && this.batteries.getEnergyStored() != 0 && this.field_145850_b.field_73011_w instanceof WorldProviderSpace && DimensionManager.getInstance().canTravelTo(((WorldProviderSpace)this.field_145850_b.field_73011_w).getDimensionProperties(this.func_174877_v()).getParentPlanet()) && !Configuration.laserBlackListDims.contains(((WorldProviderSpace)this.field_145850_b.field_73011_w).getDimensionProperties(this.func_174877_v()).getParentPlanet());
    }

    public void checkCanRun() {
        if (this.field_145850_b.func_175687_A(this.func_174877_v()) == 0 || !this.isAllowedToRun()) {
            if (this.laserSat.isAlive()) {
                this.laserSat.deactivateLaser();
            }
            this.setRunning(false);
        } else if (!this.laserSat.isAlive() && !this.finished && !this.laserSat.getJammed() && this.field_145850_b.func_175687_A(this.func_174877_v()) > 0 && this.canMachineSeeEarth()) {
            int orbitDimId = ((WorldProviderSpace)this.field_145850_b.field_73011_w).getDimensionProperties(this.func_174877_v()).getParentPlanet();
            if (orbitDimId == Integer.MIN_VALUE) {
                return;
            }
            WorldServer orbitWorld = net.minecraftforge.common.DimensionManager.getWorld((int)orbitDimId);
            if (orbitWorld == null) {
                net.minecraftforge.common.DimensionManager.initDimension((int)orbitDimId);
                orbitWorld = net.minecraftforge.common.DimensionManager.getWorld((int)orbitDimId);
                if (orbitWorld == null) {
                    return;
                }
            }
            if (this.ticket == null) {
                this.ticket = ForgeChunkManager.requestTicket((Object)AdvancedRocketry.instance, (World)this.field_145850_b, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
                if (this.ticket != null) {
                    ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkPos)new ChunkPos(this.func_174877_v().func_177958_n() / 16 - (this.func_174877_v().func_177958_n() < 0 ? 1 : 0), this.func_174877_v().func_177952_p() / 16 - (this.func_174877_v().func_177952_p() < 0 ? 1 : 0)));
                }
            }
            this.setRunning(this.laserSat.activateLaser((World)orbitWorld, this.laserX, this.laserZ));
        }
        if (!this.field_145850_b.field_72995_K) {
            PacketHandler.sendToNearby((BasePacket)new PacketMachine((INetworkMachine)this, 12), (int)128, (BlockPos)this.field_174879_c, (double)this.field_145850_b.field_73011_w.getDimension());
        }
    }

    public int getEnergyPercentScaled(int max) {
        return (int)((float)max * ((float)this.batteries.getEnergyStored() / (float)this.batteries.getMaxEnergyStored()));
    }

    public boolean hasEnergy() {
        return this.batteries.getEnergyStored() != 0;
    }

    public int func_70302_i_() {
        return this.inv.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        if (i == 0) {
            return this.glassPanel;
        }
        return this.inv.func_70301_a(--i);
    }

    public ItemStack func_70298_a(int i, int j) {
        if (i == 0) {
            ItemStack ret = this.glassPanel.func_77946_l();
            this.glassPanel = null;
            return ret;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        if (i == 0) {
            this.glassPanel = itemstack;
        } else {
            if (InventoryCompat.canInjectItems((IInventory)this.inv, (ItemStack)itemstack)) {
                InventoryCompat.injectItem((Object)this.inv, (ItemStack)itemstack);
            }
            this.checkCanRun();
        }
    }

    public String func_70005_c_() {
        return LibVulpes.proxy.getLocalizedString("tile.spaceLaser.name");
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return entityplayer.func_174818_b(this.field_174879_c) <= 64.0;
    }

    public void func_174889_b(EntityPlayer entity) {
    }

    public void func_174886_c(EntityPlayer entity) {
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (i == 0) {
            return AdvancedRocketryItems.itemLens == itemstack.func_77973_b();
        }
        return this.inv.func_94041_b(i, itemstack);
    }

    public boolean hasPowerForOperation() {
        return POWER_PER_OPERATION <= this.batteries.getEnergyStored();
    }

    public void setEnergy(int amt) {
        this.batteries.setEnergyStored(amt);
    }

    public boolean isJammed() {
        return this.laserSat.getJammed();
    }

    public void setJammed(boolean b) {
        this.laserSat.setJammed(b);
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void onModuleUpdated(ModuleBase module) {
        if (module == this.locationX) {
            if (!((ModuleTextBox)module).getText().isEmpty() && !((ModuleTextBox)module).getText().contentEquals("-")) {
                this.laserX = Integer.parseInt(((ModuleTextBox)module).getText());
            }
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 10));
        } else if (module == this.locationZ) {
            if (!((ModuleTextBox)module).getText().isEmpty() && !((ModuleTextBox)module).getText().contentEquals("-")) {
                this.laserZ = Integer.parseInt(((ModuleTextBox)module).getText());
            }
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 11));
        }
    }

    public List<ModuleBase> getModules(int id, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        if (this.field_145850_b.field_72995_K) {
            this.locationX = new ModuleNumericTextbox((IGuiCallback)this, 113, 31, 50, 10, 16);
            modules.add((ModuleBase)this.locationX);
            this.locationZ = new ModuleNumericTextbox((IGuiCallback)this, 113, 41, 50, 10, 16);
            modules.add((ModuleBase)this.locationZ);
            this.locationX.setText(String.valueOf(this.laserX));
            this.locationZ.setText(String.valueOf(this.laserZ));
            this.updateText = new ModuleText(130, 20, this.getMode().toString(), 723723, true);
            modules.add((ModuleBase)this.updateText);
            modules.add((ModuleBase)new ModuleText(103, 33, "X:", 723723));
            modules.add((ModuleBase)new ModuleText(103, 43, "Z:", 723723));
            modules.add((ModuleBase)new ModuleImage(8, 16, TextureResources.laserGuiBG));
        }
        modules.add((ModuleBase)new ModuleButton(103, 20, 0, "", (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonLeft, 5, 8));
        modules.add((ModuleBase)new ModuleButton(157, 20, 1, "", (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonRight, 5, 8));
        modules.add((ModuleBase)new ModuleButton(103, 62, 2, "Reset", (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonBuild, 34, 20));
        modules.add((ModuleBase)new ModulePower(11, 25, (IUniversalEnergy)this.batteries));
        modules.add((ModuleBase)new ModuleSlotArray(56, 54, (IInventory)this, 0, 1));
        return modules;
    }

    public String getModularInventoryName() {
        return "tile.spaceLaser.name";
    }

    public boolean canInteractWithContainer(EntityPlayer entity) {
        return true;
    }

    public void onInventoryButtonPressed(int buttonId) {
        if (buttonId == 0) {
            this.decrementMode();
            this.updateText.setText(this.getMode().toString());
        } else if (buttonId == 1) {
            this.incrementMode();
            this.updateText.setText(this.getMode().toString());
        } else {
            if (buttonId == 2) {
                PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 14));
                return;
            }
            return;
        }
        if (!this.isRunning()) {
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 13));
        }
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public static enum MODE {
        SINGLE,
        LINE_X,
        LINE_Z,
        SPIRAL;

    }
}

