/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.multiblock;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.Configuration;
import zmaster587.advancedRocketry.api.DataStorage;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.inventory.modules.ModuleData;
import zmaster587.advancedRocketry.item.ItemAsteroidChip;
import zmaster587.advancedRocketry.item.ItemData;
import zmaster587.advancedRocketry.tile.hatch.TileDataBus;
import zmaster587.advancedRocketry.util.AsteroidSmall;
import zmaster587.advancedRocketry.util.IDataInventory;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.api.LibVulpesBlocks;
import zmaster587.libVulpes.block.BlockMeta;
import zmaster587.libVulpes.block.multiblock.BlockMultiblockMachine;
import zmaster587.libVulpes.client.util.ProgressBarImage;
import zmaster587.libVulpes.inventory.GuiHandler;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IGuiCallback;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.IProgressBar;
import zmaster587.libVulpes.inventory.modules.IToggleButton;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleContainerPan;
import zmaster587.libVulpes.inventory.modules.ModuleOutputSlotArray;
import zmaster587.libVulpes.inventory.modules.ModulePower;
import zmaster587.libVulpes.inventory.modules.ModuleProgress;
import zmaster587.libVulpes.inventory.modules.ModuleScaledImage;
import zmaster587.libVulpes.inventory.modules.ModuleSlotButton;
import zmaster587.libVulpes.inventory.modules.ModuleTab;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.inventory.modules.ModuleTexturedSlotArray;
import zmaster587.libVulpes.inventory.modules.ModuleToggleSwitch;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.multiblock.TileMultiBlock;
import zmaster587.libVulpes.tile.multiblock.TileMultiPowerConsumer;
import zmaster587.libVulpes.util.EmbeddedInventory;
import zmaster587.libVulpes.util.INetworkMachine;

public class TileObservatory
extends TileMultiPowerConsumer
implements IModularInventory,
IDataInventory,
IGuiCallback {
    private static final Block[] lens = new Block[]{AdvancedRocketryBlocks.blockLens, Blocks.field_150359_w};
    private static final Object[][][] structure = new Object[][][]{{{Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a}, {Blocks.field_150350_a, Blocks.field_150348_b, lens, Blocks.field_150348_b, Blocks.field_150350_a}, {Blocks.field_150350_a, Blocks.field_150348_b, Blocks.field_150348_b, Blocks.field_150348_b, Blocks.field_150350_a}, {Blocks.field_150350_a, Blocks.field_150348_b, Blocks.field_150348_b, Blocks.field_150348_b, Blocks.field_150350_a}, {Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a}}, {{Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a}, {Blocks.field_150350_a, Blocks.field_150348_b, Blocks.field_150348_b, Blocks.field_150348_b, Blocks.field_150350_a}, {Blocks.field_150350_a, Blocks.field_150348_b, lens, Blocks.field_150348_b, Blocks.field_150350_a}, {Blocks.field_150350_a, Blocks.field_150348_b, Blocks.field_150348_b, Blocks.field_150348_b, Blocks.field_150350_a}, {Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a}}, {{null, Blocks.field_150348_b, Blocks.field_150348_b, Blocks.field_150348_b, null}, {Blocks.field_150348_b, Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150348_b}, {Blocks.field_150348_b, Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150348_b}, {Blocks.field_150348_b, Blocks.field_150350_a, lens, Blocks.field_150350_a, Blocks.field_150348_b}, {null, Blocks.field_150348_b, Blocks.field_150348_b, Blocks.field_150348_b, null}}, {{null, Character.valueOf('*'), Character.valueOf('c'), Character.valueOf('*'), null}, {Character.valueOf('*'), Blocks.field_150348_b, Blocks.field_150348_b, Blocks.field_150348_b, Character.valueOf('*')}, {Character.valueOf('*'), Blocks.field_150348_b, Blocks.field_150348_b, Blocks.field_150348_b, Character.valueOf('*')}, {Character.valueOf('*'), Blocks.field_150348_b, Blocks.field_150348_b, Blocks.field_150348_b, Character.valueOf('*')}, {null, Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), null}}, {{null, Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), null}, {Character.valueOf('*'), Blocks.field_150348_b, Blocks.field_150348_b, Blocks.field_150348_b, Character.valueOf('*')}, {Character.valueOf('*'), Blocks.field_150348_b, LibVulpesBlocks.motors, Blocks.field_150348_b, Character.valueOf('*')}, {Character.valueOf('*'), Blocks.field_150348_b, Blocks.field_150348_b, Blocks.field_150348_b, Character.valueOf('*')}, {null, Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), null}}};
    static final int openTime = 100;
    static final int observationtime = 1000;
    private static final byte TAB_SWITCH = 10;
    private static final byte BUTTON_PRESS = 11;
    private static final short LIST_OFFSET = 100;
    private static final byte PROCESS_CHIP = 12;
    private static final byte SEED_CHANGE = 13;
    private int viewDistance = 0;
    private int lastButton = -1;
    private long lastSeed = -1L;
    private String lastType;
    int openProgress = 0;
    private LinkedList<TileDataBus> dataCables;
    private HashMap<Integer, String> buttonType = new HashMap();
    private boolean isOpen;
    private ModuleTab tabModule;
    private int dataConsumedPerRefresh = 100;
    EmbeddedInventory inv = new EmbeddedInventory(3);

    public TileObservatory() {
        this.completionTime = 1000;
        this.dataCables = new LinkedList();
        this.tabModule = new ModuleTab(4, 0, 0, (IGuiCallback)this, 2, new String[]{LibVulpes.proxy.getLocalizedString("msg.tooltip.data"), LibVulpes.proxy.getLocalizedString("msg.tooltip.asteroidselection")}, (ResourceLocation[][])new ResourceLocation[][]{TextureResources.tabData, TextureResources.tabAsteroid});
    }

    public float getOpenProgress() {
        return (float)this.openProgress / 100.0f;
    }

    protected void integrateTile(TileEntity tile) {
        super.integrateTile(tile);
        if (tile instanceof TileDataBus) {
            this.dataCables.add((TileDataBus)tile);
            ((TileDataBus)tile).lockData(((TileDataBus)tile).getDataObject().getDataType());
        }
    }

    public void deconstructMultiBlock(World world, BlockPos destroyedPos, boolean blockBroken, IBlockState state) {
        super.deconstructMultiBlock(world, destroyedPos, blockBroken, state);
        this.viewDistance = 0;
    }

    protected void replaceStandardBlock(BlockPos newPos, IBlockState state, TileEntity tile) {
        Block block = state.func_177230_c();
        if (block == AdvancedRocketryBlocks.blockLens) {
            this.viewDistance += 5;
        } else if (block == LibVulpesBlocks.blockMotor) {
            this.viewDistance += 25;
        } else if (block == LibVulpesBlocks.blockAdvancedMotor) {
            this.viewDistance += 50;
        } else if (block == LibVulpesBlocks.blockEnhancedMotor) {
            this.viewDistance += 100;
        } else if (block == LibVulpesBlocks.blockEliteMotor) {
            this.viewDistance += 175;
        }
        super.replaceStandardBlock(newPos, state, tile);
    }

    public void func_73660_a() {
        if (this.timeAlive == 0) {
            this.attemptCompleteStructure(this.field_145850_b.func_180495_p(this.field_174879_c));
            this.timeAlive = 1;
        }
        if (this.field_145850_b.field_72995_K && this.isOpen || !this.field_145850_b.field_72995_K && this.isRunning() && this.getMachineEnabled() && !this.field_145850_b.func_72896_J() && this.field_145850_b.func_175710_j(this.field_174879_c.func_177982_a(0, 1, 0)) && !this.field_145850_b.func_72935_r()) {
            if (!this.isOpen) {
                this.isOpen = true;
                this.func_70296_d();
                this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
            }
            if (this.openProgress < 100) {
                ++this.openProgress;
            }
        } else if (this.openProgress > 0) {
            if (this.isOpen) {
                this.isOpen = false;
                this.func_70296_d();
                this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
            }
            --this.openProgress;
        }
    }

    public boolean isRunning() {
        return true;
    }

    protected void processComplete() {
    }

    public void resetCache() {
        super.resetCache();
        this.dataCables.clear();
    }

    public Object[][][] getStructure() {
        return structure;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-5, -3, -5), this.field_174879_c.func_177982_a(5, 3, 5));
    }

    public List<BlockMeta> getAllowableWildCardBlocks() {
        List list = super.getAllowableWildCardBlocks();
        list.add(new BlockMeta(Blocks.field_150339_S, -1));
        list.addAll(TileMultiBlock.getMapping((char)'P'));
        list.addAll(TileMultiBlock.getMapping((char)'D'));
        return list;
    }

    protected void writeNetworkData(NBTTagCompound nbt) {
        super.writeNetworkData(nbt);
        nbt.func_74768_a("openProgress", this.openProgress);
        nbt.func_74757_a("isOpen", this.isOpen);
        nbt.func_74768_a("viewableDist", this.viewDistance);
        nbt.func_74772_a("lastSeed", this.lastSeed);
        nbt.func_74768_a("lastButton", this.lastButton);
        if (this.lastType != null && !this.lastType.isEmpty()) {
            nbt.func_74778_a("lastType", this.lastType);
        }
    }

    protected void readNetworkData(NBTTagCompound nbt) {
        super.readNetworkData(nbt);
        this.openProgress = nbt.func_74762_e("openProgress");
        this.isOpen = nbt.func_74767_n("isOpen");
        this.viewDistance = nbt.func_74762_e("viewableDist");
        this.lastSeed = nbt.func_74763_f("lastSeed");
        this.lastButton = nbt.func_74762_e("lastButton");
        this.lastType = nbt.func_74779_i("lastType");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.inv.writeToNBT(nbt);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inv.readFromNBT(nbt);
    }

    public LinkedList<TileDataBus> getDataBus() {
        return this.dataCables;
    }

    private int getDataAmt(DataStorage.DataType type) {
        int data = 0;
        for (TileDataBus tile : this.getDataBus()) {
            if (tile.getDataObject().getDataType() != type) continue;
            data += tile.getDataObject().getData();
        }
        return data;
    }

    public boolean completeStructure(IBlockState state) {
        boolean result = super.completeStructure(state);
        if (result) {
            ((BlockMultiblockMachine)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c()).setBlockState(this.field_145850_b, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_174879_c, true);
        } else {
            ((BlockMultiblockMachine)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c()).setBlockState(this.field_145850_b, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_174879_c, false);
        }
        this.completionTime = 1000;
        return result;
    }

    public String getMachineName() {
        return "container.observatory";
    }

    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        modules.add((ModuleBase)this.tabModule);
        if (this.tabModule.getTab() == 1) {
            modules.add((ModuleBase)new ModuleTexturedSlotArray(5, 120, (IInventory)this, 1, 2, TextureResources.idChip));
            modules.add((ModuleBase)new ModuleOutputSlotArray(45, 120, (IInventory)this, 2, 3));
            modules.add((ModuleBase)new ModuleProgress(25, 120, 0, new ProgressBarImage(217, 0, 17, 17, 234, 0, EnumFacing.DOWN, TextureResources.progressBars), (IProgressBar)this));
            modules.add((ModuleBase)new ModuleButton(25, 120, 1, "", (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonNull, LibVulpes.proxy.getLocalizedString("msg.observetory.text.processdiscovery"), 17, 17));
            ModuleButton scanButton = new ModuleButton(100, 120, 2, LibVulpes.proxy.getLocalizedString("msg.observetory.scan.button"), (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonBuild, LibVulpes.proxy.getLocalizedString("msg.observetory.scan.tooltip"), 64, 18);
            scanButton.setColor(this.extractData(this.dataConsumedPerRefresh, DataStorage.DataType.DISTANCE, EnumFacing.DOWN, false) == this.dataConsumedPerRefresh ? 65280 : 0xFF0000);
            modules.add((ModuleBase)scanButton);
            LinkedList<ModuleButton> list2 = new LinkedList<ModuleButton>();
            LinkedList<Object> buttonList = new LinkedList<Object>();
            this.buttonType.clear();
            int g = 0;
            if (this.lastButton != -1 && this.lastType != null && !this.lastType.isEmpty()) {
                List<AsteroidSmall.StackEntry> harvestList = Configuration.asteroidTypes.get(this.lastType).getHarvest(this.lastSeed + (long)this.lastButton, Math.max(1.0f - (float)(Math.min(this.getDataAmt(DataStorage.DataType.COMPOSITION), 2000) + Math.min(this.getDataAmt(DataStorage.DataType.MASS), 2000)) / 4000.0f, 0.0f));
                for (AsteroidSmall.StackEntry entry : harvestList) {
                    buttonList.add(new ModuleSlotButton(g % 3 * 24 + 1, 24 * (g / 3) + 1, -2, (IButtonInventory)this, entry.stack, String.valueOf(entry.midpoint) + " +/-  " + String.valueOf(entry.variablility), this.func_145831_w()));
                    buttonList.add(new ModuleText(g % 3 * 24 + 1, 24 * (g / 3) + 1, String.valueOf(entry.midpoint) + "\n+/- " + String.valueOf(entry.variablility), 0xFFFFFF, 0.5f));
                    ++g;
                }
                float time = Configuration.asteroidTypes.get((Object)this.lastType).timeMultiplier;
                buttonList.add(new ModuleText(0, 24 * (1 + g / 3), String.format("Mission Time:\n%.2fx", Float.valueOf(time)), 0x2F2F2F));
            }
            int totalAmountAllowed = 10;
            float totalWeight = 0.0f;
            LinkedList<Object> viableTypes = new LinkedList<Object>();
            for (String str : Configuration.asteroidTypes.keySet()) {
                AsteroidSmall asteroid = Configuration.asteroidTypes.get(str);
                if (asteroid.distance > this.getMaxDistance()) continue;
                totalWeight += asteroid.getProbability();
                viableTypes.add(asteroid);
            }
            LinkedList<AsteroidSmall> finalList = new LinkedList<AsteroidSmall>();
            Random rand = new Random(this.lastSeed);
            for (AsteroidSmall asteroidSmall : viableTypes) {
                for (int i = 0; i < totalAmountAllowed; ++i) {
                    if (!(asteroidSmall.getProbability() / totalWeight >= rand.nextFloat())) continue;
                    finalList.add(asteroidSmall);
                }
            }
            for (int i = 0; i < finalList.size(); ++i) {
                AsteroidSmall asteroidSmall = (AsteroidSmall)finalList.get(i);
                ModuleButton button = new ModuleButton(0, i * 18, 100 + i, asteroidSmall.getName(), (IButtonInventory)this, TextureResources.buttonAsteroid, 72, 18);
                if (this.lastButton - 100 == i) {
                    button.setColor(0xFFFF00);
                }
                list2.add(button);
                this.buttonType.put(i, asteroidSmall.getName());
            }
            modules.add((ModuleBase)new ModuleText(10, 18, LibVulpes.proxy.getLocalizedString("msg.observetory.text.asteroids"), 0x2D2D2D));
            modules.add((ModuleBase)new ModuleText(105, 18, LibVulpes.proxy.getLocalizedString("msg.observetory.text.composition"), 0x2D2D2D));
            int baseX = 5;
            int n = 32;
            int sizeX = 72;
            int sizeY = 46;
            if (this.field_145850_b.field_72995_K) {
                modules.add((ModuleBase)new ModuleScaledImage(baseX - 3, n - 3, 3, n + sizeY + 6, TextureResources.verticalBar));
                modules.add((ModuleBase)new ModuleScaledImage(baseX + sizeX, n - 3, -3, n + sizeY + 6, TextureResources.verticalBar));
                modules.add((ModuleBase)new ModuleScaledImage(baseX, n - 3, sizeX, 3, TextureResources.horizontalBar));
                modules.add((ModuleBase)new ModuleScaledImage(baseX, 2 * n + sizeY, sizeX, -3, TextureResources.horizontalBar));
            }
            if (this.lastSeed != -1L) {
                ModuleContainerPan pan = new ModuleContainerPan(baseX, n, list2, new LinkedList(), null, sizeX - 2, sizeY, 0, -48, 0, 72);
                modules.add((ModuleBase)pan);
            }
            baseX = 100;
            int n2 = 32;
            sizeX = 72;
            sizeY = 46;
            if (this.field_145850_b.field_72995_K) {
                modules.add((ModuleBase)new ModuleScaledImage(baseX - 3, n2 - 3, 3, n2 + sizeY + 6, TextureResources.verticalBar));
                modules.add((ModuleBase)new ModuleScaledImage(baseX + sizeX, n2 - 3, -3, n2 + sizeY + 6, TextureResources.verticalBar));
                modules.add((ModuleBase)new ModuleScaledImage(baseX, n2 - 3, sizeX, 3, TextureResources.horizontalBar));
                modules.add((ModuleBase)new ModuleScaledImage(baseX, 2 * n2 + sizeY, sizeX, -3, TextureResources.horizontalBar));
            }
            ModuleContainerPan pan2 = new ModuleContainerPan(baseX, n2, buttonList, new LinkedList(), null, 40, 48, 0, 0, 0, 72);
            modules.add((ModuleBase)pan2);
        } else if (this.tabModule.getTab() == 0) {
            modules.add((ModuleBase)new ModulePower(18, 20, (IUniversalEnergy)this.getBatteries()));
            this.toggleSwitch = new ModuleToggleSwitch(160, 5, 0, "", (IToggleButton)this, zmaster587.libVulpes.inventory.TextureResources.buttonToggleImage, 11, 26, this.getMachineEnabled());
            modules.add((ModuleBase)this.toggleSwitch);
            LinkedList<DataStorage> distanceStorage = new LinkedList<DataStorage>();
            LinkedList<DataStorage> compositionStorage = new LinkedList<DataStorage>();
            LinkedList<DataStorage> massStorage = new LinkedList<DataStorage>();
            for (int i = 0; i < this.dataCables.size(); ++i) {
                DataStorage storage = this.dataCables.get(i).getDataObject();
                DataStorage.DataType type = this.dataCables.get(i).getDataObject().getDataType();
                if (type == DataStorage.DataType.COMPOSITION) {
                    compositionStorage.add(storage);
                    continue;
                }
                if (type == DataStorage.DataType.DISTANCE) {
                    distanceStorage.add(storage);
                    continue;
                }
                if (type != DataStorage.DataType.MASS) continue;
                massStorage.add(storage);
            }
            if (distanceStorage.size() > 0) {
                modules.add(new ModuleData(40, 20, 0, this, distanceStorage.toArray(new DataStorage[distanceStorage.size()])));
            }
            if (compositionStorage.size() > 0) {
                modules.add(new ModuleData(80, 20, 0, this, compositionStorage.toArray(new DataStorage[compositionStorage.size()])));
            }
            if (massStorage.size() > 0) {
                modules.add(new ModuleData(120, 20, 0, this, massStorage.toArray(new DataStorage[massStorage.size()])));
            }
            modules.add((ModuleBase)new ModuleText(10, 90, LibVulpes.proxy.getLocalizedString("msg.observetory.text.observabledistance") + " " + this.getMaxDistance(), 0x2D2D2D, false));
        }
        return modules;
    }

    public int getMaxDistance() {
        return this.viewDistance + 10;
    }

    public void onInventoryButtonPressed(int buttonId) {
        super.onInventoryButtonPressed(buttonId);
        if (buttonId == 1) {
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 12));
        }
        if (buttonId >= 100) {
            this.lastButton = buttonId;
            this.lastType = this.buttonType.get(this.lastButton - 100);
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 11));
        }
        if (buttonId == 2 && this.extractData(this.dataConsumedPerRefresh, DataStorage.DataType.DISTANCE, EnumFacing.UP, false) == this.dataConsumedPerRefresh) {
            this.lastSeed = this.field_145850_b.func_82737_E() / 100L;
            this.lastButton = -1;
            this.lastType = "";
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 13));
        }
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        ItemStack stack;
        super.useNetworkData(player, side, id, nbt);
        if (id == -1) {
            this.storeData(-1);
        } else if (id == 10 && !this.field_145850_b.field_72995_K) {
            this.tabModule.setTab((int)nbt.func_74765_d("tab"));
            player.openGui((Object)LibVulpes.instance, GuiHandler.guiId.MODULARNOINV.ordinal(), this.func_145831_w(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        } else if (id == 11 && !this.field_145850_b.field_72995_K) {
            this.lastButton = nbt.func_74765_d("button");
            this.lastType = this.buttonType.get(this.lastButton - 100);
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
            player.openGui((Object)LibVulpes.instance, GuiHandler.guiId.MODULARNOINV.ordinal(), this.func_145831_w(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        } else if (id == 13) {
            if (this.extractData(this.dataConsumedPerRefresh, DataStorage.DataType.DISTANCE, EnumFacing.UP, false) >= this.dataConsumedPerRefresh) {
                this.lastSeed = this.field_145850_b.func_82737_E() / 100L;
                this.lastButton = -1;
                this.lastType = "";
                this.extractData(this.dataConsumedPerRefresh, DataStorage.DataType.DISTANCE, EnumFacing.UP, true);
                this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
                this.func_70296_d();
                player.openGui((Object)LibVulpes.instance, GuiHandler.guiId.MODULARNOINV.ordinal(), this.func_145831_w(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
            }
        } else if (id == 12 && !this.field_145850_b.field_72995_K && this.inv.func_70301_a(2) == null && this.isOpen && this.hasEnergy(500) && this.lastButton != -1 && (stack = this.inv.func_70298_a(1, 1)) != null && stack.func_77973_b() instanceof ItemAsteroidChip) {
            ((ItemAsteroidChip)stack.func_77973_b()).setUUID(stack, this.lastSeed);
            ((ItemAsteroidChip)stack.func_77973_b()).setType(stack, this.lastType);
            ((ItemAsteroidChip)stack.func_77973_b()).setMaxData(stack, 1000);
            this.inv.func_70299_a(2, stack);
            this.extractData(1000, DataStorage.DataType.COMPOSITION, EnumFacing.UP, true);
            this.extractData(1000, DataStorage.DataType.MASS, EnumFacing.UP, true);
            this.useEnergy(500);
        }
    }

    public void writeDataToNetwork(ByteBuf out, byte id) {
        super.writeDataToNetwork(out, id);
        if (id == 10) {
            out.writeShort(this.tabModule.getTab());
        } else if (id == 11) {
            out.writeShort(this.lastButton);
        }
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        super.readDataFromNetwork(in, packetId, nbt);
        if (packetId == 10) {
            nbt.func_74777_a("tab", in.readShort());
        } else if (packetId == 11) {
            nbt.func_74777_a("button", in.readShort());
        }
    }

    public int func_70302_i_() {
        return this.inv.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inv.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.inv.func_70298_a(slot, amount);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inv.func_70299_a(slot, stack);
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return this.inv.func_94041_b(p_94041_1_, p_94041_2_);
    }

    @Override
    public int extractData(int maxAmount, DataStorage.DataType type, EnumFacing dir, boolean commit) {
        int amt = 0;
        for (TileDataBus tile : this.getDataBus()) {
            int dataAmt = tile.extractData(maxAmount, type, dir, commit);
            amt += dataAmt;
            maxAmount -= dataAmt;
        }
        return amt;
    }

    @Override
    public int addData(int maxAmount, DataStorage.DataType type, EnumFacing dir, boolean commit) {
        return 0;
    }

    @Override
    public void loadData(int id) {
    }

    @Override
    public void storeData(int id) {
        ItemStack dataChip = this.inv.func_70301_a(0);
        if (dataChip != null && dataChip.func_77973_b() instanceof ItemData && dataChip.field_77994_a == 1) {
            ItemData dataItem = (ItemData)dataChip.func_77973_b();
            DataStorage data = dataItem.getDataStorage(dataChip);
            for (TileDataBus tile : this.dataCables) {
                DataStorage.DataType dataType = tile.getDataObject().getDataType();
                data.addData(tile.extractData(data.getMaxData() - data.getData(), data.getDataType(), EnumFacing.UP, true), dataType, true);
            }
            dataItem.setData(dataChip, data.getData(), data.getDataType());
        }
        if (this.field_145850_b.field_72995_K) {
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, -1));
        }
    }

    public String func_70005_c_() {
        return null;
    }

    public ItemStack func_70304_b(int index) {
        return this.inv.func_70304_b(index);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public void onModuleUpdated(ModuleBase module) {
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 10));
    }
}

