/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.multiblock;

import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.util.AudioRegistry;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.api.LibVulpesBlocks;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IGuiCallback;
import zmaster587.libVulpes.inventory.modules.ISliderBar;
import zmaster587.libVulpes.inventory.modules.IToggleButton;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleBlockSideSelector;
import zmaster587.libVulpes.inventory.modules.ModulePower;
import zmaster587.libVulpes.inventory.modules.ModuleRedstoneOutputButton;
import zmaster587.libVulpes.inventory.modules.ModuleSlider;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.inventory.modules.ModuleToggleSwitch;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.multiblock.TileMultiPowerConsumer;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.ZUtils;

public class TileGravityController
extends TileMultiPowerConsumer
implements ISliderBar,
IGuiCallback {
    int gravity;
    int progress;
    int radius;
    float currentProgress;
    double rotation;
    private ModuleRedstoneOutputButton redstoneControl;
    private ZUtils.RedstoneState state;
    private ModuleText targetGrav;
    private ModuleText textRadius = new ModuleText(6, 82, "Radius: 5", 0x202020);
    private ModuleBlockSideSelector sideSelectorModule;
    private static final Object[][][] structure = new Object[][][]{{{null, null, null}, {null, Character.valueOf('c'), null}, {null, null, null}}, {{null, LibVulpesBlocks.blockAdvStructureBlock, null}, {LibVulpesBlocks.blockAdvStructureBlock, Character.valueOf('P'), LibVulpesBlocks.blockAdvStructureBlock}, {null, LibVulpesBlocks.blockAdvStructureBlock, null}}};

    public TileGravityController() {
        this.targetGrav = new ModuleText(6, 110, "Target Gravity:", 0x202020);
        this.sideSelectorModule = new ModuleBlockSideSelector(90, 15, (IGuiCallback)this, new String[]{"None", "Active: set", "Active: Additive"});
        this.redstoneControl = new ModuleRedstoneOutputButton(174, 4, 1, "", (IButtonInventory)this);
        this.state = ZUtils.RedstoneState.OFF;
        this.redstoneControl.setRedstoneState(this.state);
        this.radius = 5;
    }

    public SoundEvent getSound() {
        return AudioRegistry.gravityOhhh;
    }

    public Object[][][] getStructure() {
        return structure;
    }

    public List<ModuleBase> getModules(int id, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        this.toggleSwitch = new ModuleToggleSwitch(160, 5, 0, "", (IToggleButton)this, zmaster587.libVulpes.inventory.TextureResources.buttonToggleImage, 11, 26, this.getMachineEnabled());
        modules.add((ModuleBase)this.toggleSwitch);
        modules.add((ModuleBase)new ModulePower(18, 20, (IUniversalEnergy)this.getBatteries()));
        modules.add((ModuleBase)this.sideSelectorModule);
        modules.add((ModuleBase)this.redstoneControl);
        modules.add((ModuleBase)new ModuleSlider(6, 120, 0, TextureResources.doubleWarningSideBarIndicator, (ISliderBar)this));
        modules.add((ModuleBase)new ModuleSlider(6, 90, 1, TextureResources.doubleWarningSideBarIndicator, (ISliderBar)this));
        modules.add((ModuleBase)new ModuleText(42, 20, "Target->\nDirection", 0x202020));
        modules.add((ModuleBase)this.targetGrav);
        modules.add((ModuleBase)this.textRadius);
        this.updateText();
        return modules;
    }

    public int getRadius() {
        return this.radius + 10;
    }

    protected boolean isStateActive(ZUtils.RedstoneState state, boolean condition) {
        if (state == ZUtils.RedstoneState.INVERTED) {
            return !condition;
        }
        if (state == ZUtils.RedstoneState.OFF) {
            return true;
        }
        return condition;
    }

    public double getArmRotation() {
        this.rotation = (this.rotation + (double)(10.0f * this.currentProgress)) % 360.0;
        return this.rotation;
    }

    public double getGravityMultiplier() {
        return this.currentProgress / 2.0f;
    }

    private void updateText() {
        if (this.field_145850_b.field_72995_K) {
            this.textRadius.setText(String.format("Radius: %d", this.getRadius()));
            this.targetGrav.setText(String.format("Target Gravity: %.2f/%d", Float.valueOf(this.currentProgress), this.gravity));
        }
    }

    public String getMachineName() {
        return this.getModularInventoryName();
    }

    public boolean isRunning() {
        return this.getMachineEnabled() && this.isStateActive(this.state, this.field_145850_b.func_175687_A(this.func_174877_v()) > 0);
    }

    public void func_73660_a() {
        if (this.timeAlive == 0) {
            SoundEvent str;
            if (!this.field_145850_b.field_72995_K) {
                if (this.isComplete()) {
                    this.canRender = this.completeStructure = this.completeStructure(this.field_145850_b.func_180495_p(this.field_174879_c));
                }
            } else if (this.field_145850_b.field_72995_K && (str = this.getSound()) != null) {
                this.playMachineSound(str);
            }
            this.timeAlive = 1;
        }
        if (this.isRunning()) {
            if (!this.field_145850_b.field_72995_K) {
                if (this.gravity == 0) {
                    this.gravity = 15;
                }
                double targetGravity = (double)this.gravity / 100.0;
                double angVel = this.currentProgress;
                double acc = 0.001;
                double difference = targetGravity - angVel;
                if (difference != 0.0) {
                    double finalVel = angVel;
                    if (difference < 0.0) {
                        finalVel = angVel + Math.max(difference, -acc);
                    } else if (difference > 0.0) {
                        finalVel = angVel + Math.min(difference, acc);
                    }
                    this.currentProgress = (float)finalVel;
                    this.func_70296_d();
                    this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
                }
            } else {
                this.updateText();
            }
            List entities = this.field_145850_b.func_72872_a(Entity.class, new AxisAlignedBB(this.func_174877_v()).func_72314_b((double)this.getRadius(), (double)this.getRadius(), (double)this.getRadius()));
            for (Entity e : entities) {
                boolean additive = true;
                boolean allowApply = false;
                e.field_70143_R = 0.0f;
                for (EnumFacing dir : EnumFacing.field_82609_l) {
                    if (e instanceof EntityPlayer && ((EntityPlayer)e).field_71075_bZ.field_75100_b || this.sideSelectorModule.getStateForSide(dir) == 0) continue;
                    allowApply = true;
                    if (this.sideSelectorModule.getStateForSide(dir) == 1) {
                        additive = false;
                    }
                    if (e instanceof EntityLivingBase) {
                        e.field_70159_w += (double)((float)dir.func_82601_c() * 0.075f * this.currentProgress);
                        e.field_70181_x += (double)((float)dir.func_96559_d() * 0.075f * this.currentProgress);
                        e.field_70179_y += (double)((float)dir.func_82599_e() * 0.075f * this.currentProgress);
                    } else if (e instanceof EntityItem || e instanceof EntityArrow) {
                        e.field_70159_w += (double)((float)dir.func_82601_c() * 0.04f * this.currentProgress);
                        e.field_70181_x += (double)((float)dir.func_96559_d() * 0.04f * this.currentProgress);
                        e.field_70179_y += (double)((float)dir.func_82599_e() * 0.04f * this.currentProgress);
                    }
                    if (!this.field_145850_b.field_72995_K || Minecraft.func_71410_x().field_71474_y.field_74362_aa != 0 || Minecraft.func_71410_x().field_71474_y.field_74320_O == 0 && Minecraft.func_71410_x().field_71439_g == e) continue;
                    AdvancedRocketry.proxy.spawnParticle("gravityEffect", this.field_145850_b, e.field_70165_t, e.field_70163_u, e.field_70161_v, 0.2f * (float)dir.func_82601_c() * this.currentProgress, 0.2f * (float)dir.func_96559_d() * this.currentProgress, 0.2f * (float)dir.func_82599_e() * this.currentProgress);
                }
                if (!allowApply || additive) continue;
                e.field_70181_x = e.field_70181_x + (e instanceof EntityItem || e instanceof EntityArrow ? (double)0.04f : 0.08000000298023224);
            }
        } else if (this.currentProgress > 0.0f) {
            this.currentProgress -= 0.01f;
            if (!this.field_145850_b.field_72995_K) {
                this.func_70296_d();
                this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
            } else {
                this.updateText();
            }
        } else {
            this.currentProgress = 0.0f;
        }
    }

    public boolean getMachineEnabled() {
        return super.getMachineEnabled();
    }

    public String getModularInventoryName() {
        return "tile.gravityMachine.name";
    }

    public boolean canInteractWithContainer(EntityPlayer entity) {
        return true;
    }

    public void writeDataToNetwork(ByteBuf out, byte id) {
        super.writeDataToNetwork(out, id);
        if (id == 3) {
            out.writeShort(this.progress);
            out.writeShort(this.radius);
        } else if (id == 4) {
            for (int i = 0; i < 6; ++i) {
                out.writeByte(this.sideSelectorModule.getStateForSide(i));
            }
        } else if (id == 5) {
            out.writeByte(this.state.ordinal());
        }
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        super.readDataFromNetwork(in, packetId, nbt);
        if (packetId == 3) {
            nbt.func_74777_a("progress", in.readShort());
            nbt.func_74777_a("radius", in.readShort());
        } else if (packetId == 4) {
            byte[] bytes = new byte[6];
            for (int i = 0; i < 6; ++i) {
                bytes[i] = in.readByte();
            }
            nbt.func_74773_a("bytes", bytes);
        } else if (packetId == 5) {
            nbt.func_74774_a("redstoneState", in.readByte());
        }
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        super.useNetworkData(player, side, id, nbt);
        if (id == 3) {
            this.setProgress(0, nbt.func_74765_d("progress"));
            this.setProgress(1, nbt.func_74765_d("radius"));
        } else if (id == 4) {
            byte[] bytes = nbt.func_74770_j("bytes");
            for (int i = 0; i < 6; ++i) {
                this.sideSelectorModule.setStateForSide(i, (int)bytes[i]);
            }
        } else if (id == 5) {
            this.state = ZUtils.RedstoneState.values()[nbt.func_74771_c("redstoneState")];
            this.redstoneControl.setRedstoneState(this.state);
        }
    }

    protected void writeNetworkData(NBTTagCompound nbt) {
        super.writeNetworkData(nbt);
        nbt.func_74777_a("gravity", (short)this.gravity);
        nbt.func_74776_a("currGravity", this.currentProgress);
        nbt.func_74774_a("redstoneState", (byte)this.state.ordinal());
        nbt.func_74777_a("radius", (short)this.radius);
        this.sideSelectorModule.writeToNBT(nbt);
    }

    protected void readNetworkData(NBTTagCompound nbt) {
        super.readNetworkData(nbt);
        this.gravity = nbt.func_74765_d("gravity");
        this.currentProgress = nbt.func_74760_g("currGravity");
        this.progress = this.gravity - 5;
        this.radius = nbt.func_74765_d("radius");
        this.sideSelectorModule.readFromNBT(nbt);
        this.state = ZUtils.RedstoneState.values()[nbt.func_74771_c("redstoneState")];
        this.redstoneControl.setRedstoneState(this.state);
    }

    public void onInventoryButtonPressed(int buttonId) {
        super.onInventoryButtonPressed(buttonId);
        if (buttonId == 1) {
            this.state = this.redstoneControl.getState();
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 5));
        }
    }

    public float getNormallizedProgress(int id) {
        return (float)this.getProgress(id) / (float)this.getTotalProgress(id);
    }

    public void setProgress(int id, int progress) {
        if (id == 0) {
            this.progress = progress;
            this.gravity = progress + 5;
        } else {
            this.radius = progress;
        }
    }

    public int getProgress(int id) {
        if (id == 0) {
            return this.progress;
        }
        return this.radius;
    }

    public int getTotalProgress(int id) {
        if (id == 0) {
            return 190;
        }
        return 22;
    }

    public void setTotalProgress(int id, int progress) {
    }

    public void setProgressByUser(int id, int progress) {
        this.setProgress(id, progress);
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 3));
    }

    public void onModuleUpdated(ModuleBase module) {
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 4));
    }
}

