/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.Satellite;

import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import zmaster587.advancedRocketry.api.DataStorage;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.inventory.modules.ModuleData;
import zmaster587.advancedRocketry.inventory.modules.ModuleSatellite;
import zmaster587.advancedRocketry.item.ItemData;
import zmaster587.advancedRocketry.item.ItemSatelliteIdentificationChip;
import zmaster587.advancedRocketry.satellite.SatelliteData;
import zmaster587.advancedRocketry.util.IDataInventory;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModulePower;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.TileInventoriedRFConsumer;
import zmaster587.libVulpes.util.INetworkMachine;

public class TileEntitySatelliteControlCenter
extends TileInventoriedRFConsumer
implements INetworkMachine,
IModularInventory,
IButtonInventory,
IDataInventory {
    ModuleSatellite moduleSatellite;
    ModuleText moduleText;
    DataStorage data = new DataStorage();

    public TileEntitySatelliteControlCenter() {
        super(10000, 2);
        this.data.setMaxData(1000);
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    public String getModularInventoryName() {
        return "container.satelliteMonitor";
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public boolean canPerformFunction() {
        return this.field_145850_b.func_82737_E() % 16L == 0L && this.getSatelliteFromSlot(0) != null;
    }

    public int getPowerPerOperation() {
        return 1;
    }

    public void performFunction() {
        if (this.field_145850_b.field_72995_K) {
            this.updateInventoryInfo();
        }
    }

    public void writeDataToNetwork(ByteBuf out, byte packetId) {
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        if (id == 0) {
            this.storeData(0);
        } else if (id == 100) {
            SatelliteBase satellite = this.moduleSatellite.getSatellite();
            if (satellite != null && satellite.getDimensionId() == DimensionManager.getEffectiveDimId(this.field_145850_b.field_73011_w.getDimension(), this.func_174877_v()).getId()) {
                satellite.performAction(player, this.field_145850_b, this.field_174879_c);
            }
        } else if (id == 101) {
            this.onInventoryButtonPressed(id - 100);
        }
    }

    public void func_70299_a(int slot, ItemStack stack) {
        super.func_70299_a(slot, stack);
        this.moduleSatellite.setSatellite(this.getSatelliteFromSlot(0));
        this.updateInventoryInfo();
    }

    public void updateInventoryInfo() {
        if (this.moduleText != null) {
            SatelliteBase satellite = this.moduleSatellite.getSatellite();
            if (satellite != null) {
                if (this.getEnergyStored() < this.getPowerPerOperation()) {
                    this.moduleText.setText("Not Enough power!");
                } else if (satellite.getDimensionId() != DimensionManager.getEffectiveDimId(this.field_145850_b, this.field_174879_c).getId()) {
                    this.moduleText.setText(satellite.getName() + "\n\nToo Far");
                } else {
                    this.moduleText.setText(satellite.getName() + "\n\nInfo:\n" + satellite.getInfo(this.field_145850_b));
                }
            } else {
                this.moduleText.setText("No Link...");
            }
        }
    }

    public SatelliteBase getSatelliteFromSlot(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null && stack.func_77973_b() instanceof ItemSatelliteIdentificationChip) {
            ItemSatelliteIdentificationChip idchip = (ItemSatelliteIdentificationChip)stack.func_77973_b();
            return idchip.getSatellite(stack);
        }
        return null;
    }

    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        modules.add((ModuleBase)new ModulePower(18, 20, (IUniversalEnergy)this.energy));
        modules.add((ModuleBase)new ModuleButton(116, 70, 0, "Connect!", (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonBuild));
        modules.add((ModuleBase)new ModuleButton(173, 3, 1, "", (IButtonInventory)this, TextureResources.buttonKill, "Destroy Satellite", 24, 24));
        modules.add(new ModuleData(28, 20, 1, this, this.data));
        this.moduleSatellite = new ModuleSatellite(152, 10, this, 0);
        modules.add((ModuleBase)this.moduleSatellite);
        this.moduleSatellite.setSatellite(this.getSatelliteFromSlot(0));
        this.moduleText = new ModuleText(60, 20, "No Link...", 0x404040);
        modules.add((ModuleBase)this.moduleText);
        this.updateInventoryInfo();
        return modules;
    }

    public void onInventoryButtonPressed(int buttonId) {
        ItemStack stack;
        if (buttonId == 0) {
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, (byte)(100 + buttonId)));
        } else if (buttonId == 1 && (stack = this.func_70301_a(0)) != null && stack.func_77973_b() instanceof ItemSatelliteIdentificationChip) {
            ItemSatelliteIdentificationChip idchip = (ItemSatelliteIdentificationChip)stack.func_77973_b();
            SatelliteBase satellite = idchip.getSatellite(stack);
            if (satellite != null) {
                DimensionManager.getInstance().getDimensionProperties(satellite.getDimensionId()).removeSatellite(satellite.getId());
            }
            idchip.erase(stack);
            this.func_70299_a(0, stack);
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, (byte)(100 + buttonId)));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        NBTTagCompound data = new NBTTagCompound();
        this.data.writeToNBT(data);
        nbt.func_74782_a("data", (NBTBase)data);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagCompound data = nbt.func_74775_l("data");
        this.data.readFromNBT(data);
    }

    @Override
    public void loadData(int id) {
    }

    @Override
    public void storeData(int id) {
        if (!this.field_145850_b.field_72995_K) {
            ItemStack inv = this.func_70301_a(1);
            if (inv != null && inv.func_77973_b() instanceof ItemData && inv.field_77994_a == 1) {
                ItemData dataItem = (ItemData)inv.func_77973_b();
                this.data.removeData(dataItem.addData(inv, this.data.getData(), this.data.getDataType()), true);
            }
        } else {
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 0));
        }
    }

    @Override
    public int extractData(int maxAmount, DataStorage.DataType type, EnumFacing dir, boolean commit) {
        if (type == this.data.getDataType() || this.data.getDataType() == DataStorage.DataType.UNDEFINED) {
            SatelliteBase satellite = this.getSatelliteFromSlot(0);
            if (satellite != null && satellite instanceof SatelliteData && satellite.getDimensionId() == this.field_145850_b.field_73011_w.getDimension()) {
                satellite.performAction(null, this.field_145850_b, this.field_174879_c);
            }
            return this.data.removeData(maxAmount, commit);
        }
        return 0;
    }

    @Override
    public int addData(int maxAmount, DataStorage.DataType type, EnumFacing dir, boolean commit) {
        return this.data.addData(maxAmount, type, commit);
    }

    public boolean canInteractWithContainer(EntityPlayer entity) {
        return true;
    }
}

