/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.item;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.item.ItemIdWithName;

public class ItemPlanetIdentificationChip
extends ItemIdWithName {
    private static final String dimensionNameIdentifier = "DimensionName";
    private static final String dimensionIdIdentifier = "dimId";
    private static final String uuidIdentifier = "UUID";

    public boolean func_77645_m() {
        return false;
    }

    public DimensionProperties getDimension(ItemStack stack) {
        if (stack.func_77942_o()) {
            return DimensionManager.getInstance().getDimensionProperties(stack.func_77978_p().func_74762_e(dimensionIdIdentifier));
        }
        return null;
    }

    public boolean hasValidDimension(ItemStack stack) {
        if (stack.func_77942_o()) {
            int dimId = stack.func_77978_p().func_74762_e(dimensionIdIdentifier);
            return dimId == 0 || DimensionManager.getInstance().isDimensionCreated(dimId);
        }
        return false;
    }

    public void erase(ItemStack stack) {
        stack.func_77982_d(null);
    }

    public void setDimensionId(ItemStack stack, int dimensionId) {
        if (dimensionId == -1) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a(dimensionIdIdentifier, dimensionId);
            return;
        }
        DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties(dimensionId);
        if (properties == null) {
            this.erase(stack);
            return;
        }
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        nbt.func_74768_a(dimensionIdIdentifier, dimensionId);
        nbt.func_74778_a(dimensionNameIdentifier, properties.getName());
        stack.func_77982_d(nbt);
    }

    public int getDimensionId(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e(dimensionIdIdentifier);
        }
        return -1;
    }

    public DimensionProperties getDimensionProperties(ItemStack stack) {
        if (stack.func_77942_o()) {
            return DimensionManager.getInstance().getDimensionProperties(stack.func_77978_p().func_74762_e(dimensionIdIdentifier));
        }
        return null;
    }

    public Long getUUID(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74763_f(uuidIdentifier);
        }
        return null;
    }

    public void setUUID(ItemStack stack, long uuid) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        nbt.func_74772_a(uuidIdentifier, uuid);
        stack.func_77982_d(nbt);
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        if (!stack.func_77942_o()) {
            list.add("Unprogrammed");
        } else if (!this.hasValidDimension(stack)) {
            list.add(ChatFormatting.RED + "Programming Failed");
        } else if (stack.func_77952_i() == 0) {
            DimensionProperties props = DimensionManager.getInstance().getDimensionProperties(this.getDimensionId(stack));
            String unknown = ChatFormatting.YELLOW + "???";
            String dimName = stack.func_77978_p().func_74779_i(dimensionNameIdentifier);
            list.add("Planet Name: " + ChatFormatting.DARK_GREEN + dimName);
            if (!props.getRequiredArtifacts().isEmpty()) {
                list.add("Artifacts:");
                for (ItemStack stack2 : props.getRequiredArtifacts()) {
                    list.add(ChatFormatting.DARK_PURPLE + "    " + stack2.func_82833_r());
                }
            }
        } else {
            list.add("Station Id: " + ChatFormatting.DARK_GREEN + stack.func_77978_p().func_74779_i(dimensionNameIdentifier));
        }
    }
}

