/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.entity;

import io.netty.buffer.ByteBuf;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.achievements.ARAchivements;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.api.Configuration;
import zmaster587.advancedRocketry.api.EntityRocketBase;
import zmaster587.advancedRocketry.api.IInfrastructure;
import zmaster587.advancedRocketry.api.RocketEvent;
import zmaster587.advancedRocketry.api.SatelliteRegistry;
import zmaster587.advancedRocketry.api.StatsRocket;
import zmaster587.advancedRocketry.api.dimension.IDimensionProperties;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.api.fuel.FuelRegistry;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.atmosphere.AtmosphereHandler;
import zmaster587.advancedRocketry.client.SoundRocketEngine;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.event.PlanetEventHandler;
import zmaster587.advancedRocketry.inventory.IPlanetDefiner;
import zmaster587.advancedRocketry.inventory.modules.ModulePlanetSelector;
import zmaster587.advancedRocketry.inventory.modules.ModuleStellarBackground;
import zmaster587.advancedRocketry.item.ItemAsteroidChip;
import zmaster587.advancedRocketry.item.ItemPackedStructure;
import zmaster587.advancedRocketry.item.ItemPlanetIdentificationChip;
import zmaster587.advancedRocketry.item.ItemStationChip;
import zmaster587.advancedRocketry.mission.MissionOreMining;
import zmaster587.advancedRocketry.network.PacketSatellite;
import zmaster587.advancedRocketry.stations.SpaceObject;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.tile.TileGuidanceComputer;
import zmaster587.advancedRocketry.tile.hatch.TileSatelliteHatch;
import zmaster587.advancedRocketry.util.AsteroidSmall;
import zmaster587.advancedRocketry.util.AudioRegistry;
import zmaster587.advancedRocketry.util.RocketInventoryHelper;
import zmaster587.advancedRocketry.util.StationLandingLocation;
import zmaster587.advancedRocketry.util.StorageChunk;
import zmaster587.advancedRocketry.util.TransitionEntity;
import zmaster587.advancedRocketry.world.util.TeleporterNoPortal;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.client.util.ProgressBarImage;
import zmaster587.libVulpes.gui.CommonResources;
import zmaster587.libVulpes.interfaces.INetworkEntity;
import zmaster587.libVulpes.inventory.GuiHandler;
import zmaster587.libVulpes.inventory.TextureResources;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.IProgressBar;
import zmaster587.libVulpes.inventory.modules.ISelectionNotify;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleContainerPan;
import zmaster587.libVulpes.inventory.modules.ModuleImage;
import zmaster587.libVulpes.inventory.modules.ModuleProgress;
import zmaster587.libVulpes.inventory.modules.ModuleSlotButton;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.items.ItemLinker;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketEntity;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.IconResource;
import zmaster587.libVulpes.util.Vector3F;

public class EntityRocket
extends EntityRocketBase
implements INetworkEntity,
IModularInventory,
IProgressBar,
IButtonInventory,
ISelectionNotify,
IPlanetDefiner {
    private boolean isInOrbit = false;
    private boolean isInFlight;
    private int lastDimensionFrom = 0;
    public StorageChunk storage;
    private String errorStr;
    private long lastErrorTime = Long.MIN_VALUE;
    private static long ERROR_DISPLAY_TIME = 100L;
    private static int DESCENT_TIMER = 500;
    private static int BUTTON_ID_OFFSET = 25;
    private static final int STATION_LOC_OFFSET = 50;
    private ModuleText landingPadDisplayText;
    protected long lastWorldTickTicked;
    private SatelliteBase satallite;
    protected int destinationDimId;
    private int tilebuttonOffset = 3;
    private int autoDescendTimer;
    private WeakReference<Entity>[] mountedEntities;
    protected ModulePlanetSelector container;
    boolean acceptedPacket = false;
    private static final DataParameter<Integer> fuelLevel = EntityDataManager.func_187226_a(EntityRocket.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> INFLIGHT = EntityDataManager.func_187226_a(EntityRocket.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> INORBIT = EntityDataManager.func_187226_a(EntityRocket.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityRocket(World p_i1582_1_) {
        super(p_i1582_1_);
        this.stats = new StatsRocket();
        this.isInFlight = false;
        this.connectedInfrastructure = new LinkedList();
        this.infrastructureCoords = new LinkedList();
        this.mountedEntities = new WeakReference[this.stats.getNumPassengerSeats()];
        this.lastWorldTickTicked = p_i1582_1_.func_82737_E();
        this.autoDescendTimer = 5000;
        this.landingPadDisplayText = new ModuleText(256, 16, "", 65280, 2.0f);
        this.landingPadDisplayText.setColor(65280);
    }

    public EntityRocket(World world, StorageChunk storage, StatsRocket stats, double x, double y, double z) {
        this(world);
        this.stats = stats;
        this.func_70107_b(x, y, z);
        this.storage = storage;
        this.storage.setEntity(this);
        this.initFromBounds();
        this.isInFlight = false;
        this.mountedEntities = new WeakReference[stats.getNumPassengerSeats()];
        this.lastWorldTickTicked = world.func_82737_E();
        this.autoDescendTimer = 5000;
        this.landingPadDisplayText = new ModuleText(256, 16, "", 65280, 2.0f);
        this.landingPadDisplayText.setColor(65280);
    }

    public AxisAlignedBB func_174813_aQ() {
        if (this.storage != null) {
            return super.func_174813_aQ();
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public void func_174826_a(AxisAlignedBB bb) {
        super.func_174826_a(bb);
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    @Override
    public int getFuelAmount() {
        int amount = (Integer)this.field_70180_af.func_187225_a(fuelLevel);
        this.stats.setFuelAmount(FuelRegistry.FuelType.LIQUID, amount);
        return amount;
    }

    @Override
    public int addFuelAmount(int amount) {
        int ret = this.stats.addFuelAmount(FuelRegistry.FuelType.LIQUID, amount);
        this.setFuelAmount(this.stats.getFuelAmount(FuelRegistry.FuelType.LIQUID));
        return ret;
    }

    public void disconnectInfrastructure(IInfrastructure infrastructure) {
        infrastructure.unlinkRocket();
        this.infrastructureCoords.remove(new HashedBlockPosition(((TileEntity)infrastructure).func_174877_v()));
        if (!this.field_70170_p.field_72995_K) {
            int[] pos = new int[]{((TileEntity)infrastructure).func_174877_v().func_177958_n(), ((TileEntity)infrastructure).func_174877_v().func_177956_o(), ((TileEntity)infrastructure).func_174877_v().func_177952_p()};
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74783_a("pos", pos);
        }
    }

    @Override
    public void linkInfrastructure(IInfrastructure tile) {
        super.linkInfrastructure(tile);
        HashedBlockPosition pos = new HashedBlockPosition(((TileEntity)tile).func_174877_v());
        if (tile instanceof TileEntity && !this.infrastructureCoords.contains(pos)) {
            this.infrastructureCoords.add(pos);
        }
    }

    @Override
    public String getTextOverlay() {
        if (this.field_70170_p.func_82737_E() < this.lastErrorTime + ERROR_DISPLAY_TIME) {
            return this.errorStr;
        }
        String displayStr = "N/A";
        if (this.storage != null) {
            int dimid = this.storage.getDestinationDimId(this.field_70170_p.field_73011_w.getDimension(), (int)this.field_70165_t, (int)this.field_70161_v);
            if (dimid == Configuration.spaceDimId) {
                ISpaceObject obj;
                Vector3F<Float> vec = this.storage.getDestinationCoordinates(dimid, false);
                if (vec != null && (obj = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(new BlockPos((double)((Float)vec.x).floatValue(), (double)((Float)vec.y).floatValue(), (double)((Float)vec.z).floatValue()))) != null) {
                    displayStr = "Station " + obj.getId();
                    StationLandingLocation location = this.storage.getGuidanceComputer().getLandingLocation(obj.getId());
                    if (location != null) {
                        displayStr = displayStr + "\nPad: " + location;
                    }
                }
            } else if (dimid != -1 && dimid != Integer.MIN_VALUE) {
                displayStr = zmaster587.advancedRocketry.dimension.DimensionManager.getInstance().getDimensionProperties(dimid).getName();
            }
        }
        if (this.isInOrbit() && !this.isInFlight()) {
            return "Press Space to descend!\n  Auto descend in " + (DESCENT_TIMER - this.field_70173_aa) / 20;
        }
        if (!this.isInFlight()) {
            return "Press Space to take off!\nDest: " + displayStr;
        }
        return super.getTextOverlay();
    }

    private void setError(String error) {
        this.errorStr = error;
        this.lastErrorTime = this.field_70170_p.func_82737_E();
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
        if (this.storage != null) {
            float sizeX = (float)this.storage.getSizeX() / 2.0f;
            float sizeY = this.storage.getSizeY();
            float sizeZ = (float)this.storage.getSizeZ() / 2.0f;
            this.func_174826_a(new AxisAlignedBB(x - (double)sizeX, y - this.func_70033_W(), z - (double)sizeZ, x + (double)sizeX, y + (double)sizeY - this.func_70033_W(), z + (double)sizeZ));
        }
    }

    public void setFuelAmount(int amt) {
        this.field_70180_af.func_187227_b(fuelLevel, (Object)amt);
        this.field_70180_af.func_187217_b(fuelLevel);
    }

    @Override
    public int getFuelCapacity() {
        return this.stats.getFuelCapacity(FuelRegistry.FuelType.LIQUID);
    }

    public void func_145769_d(int id) {
        super.func_145769_d(id);
        if (this.field_70170_p.field_72995_K) {
            PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.REQUESTNBT.ordinal()));
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean isInFlight() {
        if (!this.field_70170_p.field_72995_K) {
            return this.isInFlight;
        }
        return (Boolean)this.field_70180_af.func_187225_a(INFLIGHT);
    }

    public void setInOrbit(boolean inOrbit) {
        this.isInOrbit = inOrbit;
        this.field_70180_af.func_187227_b(INORBIT, (Object)inOrbit);
        this.field_70180_af.func_187217_b(INORBIT);
    }

    public boolean isInOrbit() {
        if (!this.field_70170_p.field_72995_K) {
            return this.isInOrbit;
        }
        return (Boolean)this.field_70180_af.func_187225_a(INORBIT);
    }

    public void setInFlight(boolean inflight) {
        this.isInFlight = inflight;
        this.field_70180_af.func_187227_b(INFLIGHT, (Object)inflight);
        this.field_70180_af.func_187217_b(INFLIGHT);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(INFLIGHT, (Object)false);
        this.field_70180_af.func_187214_a(fuelLevel, (Object)0);
        this.field_70180_af.func_187214_a(INORBIT, (Object)false);
    }

    public void initFromBounds() {
        if (this.storage != null) {
            this.func_70105_a(Math.max(this.storage.getSizeX(), this.storage.getSizeZ()), this.storage.getSizeY());
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    protected boolean interact(EntityPlayer player) {
        block25: {
            FluidStack fluidStack;
            float fuelMult;
            ItemStack heldItem;
            block26: {
                float f;
                heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
                if (heldItem == null) break block25;
                if (heldItem.func_77973_b() instanceof ItemLinker) {
                    if (ItemLinker.isSet((ItemStack)heldItem)) {
                        TileEntity tile = this.field_70170_p.func_175625_s(ItemLinker.getMasterCoords((ItemStack)heldItem));
                        if (tile instanceof IInfrastructure) {
                            IInfrastructure infrastructure = (IInfrastructure)tile;
                            if (this.func_70011_f(ItemLinker.getMasterX((ItemStack)heldItem), this.field_70163_u, ItemLinker.getMasterZ((ItemStack)heldItem)) < (double)(infrastructure.getMaxLinkDistance() + Math.max(this.storage.getSizeX(), this.storage.getSizeZ()))) {
                                if (!this.connectedInfrastructure.contains(tile)) {
                                    this.linkInfrastructure(infrastructure);
                                    if (!this.field_70170_p.field_72995_K) {
                                        player.func_145747_a((ITextComponent)new TextComponentString("Linked Sucessfully"));
                                    }
                                    ItemLinker.resetPosition((ItemStack)heldItem);
                                    return true;
                                }
                                if (!this.field_70170_p.field_72995_K) {
                                    player.func_145747_a((ITextComponent)new TextComponentString("Already linked!"));
                                }
                            } else if (!this.field_70170_p.field_72995_K) {
                                player.func_145747_a((ITextComponent)new TextComponentString("The object you are trying to link is too far away"));
                            }
                        } else if (!this.field_70170_p.field_72995_K) {
                            player.func_145747_a((ITextComponent)new TextComponentString("This cannot be linked to a rocket!"));
                        }
                    } else if (!this.field_70170_p.field_72995_K) {
                        player.func_145747_a((ITextComponent)new TextComponentString("Nothing to be linked"));
                    }
                    return false;
                }
                if (FluidContainerRegistry.isFilledContainer((ItemStack)heldItem) && (fuelMult = FuelRegistry.instance.getMultiplier(FuelRegistry.FuelType.LIQUID, (fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)heldItem)).getFluid())) > 0.0f) break block26;
                if (!(heldItem.func_77973_b() instanceof IFluidContainerItem) || ((IFluidContainerItem)heldItem.func_77973_b()).getFluid(heldItem) == null || ((IFluidContainerItem)heldItem.func_77973_b()).getFluid((ItemStack)heldItem).amount < 1000) break block25;
                fluidStack = ((IFluidContainerItem)heldItem.func_77973_b()).getFluid(heldItem);
                fuelMult = FuelRegistry.instance.getMultiplier(FuelRegistry.FuelType.LIQUID, fluidStack.getFluid());
                if (!(f > 0.0f)) break block25;
            }
            int amountToAdd = (int)(fuelMult * (float)fluidStack.amount);
            this.addFuelAmount(amountToAdd);
            if (!player.field_71075_bZ.field_75098_d) {
                if (heldItem.func_77973_b() instanceof IFluidContainerItem) {
                    ((IFluidContainerItem)heldItem.func_77973_b()).drain(heldItem, 1000, true);
                } else {
                    ItemStack emptyStack = FluidContainerRegistry.drainFluidContainer((ItemStack)player.func_184586_b(EnumHand.MAIN_HAND));
                    if (player.field_71071_by.func_70441_a(emptyStack)) {
                        player.func_184586_b(EnumHand.MAIN_HAND).func_77979_a(1);
                        if (player.func_184586_b((EnumHand)EnumHand.MAIN_HAND).field_77994_a == 0) {
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                        }
                    }
                }
            }
            return true;
        }
        if (player.func_70093_af()) {
            this.openGui(player);
        } else if (this.stats.hasSeat() && this.stats.hasSeat() && this.func_184188_bt().isEmpty() && !this.field_70170_p.field_72995_K) {
            player.func_184220_m((Entity)this);
        }
        return true;
    }

    public void openGui(EntityPlayer player) {
        player.openGui((Object)LibVulpes.instance, GuiHandler.guiId.MODULAR.ordinal(), player.field_70170_p, this.func_145782_y(), -1, 0);
        if (!this.field_70170_p.field_72995_K) {
            RocketInventoryHelper.addPlayerToInventoryBypass(player);
        }
    }

    public boolean func_184230_a(EntityPlayer player, @Nullable ItemStack stack, EnumHand hand) {
        if (this.field_70170_p.field_72995_K) {
            PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.SENDINTERACT.ordinal()));
            return this.interact(player);
        }
        return true;
    }

    public boolean isBurningFuel() {
        return (this.getFuelAmount() > 0 || !Configuration.rocketRequireFuel) && (!this.func_184188_bt().isEmpty() && this.getPassengerMovingForward() > 0.0f || !this.isInOrbit());
    }

    public float getPassengerMovingForward() {
        for (Entity entity : this.func_184188_bt()) {
            if (!(entity instanceof EntityPlayer)) continue;
            return ((EntityPlayer)entity).field_70701_bs;
        }
        return 0.0f;
    }

    private boolean hasHumanPassenger() {
        for (Entity entity : this.func_184188_bt()) {
            if (!(entity instanceof EntityPlayer)) continue;
            return true;
        }
        return false;
    }

    public boolean isDescentPhase() {
        return Configuration.automaticRetroRockets && this.isInOrbit() && this.field_70163_u < 300.0 && (this.field_70181_x < (double)-0.4f || this.field_70170_p.field_72995_K);
    }

    public boolean areEnginesRunning() {
        return this.field_70181_x > 0.0 || this.isDescentPhase() || this.getPassengerMovingForward() > 0.0f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        long deltaTime = this.field_70170_p.func_82737_E() - this.lastWorldTickTicked;
        this.lastWorldTickTicked = this.field_70170_p.func_82737_E();
        if (this.field_70173_aa == 20) {
            Iterator itr = new LinkedList(this.infrastructureCoords).listIterator();
            while (itr.hasNext()) {
                HashedBlockPosition temp = (HashedBlockPosition)itr.next();
                TileEntity tile = this.field_70170_p.func_175625_s(new BlockPos(temp.x, (int)temp.y, temp.z));
                if (!(tile instanceof IInfrastructure)) continue;
                this.linkInfrastructure((IInfrastructure)tile);
            }
            if (this.field_70170_p.field_72995_K) {
                LibVulpes.proxy.playSound((Object)new SoundRocketEngine(AudioRegistry.combustionRocket, SoundCategory.NEUTRAL, this));
            }
        }
        if (this.field_70173_aa > DESCENT_TIMER && this.isInOrbit() && !this.isInFlight()) {
            this.setInFlight(true);
        }
        if (!this.field_70170_p.field_72995_K && (this.isInFlight() || this.isInOrbit()) && this.field_70173_aa == 20) {
            MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketDeOrbitingEvent(this));
            PacketHandler.sendToNearby((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.ROCKETLANDEVENT.ordinal()), (int)this.field_70170_p.field_73011_w.getDimension(), (int)((int)this.field_70165_t), (int)((int)this.field_70163_u), (int)((int)this.field_70161_v), (double)64.0);
            for (Entity riddenByEntity : this.func_184188_bt()) {
                EntityPlayer player;
                if (!(riddenByEntity instanceof EntityPlayer) || !((player = (EntityPlayer)riddenByEntity) instanceof EntityPlayer)) continue;
                PacketHandler.sendToPlayer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.FORCEMOUNT.ordinal()), (EntityPlayer)player);
            }
        }
        if (this.isInFlight()) {
            boolean burningFuel = this.isBurningFuel();
            boolean descentPhase = this.isDescentPhase();
            if (burningFuel || descentPhase) {
                if (!this.field_70170_p.field_72995_K && !descentPhase) {
                    this.setFuelAmount((int)((float)this.getFuelAmount() - (float)this.stats.getFuelRate(FuelRegistry.FuelType.LIQUID) * (Configuration.gravityAffectsFuel ? zmaster587.advancedRocketry.dimension.DimensionManager.getInstance().getDimensionProperties(this.field_70170_p.field_73011_w.getDimension()).getGravitationalMultiplier() : 1.0f)));
                }
                int engineNum = 0;
                if (this.field_70170_p.field_72995_K && Minecraft.func_71410_x().field_71474_y.field_74362_aa < 2 && this.areEnginesRunning()) {
                    for (Vector3F<Float> vec : this.stats.getEngineLocations()) {
                        AtmosphereHandler handler;
                        if (Minecraft.func_71410_x().field_71474_y.field_74362_aa < 1 && this.field_70170_p.func_82737_E() % 10L == 0L && (engineNum < 8 || this.field_70170_p.func_82737_E() / 10L % (long)Math.max(this.stats.getEngineLocations().size() / 8, 1) == (long)(engineNum / 8)) && ((handler = AtmosphereHandler.getOxygenHandler(this.field_70170_p.field_73011_w.getDimension())) == null || handler.getAtmosphereType(this) != null && handler.getAtmosphereType(this).allowsCombustion())) {
                            AdvancedRocketry.proxy.spawnParticle("rocketSmoke", this.field_70170_p, this.field_70165_t + (double)((Float)vec.x).floatValue(), this.field_70163_u + (double)((Float)vec.y).floatValue() - 0.75, this.field_70161_v + (double)((Float)vec.z).floatValue(), 0.0, 0.0, 0.0);
                        }
                        for (int i = 0; i < 4; ++i) {
                            AdvancedRocketry.proxy.spawnParticle("rocketFlame", this.field_70170_p, this.field_70165_t + (double)((Float)vec.x).floatValue(), this.field_70163_u + (double)((Float)vec.y).floatValue() - 0.75, this.field_70161_v + (double)((Float)vec.z).floatValue(), (this.field_70146_Z.nextFloat() - 0.5f) / 8.0f, -0.75, (this.field_70146_Z.nextFloat() - 0.5f) / 8.0f);
                        }
                    }
                }
            }
            if (!this.func_184188_bt().isEmpty()) {
                for (Entity entity : this.func_184188_bt()) {
                    entity.field_70143_R = 0.0f;
                    this.field_70143_R = 0.0f;
                }
                if (this.isInOrbit() && (burningFuel || descentPhase)) {
                    float vel = descentPhase ? 1.0f : this.getPassengerMovingForward();
                    this.field_70181_x -= this.field_70181_x * (double)vel / 50.0;
                }
                this.field_70133_I = true;
            } else if (this.isInOrbit() && descentPhase) {
                this.field_70181_x -= this.field_70181_x / 50.0;
                this.field_70133_I = true;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.field_70181_x = this.isInOrbit() || !burningFuel ? Math.min(this.field_70181_x - 0.001, 1.0) : (this.field_70181_x += (double)(this.stats.getAcceleration() * (float)deltaTime));
                double lastPosY = this.field_70163_u;
                double prevMotion = this.field_70181_x;
                this.func_70091_d(0.0, prevMotion * (double)deltaTime, 0.0);
                if ((this.isInOrbit() || !burningFuel) && this.isInFlight() && lastPosY + prevMotion != this.field_70163_u && this.field_70163_u < 256.0) {
                    MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketLandedEvent(this));
                    this.setInFlight(false);
                    this.setInOrbit(false);
                }
                if (!this.isInOrbit() && this.field_70163_u > (double)Configuration.orbit) {
                    this.onOrbitReached();
                }
                if (this.field_70163_u < 0.0) {
                    int dimId = this.field_70170_p.field_73011_w.getDimension();
                    if (dimId == Configuration.spaceDimId) {
                        ISpaceObject obj = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.func_180425_c());
                        if (obj != null) {
                            int targetDimID = obj.getOrbitingPlanetId();
                            Vector3F<Float> pos = this.storage.getDestinationCoordinates(targetDimID, true);
                            if (pos != null) {
                                this.setInOrbit(true);
                                this.setInFlight(false);
                                this.changeDimension(targetDimID, ((Float)pos.x).floatValue(), Configuration.orbit, ((Float)pos.z).floatValue());
                            } else {
                                this.func_70106_y();
                            }
                        } else {
                            Vector3F<Float> pos = this.storage.getDestinationCoordinates(0, true);
                            if (pos != null) {
                                this.setInOrbit(true);
                                this.setInFlight(false);
                                this.changeDimension(this.lastDimensionFrom, ((Float)pos.x).floatValue(), Configuration.orbit, ((Float)pos.z).floatValue());
                            } else {
                                this.func_70106_y();
                            }
                        }
                    } else {
                        this.func_70106_y();
                    }
                }
            } else {
                this.func_70091_d(0.0, this.field_70181_x, 0.0);
            }
        }
    }

    public List<SatelliteBase> getSatellites() {
        ArrayList<SatelliteBase> satellites = new ArrayList<SatelliteBase>();
        for (TileSatelliteHatch tile : this.storage.getSatelliteHatches()) {
            SatelliteBase satellite = tile.getSatellite();
            if (satellite == null) continue;
            satellites.add(satellite);
        }
        return satellites;
    }

    @Override
    public void onOrbitReached() {
        long targetSatellite;
        super.onOrbitReached();
        if (this.storage.getGuidanceComputer() != null && (targetSatellite = this.storage.getGuidanceComputer().getTargetSatellite()) != -1L) {
            SatelliteBase sat = zmaster587.advancedRocketry.dimension.DimensionManager.getInstance().getSatellite(targetSatellite);
            for (TileEntity tile : this.storage.getTileEntityList()) {
                if (!(tile instanceof TileSatelliteHatch) || ((IInventory)tile).func_70301_a(0) != null) continue;
                ((IInventory)tile).func_70299_a(0, sat.getItemStackFromSatellite());
                zmaster587.advancedRocketry.dimension.DimensionManager.getInstance().getDimensionProperties(sat.getDimensionId()).removeSatellite(targetSatellite);
                break;
            }
            this.field_70181_x = -this.field_70181_x;
            this.setInOrbit(true);
        } else if (!this.stats.hasSeat()) {
            TileGuidanceComputer computer = this.storage.getGuidanceComputer();
            if (computer != null && computer.func_70301_a(0) != null && computer.func_70301_a(0).func_77973_b() instanceof ItemAsteroidChip) {
                float drillingPower = this.stats.getDrillingPower();
                float asteroidDrillingMult = 1.0f;
                ItemStack stack = this.storage.getGuidanceComputer().func_70301_a(0);
                AsteroidSmall asteroid = Configuration.asteroidTypes.get(((ItemAsteroidChip)stack.func_77973_b()).getType(stack));
                if (asteroid != null) {
                    asteroidDrillingMult = asteroid.timeMultiplier;
                }
                MissionOreMining miningMission = new MissionOreMining((long)((double)asteroidDrillingMult * Configuration.asteroidMiningTimeMult * (double)(drillingPower == 0.0f ? 36000.0f : 360.0f / this.stats.getDrillingPower())), this, this.connectedInfrastructure);
                DimensionProperties properties = zmaster587.advancedRocketry.dimension.DimensionManager.getInstance().getDimensionProperties(this.field_70170_p.field_73011_w.getDimension());
                miningMission.setDimensionId(this.field_70170_p);
                properties.addSatallite(miningMission, this.field_70170_p);
                if (!this.field_70170_p.field_72995_K) {
                    PacketHandler.sendToAll((BasePacket)new PacketSatellite(miningMission));
                }
                for (IInfrastructure i : this.connectedInfrastructure) {
                    i.linkMission(miningMission);
                }
                this.func_70106_y();
            } else {
                this.unpackSatellites();
            }
            this.destinationDimId = this.storage.getDestinationDimId(this.field_70170_p.field_73011_w.getDimension(), (int)this.field_70165_t, (int)this.field_70161_v);
            if (zmaster587.advancedRocketry.dimension.DimensionManager.getInstance().canTravelTo(this.destinationDimId)) {
                Vector3F<Float> pos = this.storage.getDestinationCoordinates(this.destinationDimId, true);
                this.storage.setDestinationCoordinates((Vector3F<Float>)new Vector3F((Object)Float.valueOf((float)this.field_70165_t), (Object)Float.valueOf((float)this.field_70163_u), (Object)Float.valueOf((float)this.field_70161_v)), this.field_70170_p.field_73011_w.getDimension());
                if (pos != null) {
                    this.setInOrbit(true);
                    this.field_70181_x = -this.field_70181_x;
                    this.changeDimension(this.destinationDimId, ((Float)pos.x).floatValue(), Configuration.orbit, ((Float)pos.z).floatValue());
                    return;
                }
            } else {
                int offX = this.field_70170_p.field_73012_v.nextInt() % 256 - 128;
                int offZ = this.field_70170_p.field_73012_v.nextInt() % 256 - 128;
                this.setInOrbit(true);
                this.field_70181_x = -this.field_70181_x;
                this.func_70107_b(this.field_70165_t + (double)offX, this.field_70163_u, this.field_70161_v + (double)offZ);
            }
        } else {
            this.unpackSatellites();
            this.field_70181_x = -this.field_70181_x;
            this.setInOrbit(true);
            if (this.destinationDimId == Configuration.spaceDimId || this.field_70170_p.field_73011_w.getDimension() == Configuration.spaceDimId) {
                Vector3F<Float> pos = this.storage.getDestinationCoordinates(this.destinationDimId, true);
                this.storage.setDestinationCoordinates((Vector3F<Float>)new Vector3F((Object)Float.valueOf((float)this.field_70165_t), (Object)Float.valueOf((float)this.field_70163_u), (Object)Float.valueOf((float)this.field_70161_v)), this.field_70170_p.field_73011_w.getDimension());
                if (pos != null) {
                    if (this.hasHumanPassenger()) {
                        this.setInFlight(false);
                        pos.y = Float.valueOf(Configuration.orbit);
                    }
                    this.changeDimension(this.destinationDimId, ((Float)pos.x).floatValue(), ((Float)pos.y).floatValue(), ((Float)pos.z).floatValue());
                    return;
                }
            }
            if (this.hasHumanPassenger()) {
                this.setInFlight(false);
                if (zmaster587.advancedRocketry.dimension.DimensionManager.getInstance().getDimensionProperties(this.destinationDimId).getName().equals("Luna")) {
                    for (Entity player : this.func_184188_bt()) {
                        if (!(player instanceof EntityPlayer)) continue;
                        ((EntityPlayer)player).func_71029_a((StatBase)ARAchivements.moonLanding);
                        if (zmaster587.advancedRocketry.dimension.DimensionManager.hasReachedMoon) continue;
                        ((EntityPlayer)player).func_71029_a((StatBase)ARAchivements.oneSmallStep);
                    }
                    zmaster587.advancedRocketry.dimension.DimensionManager.hasReachedMoon = true;
                }
            } else {
                this.func_70107_b(this.field_70165_t, Configuration.orbit, this.field_70161_v);
            }
            if (this.destinationDimId != this.field_70170_p.field_73011_w.getDimension()) {
                this.func_184204_a(this.field_70170_p.field_73011_w.getDimension() == this.destinationDimId ? 0 : this.destinationDimId);
            }
        }
    }

    private void unpackSatellites() {
        List<TileSatelliteHatch> satelliteHatches = this.storage.getSatelliteHatches();
        for (TileSatelliteHatch tile : satelliteHatches) {
            SatelliteBase satellite = tile.getSatellite();
            if (satellite == null) {
                ItemStack stack = tile.func_70301_a(0);
                if (stack == null || stack.func_77973_b() != AdvancedRocketryItems.itemSpaceStation) continue;
                StorageChunk storage = ((ItemPackedStructure)stack.func_77973_b()).getStructure(stack);
                ISpaceObject object = SpaceObjectManager.getSpaceManager().getSpaceStation(ItemStationChip.getUUID(stack));
                if (object == null) {
                    tile.func_70299_a(0, null);
                    continue;
                }
                SpaceObjectManager.getSpaceManager().moveStationToBody(object, this.field_70170_p.field_73011_w.getDimension());
                object.onModuleUnpack(storage);
                tile.func_70299_a(0, null);
                continue;
            }
            int destinationId = this.storage.getDestinationDimId(this.field_70170_p.field_73011_w.getDimension(), (int)this.field_70165_t, (int)this.field_70161_v);
            DimensionProperties properties = zmaster587.advancedRocketry.dimension.DimensionManager.getEffectiveDimId(this.field_70170_p, this.func_180425_c());
            WorldServer world = destinationId == Configuration.spaceDimId || destinationId == -1 ? DimensionManager.getWorld((int)properties.getId()) : DimensionManager.getWorld((int)destinationId);
            if (world != null) {
                properties.addSatallite(satellite, (World)world);
            }
            tile.func_70299_a(0, null);
        }
    }

    @Override
    public void prepareLaunch() {
        RocketEvent.RocketPreLaunchEvent event = new RocketEvent.RocketPreLaunchEvent(this);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            if (this.field_70170_p.field_72995_K) {
                PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.LAUNCH.ordinal()));
            }
            this.launch();
        }
    }

    @Override
    public void launch() {
        ISpaceObject object;
        if (this.isInFlight()) {
            return;
        }
        if (this.isInOrbit()) {
            this.setInFlight(true);
            return;
        }
        this.destinationDimId = this.storage.getDestinationDimId(this.field_70170_p.field_73011_w.getDimension(), (int)this.field_70165_t, (int)this.field_70161_v);
        if (!(zmaster587.advancedRocketry.dimension.DimensionManager.getInstance().canTravelTo(this.destinationDimId) || this.destinationDimId == -1 && this.storage.getSatelliteHatches().size() != 0)) {
            this.setError(LibVulpes.proxy.getLocalizedString("error.rocket.cannotGetThere"));
            return;
        }
        int finalDest = this.destinationDimId;
        if (this.destinationDimId == Configuration.spaceDimId) {
            ISpaceObject obj = null;
            Vector3F<Float> vec = this.storage.getDestinationCoordinates(this.destinationDimId, false);
            if (vec != null) {
                obj = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(new BlockPos((double)((Float)vec.x).floatValue(), (double)((Float)vec.y).floatValue(), (double)((Float)vec.z).floatValue()));
            }
            if (obj != null) {
                finalDest = obj.getOrbitingPlanetId();
            } else {
                this.setError(LibVulpes.proxy.getLocalizedString("error.rocket.destinationNotExist"));
                return;
            }
        }
        int thisDimId = this.field_70170_p.field_73011_w.getDimension();
        if (this.field_70170_p.field_73011_w.getDimension() == Configuration.spaceDimId && (object = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.func_180425_c())) != null) {
            thisDimId = object.getProperties().getParentProperties().getId();
        }
        if (!(finalDest == -1 || this.storage.hasWarpCore() && zmaster587.advancedRocketry.dimension.DimensionManager.getInstance().getDimensionProperties(finalDest).getStarId() == zmaster587.advancedRocketry.dimension.DimensionManager.getInstance().getDimensionProperties(thisDimId).getStarId() || zmaster587.advancedRocketry.dimension.DimensionManager.getInstance().areDimensionsInSamePlanetMoonSystem(finalDest, thisDimId))) {
            this.setError(LibVulpes.proxy.getLocalizedString("error.rocket.notSameSystem"));
            return;
        }
        if (!this.stats.hasSeat() || zmaster587.advancedRocketry.dimension.DimensionManager.getInstance().isDimensionCreated(this.destinationDimId) || this.destinationDimId == Configuration.spaceDimId || this.destinationDimId == 0) {
            this.setInFlight(true);
            Iterator connectedTiles = this.connectedInfrastructure.iterator();
            MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketLaunchEvent(this));
            while (connectedTiles.hasNext()) {
                IInfrastructure i = (IInfrastructure)connectedTiles.next();
                if (!i.disconnectOnLiftOff()) continue;
                this.disconnectInfrastructure(i);
                connectedTiles.remove();
            }
        }
    }

    @Override
    public void deconstructRocket() {
        super.deconstructRocket();
        for (IInfrastructure infrastructure : this.connectedInfrastructure) {
            infrastructure.unlinkRocket();
        }
        this.storage.pasteInWorld(this.field_70170_p, (int)(this.field_70165_t - (double)((float)this.storage.getSizeX() / 2.0f)), (int)this.field_70163_u, (int)(this.field_70161_v - (double)((float)this.storage.getSizeZ() / 2.0f)));
        this.func_70106_y();
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.storage != null && this.storage.world.displayListIndex != -1) {
            GLAllocation.func_74523_b((int)this.storage.world.displayListIndex);
        }
        Iterator connectedTiles = this.connectedInfrastructure.iterator();
        while (connectedTiles.hasNext()) {
            ((IInfrastructure)connectedTiles.next()).unlinkRocket();
            connectedTiles.remove();
        }
    }

    public void setOverriddenCoords(int dimId, float x, float y, float z) {
        TileGuidanceComputer tile = this.storage.getGuidanceComputer();
        if (tile != null) {
            tile.setFallbackDestination(dimId, (Vector3F<Float>)new Vector3F((Object)Float.valueOf(x), (Object)Float.valueOf(y), (Object)Float.valueOf(z)));
        }
    }

    public Entity func_184204_a(int newDimId) {
        return this.changeDimension(newDimId, this.field_70165_t, Configuration.orbit, this.field_70161_v);
    }

    @Nullable
    public Entity changeDimension(int dimensionIn, double posX, double y, double posZ) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            if (!zmaster587.advancedRocketry.dimension.DimensionManager.getInstance().canTravelTo(dimensionIn)) {
                AdvancedRocketry.logger.warn("Rocket trying to travel from Dim" + this.field_70170_p.field_73011_w.getDimension() + " to Dim " + dimensionIn + ".  target not accessible by rocket from launch dim");
                return null;
            }
            this.lastDimensionFrom = this.field_70170_p.field_73011_w.getDimension();
            List passengers = this.func_184188_bt();
            if (!ForgeHooks.onTravelToDimension((Entity)this, (int)dimensionIn)) {
                return null;
            }
            this.field_70170_p.field_72984_F.func_76320_a("changeDimension");
            MinecraftServer minecraftserver = this.func_184102_h();
            int i = this.field_71093_bK;
            WorldServer worldserver = minecraftserver.func_71218_a(i);
            WorldServer worldserver1 = minecraftserver.func_71218_a(dimensionIn);
            this.field_71093_bK = dimensionIn;
            if (i == 1 && dimensionIn == 1) {
                worldserver1 = minecraftserver.func_71218_a(0);
                this.field_71093_bK = 0;
            }
            this.field_70170_p.func_72900_e((Entity)this);
            this.field_70128_L = false;
            this.field_70170_p.field_72984_F.func_76320_a("reposition");
            double d0 = this.field_70165_t;
            double d1 = this.field_70161_v;
            double d2 = 8.0;
            d0 = MathHelper.func_151237_a((double)(d0 * 8.0), (double)(worldserver1.func_175723_af().func_177726_b() + 16.0), (double)(worldserver1.func_175723_af().func_177728_d() - 16.0));
            d1 = MathHelper.func_151237_a((double)(d1 * 8.0), (double)(worldserver1.func_175723_af().func_177736_c() + 16.0), (double)(worldserver1.func_175723_af().func_177733_e() - 16.0));
            d0 = MathHelper.func_76125_a((int)((int)d0), (int)-29999872, (int)29999872);
            d1 = MathHelper.func_76125_a((int)((int)d1), (int)-29999872, (int)29999872);
            float f = this.field_70177_z;
            this.func_70012_b(d0, this.field_70163_u, d1, 90.0f, 0.0f);
            TeleporterNoPortal teleporter = new TeleporterNoPortal(worldserver1);
            teleporter.func_180620_b(this, f);
            worldserver.func_72866_a((Entity)this, false);
            this.field_70170_p.field_72984_F.func_76318_c("reloading");
            Entity entity = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)this), (World)worldserver1);
            if (entity != null) {
                this.func_174828_a(new BlockPos(posX, y, posZ), entity.field_70177_z, entity.field_70125_A);
                ((EntityRocket)entity).func_180432_n(this);
                entity.field_98038_p = true;
                worldserver1.func_72838_d(entity);
                worldserver1.func_72866_a(entity, true);
                boolean timeOffset = true;
                for (Entity e : passengers) {
                    worldserver.func_82742_i();
                    worldserver1.func_82742_i();
                    PlanetEventHandler.addDelayedTransition(worldserver.func_82737_E(), new TransitionEntity(worldserver.func_82737_E(), e, dimensionIn, new BlockPos(posX + 16.0, y, posZ), entity));
                }
            }
            this.field_70128_L = true;
            this.field_70170_p.field_72984_F.func_76319_b();
            worldserver.func_82742_i();
            worldserver1.func_82742_i();
            this.field_70170_p.field_72984_F.func_76319_b();
            return entity;
        }
        return null;
    }

    public void func_180432_n(Entity entityIn) {
        NBTTagCompound nbttagcompound = entityIn.func_189511_e(new NBTTagCompound());
        nbttagcompound.func_82580_o("Dimension");
        nbttagcompound.func_82580_o("Passengers");
        this.func_70020_e(nbttagcompound);
        this.field_71088_bW = entityIn.field_71088_bW;
    }

    protected void readNetworkableNBT(NBTTagCompound nbt) {
        this.func_70037_a(nbt);
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.isInOrbit = nbt.func_74767_n("orbit");
        this.setInOrbit(this.isInOrbit);
        this.stats.readFromNBT(nbt);
        this.mountedEntities = new WeakReference[this.stats.getNumPassengerSeats()];
        this.setFuelAmount(this.stats.getFuelAmount(FuelRegistry.FuelType.LIQUID));
        this.isInFlight = nbt.func_74767_n("flight");
        this.setInFlight(this.isInFlight);
        this.readMissionPersistantNBT(nbt);
        if (nbt.func_74764_b("data")) {
            if (this.storage == null) {
                this.storage = new StorageChunk();
            }
            this.storage.readFromNBT(nbt.func_74775_l("data"));
            this.storage.setEntity(this);
            this.func_70105_a(Math.max(this.storage.getSizeX(), this.storage.getSizeZ()), this.storage.getSizeY());
        }
        if (nbt.func_74764_b("infrastructure")) {
            NBTTagList tagList = nbt.func_150295_c("infrastructure", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                int[] coords = tagList.func_150305_b(i).func_74759_k("loc");
                this.infrastructureCoords.add(new HashedBlockPosition(coords[0], coords[1], coords[2]));
            }
        }
        this.destinationDimId = nbt.func_74762_e("destinationDimId");
        this.lastDimensionFrom = nbt.func_74762_e("lastDimensionFrom");
        if (nbt.func_74764_b("satallite")) {
            NBTTagCompound satalliteNbt = nbt.func_74775_l("satallite");
            this.satallite = SatelliteRegistry.createFromNBT(satalliteNbt);
        }
    }

    protected void writeNetworkableNBT(NBTTagCompound nbt) {
        this.writeMissionPersistantNBT(nbt);
        nbt.func_74757_a("orbit", this.isInOrbit());
        nbt.func_74757_a("flight", this.isInFlight());
        this.stats.writeToNBT(nbt);
        if (!this.infrastructureCoords.isEmpty()) {
            NBTTagList itemList = new NBTTagList();
            for (int i = 0; i < this.infrastructureCoords.size(); ++i) {
                HashedBlockPosition inf = (HashedBlockPosition)this.infrastructureCoords.get(i);
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74783_a("loc", new int[]{inf.x, inf.y, inf.z});
                itemList.func_74742_a((NBTBase)tag);
            }
            nbt.func_74782_a("infrastructure", (NBTBase)itemList);
        }
        nbt.func_74768_a("destinationDimId", this.destinationDimId);
        if (this.satallite != null) {
            NBTTagCompound satalliteNbt = new NBTTagCompound();
            this.satallite.writeToNBT(satalliteNbt);
            satalliteNbt.func_74778_a("DataType", SatelliteRegistry.getKey(this.satallite.getClass()));
            nbt.func_74782_a("satallite", (NBTBase)satalliteNbt);
        }
    }

    public void writeMissionPersistantNBT(NBTTagCompound nbt) {
    }

    public void readMissionPersistantNBT(NBTTagCompound nbt) {
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        this.writeNetworkableNBT(nbt);
        if (this.storage != null) {
            NBTTagCompound blocks = new NBTTagCompound();
            this.storage.writeToNBT(blocks);
            nbt.func_74782_a("data", (NBTBase)blocks);
        }
        nbt.func_74768_a("lastDimensionFrom", this.lastDimensionFrom);
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        if (packetId == PacketType.RECIEVENBT.ordinal()) {
            this.storage = new StorageChunk();
            this.storage.setEntity(this);
            this.storage.readFromNetwork(in);
        } else if (packetId == PacketType.SENDPLANETDATA.ordinal()) {
            nbt.func_74768_a("selection", in.readInt());
        }
    }

    public void writeDataToNetwork(ByteBuf out, byte id) {
        if (id == PacketType.RECIEVENBT.ordinal()) {
            this.storage.writeToNetwork(out);
        } else if (id == PacketType.SENDPLANETDATA.ordinal()) {
            ItemStack stack;
            if (this.field_70170_p.field_72995_K) {
                out.writeInt(this.container.getSelectedSystem());
            } else if (this.storage.getGuidanceComputer() != null && (stack = this.storage.getGuidanceComputer().func_70301_a(0)) != null && stack.func_77973_b() == AdvancedRocketryItems.itemPlanetIdChip) {
                out.writeInt(((ItemPlanetIdentificationChip)AdvancedRocketryItems.itemPlanetIdChip).getDimensionId(stack));
            }
        }
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        if (id == PacketType.RECIEVENBT.ordinal()) {
            this.func_70037_a(nbt);
            this.initFromBounds();
        } else if (id == PacketType.DECONSTRUCT.ordinal()) {
            this.deconstructRocket();
        } else if (id == PacketType.SENDINTERACT.ordinal()) {
            this.interact(player);
        } else if (id == PacketType.OPENGUI.ordinal()) {
            if (player.func_184187_bx() == this) {
                this.openGui(player);
            }
        } else if (id == PacketType.REQUESTNBT.ordinal()) {
            if (this.storage != null) {
                NBTTagCompound nbtdata = new NBTTagCompound();
                this.writeNetworkableNBT(nbtdata);
                PacketHandler.sendToPlayer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.RECIEVENBT.ordinal(), nbtdata), (EntityPlayer)player);
            }
        } else if (id == PacketType.FORCEMOUNT.ordinal()) {
            if (!this.acceptedPacket) {
                this.acceptedPacket = true;
                player.func_70080_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, player.field_70177_z, player.field_70125_A);
                player.func_184220_m((Entity)this);
                MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketDeOrbitingEvent(this));
            }
        } else if (id == PacketType.LAUNCH.ordinal()) {
            if (this.func_184188_bt().contains(player)) {
                this.prepareLaunch();
            }
        } else if (id == PacketType.CHANGEWORLD.ordinal()) {
            AdvancedRocketry.proxy.changeClientPlayerWorld(this.storage.world);
        } else if (id == PacketType.REVERTWORLD.ordinal()) {
            AdvancedRocketry.proxy.changeClientPlayerWorld(this.field_70170_p);
        } else if (id == PacketType.OPENPLANETSELECTION.ordinal()) {
            player.openGui((Object)LibVulpes.instance, GuiHandler.guiId.MODULARFULLSCREEN.ordinal(), player.field_70170_p, this.func_145782_y(), -1, 0);
        } else if (id == PacketType.SENDPLANETDATA.ordinal()) {
            ItemStack stack = this.storage.getGuidanceComputer().func_70301_a(0);
            if (stack != null && stack.func_77973_b() == AdvancedRocketryItems.itemPlanetIdChip) {
                ((ItemPlanetIdentificationChip)AdvancedRocketryItems.itemPlanetIdChip).setDimensionId(stack, nbt.func_74762_e("selection"));
                if (!this.field_70170_p.field_72995_K) {
                    PacketHandler.sendToPlayersTrackingEntity((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.SENDPLANETDATA.ordinal()), (Entity)this);
                }
            }
        } else if (id == PacketType.DISCONNECTINFRASTRUCTURE.ordinal()) {
            int[] pos = nbt.func_74759_k("pos");
            this.connectedInfrastructure.remove(new HashedBlockPosition(pos[0], pos[1], pos[2]));
            TileEntity tile = this.field_70170_p.func_175625_s(new BlockPos(pos[0], pos[1], pos[2]));
            if (tile instanceof IInfrastructure) {
                ((IInfrastructure)tile).unlinkRocket();
                this.connectedInfrastructure.remove(tile);
            }
        } else if (id == PacketType.ROCKETLANDEVENT.ordinal() && this.field_70170_p.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketLandedEvent(this));
        } else if (id == PacketType.DISMOUNTCLIENT.ordinal() && this.field_70170_p.field_72995_K) {
            player.func_184210_p();
        } else if (id >= 50 + BUTTON_ID_OFFSET) {
            int id2 = id - (50 + BUTTON_ID_OFFSET) - 1;
            this.setDestLandingPad(id2);
            if (!this.field_70170_p.field_72995_K) {
                PacketHandler.sendToPlayersTrackingEntity((BasePacket)new PacketEntity((INetworkEntity)this, id), (Entity)this);
            }
        } else if (id > BUTTON_ID_OFFSET) {
            TileEntity tile = this.storage.getGUItiles().get(id - BUTTON_ID_OFFSET - this.tilebuttonOffset);
            PacketHandler.sendToPlayer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.CHANGEWORLD.ordinal()), (EntityPlayer)player);
            this.storage.func_180495_p(tile.func_174877_v()).func_177230_c().func_180639_a((World)this.storage.world, tile.func_174877_v(), this.storage.func_180495_p(tile.func_174877_v()), player, EnumHand.MAIN_HAND, null, EnumFacing.DOWN, 0.0f, 0.0f, 0.0f);
            PacketHandler.sendToPlayer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.REVERTWORLD.ordinal()), (EntityPlayer)player);
        }
    }

    private void setDestLandingPad(int padIndex) {
        int uuid;
        ItemStack slot0 = this.storage.getGuidanceComputer().func_70301_a(0);
        if (slot0 != null && slot0.func_77973_b() instanceof ItemStationChip && (uuid = ItemStationChip.getUUID(slot0)) != 0) {
            StationLandingLocation location;
            ISpaceObject obj = SpaceObjectManager.getSpaceManager().getSpaceStation(uuid);
            if (obj instanceof SpaceObject) {
                if (padIndex == -1) {
                    this.storage.getGuidanceComputer().setLandingLocation(uuid, null);
                } else {
                    location = ((SpaceObject)obj).getLandingPads().get(padIndex);
                    if (location != null && !location.getOccupied()) {
                        this.storage.getGuidanceComputer().setLandingLocation(uuid, location);
                    }
                }
            }
            this.landingPadDisplayText.setText((location = this.storage.getGuidanceComputer().getLandingLocation(uuid)) != null ? location.toString() : "None Selected");
        }
    }

    public void func_184232_k(Entity entity) {
        if (entity != null) {
            if (this.storage != null) {
                float xOffset = this.storage.getSizeX() % 2 == 0 ? 0.5f : 0.0f;
                float zOffset = this.storage.getSizeZ() % 2 == 0 ? 0.5f : 0.0f;
                entity.func_70107_b(this.field_70165_t + (double)this.stats.getSeatX() + (double)xOffset, this.field_70163_u + (double)this.stats.getSeatY() - 0.5, this.field_70161_v + (double)this.stats.getSeatZ() + (double)zOffset);
            } else {
                entity.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            }
        }
        for (int i = 0; i < this.stats.getNumPassengerSeats(); ++i) {
            HashedBlockPosition pos = this.stats.getPassengerSeat(i);
            if (this.mountedEntities[i] == null || this.mountedEntities[i].get() == null) continue;
            ((Entity)this.mountedEntities[i].get()).func_70107_b(this.field_70165_t + (double)pos.x, this.field_70163_u + (double)pos.y, this.field_70161_v + (double)pos.z);
            System.out.println("Additional: " + this.mountedEntities[i].get());
        }
    }

    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        if (ID == GuiHandler.guiId.MODULAR.ordinal()) {
            if (this.field_70170_p.field_72995_K) {
                modules.add((ModuleBase)new ModuleImage(173, 0, new IconResource(128, 0, 48, 86, CommonResources.genericBackground)));
                modules.add((ModuleBase)new ModuleImage(173, 86, new IconResource(98, 0, 78, 83, CommonResources.genericBackground)));
                modules.add((ModuleBase)new ModuleImage(173, 168, new IconResource(98, 168, 78, 3, CommonResources.genericBackground)));
            }
            modules.add((ModuleBase)new ModuleProgress(192, 7, 0, new ProgressBarImage(2, 173, 12, 71, 17, 6, 3, 69, 1, 1, EnumFacing.UP, zmaster587.advancedRocketry.inventory.TextureResources.rocketHud), (IProgressBar)this));
            List<TileEntity> tiles = this.storage.getGUItiles();
            for (int i = 0; i < tiles.size(); ++i) {
                TileEntity tile = tiles.get(i);
                IBlockState state = this.storage.func_180495_p(tile.func_174877_v());
                try {
                    modules.add((ModuleBase)new ModuleSlotButton(8 + 18 * (i % 9), 17 + 18 * (i / 9), i + this.tilebuttonOffset, (IButtonInventory)this, new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state)), this.field_70170_p));
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            modules.add((ModuleBase)new ModuleButton(180, 140, 0, "Dissassemble", (IButtonInventory)this, TextureResources.buttonBuild, 64, 20));
            modules.add((ModuleBase)new ModuleButton(180, 114, 1, "Select Dst", (IButtonInventory)this, TextureResources.buttonBuild, 64, 20));
        } else {
            int uuid;
            ItemStack slot0 = this.storage.getGuidanceComputer().func_70301_a(0);
            if (slot0 != null && slot0.func_77973_b() instanceof ItemStationChip && (uuid = ItemStationChip.getUUID(slot0)) != 0) {
                ISpaceObject obj = SpaceObjectManager.getSpaceManager().getSpaceStation(uuid);
                modules.add(new ModuleStellarBackground(0, 0, TextureResources.starryBG));
                if (obj == null) {
                    return modules;
                }
                LinkedList<ModuleButton> list2 = new LinkedList<ModuleButton>();
                ModuleButton button = new ModuleButton(0, 0, 50, "Clear", (IButtonInventory)this, zmaster587.advancedRocketry.inventory.TextureResources.buttonGeneric, 72, 18);
                list2.add(button);
                int i = 1;
                for (StationLandingLocation pos : ((SpaceObject)obj).getLandingPads()) {
                    button = new ModuleButton(0, i * 18, i + 50, pos.toString(), (IButtonInventory)this, zmaster587.advancedRocketry.inventory.TextureResources.buttonGeneric, 72, 18);
                    list2.add(button);
                    if (pos.getOccupied()) {
                        button.setColor(0xFF0000);
                    }
                    ++i;
                }
                ModuleContainerPan pan = new ModuleContainerPan(25, 25, list2, new LinkedList(), null, 256, 256, 0, -48, 258, 256);
                modules.add((ModuleBase)pan);
                StationLandingLocation location = this.storage.getGuidanceComputer().getLandingLocation(uuid);
                this.landingPadDisplayText.setText(location != null ? location.toString() : "None Selected");
                modules.add((ModuleBase)this.landingPadDisplayText);
            } else {
                DimensionProperties properties = zmaster587.advancedRocketry.dimension.DimensionManager.getEffectiveDimId(this.field_70170_p, this.func_180425_c());
                while (properties.getParentProperties() != null) {
                    properties = properties.getParentProperties();
                }
                this.container = this.storage.hasWarpCore() ? new ModulePlanetSelector(properties.getStarId(), TextureResources.starryBG, this, this, true) : new ModulePlanetSelector(properties.getId(), TextureResources.starryBG, this, false);
                this.container.setOffset(1000, 1000);
                modules.add((ModuleBase)this.container);
            }
        }
        return modules;
    }

    public String getModularInventoryName() {
        return "Rocket";
    }

    public float getNormallizedProgress(int id) {
        if (id == 0) {
            return (float)this.getFuelAmount() / (float)this.getFuelCapacity();
        }
        return 0.0f;
    }

    public void setProgress(int id, int progress) {
    }

    public int getProgress(int id) {
        return 0;
    }

    public int getTotalProgress(int id) {
        return 0;
    }

    public void setTotalProgress(int id, int progress) {
    }

    public boolean func_184205_a(Entity entityIn, boolean force) {
        return super.func_184205_a(entityIn, force);
    }

    public boolean func_184220_m(Entity entityIn) {
        return super.func_184220_m(entityIn);
    }

    @SideOnly(value=Side.CLIENT)
    public void onInventoryButtonPressed(int buttonId) {
        switch (buttonId) {
            case 0: {
                PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.DECONSTRUCT.ordinal()));
                break;
            }
            case 1: {
                PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.OPENPLANETSELECTION.ordinal()));
                break;
            }
            default: {
                PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)(buttonId + BUTTON_ID_OFFSET)));
                if (buttonId >= 50) break;
                TileEntity tile = this.storage.getGUItiles().get(buttonId - this.tilebuttonOffset);
                this.storage.func_180495_p(tile.func_174877_v()).func_177230_c().func_180639_a((World)this.storage.world, tile.func_174877_v(), this.storage.func_180495_p(tile.func_174877_v()), (EntityPlayer)Minecraft.func_71410_x().field_71439_g, EnumHand.MAIN_HAND, null, EnumFacing.DOWN, 0.0f, 0.0f, 0.0f);
            }
        }
    }

    public boolean canInteractWithContainer(EntityPlayer entity) {
        boolean ret;
        boolean bl = ret = !this.field_70128_L && this.func_70032_d((Entity)entity) < 64.0f;
        if (!ret) {
            RocketInventoryHelper.removePlayerFromInventoryBypass(entity);
        }
        RocketInventoryHelper.updateTime(entity, this.field_70170_p.func_72820_D());
        return ret;
    }

    @Override
    public StatsRocket getRocketStats() {
        return this.stats;
    }

    public void onSelected(Object sender) {
    }

    public void onSelectionConfirmed(Object sender) {
        PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)PacketType.SENDPLANETDATA.ordinal()));
    }

    public void onSystemFocusChanged(Object sender) {
    }

    public LinkedList<IInfrastructure> getConnectedInfrastructure() {
        return this.connectedInfrastructure;
    }

    @Override
    public boolean isPlanetKnown(IDimensionProperties properties) {
        return !Configuration.planetsMustBeDiscovered || zmaster587.advancedRocketry.dimension.DimensionManager.getInstance().knownPlanets.contains(properties.getId());
    }

    @Override
    public boolean isStarKnown(StellarBody body) {
        return true;
    }

    public static enum PacketType {
        RECIEVENBT,
        SENDINTERACT,
        REQUESTNBT,
        FORCEMOUNT,
        LAUNCH,
        DECONSTRUCT,
        OPENGUI,
        CHANGEWORLD,
        REVERTWORLD,
        OPENPLANETSELECTION,
        SENDPLANETDATA,
        DISCONNECTINFRASTRUCTURE,
        CONNECTINFRASTRUCTURE,
        ROCKETLANDEVENT,
        MENU_CHANGE,
        UPDATE_ATM,
        UPDATE_ORBIT,
        UPDATE_FLIGHT,
        DISMOUNTCLIENT;

    }
}

