/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.client.render.planet;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import org.lwjgl.opengl.GL11;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.client.render.planet.RenderPlanetarySky;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.libVulpes.render.RenderHelper;
import zmaster587.libVulpes.util.Vector3F;

public class RenderSpaceSky
extends RenderPlanetarySky {
    Minecraft mc = Minecraft.func_71410_x();

    @Override
    public void renderPlanet2(VertexBuffer buffer, ResourceLocation icon, int locationX, int locationY, double zLevel, float planetOrbitalDistance, float alphaMultiplier, double angle, boolean hasAtmosphere, float[] atmColor, float[] ringColor, boolean isGasgiant, boolean hasRings) {
        float f15;
        ISpaceObject object = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.mc.field_71439_g.func_180425_c());
        if (object == null) {
            return;
        }
        planetOrbitalDistance = object.getOrbitalDistance();
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2912);
        GL11.glBlendFunc((int)1, (int)0);
        this.mc.field_71446_o.func_110577_a(icon);
        GL11.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GL11.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        float f10 = 100.0f * (200.0f - planetOrbitalDistance) / 100.0f;
        float Xoffset = (float)((double)System.currentTimeMillis() / 1000000.0 % 1.0);
        float f14 = 1.0f + Xoffset;
        float f16 = f15 = 0.0f + Xoffset;
        float f17 = f14;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alphaMultiplier);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)(-f10), -10.0, (double)f10).func_187315_a((double)f16, (double)f17).func_181675_d();
        buffer.func_181662_b((double)f10, -10.0, (double)f10).func_187315_a((double)f14, (double)f17).func_181675_d();
        buffer.func_181662_b((double)f10, -10.0, (double)(-f10)).func_187315_a((double)f14, (double)f15).func_181675_d();
        buffer.func_181662_b((double)(-f10), -10.0, (double)(-f10)).func_187315_a((double)f16, (double)f15).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GL11.glPopAttrib();
        if (isGasgiant) {
            int i;
            GL11.glBlendFunc((int)770, (int)1);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            this.mc.field_71446_o.func_110577_a(DimensionProperties.getAtmosphereLEOResource());
            double dist = -5.0 - (double)(4.0f * planetOrbitalDistance) / 200.0;
            double scalingMult = 1.0 - 0.9 * (double)planetOrbitalDistance / 200.0;
            int maxAmt = 6;
            float lng = (float)((double)Minecraft.func_71386_F() / 100000.0 % 1.0);
            for (i = 0; i < maxAmt; ++i) {
                GlStateManager.func_179131_c((float)(0.05f * ((float)maxAmt - (float)i / 6.0f)), (float)(0.4f * ((float)i / 6.0f)), (float)1.0f, (float)0.4f);
                Xoffset = lng * ((float)i - (float)maxAmt / 4.0f);
                float Yoffset = -lng * (float)i;
                f14 = (float)i + Yoffset;
                f15 = 0.0f + Yoffset;
                f16 = 0.0f + Xoffset;
                f17 = (float)i + Xoffset;
                RenderHelper.renderTopFaceWithUV((VertexBuffer)buffer, (double)(-10.0 + (double)i * scalingMult), (double)(-f10), (double)(-f10), (double)0.0, (double)0.0, (double)f14, (double)f15, (double)f16, (double)f17);
                RenderHelper.renderTopFaceWithUV((VertexBuffer)buffer, (double)(-10.0 + (double)i * scalingMult), (double)0.0, (double)0.0, (double)f10, (double)f10, (double)f14, (double)f15, (double)f16, (double)f17);
                RenderHelper.renderTopFaceWithUV((VertexBuffer)buffer, (double)(-10.0 + (double)i * scalingMult), (double)(-f10), (double)0.0, (double)0.0, (double)f10, (double)f14, (double)f15, (double)f16, (double)f17);
                RenderHelper.renderTopFaceWithUV((VertexBuffer)buffer, (double)(-10.0 + (double)i * scalingMult), (double)0.0, (double)(-f10), (double)f10, (double)0.0, (double)f14, (double)f15, (double)f16, (double)f17);
            }
            Tessellator.func_178181_a().func_78381_a();
            GL11.glDisable((int)3553);
            GL11.glBlendFunc((int)770, (int)771);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            GlStateManager.func_179131_c((float)0.5f, (float)0.5f, (float)1.0f, (float)0.08f);
            for (i = 0; i < 5; ++i) {
                RenderHelper.renderTopFaceWithUV((VertexBuffer)buffer, (double)(dist + (double)i * scalingMult), (double)(-f10), (double)(-f10), (double)0.0, (double)0.0, (double)f14, (double)f15, (double)f16, (double)f17);
                RenderHelper.renderTopFaceWithUV((VertexBuffer)buffer, (double)(dist + (double)i * scalingMult), (double)0.0, (double)0.0, (double)f10, (double)f10, (double)f14, (double)f15, (double)f16, (double)f17);
                RenderHelper.renderTopFaceWithUV((VertexBuffer)buffer, (double)(dist + (double)i * scalingMult), (double)(-f10), (double)0.0, (double)0.0, (double)f10, (double)f14, (double)f15, (double)f16, (double)f17);
                RenderHelper.renderTopFaceWithUV((VertexBuffer)buffer, (double)(dist + (double)i * scalingMult), (double)0.0, (double)(-f10), (double)f10, (double)0.0, (double)f14, (double)f15, (double)f16, (double)f17);
            }
            Tessellator.func_178181_a().func_78381_a();
            GL11.glEnable((int)3553);
        } else if (hasAtmosphere) {
            GL11.glBlendFunc((int)770, (int)1);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            this.mc.field_71446_o.func_110577_a(DimensionProperties.getAtmosphereLEOResource());
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            Xoffset = (float)((double)System.currentTimeMillis() / 100000.0 % 1.0);
            f14 = 1.0f + Xoffset;
            f16 = f15 = 0.0f + Xoffset;
            f17 = f14;
            RenderHelper.renderTopFaceWithUV((VertexBuffer)buffer, (double)-10.0, (double)(-f10), (double)(-f10), (double)0.0, (double)0.0, (double)f14, (double)f15, (double)f16, (double)f17);
            RenderHelper.renderTopFaceWithUV((VertexBuffer)buffer, (double)-10.0, (double)0.0, (double)0.0, (double)f10, (double)f10, (double)f14, (double)f15, (double)f16, (double)f17);
            RenderHelper.renderTopFaceWithUV((VertexBuffer)buffer, (double)-10.0, (double)(-f10), (double)0.0, (double)0.0, (double)f10, (double)f14, (double)f15, (double)f16, (double)f17);
            RenderHelper.renderTopFaceWithUV((VertexBuffer)buffer, (double)-10.0, (double)0.0, (double)(-f10), (double)f10, (double)0.0, (double)f14, (double)f15, (double)f16, (double)f17);
            Tessellator.func_178181_a().func_78381_a();
            GL11.glDisable((int)3553);
            GL11.glBlendFunc((int)770, (int)771);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            GlStateManager.func_179131_c((float)atmColor[0], (float)atmColor[1], (float)atmColor[2], (float)0.08f);
            double dist = -5.0 - (double)(4.0f * planetOrbitalDistance) / 200.0;
            double scalingMult = 1.0 - 0.9 * (double)planetOrbitalDistance / 200.0;
            for (int i = 0; i < 5; ++i) {
                RenderHelper.renderTopFaceWithUV((VertexBuffer)buffer, (double)(dist + (double)i * scalingMult), (double)(-f10), (double)(-f10), (double)0.0, (double)0.0, (double)f14, (double)f15, (double)f16, (double)f17);
                RenderHelper.renderTopFaceWithUV((VertexBuffer)buffer, (double)(dist + (double)i * scalingMult), (double)0.0, (double)0.0, (double)f10, (double)f10, (double)f14, (double)f15, (double)f16, (double)f17);
                RenderHelper.renderTopFaceWithUV((VertexBuffer)buffer, (double)(dist + (double)i * scalingMult), (double)(-f10), (double)0.0, (double)0.0, (double)f10, (double)f14, (double)f15, (double)f16, (double)f17);
                RenderHelper.renderTopFaceWithUV((VertexBuffer)buffer, (double)(dist + (double)i * scalingMult), (double)0.0, (double)(-f10), (double)f10, (double)0.0, (double)f14, (double)f15, (double)f16, (double)f17);
            }
            Tessellator.func_178181_a().func_78381_a();
            GL11.glEnable((int)3553);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2912);
        GL11.glPopMatrix();
    }

    @Override
    protected EnumFacing getRotationAxis(DimensionProperties properties, BlockPos pos) {
        try {
            return SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(pos).getForwardDirection().func_176746_e();
        }
        catch (Exception e) {
            return EnumFacing.EAST;
        }
    }

    @Override
    protected void rotateAroundAxis() {
        Vector3F<Float> axis = this.getRotateAxis();
        ISpaceObject obj = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.mc.field_71439_g.func_180425_c());
        if (obj != null) {
            GL11.glRotated((double)(obj.getRotation(EnumFacing.UP) * 360.0), (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)(obj.getRotation(EnumFacing.EAST) * 360.0), (double)1.0, (double)0.0, (double)0.0);
        }
    }

    @Override
    protected ResourceLocation getTextureForPlanet(DimensionProperties properties) {
        return properties.getPlanetIconLEO();
    }
}

