/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.armor;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import zmaster587.advancedRocketry.api.AdvancedRocketryFluids;
import zmaster587.advancedRocketry.api.armor.IFillableArmor;
import zmaster587.advancedRocketry.armor.ItemSpaceArmor;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.libVulpes.util.EmbeddedInventory;
import zmaster587.libVulpes.util.FluidUtils;
import zmaster587.libVulpes.util.IconResource;

public class ItemSpaceChest
extends ItemSpaceArmor
implements IFillableArmor {
    public ItemSpaceChest(ItemArmor.ArmorMaterial material, EntityEquipmentSlot component, int numModules) {
        super(material, component, numModules);
    }

    @Override
    public boolean isItemValidForSlot(ItemStack stack, int slot) {
        if (slot >= 2) {
            return true;
        }
        return stack != null && stack.func_77973_b() instanceof IFluidContainerItem && (((IFluidContainerItem)stack.func_77973_b()).getFluid(stack) == null || ((IFluidContainerItem)stack.func_77973_b()).getFluid(stack).getFluid() == AdvancedRocketryFluids.fluidOxygen);
    }

    @Override
    public boolean canBeExternallyModified(ItemStack armor, int slot) {
        return slot >= 2;
    }

    @Override
    public IconResource getResourceForSlot(int slot) {
        if (slot < 2) {
            return TextureResources.slotO2;
        }
        return null;
    }

    @Override
    public int getAirRemaining(ItemStack stack) {
        List<ItemStack> list = this.getComponents(stack);
        int airRemaining = 0;
        for (ItemStack component : list) {
            IFluidContainerItem fluidItem;
            FluidStack fluidStack;
            if (!(component.func_77973_b() instanceof IFluidContainerItem) || (fluidStack = (fluidItem = (IFluidContainerItem)component.func_77973_b()).getFluid(component)) == null || !FluidUtils.areFluidsSameType((Fluid)fluidStack.getFluid(), (Fluid)AdvancedRocketryFluids.fluidOxygen)) continue;
            airRemaining += fluidStack.amount;
        }
        return airRemaining;
    }

    @Override
    public void setAirRemaining(ItemStack stack, int amt) {
    }

    @Override
    public int decrementAir(ItemStack stack, int amt) {
        if (stack.func_77942_o()) {
            EmbeddedInventory inv = new EmbeddedInventory(this.getNumSlots(stack));
            inv.readFromNBT(stack.func_77978_p());
            LinkedList<ItemStack> list = new LinkedList<ItemStack>();
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                if (inv.func_70301_a(i) == null) continue;
                list.add(inv.func_70301_a(i));
            }
            int amtDrained = amt;
            for (ItemStack component : list) {
                if (!(component.func_77973_b() instanceof IFluidContainerItem)) continue;
                IFluidContainerItem fluidItem = (IFluidContainerItem)component.func_77973_b();
                FluidStack fluidStack = fluidItem.getFluid(component);
                FluidStack fluidDrained = null;
                if (fluidStack != null && FluidUtils.areFluidsSameType((Fluid)fluidStack.getFluid(), (Fluid)AdvancedRocketryFluids.fluidOxygen)) {
                    fluidDrained = fluidItem.drain(component, amtDrained, true);
                }
                if (fluidDrained != null) {
                    amtDrained -= fluidDrained.amount;
                }
                if (amtDrained != 0) continue;
                break;
            }
            this.saveEmbeddedInventory(stack, inv);
            return amt - amtDrained;
        }
        return 0;
    }

    @Override
    public int increment(ItemStack stack, int amt) {
        if (stack.func_77942_o()) {
            EmbeddedInventory inv = new EmbeddedInventory(this.getNumSlots(stack));
            inv.readFromNBT(stack.func_77978_p());
            LinkedList<ItemStack> list = new LinkedList<ItemStack>();
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                if (inv.func_70301_a(i) == null || i >= 2 && (!(inv.func_70301_a(i).func_77973_b() instanceof IFluidContainerItem) || ((IFluidContainerItem)inv.func_70301_a(i).func_77973_b()).getFluid(inv.func_70301_a(i)) == null || !FluidUtils.areFluidsSameType((Fluid)((IFluidContainerItem)inv.func_70301_a(i).func_77973_b()).getFluid(inv.func_70301_a(i)).getFluid(), (Fluid)AdvancedRocketryFluids.fluidOxygen))) continue;
                list.add(inv.func_70301_a(i));
            }
            int amtDrained = amt;
            for (ItemStack component : list) {
                if (!(component.func_77973_b() instanceof IFluidContainerItem)) continue;
                IFluidContainerItem fluidItem = (IFluidContainerItem)component.func_77973_b();
                FluidStack fluidStack = fluidItem.getFluid(component);
                if (fluidStack == null || FluidUtils.areFluidsSameType((Fluid)fluidStack.getFluid(), (Fluid)AdvancedRocketryFluids.fluidOxygen)) {
                    amtDrained -= fluidItem.fill(component, new FluidStack(AdvancedRocketryFluids.fluidOxygen, amtDrained), true);
                }
                if (amtDrained != 0) continue;
                break;
            }
            this.saveEmbeddedInventory(stack, inv);
            return amt - amtDrained;
        }
        return 0;
    }

    @Override
    public int getMaxAir(ItemStack stack) {
        if (stack.func_77942_o()) {
            EmbeddedInventory inv = new EmbeddedInventory(this.getNumSlots(stack));
            inv.readFromNBT(stack.func_77978_p());
            LinkedList<ItemStack> list = new LinkedList<ItemStack>();
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                if (inv.func_70301_a(i) == null || i >= 2 && (!(inv.func_70301_a(i).func_77973_b() instanceof IFluidContainerItem) || ((IFluidContainerItem)inv.func_70301_a(i).func_77973_b()).getFluid(inv.func_70301_a(i)) == null || !FluidUtils.areFluidsSameType((Fluid)((IFluidContainerItem)inv.func_70301_a(i).func_77973_b()).getFluid(inv.func_70301_a(i)).getFluid(), (Fluid)AdvancedRocketryFluids.fluidOxygen))) continue;
                list.add(inv.func_70301_a(i));
            }
            int maxAir = 0;
            for (ItemStack component : list) {
                IFluidContainerItem fluidItem;
                FluidStack fluidStack;
                if (!(component.func_77973_b() instanceof IFluidContainerItem) || (fluidStack = (fluidItem = (IFluidContainerItem)component.func_77973_b()).getFluid(component)) != null && fluidStack.getFluid() != null && !FluidUtils.areFluidsSameType((Fluid)fluidStack.getFluid(), (Fluid)AdvancedRocketryFluids.fluidOxygen)) continue;
                maxAir += fluidItem.getCapacity(component);
            }
            return maxAir;
        }
        return 0;
    }
}

