/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.api;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.api.satellite.SatelliteProperties;

public class SatelliteRegistry {
    static HashMap<String, Class<? extends SatelliteBase>> registry = new HashMap();
    static HashMap<ItemStack, SatelliteProperties> itemPropertiesRegistry = new HashMap();

    public static void registerSatelliteProperty(ItemStack stack, SatelliteProperties properties) {
        if (stack == null) {
            Logger.getLogger("advancedRocketry").warning("null satellite property being registered!");
        } else if (!itemPropertiesRegistry.containsKey(stack)) {
            itemPropertiesRegistry.put(stack, properties);
        } else {
            Logger.getLogger("advancedRocketry").warning("Duplicate satellite property being registered for " + stack.toString());
        }
    }

    public static SatelliteProperties getSatelliteProperty(ItemStack stack) {
        for (ItemStack keyStack : itemPropertiesRegistry.keySet()) {
            if (keyStack.func_77973_b() != stack.func_77973_b() || keyStack.func_77981_g() && keyStack.func_77952_i() != stack.func_77952_i()) continue;
            return itemPropertiesRegistry.get(keyStack);
        }
        return null;
    }

    public static void registerSatellite(String name, Class<? extends SatelliteBase> clazz) {
        registry.put(name, clazz);
    }

    public static String getKey(Class<? extends SatelliteBase> clazz) {
        for (Map.Entry<String, Class<? extends SatelliteBase>> entrySet : registry.entrySet()) {
            if (entrySet.getValue() != clazz) continue;
            return entrySet.getKey();
        }
        return "poo";
    }

    public static SatelliteBase createFromNBT(NBTTagCompound nbt) {
        SatelliteBase satellite = SatelliteRegistry.getSatallite(nbt.func_74779_i("dataType"));
        satellite.readFromNBT(nbt);
        return satellite;
    }

    public static SatelliteBase getSatallite(String name) {
        Class<? extends SatelliteBase> clazz = registry.get(name);
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }
}

