/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.ForgeBlock;
import com.endertech.minecraft.forge.units.UnitId;
import javax.annotation.Nullable;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class ForgeBlockContainer<T extends TileEntity>
extends ForgeBlock
implements ITileEntityProvider {
    private final Class<T> tileEntityClass;

    public ForgeBlockContainer(ForgeMod mod, UnitConfig config, Class<T> tileEntityClass, String name, Material material, CreativeTabs tab) {
        super(mod, config, name, material, tab);
        this.tileEntityClass = tileEntityClass;
        this.field_149758_A = true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        worldIn.func_175713_t(pos);
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(id, param);
    }

    public UnitId getTileEntityId() {
        String unitName = UnitId.buildRegName(this.getId().getRegName(), "tile");
        return UnitId.from(this.getMod().getId(), unitName);
    }

    public Class<T> getTileEntityClass() {
        return this.tileEntityClass;
    }

    @Nullable
    public TileEntity getTileEntity(World world, BlockPos pos) {
        return world.func_175625_s(pos);
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        try {
            return (TileEntity)this.getTileEntityClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }
}

