/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cxlibrary.asm;

import cubex2.cxlibrary.asm.ASMUtil;
import cubex2.cxlibrary.asm.ClassTransformer;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

public class PacketTransformer
extends ClassTransformer {
    @Override
    public boolean transform(ClassNode classNode) {
        if (ASMUtil.isAbstract(classNode.access)) {
            return false;
        }
        if (!classNode.superName.equalsIgnoreCase("cubex2/cxlibrary/network/Packet")) {
            return false;
        }
        if (!ASMUtil.hasMethod(classNode, "()V", "<init>")) {
            ASMUtil.createEmptyDefaultConstructor(classNode);
        }
        if (!ASMUtil.hasMethod(classNode, null, "toBytesGenerated")) {
            this.createToBytes(classNode);
        }
        if (!ASMUtil.hasMethod(classNode, null, "fromBytesGenerated")) {
            this.createFromBytes(classNode);
        }
        return true;
    }

    private void createToBytes(ClassNode classNode) {
        MethodVisitor m = classNode.visitMethod(1, "toBytesGenerated", "(Lio/netty/buffer/ByteBuf;)V", null, null);
        m.visitCode();
        for (FieldNode field : classNode.fields) {
            if (!this.hasCorrectAccess(field)) continue;
            if (ASMUtil.isPrimitive(field.desc)) {
                this.writePrimitive(m, classNode, field);
                continue;
            }
            if (!this.isObjectSupported(field.desc)) continue;
            this.writeObject(m, classNode, field);
        }
        m.visitInsn(177);
    }

    private void writePrimitive(MethodVisitor m, ClassNode classNode, FieldNode field) {
        String desc = field.desc;
        String className = Type.getType((String)desc).getClassName();
        String methodName = "write" + className.substring(0, 1).toUpperCase() + className.substring(1);
        if (desc.equals("B") || desc.equals("S")) {
            desc = "I";
        }
        m.visitVarInsn(25, 1);
        m.visitVarInsn(25, 0);
        m.visitFieldInsn(180, classNode.name, field.name, field.desc);
        m.visitMethodInsn(182, "io/netty/buffer/ByteBuf", methodName, "(" + desc + ")Lio/netty/buffer/ByteBuf;", false);
    }

    private void writeObject(MethodVisitor m, ClassNode classNode, FieldNode field) {
        String desc = field.desc;
        m.visitVarInsn(25, 1);
        m.visitVarInsn(25, 0);
        m.visitFieldInsn(180, classNode.name, field.name, field.desc);
        if (desc.equals("Ljava/lang/String;")) {
            m.visitMethodInsn(184, "cpw/mods/fml/common/network/ByteBufUtils", "writeUTF8String", "(Lio/netty/buffer/ByteBuf;Ljava/lang/String;)V", false);
        }
    }

    private void createFromBytes(ClassNode classNode) {
        MethodVisitor m = classNode.visitMethod(1, "fromBytesGenerated", "(Lio/netty/buffer/ByteBuf;)V", null, null);
        m.visitCode();
        for (FieldNode field : classNode.fields) {
            if (!this.hasCorrectAccess(field)) continue;
            if (ASMUtil.isPrimitive(field.desc)) {
                this.readPrimitive(m, classNode, field);
                continue;
            }
            if (!this.isObjectSupported(field.desc)) continue;
            this.readObject(m, classNode, field);
        }
        m.visitInsn(177);
    }

    private void readPrimitive(MethodVisitor m, ClassNode classNode, FieldNode field) {
        String desc = field.desc;
        String className = Type.getType((String)desc).getClassName();
        String methodName = "read" + className.substring(0, 1).toUpperCase() + className.substring(1);
        m.visitVarInsn(25, 0);
        m.visitVarInsn(25, 1);
        m.visitMethodInsn(182, "io/netty/buffer/ByteBuf", methodName, "()" + desc, false);
        m.visitFieldInsn(181, classNode.name, field.name, field.desc);
    }

    private void readObject(MethodVisitor m, ClassNode classNode, FieldNode field) {
        String desc = field.desc;
        m.visitVarInsn(25, 0);
        m.visitVarInsn(25, 1);
        if (desc.equals("Ljava/lang/String;")) {
            m.visitMethodInsn(184, "cpw/mods/fml/common/network/ByteBufUtils", "readUTF8String", "(Lio/netty/buffer/ByteBuf;)Ljava/lang/String;", false);
        }
        m.visitFieldInsn(181, classNode.name, field.name, field.desc);
    }

    private boolean hasCorrectAccess(FieldNode field) {
        return !ASMUtil.isFinal(field.access) && !ASMUtil.isStatic(field.access) && !ASMUtil.isTransient(field.access);
    }

    private boolean isObjectSupported(String desc) {
        return desc.equals("Ljava/lang/String;");
    }
}

