/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.gyth.plugins;

import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import net.darkhax.gyth.api.GythApi;
import net.darkhax.gyth.api.TankTier;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gyth.Tiers")
public class PluginMineTweaker {
    public static void registerSelf() {
        MineTweakerAPI.registerClass(PluginMineTweaker.class);
    }

    @ZenMethod
    public static void addTier(String name, IIngredient displayBlock, IIngredient recipe, int tier) {
        Block block = null;
        int meta = 0;
        Object recipeObj = recipe.getInternal();
        if (displayBlock.getInternal() instanceof ItemStack) {
            ItemStack stack = (ItemStack)displayBlock.getInternal();
            block = Block.func_149634_a((Item)stack.func_77973_b());
            meta = stack.func_77960_j();
        }
        if (!(recipeObj instanceof String || recipeObj instanceof ItemStack || recipeObj instanceof Item || recipeObj instanceof Block)) {
            MineTweakerAPI.logInfo((String)("The GYTH tier " + name + " could not be created. The recipe object was invalid! " + recipeObj.toString()));
        }
        if (block == null) {
            MineTweakerAPI.logInfo((String)("The GYTH tier " + name + " could not be created. The display block was null!"));
        }
        if (meta < 0 || meta > 15) {
            MineTweakerAPI.logInfo((String)("The GYTH tier " + name + " could not be created. The meta value was out of range!"));
        }
        MineTweakerAPI.apply((IUndoableAction)new ActionAddGythTier(name, block, meta, recipeObj, tier));
    }

    @ZenMethod
    public static void removeTier(String tierName) {
        TankTier tier = GythApi.getTier(tierName);
        if (tier == null) {
            MineTweakerAPI.logInfo((String)("The GYTH tier could not be removed. No tier found with name " + tierName));
        }
        MineTweakerAPI.apply((IUndoableAction)new ActionRemoveGythTier(tier));
    }

    public static class ActionRemoveGythTier
    implements IUndoableAction {
        private final TankTier tier;

        public ActionRemoveGythTier(TankTier tier) {
            this.tier = tier;
        }

        public void apply() {
            GythApi.removeTier("MineTweaker3", this.tier.identifier);
        }

        public void undo() {
        }

        public String describe() {
            return "Removing a GYTH tier called " + this.tier.identifier.toString();
        }

        public String describeUndo() {
            return "Unable to re-add GYTH tier! THIS IS NOT AN ERROR";
        }

        public boolean canUndo() {
            return true;
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    public static class ActionAddGythTier
    implements IUndoableAction {
        private final String name;
        private final Block block;
        private final int meta;
        private final Object recipe;
        private final int tier;

        public ActionAddGythTier(String name, Block block, int meta, Object recipe, int tier) {
            this.name = name;
            this.block = block;
            this.meta = meta;
            this.recipe = recipe;
            this.tier = tier;
        }

        public void apply() {
            GythApi.createTier("MineTweaker3", this.name, this.block, this.meta, this.recipe, this.tier);
        }

        public void undo() {
        }

        public String describe() {
            return "Creating a GYTH tier called crafttweaker: " + this.name;
        }

        public String describeUndo() {
            return "Unable to remove GYTH tier! THIS IS NOT AN ERROR";
        }

        public boolean canUndo() {
            return true;
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

