/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.gyth.api;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.darkhax.bookshelf.lib.util.ItemStackUtils;
import net.darkhax.bookshelf.lib.util.ModUtils;
import net.darkhax.bookshelf.lib.util.PlayerUtils;
import net.darkhax.gyth.Gyth;
import net.darkhax.gyth.api.TankTier;
import net.darkhax.gyth.libs.ConfigurationHandler;
import net.darkhax.gyth.libs.Constants;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidStack;

public class GythApi {
    public static Map<ResourceLocation, TankTier> REGISTRY = new HashMap<ResourceLocation, TankTier>();
    public static final TankTier WOOD_OAK = GythApi.createTier("oak", Blocks.field_150344_f, 0, new ItemStack(Blocks.field_150344_f, 1, 0), 1);
    public static final TankTier WOOD_SPRUCE = GythApi.createTier("spruce", Blocks.field_150344_f, 1, new ItemStack(Blocks.field_150344_f, 1, 1), 1);
    public static final TankTier WOOD_BIRCH = GythApi.createTier("birch", Blocks.field_150344_f, 2, new ItemStack(Blocks.field_150344_f, 1, 2), 1);
    public static final TankTier WOOD_JUNGLE = GythApi.createTier("jungle", Blocks.field_150344_f, 3, new ItemStack(Blocks.field_150344_f, 1, 3), 1);
    public static final TankTier WOOD_ACACIA = GythApi.createTier("acacia", Blocks.field_150344_f, 4, new ItemStack(Blocks.field_150344_f, 1, 4), 1);
    public static final TankTier WOOD_DARK_OAK = GythApi.createTier("dark_oak", Blocks.field_150344_f, 5, new ItemStack(Blocks.field_150344_f, 1, 5), 1);
    public static final TankTier CLAY = GythApi.createTier("clay", Blocks.field_150405_ch, 0, "ingotBrick", 1);
    public static final TankTier STONE_COBBLE = GythApi.createTier("stone_cobble", Blocks.field_150347_e, 0, "cobblestone", 2);
    public static final TankTier STONE_SMOOTH = GythApi.createTier("stone_smooth", Blocks.field_150348_b, 0, new ItemStack(Blocks.field_150348_b, 1, 0), 2);
    public static final TankTier STONE_GRANITE = GythApi.createTier("stone_granite", Blocks.field_150348_b, 1, new ItemStack(Blocks.field_150348_b, 1, 1), 2);
    public static final TankTier STONE_GRANITE_SMOOTH = GythApi.createTier("stone_granite_smooth", Blocks.field_150348_b, 2, new ItemStack(Blocks.field_150348_b, 1, 2), 2);
    public static final TankTier STONE_DIORITE = GythApi.createTier("stone_diorite", Blocks.field_150348_b, 3, new ItemStack(Blocks.field_150348_b, 1, 3), 2);
    public static final TankTier STONE_DIORITE_SMOOTH = GythApi.createTier("stone_diorite_smooth", Blocks.field_150348_b, 4, new ItemStack(Blocks.field_150348_b, 1, 4), 2);
    public static final TankTier STONE_ANDESITE = GythApi.createTier("stone_andesite", Blocks.field_150348_b, 5, new ItemStack(Blocks.field_150348_b, 1, 5), 2);
    public static final TankTier STONE_ANDESITE_SMOOTH = GythApi.createTier("stone_andesite_smooth", Blocks.field_150348_b, 6, new ItemStack(Blocks.field_150348_b, 1, 6), 2);
    public static final TankTier SANDSTONE_BRICK = GythApi.createTier("sandstone_brick", Blocks.field_150322_A, 0, Blocks.field_150322_A, 2);
    public static final TankTier SANDSTONE_BRICK_RED = GythApi.createTier("sandstone_brick_red", Blocks.field_180395_cM, 0, Blocks.field_180395_cM, 2);
    public static final TankTier BRICK = GythApi.createTier("brick", Blocks.field_150336_V, 0, Blocks.field_150336_V, 2);
    public static final TankTier BRICK_NETHER = GythApi.createTier("brick_nether", Blocks.field_150385_bj, 0, "ingotBrickNether", 2);
    public static final TankTier BRICK_STONE = GythApi.createTier("brick_stone", Blocks.field_150417_aV, 0, Blocks.field_150417_aV, 2);
    public static final TankTier BRICK_PURPUR = GythApi.createTier("brick_purpur", Blocks.field_185767_cT, 0, Blocks.field_185767_cT, 2);
    public static final TankTier BRICK_END = GythApi.createTier("brick_end", Blocks.field_185772_cY, 0, Blocks.field_185772_cY, 2);
    public static final TankTier PRISMARINE = GythApi.createTier("prismarine", Blocks.field_180397_cI, 0, Items.field_179562_cC, 2);
    public static final TankTier IRON = GythApi.createTier("iron", Blocks.field_150339_S, 0, "ingotIron", 3);
    public static final TankTier GOLD = GythApi.createTier("gold", Blocks.field_150340_R, 0, "ingotGold", 3);
    public static final TankTier OBSIDIAN = GythApi.createTier("obsidian", Blocks.field_150343_Z, 0, "obsidian", 3);
    public static final TankTier LAPIS = GythApi.createTier("lapis", Blocks.field_150368_y, 0, "gemLapis", 4);
    public static final TankTier REDSTONE = GythApi.createTier("redstone", Blocks.field_150451_bX, 0, "dustRedstone", 4);
    public static final TankTier QUARTZ = GythApi.createTier("quartz", Blocks.field_150371_ca, 0, "gemQuartz", 4);
    public static final TankTier DIAMOND = GythApi.createTier("diamond", Blocks.field_150484_ah, 0, "gemDiamond", 5);
    public static final TankTier EMERALD = GythApi.createTier("emerald", Blocks.field_150475_bE, 0, "gemEmerald", 5);

    public static TankTier registerTier(ResourceLocation identifier, TankTier tier) {
        REGISTRY.put(identifier, tier);
        return tier;
    }

    public static TankTier getTier(String identifier) {
        return identifier == null || identifier.isEmpty() ? null : REGISTRY.get(new ResourceLocation(identifier));
    }

    public static ItemStack createTierUpgrade(TankTier tier) {
        ItemStack stack = new ItemStack(Gyth.itemTankUpgrade);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("TierID", tier.identifier.toString());
        stack.func_77982_d(tag);
        return stack;
    }

    public static ItemStack createTieredTank(TankTier tier) {
        ItemStack stack = new ItemStack(Gyth.blockModularTanks);
        ItemStackUtils.prepareDataTag((ItemStack)stack);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("TierID", tier.identifier.toString());
        stack.func_77978_p().func_74782_a("TileData", (NBTBase)tag);
        return stack;
    }

    public static TankTier getTierFromStack(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("TierID")) {
            return GythApi.getTier(stack.func_77978_p().func_74779_i("TierID"));
        }
        return null;
    }

    public static void createTierTooltip(TankTier tier, FluidStack stack, List<String> tooltip) {
        GythApi.createTierTooltip(tier, stack, tooltip, true);
    }

    public static void createTierTooltip(TankTier tier, FluidStack stack, List<String> tooltip, boolean showAddedBy) {
        EntityPlayer clientPlayer = PlayerUtils.getClientPlayer();
        if (tier != null && clientPlayer != null && clientPlayer.field_70170_p != null) {
            if (stack != null) {
                tooltip.add(I18n.func_135052_a((String)"tooltip.gyth.capacity", (Object[])new Object[]{stack.amount, tier.getCapacity()}));
                tooltip.add(I18n.func_135052_a((String)"tooltip.gyth.contents", (Object[])new Object[0]) + ": " + stack.getLocalizedName());
            } else {
                tooltip.add(I18n.func_135052_a((String)"tooltip.gyth.capacity.upgrade", (Object[])new Object[]{tier.getCapacity() / 1000}));
            }
            tooltip.add(I18n.func_135052_a((String)"tooltip.gyth.block", (Object[])new Object[0]) + ": " + ItemStackUtils.getStackFromState((IBlockState)tier.renderState, (int)1).func_82833_r());
            tooltip.add(I18n.func_135052_a((String)"tooltip.gyth.tier", (Object[])new Object[0]) + ": " + tier.tier);
            if (ConfigurationHandler.handleTemperature && tier.isFlammable((IBlockAccess)clientPlayer.field_70170_p, BlockPos.field_177992_a, EnumFacing.UP)) {
                tooltip.add(ChatFormatting.RED + I18n.func_135052_a((String)"tooltip.gyth.flammable", (Object[])new Object[0]));
            }
            if (showAddedBy) {
                tooltip.add(I18n.func_135052_a((String)"tooltip.gyth.owner", (Object[])new Object[]{ChatFormatting.BLUE, ModUtils.getModName((String)tier.identifier.func_110624_b())}));
            }
            return;
        }
        tooltip.add(ChatFormatting.RED + "[WARNING] " + ChatFormatting.GRAY + I18n.func_135052_a((String)"tooltip.gyth.missing", (Object[])new Object[0]));
    }

    public static void removeTier(String modId, ResourceLocation tier) {
        if (REGISTRY.remove(tier) != null) {
            Constants.LOG.info("The tier " + tier.toString() + " was removed by " + modId);
        }
    }

    public static TankTier createTier(String modId, String name, Block block, int meta, Object recipe, int tier) {
        ResourceLocation identifier = new ResourceLocation(modId, name);
        TankTier tankTier = new TankTier(identifier, block.func_176203_a(meta), recipe, tier);
        REGISTRY.put(identifier, tankTier);
        return tankTier;
    }

    public static void printMarkdownTable(String modId) {
        System.out.println("|Name|Identifier|Tier|Capacity|Notes|");
        System.out.println("|----|----------|----|--------|-----|");
        for (TankTier tier : REGISTRY.values()) {
            if (!tier.identifier.func_110624_b().startsWith(modId)) continue;
            System.out.println(String.format("|%s|%s|%d|%s|%s|", ItemStackUtils.getStackFromState((IBlockState)tier.renderState, (int)1).func_82833_r(), tier.identifier.toString(), tier.tier, tier.getCapacity() / 1000 + "B", tier.isFlammable(null, null, null) ? "flammable" : ""));
        }
    }

    private static TankTier createTier(String name, Block block, int meta, Object recipe, int tier) {
        return GythApi.createTier("gyth", name, block, meta, recipe, tier);
    }
}

