/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.gyth;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.darkhax.bookshelf.lib.util.ItemStackUtils;
import net.darkhax.gyth.api.GythApi;
import net.darkhax.gyth.api.TankTier;
import net.darkhax.gyth.blocks.BlockTank;
import net.darkhax.gyth.common.ProxyCommon;
import net.darkhax.gyth.items.ItemBlockTank;
import net.darkhax.gyth.items.ItemTankUpgrade;
import net.darkhax.gyth.libs.ConfigurationHandler;
import net.darkhax.gyth.libs.Constants;
import net.darkhax.gyth.plugins.PluginMineTweaker;
import net.darkhax.gyth.tabs.CreativeTabGyth;
import net.darkhax.gyth.tileentity.TileEntityModularTank;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.ShapedOreRecipe;

@Mod(modid="gyth", name="Get Ya' Tanks Here", version="2.0.0.2", dependencies="required-after:bookshelf@[1.4.4.347,)", acceptedMinecraftVersions="[1.10.2]")
public class Gyth {
    @SidedProxy(serverSide="net.darkhax.gyth.common.ProxyCommon", clientSide="net.darkhax.gyth.client.ProxyClient")
    public static ProxyCommon proxy;
    @Mod.Instance(value="gyth")
    public static Gyth instance;
    public static Block blockModularTanks;
    public static Item itemTankUpgrade;
    public static Item itemBlockModularTank;
    public static CreativeTabs tabGyth;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ConfigurationHandler.initConfig(event.getSuggestedConfigurationFile());
        tabGyth = new CreativeTabGyth();
        blockModularTanks = new BlockTank();
        itemBlockModularTank = new ItemBlockTank(blockModularTanks);
        GameRegistry.register((IForgeRegistryEntry)blockModularTanks);
        GameRegistry.register((IForgeRegistryEntry)itemBlockModularTank);
        GameRegistry.registerTileEntity(TileEntityModularTank.class, (String)"modularTank");
        itemTankUpgrade = new ItemTankUpgrade();
        GameRegistry.register((IForgeRegistryEntry)itemTankUpgrade);
        proxy.registerBlockRenderers();
        if (Loader.isModLoaded((String)"MineTweaker3")) {
            PluginMineTweaker.registerSelf();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        GythApi.REGISTRY = GythApi.REGISTRY.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        proxy.registerBlockRenderers();
        for (TankTier tier : GythApi.REGISTRY.values()) {
            if (tier.tier == 1) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(GythApi.createTieredTank(tier), new Object[]{"xyx", "yzy", "xyx", Character.valueOf('x'), tier.recipe, Character.valueOf('y'), "paneGlass", Character.valueOf('z'), Items.field_151133_ar}));
            }
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(GythApi.createTierUpgrade(tier), new Object[]{"xyx", "yxy", "xyx", Character.valueOf('x'), tier.recipe, Character.valueOf('y'), "paneGlass"}));
        }
        if (Loader.isModLoaded((String)"Waila")) {
            FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"net.darkhax.gyth.plugins.PluginWaila.registerAddon");
        }
        if (Loader.isModLoaded((String)"theoneprobe")) {
            FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)"net.darkhax.gyth.plugins.PluginTOP$GetTheOneProbe");
        }
    }

    @Mod.EventHandler
    public void handleIMC(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage msg : event.getMessages()) {
            if (msg.key.equalsIgnoreCase("addTier") && msg.isNBTMessage()) {
                NBTTagCompound tag = msg.getNBTValue();
                String name = tag.func_74779_i("tierName");
                Block block = Block.func_149684_b((String)tag.func_74779_i("blockId"));
                int meta = tag.func_74762_e("meta");
                int tier = tag.func_74762_e("tier");
                Object recipe = this.getRecipeFromStackString(tag.func_74779_i("recipe"));
                if (!name.isEmpty() && block != null && meta >= 0 && tier >= 0 && recipe != null) {
                    GythApi.createTier(msg.getSender(), name, block, meta, recipe, Math.min(10, tier));
                    continue;
                }
                Constants.LOG.info(msg.getSender() + " tried to register a tier, but it failed.");
                continue;
            }
            if (!msg.key.equalsIgnoreCase("removeTier") || !msg.isResourceLocationMessage()) continue;
            GythApi.removeTier(msg.getSender(), msg.getResourceLocationValue());
        }
    }

    private Object getRecipeFromStackString(String string) {
        ItemStack stack = ItemStackUtils.createStackFromString((String)string);
        return ItemStackUtils.isValidStack((ItemStack)stack) ? stack : string;
    }
}

