/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import knightminer.ceramics.Ceramics;
import knightminer.ceramics.blocks.BlockBarrel;
import knightminer.ceramics.library.BarrelTank;
import knightminer.ceramics.tileentity.TileBarrelBase;
import knightminer.ceramics.tileentity.TileBarrelExtension;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileBarrel
extends TileBarrelBase {
    public static final int BASE_CAPACITY = 4000;
    public BlockPos topPos;
    private BarrelTank tank = new BarrelTank(4000, this);
    private int capacity = 4000;
    private int lastStrength = -1;
    public static final String TAG_TANK = "tank";
    public static final String TAG_TOP = "topPos";
    public static final String TAG_CAPACITY = "capacity";

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank);
        }
        return (T)super.getCapability(capability, facing);
    }

    public BarrelTank getTank() {
        return this.tank;
    }

    @Override
    public void checkBarrelStructure() {
        BlockPos topPos = this.field_174879_c.func_177984_a();
        IBlockState state = this.field_145850_b.func_180495_p(topPos);
        while (state.func_177230_c() instanceof BlockBarrel && ((BlockBarrel)state.func_177230_c()).isExtension(state)) {
            TileEntity te = this.field_145850_b.func_175625_s(topPos);
            if (te instanceof TileBarrelExtension) {
                ((TileBarrelExtension)te).setMaster(this.field_174879_c);
            }
            topPos = topPos.func_177984_a();
            state = this.field_145850_b.func_180495_p(topPos);
        }
        this.topPos = topPos.func_177977_b();
        int newCapacity = 4000 * (this.topPos.func_177956_o() + 1 - this.field_174879_c.func_177956_o());
        if (newCapacity != this.capacity) {
            this.capacity = newCapacity;
            this.tank.setCapacity(newCapacity);
            this.onTankContentsChanged();
        }
    }

    public int comparatorStrength() {
        return 15 * this.tank.getFluidAmount() / this.tank.getCapacity();
    }

    public void onTankContentsChanged() {
        int newStrength = this.comparatorStrength();
        if (newStrength != this.lastStrength) {
            this.lastStrength = newStrength;
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        int y = this.field_174879_c.func_177956_o();
        if (this.topPos != null) {
            y = this.topPos.func_177956_o();
        }
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(++y), (double)(this.field_174879_c.func_177952_p() + 1));
    }

    @SideOnly(value=Side.CLIENT)
    public void updateFluidTo(FluidStack fluid) {
        int oldAmount = this.tank.getFluidAmount();
        this.tank.setFluid(fluid);
        this.tank.renderOffset += this.tank.getFluidAmount() - oldAmount;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateCapacityTo(int capacity2) {
        this.tank.setCapacity(this.capacity);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        tags = super.func_189515_b(tags);
        tags.func_74782_a(TAG_TANK, (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        if (this.topPos != null) {
            NBTTagCompound top = new NBTTagCompound();
            top.func_74768_a("x", this.topPos.func_177958_n());
            top.func_74768_a("y", this.topPos.func_177956_o());
            top.func_74768_a("z", this.topPos.func_177952_p());
            tags.func_74782_a(TAG_TOP, (NBTBase)top);
        }
        tags.func_74768_a(TAG_CAPACITY, this.capacity);
        return tags;
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        NBTTagCompound tankTag = tags.func_74775_l(TAG_TANK);
        if (tankTag != null) {
            this.tank.readFromNBT(tankTag);
        } else {
            Ceramics.log.info("No tag");
        }
        NBTTagCompound top = tags.func_74775_l(TAG_TOP);
        if (top != null && top.func_74764_b("x") && top.func_74764_b("y") && top.func_74764_b("z")) {
            this.topPos = new BlockPos(top.func_74762_e("x"), top.func_74762_e("y"), top.func_74762_e("z"));
        }
        if (tags.func_74764_b(TAG_CAPACITY)) {
            this.capacity = tags.func_74762_e(TAG_CAPACITY);
            this.tank.setCapacity(this.capacity);
        }
    }
}

