/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.network;

import io.netty.buffer.ByteBuf;
import knightminer.ceramics.network.PacketBase;
import knightminer.ceramics.tileentity.TileBarrel;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class BarrelFluidUpdatePacket
extends PacketBase {
    public BlockPos pos;
    public FluidStack fluid;

    public BarrelFluidUpdatePacket() {
    }

    public BarrelFluidUpdatePacket(BlockPos pos, FluidStack fluid) {
        this.pos = pos;
        this.fluid = fluid;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = this.readPos(buf);
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
    }

    public void toBytes(ByteBuf buf) {
        this.writePos(this.pos, buf);
        NBTTagCompound tag = new NBTTagCompound();
        if (this.fluid != null) {
            this.fluid.writeToNBT(tag);
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static class BarrelFluidUpdateHandler
    implements IMessageHandler<BarrelFluidUpdatePacket, IMessage> {
        public IMessage onMessage(final BarrelFluidUpdatePacket message, MessageContext ctx) {
            PacketBase.getMainThread(ctx).func_152344_a(new Runnable(){

                @Override
                public void run() {
                    TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(message.pos);
                    if (te instanceof TileBarrel) {
                        ((TileBarrel)te).updateFluidTo(message.fluid);
                    }
                }
            });
            return null;
        }
    }
}

