/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.utils;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import oreexcavation.core.ExcavationSettings;

public class ToolEffectiveCheck {
    public static boolean canHarvestBlock(World world, IBlockState state, BlockPos pos, EntityPlayer player) {
        ItemStack held;
        if (world == null || state == null || pos == null || player == null) {
            return false;
        }
        if (!ExcavationSettings.openHand && player.func_184586_b(EnumHand.MAIN_HAND) == null) {
            return false;
        }
        if (ExcavationSettings.toolClass) {
            ItemStack held2 = player.func_184586_b(EnumHand.MAIN_HAND);
            if (held2 == null) {
                return false;
            }
            if (held2.func_77973_b() instanceof ItemShears && state.func_177230_c() instanceof IShearable) {
                return true;
            }
            for (String type : held2.func_77973_b().getToolClasses(held2)) {
                if (type.equalsIgnoreCase(state.func_177230_c().getHarvestTool(state)) && held2.func_77973_b().getHarvestLevel(held2, type, player, state) >= state.func_177230_c().getHarvestLevel(state)) {
                    return true;
                }
                if (!state.func_177230_c().isToolEffective(type, state)) continue;
                return true;
            }
            return false;
        }
        if (ExcavationSettings.altTools && (held = player.func_184586_b(EnumHand.MAIN_HAND)) != null && held.func_150997_a(state) > 1.0f) {
            return true;
        }
        return state.func_177230_c().canHarvestBlock((IBlockAccess)world, pos, player);
    }
}

