/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.superckl.api.superscript.util.ParameterTypes;
import me.superckl.biometweaker.common.handler.BiomeEventHandler;
import me.superckl.biometweaker.common.world.gen.feature.WorldGenDoublePlantBlank;
import me.superckl.biometweaker.config.Config;
import me.superckl.biometweaker.integration.IntegrationManager;
import me.superckl.biometweaker.util.LogHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.feature.WorldGenDoublePlant;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BiomeHelper {
    private static Field oceanTopBlock;
    private static Field oceanFillerBlock;
    private static Field grassColor;
    private static Field foliageColor;
    private static Field skyColor;
    private static Field biomeInfoMap;
    private static Field typeInfoList;
    private static Field typeList;
    private static Field biomes;
    private static Field isModded;
    private static Set<BiomeManager.BiomeType> logged;
    private static boolean loggedSpawn;
    private static boolean hasModded;

    public static JsonObject fillJsonObject(Biome biome, int ... coords) {
        JsonObject object;
        BiomeHelper.checkFields();
        JsonObject obj = new JsonObject();
        obj.addProperty("ID", (Number)Biome.func_185362_a((Biome)biome));
        obj.addProperty("Name", biome.func_185359_l());
        obj.addProperty("Class", biome.getClass().getName());
        obj.addProperty("Root Height", (Number)Float.valueOf(biome.func_185355_j()));
        obj.addProperty("Height Variation", (Number)Float.valueOf(biome.func_185360_m()));
        boolean topNull = biome.field_76752_A == null || biome.field_76752_A.func_177230_c() == null || biome.field_76752_A.func_177230_c().delegate == null;
        boolean bottomNull = biome.field_76752_A == null || biome.field_76752_A.func_177230_c() == null || biome.field_76752_A.func_177230_c().delegate == null;
        obj.addProperty("Top Block", topNull ? "ERROR" : biome.field_76752_A.func_177230_c().delegate.name().toString());
        obj.addProperty("Filler Block", bottomNull ? "ERROR" : biome.field_76753_B.func_177230_c().delegate.name().toString());
        try {
            int i = -1;
            boolean hasCoords = coords != null && coords.length == 3;
            int x = 0;
            int y = 0;
            int z = 0;
            if (hasCoords) {
                x = coords[0];
                y = coords[1];
                z = coords[2];
            }
            obj.addProperty("Grass Color", "" + (hasCoords ? Integer.valueOf(biome.func_180627_b(new BlockPos(x, y, z))) : ((i = grassColor.getInt(biome)) == -1 ? "Not set. Check in-game." : Integer.valueOf(i))));
            obj.addProperty("Foliage Color", "" + (hasCoords ? Integer.valueOf(biome.func_180625_c(new BlockPos(x, y, z))) : ((i = foliageColor.getInt(biome)) == -1 ? "Not set. Check in-game." : Integer.valueOf(i))));
            obj.addProperty("Water Color", "" + biome.getWaterColorMultiplier());
        }
        catch (Exception e) {
            LogHelper.error("Failed to retrieve inserted fields!");
            e.printStackTrace();
        }
        obj.addProperty("Temperature", (Number)Float.valueOf(biome.func_185353_n()));
        obj.addProperty("Humidity", (Number)Float.valueOf(biome.func_76727_i()));
        obj.addProperty("Water Tint", (Number)biome.getWaterColorMultiplier());
        obj.addProperty("Enable Rain", Boolean.valueOf(biome.field_76765_S));
        obj.addProperty("Enable Snow", Boolean.valueOf(biome.field_76766_R));
        JsonArray array = new JsonArray();
        for (BiomeDictionary.Type type : BiomeDictionary.getTypesForBiome((Biome)biome)) {
            array.add((JsonElement)new JsonPrimitive(type.toString()));
        }
        obj.add("Dictionary Types", (JsonElement)array);
        JsonObject managerWeights = new JsonObject();
        for (BiomeManager.BiomeType type : BiomeManager.BiomeType.values()) {
            JsonArray subArray = new JsonArray();
            ImmutableList entries = BiomeManager.getBiomes((BiomeManager.BiomeType)type);
            for (BiomeManager.BiomeEntry entry : entries) {
                if (Biome.func_185362_a((Biome)entry.biome) != Biome.func_185362_a((Biome)biome)) continue;
                subArray.add((JsonElement)new JsonPrimitive((Number)entry.field_76292_a));
            }
            if (subArray.size() <= 0) continue;
            managerWeights.add(type.name() + " Weights", (JsonElement)subArray);
        }
        obj.add("BiomeManager Entries", (JsonElement)managerWeights);
        array = new JsonArray();
        for (Object entity : biome.field_76762_K) {
            Biome.SpawnListEntry entry = (Biome.SpawnListEntry)entity;
            object = new JsonObject();
            object.addProperty("Entity Class", entry.field_76300_b.getName());
            object.addProperty("Weight", (Number)entry.field_76292_a);
            object.addProperty("Min Group Count", (Number)entry.field_76301_c);
            object.addProperty("Max Group Count", (Number)entry.field_76299_d);
            array.add((JsonElement)object);
        }
        obj.add("Spawnable Creatures", (JsonElement)array);
        array = new JsonArray();
        for (Object entity : biome.field_76761_J) {
            Biome.SpawnListEntry entry = (Biome.SpawnListEntry)entity;
            object = new JsonObject();
            object.addProperty("Entity Class", entry.field_76300_b.getName());
            object.addProperty("Weight", (Number)entry.field_76292_a);
            object.addProperty("Min Group Count", (Number)entry.field_76301_c);
            object.addProperty("Max Group Count", (Number)entry.field_76299_d);
            array.add((JsonElement)object);
        }
        obj.add("Spawnable Monsters", (JsonElement)array);
        array = new JsonArray();
        for (Object entity : biome.field_76755_L) {
            Biome.SpawnListEntry entry = (Biome.SpawnListEntry)entity;
            object = new JsonObject();
            object.addProperty("Entity Class", entry.field_76300_b.getName());
            object.addProperty("Weight", (Number)entry.field_76292_a);
            object.addProperty("Min Group Count", (Number)entry.field_76301_c);
            object.addProperty("Max Group Count", (Number)entry.field_76299_d);
            array.add((JsonElement)object);
        }
        obj.add("Spawnable Water Creatures", (JsonElement)array);
        array = new JsonArray();
        for (Object entity : biome.field_82914_M) {
            Biome.SpawnListEntry entry = (Biome.SpawnListEntry)entity;
            object = new JsonObject();
            object.addProperty("Entity Class", entry.field_76300_b.getName());
            object.addProperty("Weight", (Number)entry.field_76292_a);
            object.addProperty("Min Group Count", (Number)entry.field_76301_c);
            object.addProperty("Max Group Count", (Number)entry.field_76299_d);
            array.add((JsonElement)object);
        }
        obj.add("Spawnable Cave Creatures", (JsonElement)array);
        obj.add("Spawn Biome", (JsonElement)new JsonPrimitive(Boolean.valueOf(BiomeProvider.allowedBiomes.contains(biome))));
        obj.addProperty("Tweaked", Boolean.valueOf(Config.INSTANCE.getTweakedBiomes().contains(-1) || Config.INSTANCE.getTweakedBiomes().contains(Biome.func_185362_a((Biome)biome))));
        IntegrationManager.INSTANCE.addBiomeInfo(biome, obj);
        return obj;
    }

    public static void setBiomeProperty(String prop, JsonElement value, Biome biome) throws Exception {
        BiomeHelper.checkFields();
        int id = Biome.func_185362_a((Biome)biome);
        if (prop.equals("name")) {
            String toSet;
            biome.field_76791_y = toSet = (String)ParameterTypes.STRING.tryParse(value.getAsString());
        } else if (prop.equals("height")) {
            float toSet;
            biome.field_76748_D = toSet = value.getAsFloat();
        } else if (prop.equals("heightVariation")) {
            float toSet;
            biome.field_76749_E = toSet = value.getAsFloat();
        } else if (prop.equals("topBlock")) {
            String blockName = (String)ParameterTypes.STRING.tryParse(value.getAsString());
            try {
                Block block = Block.func_149684_b((String)blockName);
                if (block == null) {
                    throw new IllegalArgumentException("Failed to find block " + blockName + "! Tweak will not be applied.");
                }
                biome.field_76752_A = block.func_176223_P();
            }
            catch (Exception e) {
                LogHelper.info("Failed to parse block: " + blockName);
            }
        } else if (prop.equals("fillerBlock")) {
            String blockName = (String)ParameterTypes.STRING.tryParse(value.getAsString());
            try {
                Block block = Block.func_149684_b((String)blockName);
                if (block == null) {
                    throw new IllegalArgumentException("Failed to find block " + blockName + "! Tweak will not be applied.");
                }
                biome.field_76753_B = block.func_176223_P();
            }
            catch (Exception e) {
                LogHelper.info("Failed to parse block: " + blockName);
            }
        } else if (prop.equals("temperature")) {
            float toSet;
            biome.field_76750_F = toSet = value.getAsFloat();
        } else if (prop.equals("humidity")) {
            float toSet;
            biome.field_76751_G = toSet = value.getAsFloat();
        } else if (prop.equals("waterTint")) {
            int toSet;
            biome.field_76759_H = toSet = value.getAsInt();
        } else if (prop.equals("enableRain")) {
            boolean toSet;
            biome.field_76765_S = toSet = value.getAsBoolean();
        } else if (prop.equals("enableSnow")) {
            boolean toSet;
            biome.field_76766_R = toSet = value.getAsBoolean();
        } else if (prop.equals("grassColor")) {
            int toSet = value.getAsInt();
            grassColor.set(biome, toSet);
        } else if (prop.equals("foliageColor")) {
            int toSet = value.getAsInt();
            foliageColor.set(biome, toSet);
        } else if (prop.equals("waterColor")) {
            int toSet;
            biome.field_76759_H = toSet = value.getAsInt();
        } else if (prop.equals("skyColor")) {
            int toSet = value.getAsInt();
            skyColor.set(biome, toSet);
        } else if (prop.equals("fillerBlockMeta")) {
            if (biome.field_76753_B != null) {
                biome.field_76753_B = biome.field_76753_B.func_177230_c().func_176203_a(value.getAsInt());
            }
        } else if (prop.equals("topBlockMeta")) {
            if (biome.field_76752_A != null) {
                biome.field_76752_A = biome.field_76752_A.func_177230_c().func_176203_a(value.getAsInt());
            }
        } else if (prop.equals("waterliliesPerChunk")) {
            BiomeEventHandler.getWaterlilyPerChunk().put(id, value.getAsInt());
        } else if (prop.equals("treesPerChunk")) {
            BiomeEventHandler.getTreesPerChunk().put(id, value.getAsInt());
        } else if (prop.equals("flowersPerChunk")) {
            BiomeEventHandler.getFlowersPerChunk().put(id, value.getAsInt());
        } else if (prop.equals("grassPerChunk")) {
            BiomeEventHandler.getGrassPerChunk().put(id, value.getAsInt());
        } else if (prop.equals("deadbushesPerChunk")) {
            BiomeEventHandler.getDeadBushPerChunk().put(id, value.getAsInt());
        } else if (prop.equals("mushroomsPerChunk")) {
            BiomeEventHandler.getMushroomPerChunk().put(id, value.getAsInt());
        } else if (prop.equals("reedsPerChunk")) {
            BiomeEventHandler.getReedsPerChunk().put(id, value.getAsInt());
        } else if (prop.equals("cactiPerChunk")) {
            BiomeEventHandler.getCactiPerChunk().put(id, value.getAsInt());
        } else if (prop.equals("sandPerChunk")) {
            BiomeEventHandler.getSandPerChunk().put(id, value.getAsInt());
        } else if (prop.equals("clayPerChunk")) {
            BiomeEventHandler.getClayPerChunk().put(id, value.getAsInt());
        } else if (prop.equals("bigMushroomsPerChunk")) {
            BiomeEventHandler.getBigMushroomsPerChunk().put(id, value.getAsInt());
        } else if (prop.equals("genWeight")) {
            int weight = value.getAsInt();
            for (BiomeManager.BiomeType type : BiomeManager.BiomeType.values()) {
                ImmutableList entries = BiomeManager.getBiomes((BiomeManager.BiomeType)type);
                for (BiomeManager.BiomeEntry entry : entries) {
                    if (Biome.func_185362_a((Biome)entry.biome) != id) continue;
                    entry.field_76292_a = weight;
                }
                if (type == BiomeManager.BiomeType.DESERT || logged.contains(type) || WeightedRandom.func_76272_a((List)entries) > 0) continue;
                LogHelper.warn("Sum of biome generation weights for type " + type + " is zero! This will cause Vanilla generation to crash! You have been warned!");
                logged.add(type);
            }
            BiomeHelper.modTypeLists();
        } else if (prop.equals("genVillages")) {
            if (value.getAsBoolean()) {
                BiomeManager.addVillageBiome((Biome)biome, (boolean)true);
            } else {
                BiomeManager.removeVillageBiome((Biome)biome);
            }
        } else if (prop.equals("genStrongholds")) {
            if (value.getAsBoolean()) {
                BiomeManager.removeStrongholdBiome((Biome)biome);
            } else {
                BiomeManager.addStrongholdBiome((Biome)biome);
            }
        } else if (prop.equals("isSpawnBiome")) {
            if (value.getAsBoolean()) {
                BiomeManager.addSpawnBiome((Biome)biome);
            } else {
                BiomeManager.removeSpawnBiome((Biome)biome);
                if (!loggedSpawn && BiomeProvider.allowedBiomes.size() == 0) {
                    LogHelper.warn("Upon removal of biome " + id + " the allowed spawn list appears to be empty. If you aren't adding one later, this will cause a crash.");
                    loggedSpawn = true;
                }
            }
        } else if (prop.equals("genTallPlants")) {
            Biome.field_180280_ag = value.getAsBoolean() ? new WorldGenDoublePlant() : new WorldGenDoublePlantBlank();
        } else if (prop.equals("oceanTopBlock")) {
            String blockName = (String)ParameterTypes.STRING.tryParse(value.getAsString());
            try {
                Block block = Block.func_149684_b((String)blockName);
                if (block == null) {
                    throw new IllegalArgumentException("Failed to find block " + blockName + "! Tweak will not be applied.");
                }
                oceanTopBlock.set(biome, block.func_176223_P());
            }
            catch (Exception e) {
                LogHelper.info("Failed to parse block: " + blockName);
            }
        } else if (prop.equals("oceanFillerBlock")) {
            String blockName = (String)ParameterTypes.STRING.tryParse(value.getAsString());
            try {
                Block block = Block.func_149684_b((String)blockName);
                if (block == null) {
                    throw new IllegalArgumentException("Failed to find block " + blockName + "! Tweak will not be applied.");
                }
                oceanFillerBlock.set(biome, block.func_176223_P());
            }
            catch (Exception e) {
                LogHelper.info("Failed to parse block: " + blockName);
            }
        } else if (prop.equals("oceanFillerBlockMeta")) {
            IBlockState state = (IBlockState)oceanFillerBlock.get(biome);
            if (state != null) {
                oceanFillerBlock.set(biome, state.func_177230_c().func_176203_a(value.getAsInt()));
            }
        } else if (prop.equals("oceanTopBlockMeta")) {
            IBlockState state = (IBlockState)oceanTopBlock.get(biome);
            if (state != null) {
                oceanTopBlock.set(biome, state.func_177230_c().func_176203_a(value.getAsInt()));
            }
        } else if (prop.equals("contiguousReplacement")) {
            BiomeEventHandler.getContigReplaces()[Biome.func_185362_a((Biome)biome)] = value.getAsBoolean();
        } else {
            LogHelper.warn("Attempted to set property " + prop + " but corresponding property was not found for biomes. Value: " + value.getAsString());
        }
    }

    private static void checkFields() {
        try {
            if (oceanTopBlock == null) {
                oceanTopBlock = Biome.class.getDeclaredField("oceanTopBlock");
            }
            if (oceanFillerBlock == null) {
                oceanFillerBlock = Biome.class.getDeclaredField("oceanFillerBlock");
            }
            if (grassColor == null) {
                grassColor = Biome.class.getDeclaredField("grassColor");
            }
            if (foliageColor == null) {
                foliageColor = Biome.class.getDeclaredField("foliageColor");
            }
            if (skyColor == null) {
                skyColor = Biome.class.getDeclaredField("skyColor");
            }
            if (biomeInfoMap == null) {
                biomeInfoMap = BiomeDictionary.class.getDeclaredField("biomeInfoMap");
                biomeInfoMap.setAccessible(true);
            }
            if (typeInfoList == null) {
                typeInfoList = BiomeDictionary.class.getDeclaredField("typeInfoList");
                typeInfoList.setAccessible(true);
            }
            if (biomes == null) {
                biomes = BiomeManager.class.getDeclaredField("biomes");
                biomes.setAccessible(true);
            }
        }
        catch (Exception e) {
            LogHelper.error("Failed to find inserted fields!");
            e.printStackTrace();
        }
    }

    public static int callGrassColorEvent(int color, Biome gen) {
        BiomeEvent.GetGrassColor e = new BiomeEvent.GetGrassColor(gen, color);
        MinecraftForge.EVENT_BUS.post((Event)e);
        return e.getNewColor();
    }

    public static int callFoliageColorEvent(int color, Biome gen) {
        BiomeEvent.GetFoliageColor e = new BiomeEvent.GetFoliageColor(gen, color);
        MinecraftForge.EVENT_BUS.post((Event)e);
        return e.getNewColor();
    }

    public static int callWaterColorEvent(int color, Biome gen) {
        BiomeEvent.GetWaterColor e = new BiomeEvent.GetWaterColor(gen, color);
        MinecraftForge.EVENT_BUS.post((Event)e);
        return e.getNewColor();
    }

    public static void modifyBiomeDicType(Biome gen, BiomeDictionary.Type type, boolean remove) throws Exception {
        BiomeHelper.checkFields();
        if (gen == null) {
            return;
        }
        List[] listArray = (List[])typeInfoList.get(null);
        if (listArray.length > type.ordinal()) {
            List list = listArray[type.ordinal()];
            if (list == null) {
                listArray[type.ordinal()] = list = Lists.newArrayList();
            }
            if (remove) {
                list.remove(gen);
            } else if (!list.contains(gen)) {
                list.add(gen);
            }
        }
        Map map = (Map)biomeInfoMap.get(null);
        Object biomeInfo = map.get(Biome.field_185377_q.func_177774_c((Object)gen));
        if (typeList == null) {
            typeList = biomeInfo.getClass().getDeclaredField("typeList");
            typeList.setAccessible(true);
        }
        EnumSet set = (EnumSet)typeList.get(biomeInfo);
        if (remove) {
            set.remove(type);
        } else if (!set.contains(type)) {
            set.add(type);
        }
    }

    public static void removeAllBiomeDicType(Biome gen) throws Exception {
        BiomeHelper.checkFields();
        if (gen == null) {
            return;
        }
        Object array = biomeInfoMap.get(null);
        Object biomeInfo = Array.get(array, Biome.func_185362_a((Biome)gen));
        if (typeList == null) {
            typeList = biomeInfo.getClass().getDeclaredField("typeList");
            typeList.setAccessible(true);
        }
        EnumSet set = (EnumSet)typeList.get(biomeInfo);
        List[] listArray = (List[])typeInfoList.get(null);
        for (BiomeDictionary.Type type : set) {
            listArray[type.ordinal()].remove(gen);
        }
        set.clear();
    }

    public static void modTypeLists() throws Exception {
        BiomeHelper.checkFields();
        if (hasModded) {
            return;
        }
        Object array = biomes.get(null);
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object list = Array.get(array, i);
            if (isModded == null) {
                isModded = list.getClass().getDeclaredField("isModded");
                isModded.setAccessible(true);
            }
            isModded.setBoolean(list, true);
        }
        hasModded = true;
    }

    static {
        logged = EnumSet.noneOf(BiomeManager.BiomeType.class);
    }
}

