/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.script.command.generation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.superckl.api.biometweaker.event.BiomeTweakEvent;
import me.superckl.api.biometweaker.script.pack.IBiomePackage;
import me.superckl.api.superscript.command.IScriptCommand;
import me.superckl.biometweaker.common.handler.BiomeEventHandler;
import me.superckl.biometweaker.config.Config;
import net.minecraft.block.Block;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.commons.lang3.tuple.Pair;

public class ScriptCommandRegisterBlockReplacement
implements IScriptCommand {
    private final IBiomePackage pack;
    private final int weight;
    private final String toReplace;
    private final Integer toReplaceMeta;
    private final String replaceWith;
    private final Integer replaceWithMeta;

    public ScriptCommandRegisterBlockReplacement(IBiomePackage pack, int weight, String block1, Integer toReplaceMeta, String block2, Integer replaceWithMeta) {
        this.weight = weight;
        this.pack = pack;
        this.toReplace = block1;
        this.replaceWith = block2;
        this.toReplaceMeta = toReplaceMeta;
        this.replaceWithMeta = replaceWithMeta;
    }

    public ScriptCommandRegisterBlockReplacement(IBiomePackage pack, String block1, Integer toReplaceMeta, String block2, Integer replaceWithMeta) {
        this(pack, 1, block1, toReplaceMeta, block2, replaceWithMeta);
    }

    public ScriptCommandRegisterBlockReplacement(IBiomePackage pack, String block1, String block2, Integer replaceWithMeta) {
        this(pack, block1, null, block2, replaceWithMeta);
    }

    public ScriptCommandRegisterBlockReplacement(IBiomePackage pack, int weight, String block1, String block2, Integer replaceWithMeta) {
        this(pack, weight, block1, null, block2, replaceWithMeta);
    }

    public ScriptCommandRegisterBlockReplacement(IBiomePackage pack, String block1, Integer toReplaceMeta, String block2) {
        this(pack, block1, toReplaceMeta, block2, null);
    }

    public ScriptCommandRegisterBlockReplacement(IBiomePackage pack, int weight, String block1, Integer toReplaceMeta, String block2) {
        this(pack, weight, block1, toReplaceMeta, block2, null);
    }

    public ScriptCommandRegisterBlockReplacement(IBiomePackage pack, String block1, String block2) {
        this(pack, block1, null, block2, null);
    }

    public ScriptCommandRegisterBlockReplacement(IBiomePackage pack, int weight, String block1, String block2) {
        this(pack, weight, block1, null, block2, null);
    }

    @Override
    public void perform() throws Exception {
        Iterator<Biome> it = this.pack.getIterator();
        Block toReplace = Block.func_149684_b((String)this.toReplace);
        if (toReplace == null) {
            throw new IllegalArgumentException("Failed to find block " + this.toReplace + "! Tweak will not be applied.");
        }
        Block replaceWith = Block.func_149684_b((String)this.replaceWith);
        if (replaceWith == null) {
            throw new IllegalArgumentException("Failed to find block " + this.replaceWith + "! Tweak will not be applied.");
        }
        while (it.hasNext()) {
            Biome gen = it.next();
            if (MinecraftForge.EVENT_BUS.post((Event)new BiomeTweakEvent.RegisterGenBlockReplacement(this, this.weight, gen, toReplace, this.toReplaceMeta, replaceWith, this.replaceWithMeta))) continue;
            if (!BiomeEventHandler.getBlockReplacements().containsKey(Biome.func_185362_a((Biome)gen))) {
                BiomeEventHandler.getBlockReplacements().put(Biome.func_185362_a((Biome)gen), new ArrayList());
            }
            List list = (List)BiomeEventHandler.getBlockReplacements().get(Biome.func_185362_a((Biome)gen));
            Pair toReplacePair = Pair.of((Object)toReplace, (Object)this.toReplaceMeta);
            List entries = null;
            for (Pair pair : list) {
                if (!((Pair)pair.getKey()).equals((Object)toReplacePair)) continue;
                entries = (List)pair.getValue();
                break;
            }
            if (entries == null) {
                entries = Lists.newArrayList();
                list.add(Pair.of((Object)toReplacePair, (Object)entries));
            }
            entries.add(new BiomeEventHandler.WeightedBlockEntry(this.weight, (Pair<Block, Integer>)Pair.of((Object)replaceWith, (Object)this.replaceWithMeta)));
            Config.INSTANCE.onTweak(Biome.func_185362_a((Biome)gen));
        }
    }
}

