/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.script.command.entity;

import java.beans.ConstructorProperties;
import java.util.Iterator;
import me.superckl.api.biometweaker.event.BiomeTweakEvent;
import me.superckl.api.biometweaker.script.pack.IBiomePackage;
import me.superckl.api.biometweaker.util.SpawnListType;
import me.superckl.api.superscript.command.IScriptCommand;
import me.superckl.biometweaker.config.Config;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ScriptCommandRemoveAllSpawns
implements IScriptCommand {
    private final IBiomePackage pack;
    private final SpawnListType type;

    @Override
    public void perform() throws Exception {
        Iterator<Biome> it = this.pack.getIterator();
        while (it.hasNext()) {
            Biome gen = it.next();
            if (MinecraftForge.EVENT_BUS.post((Event)new BiomeTweakEvent.RemoveAllSpawns(this, gen, this.type))) continue;
            this.removeEntries(gen, this.type);
            Config.INSTANCE.onTweak(Biome.func_185362_a((Biome)gen));
        }
    }

    private void removeEntries(Biome gen, SpawnListType type) {
        switch (this.type) {
            case CAVE_CREATURE: {
                gen.field_82914_M.clear();
                break;
            }
            case CREATURE: {
                gen.field_76762_K.clear();
                break;
            }
            case MONSTER: {
                gen.field_76761_J.clear();
                break;
            }
            case WATER_CREATURE: {
                gen.field_76755_L.clear();
            }
        }
    }

    @ConstructorProperties(value={"pack", "type"})
    public ScriptCommandRemoveAllSpawns(IBiomePackage pack, SpawnListType type) {
        this.pack = pack;
        this.type = type;
    }
}

