/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.integration;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.superckl.biometweaker.integration.IIntegrationModule;
import me.superckl.biometweaker.util.LogHelper;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.Loader;

public class IntegrationManager
implements IIntegrationModule {
    public static final IntegrationManager INSTANCE = new IntegrationManager();
    private static final Map<List<String>, String> modules = new HashMap<List<String>, String>();
    private final List<IIntegrationModule> activeModules = Lists.newArrayList();

    private IntegrationManager() {
    }

    @Override
    public void preInit() {
        boolean noGo = false;
        for (Map.Entry<List<String>, String> entry : modules.entrySet()) {
            for (String mod : entry.getKey()) {
                if (Loader.isModLoaded((String)mod)) continue;
                noGo = true;
                break;
            }
            if (noGo) continue;
            try {
                IIntegrationModule module = (IIntegrationModule)Class.forName(entry.getValue()).newInstance();
                this.activeModules.add(module);
                LogHelper.info("Enabled " + module.getName() + " module.");
            }
            catch (Exception e) {
                LogHelper.error("Failed to instantiate integration module " + entry.getValue());
                e.printStackTrace();
            }
        }
        for (IIntegrationModule module : this.activeModules) {
            module.preInit();
        }
    }

    @Override
    public void init() {
        for (IIntegrationModule module : this.activeModules) {
            module.init();
        }
    }

    @Override
    public void postInit() {
        for (IIntegrationModule module : this.activeModules) {
            module.postInit();
        }
    }

    @Override
    public String getName() {
        return "BiomeTweaker Integration Manager";
    }

    @Override
    public void addBiomeInfo(Biome biome, JsonObject obj) {
        for (IIntegrationModule module : this.activeModules) {
            module.addBiomeInfo(biome, obj);
        }
    }

    public List<IIntegrationModule> getActiveModules() {
        return this.activeModules;
    }

    static {
        modules.put(Arrays.asList("BiomesOPlenty"), "me.superckl.biometweaker.integration.bop.BOPIntegrationModule");
    }
}

