/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.core.module;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import me.superckl.biometweaker.config.Config;
import me.superckl.biometweaker.core.ASMNameHelper;
import me.superckl.biometweaker.core.ModBiomeTweakerCore;
import me.superckl.biometweaker.core.module.IClassTransformerModule;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import squeek.asmhelper.me.superckl.biometweaker.ASMHelper;
import squeek.asmhelper.me.superckl.biometweaker.ObfHelper;

public class ModuleBiomeGenBaseSubclass
implements IClassTransformerModule {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        ClassReader reader = new ClassReader(basicClass);
        if (ASMHelper.doesClassExtend(reader, ObfHelper.isObfuscated() ? "aig" : "net/minecraft/world/biome/Biome")) {
            ClassNode cNode = new ClassNode();
            reader.accept((ClassVisitor)cNode, 0);
            for (MethodNode mNode : cNode.methods) {
                AbstractInsnNode node;
                InsnList list;
                AbstractInsnNode aNode;
                if (mNode.name.equals(ASMNameHelper.method_getBiomeGrassColor.get()) && mNode.desc.equals("(III)I")) {
                    boolean shouldCont = false;
                    aNode = mNode.instructions.get(mNode.instructions.size() - 2);
                    if (aNode instanceof MethodInsnNode) {
                        MethodInsnNode methNode = (MethodInsnNode)aNode;
                        if (methNode.name.equals("getModdedBiomeGrassColor") && methNode.desc.equals("(I)I") && methNode.owner.equals("net/minecraft/world/biome/Biome")) {
                            shouldCont = true;
                            break;
                        }
                    }
                    if (shouldCont) continue;
                    ModBiomeTweakerCore.logger.debug("Found Biome subclass " + transformedName + " with overriden grass color method and no event call. Attempting to force modded color event call...");
                    for (AbstractInsnNode aINode : this.findReturnNodes(mNode.instructions)) {
                        list = new InsnList();
                        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                        list.add((AbstractInsnNode)new MethodInsnNode(184, "me/superckl/biometweaker/util/BiomeHelper", "callGrassColorEvent", "(ILnet/minecraft/world/biome/Biome;)I", false));
                        mNode.instructions.insertBefore(aINode, list);
                    }
                    continue;
                }
                if (mNode.name.equals(ASMNameHelper.method_getBiomeFoliageColor.get()) && mNode.desc.equals("(III)I")) {
                    boolean shouldCont = false;
                    aNode = mNode.instructions.get(mNode.instructions.size() - 2);
                    if (aNode instanceof MethodInsnNode) {
                        MethodInsnNode methNode = (MethodInsnNode)aNode;
                        if (methNode.name.equals("getModdedBiomeFoliageColor") && methNode.desc.equals("(I)I") && methNode.owner.equals("net/minecraft/world/biome/Biome")) {
                            shouldCont = true;
                            break;
                        }
                    }
                    if (shouldCont) continue;
                    ModBiomeTweakerCore.logger.debug("Found Biome subclass " + transformedName + " with overriden foliage color method and no event call. Attempting to force modded color event call...");
                    for (AbstractInsnNode aINode : this.findReturnNodes(mNode.instructions)) {
                        list = new InsnList();
                        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                        list.add((AbstractInsnNode)new MethodInsnNode(184, "me/superckl/biometweaker/util/BiomeHelper", "callFoliageColorEvent", "(ILnet/minecraft/world/biome/Biome;)I", false));
                        mNode.instructions.insertBefore(aINode, list);
                    }
                    continue;
                }
                if (mNode.name.equals("getWaterColorMultiplier") && mNode.desc.equals("()I")) {
                    ModBiomeTweakerCore.logger.debug("Found Biome subclass " + transformedName + " with overriden water color method. Attempting to force modded color event call...");
                    for (AbstractInsnNode aINode : this.findReturnNodes(mNode.instructions)) {
                        InsnList list2 = new InsnList();
                        list2.add((AbstractInsnNode)new VarInsnNode(25, 0));
                        list2.add((AbstractInsnNode)new MethodInsnNode(184, "me/superckl/biometweaker/util/BiomeHelper", "callFoliageColorEvent", "(ILnet/minecraft/world/biome/Biome;)I", false));
                        mNode.instructions.insertBefore(aINode, list2);
                    }
                    continue;
                }
                if (!Config.INSTANCE.isRemoveLateAssignments() || !mNode.name.equals(ASMNameHelper.method_genTerrainBlocks.get()) || !mNode.desc.equals(ASMNameHelper.desc_genTerrainBlocks.get())) continue;
                AbstractInsnNode nextNode = node = ASMHelper.findFirstInstruction(mNode);
                int removed = 0;
                do {
                    try {
                        AbstractInsnNode prevNode;
                        nextNode = node.getNext();
                        if (!(node instanceof FieldInsnNode)) continue;
                        FieldInsnNode fNode = (FieldInsnNode)node;
                        if (!fNode.name.equals(ASMNameHelper.field_topBlock.get()) && !fNode.name.equals(ASMNameHelper.field_fillerBlock.get()) || !fNode.desc.equals("Lnet/minecraft/block/state/IBlockState;") || (prevNode = ASMHelper.findPreviousInstruction((AbstractInsnNode)fNode)) == null || !(prevNode instanceof MethodInsnNode) || prevNode.getOpcode() != 182 && prevNode.getOpcode() != 185) continue;
                        MethodInsnNode prevMNode = (MethodInsnNode)prevNode;
                        if (!prevMNode.name.equals(ASMNameHelper.method_getDefaultState.get()) || !prevMNode.desc.equals("()Lnet/minecraft/block/state/IBlockState;")) {
                            prevNode = ASMHelper.findPreviousInstruction(ASMHelper.findPreviousInstruction(ASMHelper.findPreviousInstruction((AbstractInsnNode)prevMNode)));
                            if (prevNode == null || !(prevNode instanceof MethodInsnNode) || prevNode.getOpcode() != 182) continue;
                            prevMNode = (MethodInsnNode)prevNode;
                        }
                        if (!prevMNode.name.equals(ASMNameHelper.method_getDefaultState.get()) || !prevMNode.desc.equals("()Lnet/minecraft/block/state/IBlockState;") || (prevNode = ASMHelper.findPreviousInstruction((AbstractInsnNode)prevMNode)) == null || !(prevNode instanceof FieldInsnNode) || prevNode.getOpcode() != 178) continue;
                        FieldInsnNode prevFNode = (FieldInsnNode)prevNode;
                        if (!prevFNode.desc.equals("Lnet/minecraft/block/Block;") && !ASMHelper.doesClassExtend(ASMHelper.getClassReaderForClassName(Type.getType((String)prevFNode.desc).getClassName()), "net/minecraft/block/Block") || (prevNode = ASMHelper.findPreviousInstruction((AbstractInsnNode)prevFNode)) == null || !(prevNode instanceof VarInsnNode) || prevNode.getOpcode() != 25 || ((VarInsnNode)prevNode).var != 0) continue;
                        ASMHelper.removeFromInsnListUntil(mNode.instructions, prevNode, nextNode);
                        ++removed;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } while ((node = ASMHelper.findNextInstructionWithOpcode(nextNode, 181)) != null);
                if (removed <= 0) continue;
                ModBiomeTweakerCore.logger.warn("Found Biome subclass " + transformedName + " that was setting topBlock or fillerBlock in genTerrainBlocks! This is bad practice and breaks functionality in BiomeTweaker! " + removed + " items were removed. If this is not a vanilla biome, please let me (superckl) know.");
                ModBiomeTweakerCore.logger.info("If you feel the removal of this is causing issues with a modded biome, add this class to the ASM blacklist in the config and let me know. I apologize for the wall of text, but this is important.");
            }
            return ASMHelper.writeClassToBytes(cNode);
        }
        return basicClass;
    }

    @Override
    public String[] getClassesToTransform() {
        return new String[]{"*"};
    }

    @Override
    public String getModuleName() {
        return "moduleTransformBiomeSubclass";
    }

    @Override
    public boolean isRequired() {
        return false;
    }

    private List<AbstractInsnNode> findReturnNodes(InsnList instructions) {
        ArrayList<AbstractInsnNode> list = new ArrayList<AbstractInsnNode>();
        for (int i = instructions.size() - 1; i >= 0; --i) {
            if (instructions.get(i).getOpcode() != 172) continue;
            list.add(instructions.get(i));
        }
        return list;
    }
}

