/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.core.module;

import me.superckl.biometweaker.core.ASMNameHelper;
import me.superckl.biometweaker.core.BiomeTweakerCore;
import me.superckl.biometweaker.core.ModBiomeTweakerCore;
import me.superckl.biometweaker.core.module.IClassTransformerModule;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import squeek.asmhelper.me.superckl.biometweaker.ASMHelper;

public class ModuleBiomeGenBase
implements IClassTransformerModule {
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        ClassNode cNode = ASMHelper.readClassFromBytes(bytes);
        ModBiomeTweakerCore.logger.info("Attempting to patch class " + transformedName + "...");
        cNode.visitField(1, "actualFillerBlocks", "[Lnet/minecraft/block/state/IBlockState;", "[Lnet/minecraft/block/state/IBlockState;", null);
        ModBiomeTweakerCore.logger.debug("Successfully inserted 'actualFillerBlocks' field into " + transformedName);
        cNode.visitField(1, "oceanTopBlock", "Lnet/minecraft/block/state/IBlockState;", "Lnet/minecraft/block/state/IBlockState;", null);
        ModBiomeTweakerCore.logger.debug("Successfully inserted 'oceanTopBlock' field into " + transformedName);
        cNode.visitField(1, "oceanFillerBlock", "Lnet/minecraft/block/state/IBlockState;", "Lnet/minecraft/block/state/IBlockState;", null);
        ModBiomeTweakerCore.logger.debug("Successfully inserted 'oceanFillerBlock' field into " + transformedName);
        cNode.visitField(1, "grassColor", "I", "I", (Object)-1);
        ModBiomeTweakerCore.logger.debug("Successfully inserted 'grassColor' field into " + transformedName);
        cNode.visitField(1, "foliageColor", "I", "I", (Object)-1);
        ModBiomeTweakerCore.logger.debug("Successfully inserted 'foliageColor' field into " + transformedName);
        cNode.visitField(1, "skyColor", "I", "I", (Object)-1);
        ModBiomeTweakerCore.logger.debug("Successfully inserted 'skyColor' field into " + transformedName);
        int fixed = 6;
        boolean sky = false;
        for (MethodNode node : cNode.methods) {
            InsnList list;
            if (node.name.equals(ASMNameHelper.method_genBiomeTerrain.get()) && node.desc.equals(ASMNameHelper.desc_genBiomeTerrain.get())) {
                AbstractInsnNode aaNode;
                AbstractInsnNode someNode;
                InsnList toFind = new InsnList();
                toFind.add((AbstractInsnNode)new VarInsnNode(25, 17));
                toFind.add((AbstractInsnNode)new MethodInsnNode(185, "net/minecraft/block/state/IBlockState", ASMNameHelper.method_getBlock.get(), "()Lnet/minecraft/block/Block;", true));
                toFind.add((AbstractInsnNode)new FieldInsnNode(178, "net/minecraft/init/Blocks", ASMNameHelper.field_stone.get(), "Lnet/minecraft/block/Block;"));
                AbstractInsnNode found = ASMHelper.find(node.instructions, toFind);
                if (found != null && (someNode = found.getNext().getNext().getNext()) instanceof JumpInsnNode && someNode.getOpcode() == 166) {
                    ((JumpInsnNode)someNode).setOpcode(153);
                    InsnList toInsert = new InsnList();
                    toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    toInsert.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/biome/Biome", "actualFillerBlocks", "[Lnet/minecraft/block/state/IBlockState;"));
                    toInsert.add((AbstractInsnNode)new VarInsnNode(25, 17));
                    toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "me/superckl/biometweaker/BiomeHooks", "contains", "([Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/block/state/IBlockState;)Z", false));
                    if (ASMHelper.findAndReplace(node.instructions, toFind, toInsert) != null) {
                        ModBiomeTweakerCore.logger.debug("Successfully redirected 'Stone' check to 'contains' method.");
                        ++fixed;
                    }
                }
                toFind = new InsnList();
                toFind.add((AbstractInsnNode)new VarInsnNode(25, 3));
                toFind.add((AbstractInsnNode)new VarInsnNode(21, 14));
                toFind.add((AbstractInsnNode)new VarInsnNode(21, 16));
                toFind.add((AbstractInsnNode)new VarInsnNode(21, 13));
                toFind.add((AbstractInsnNode)new FieldInsnNode(178, "net/minecraft/world/biome/Biome", ASMNameHelper.field_BiomeGenBase_gravel.get(), "Lnet/minecraft/block/state/IBlockState;"));
                toFind.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/world/chunk/ChunkPrimer", ASMNameHelper.method_setBlockState.get(), "(IIILnet/minecraft/block/state/IBlockState;)V", false));
                AbstractInsnNode aNode = ASMHelper.find(node.instructions, toFind);
                if (aNode == null || (aaNode = ASMHelper.findNextInstructionWithOpcode(aNode, 178)) == null) continue;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/biome/Biome", "oceanTopBlock", "Lnet/minecraft/block/state/IBlockState;"));
                node.instructions.insert(aaNode, toInsert);
                node.instructions.remove(aaNode);
                ModBiomeTweakerCore.logger.debug("Successfully inserted 'oceanTopBlock' instructions.");
                ++fixed;
                aNode = ASMHelper.findPreviousInstructionWithOpcode(aNode, 178);
                toFind = new InsnList();
                toFind.add((AbstractInsnNode)new FieldInsnNode(178, "net/minecraft/world/biome/Biome", ASMNameHelper.field_BiomeGenBase_stone.get(), "Lnet/minecraft/block/state/IBlockState;"));
                toFind.add((AbstractInsnNode)new VarInsnNode(58, 10));
                if ((aNode = ASMHelper.find(aNode, toFind)) == null) continue;
                InsnList toInsert1 = new InsnList();
                toInsert1.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert1.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/biome/Biome", "oceanFillerBlock", "Lnet/minecraft/block/state/IBlockState;"));
                node.instructions.insert(aNode, toInsert1);
                node.instructions.remove(aNode);
                ModBiomeTweakerCore.logger.debug("Successfully inserted 'oceanFillerBlock' instructions.");
                ++fixed;
                continue;
            }
            if (node.name.equals(ASMNameHelper.method_getSkyColorByTemp.get()) && node.desc.equals("(F)I")) {
                list = new InsnList();
                list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/biome/Biome", "skyColor", "I"));
                list.add((AbstractInsnNode)new InsnNode(2));
                LabelNode label = new LabelNode();
                list.add((AbstractInsnNode)new JumpInsnNode(159, label));
                list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/biome/Biome", "skyColor", "I"));
                list.add((AbstractInsnNode)new InsnNode(172));
                list.add((AbstractInsnNode)label);
                node.instructions.insertBefore(node.instructions.getFirst(), list);
                ModBiomeTweakerCore.logger.debug("Successfully inserted sky color instructions.");
                sky = true;
                continue;
            }
            if (!node.name.equals("<init>") || !node.desc.equals("(Lnet/minecraft/world/biome/Biome$BiomeProperties;)V")) continue;
            list = new InsnList();
            list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new InsnNode(4));
            list.add((AbstractInsnNode)new TypeInsnNode(189, "net/minecraft/block/state/IBlockState"));
            list.add((AbstractInsnNode)new InsnNode(89));
            list.add((AbstractInsnNode)new InsnNode(3));
            list.add((AbstractInsnNode)new FieldInsnNode(178, "net/minecraft/init/Blocks", ASMNameHelper.field_stone.get(), "Lnet/minecraft/block/Block;"));
            list.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/block/Block", ASMNameHelper.method_getDefaultState.get(), "()Lnet/minecraft/block/state/IBlockState;", false));
            list.add((AbstractInsnNode)new InsnNode(83));
            list.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraft/world/biome/Biome", "actualFillerBlocks", "[Lnet/minecraft/block/state/IBlockState;"));
            node.instructions.insert(list);
            ModBiomeTweakerCore.logger.debug("Successfully inserted empty array into 'actualFillerBlocks'");
            ++fixed;
            list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new FieldInsnNode(178, "net/minecraft/world/biome/Biome", ASMNameHelper.field_BiomeGenBase_stone.get(), "Lnet/minecraft/block/state/IBlockState;"));
            list.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraft/world/biome/Biome", "oceanFillerBlock", "Lnet/minecraft/block/state/IBlockState;"));
            node.instructions.insert(list);
            ModBiomeTweakerCore.logger.debug("Successfully inserted stone into 'oceanFillerBlock'");
            ++fixed;
            list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new FieldInsnNode(178, "net/minecraft/world/biome/Biome", ASMNameHelper.field_BiomeGenBase_gravel.get(), "Lnet/minecraft/block/state/IBlockState;"));
            list.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraft/world/biome/Biome", "oceanTopBlock", "Lnet/minecraft/block/state/IBlockState;"));
            node.instructions.insert(list);
            ModBiomeTweakerCore.logger.debug("Successfully inserted gravel into 'oceanTopBlock'");
            ++fixed;
            list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new InsnNode(2));
            list.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraft/world/biome/Biome", "grassColor", "I"));
            node.instructions.insert(list);
            ModBiomeTweakerCore.logger.debug("Successfully inserted -1 into 'grassColor'");
            ++fixed;
            list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new InsnNode(2));
            list.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraft/world/biome/Biome", "foliageColor", "I"));
            node.instructions.insert(list);
            ModBiomeTweakerCore.logger.debug("Successfully inserted -1 into 'foliageColor'");
            ++fixed;
            list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new InsnNode(2));
            list.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraft/world/biome/Biome", "skyColor", "I"));
            node.instructions.insert(list);
            ModBiomeTweakerCore.logger.debug("Successfully inserted -1 into 'skyColor'");
            ++fixed;
        }
        if (!sky) {
            ModBiomeTweakerCore.logger.warn("Failed to insert sky color instructions. If this is a server, don't worry. If if this a client, worry. A lot.");
        }
        if (fixed < 15) {
            ModBiomeTweakerCore.logger.error("Failed to completely patch " + transformedName + "! Only " + fixed + " patches were processed. Ye who continue now abandon all hope.");
            ModBiomeTweakerCore.logger.error("Seriously, this is really bad. Things are probably going to break.");
        } else if (fixed > 15) {
            ModBiomeTweakerCore.logger.warn("Sucessfully patched " + transformedName + ", but " + fixed + " patches were applied when we were expecting 15" + ". Is something else also patching this class?");
        } else {
            ModBiomeTweakerCore.logger.info("Sucessfully patched " + transformedName + "! " + fixed + " patches were applied.");
            BiomeTweakerCore.modifySuccess = true;
        }
        return ASMHelper.writeClassToBytes(cNode);
    }

    @Override
    public String[] getClassesToTransform() {
        return new String[]{ASMNameHelper.class_biomeGenBase.get()};
    }

    @Override
    public String getModuleName() {
        return "moduleTransformBiome";
    }

    @Override
    public boolean isRequired() {
        return true;
    }
}

