/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collections;
import me.superckl.api.biometweaker.script.wrapper.BTParameterTypes;
import me.superckl.api.superscript.ScriptCommandManager;
import me.superckl.api.superscript.ScriptCommandRegistry;
import me.superckl.api.superscript.ScriptHandler;
import me.superckl.api.superscript.ScriptParser;
import me.superckl.api.superscript.object.ScriptObject;
import me.superckl.api.superscript.util.ConstructorListing;
import me.superckl.api.superscript.util.ParameterWrapper;
import me.superckl.biometweaker.config.Config;
import me.superckl.biometweaker.core.BiomeTweakerCore;
import me.superckl.biometweaker.integration.IntegrationManager;
import me.superckl.biometweaker.proxy.IProxy;
import me.superckl.biometweaker.script.object.BiomesScriptObject;
import me.superckl.biometweaker.script.object.TweakerScriptObject;
import me.superckl.biometweaker.server.command.CommandInfo;
import me.superckl.biometweaker.server.command.CommandListBiomes;
import me.superckl.biometweaker.server.command.CommandOutput;
import me.superckl.biometweaker.server.command.CommandReload;
import me.superckl.biometweaker.server.command.CommandReloadScript;
import me.superckl.biometweaker.server.command.CommandSetBiome;
import me.superckl.biometweaker.util.BiomeHelper;
import me.superckl.biometweaker.util.LogHelper;
import net.minecraft.command.ICommand;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

@Mod(modid="biometweaker", name="BiomeTweaker", version="2.3.239", guiFactory="me.superckl.biometweaker.client.gui.GuiFactory", acceptableRemoteVersions="*", certificateFingerprint="bdea6e9d19f35da4858ffcc93210c6207dd590bd", dependencies="before:BiomesOPlenty; after:GalacticraftCore", acceptedMinecraftVersions="[1.10.2]")
public class BiomeTweaker {
    @Mod.Instance(value="biometweaker")
    private static BiomeTweaker instance;
    private boolean signed = true;
    @SidedProxy(clientSide="me.superckl.biometweaker.proxy.ClientProxy", serverSide="me.superckl.biometweaker.proxy.ServerProxy")
    private static IProxy proxy;

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent e) {
        this.signed = false;
        LogHelper.warn("Hey... uhm... this is akward but, it looks like you're using an unofficial version of BiomeTweaker. Where exactly did you get this from?");
        LogHelper.warn("Unless I (superckl) sent you this version, don't expect to get any support for it.");
    }

    @Mod.EventHandler
    public void onConstruction(FMLConstructionEvent e) {
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"BiomeTweaker Construction", (int)1, (boolean)true);
        bar.step("Populating script commands");
        try {
            ScriptCommandRegistry.INSTANCE.registerClassListing(BiomesScriptObject.class, BiomesScriptObject.populateCommands());
            ScriptCommandRegistry.INSTANCE.registerClassListing(TweakerScriptObject.class, TweakerScriptObject.populateCommands());
        }
        catch (Exception e2) {
            LogHelper.error("Failed to populate command listings! Some tweaks may not be applied.");
            e2.printStackTrace();
        }
        ScriptHandler.registerStaticObject("Tweaker", TweakerScriptObject.class);
        try {
            ConstructorListing<ScriptObject> listing = new ConstructorListing<ScriptObject>();
            listing.addEntry(Lists.newArrayList((Object[])new ParameterWrapper[]{BTParameterTypes.BASIC_BIOMES_PACKAGE.getVarArgsWrapper()}), BiomesScriptObject.class.getDeclaredConstructor(new Class[0]));
            ScriptParser.registerValidObjectInst("forBiomes", listing);
            listing = new ConstructorListing();
            listing.addEntry(Lists.newArrayList((Object[])new ParameterWrapper[]{BTParameterTypes.TYPE_BIOMES_PACKAGE.getSpecialWrapper()}), BiomesScriptObject.class.getDeclaredConstructor(new Class[0]));
            ScriptParser.registerValidObjectInst("forBiomesOfTypes", listing);
            listing = new ConstructorListing();
            listing.addEntry(Lists.newArrayList((Object[])new ParameterWrapper[]{BTParameterTypes.ALL_BIOMES_PACKAGE.getSpecialWrapper()}), BiomesScriptObject.class.getDeclaredConstructor(new Class[0]));
            ScriptParser.registerValidObjectInst("forAllBiomes", listing);
            listing = new ConstructorListing();
            listing.addEntry(Lists.newArrayList((Object[])new ParameterWrapper[]{BTParameterTypes.ALL_BUT_BIOMES_PACKAGE.getSpecialWrapper()}), BiomesScriptObject.class.getDeclaredConstructor(new Class[0]));
            ScriptParser.registerValidObjectInst("forAllBiomesExcept", listing);
            listing = new ConstructorListing();
            listing.addEntry(Lists.newArrayList((Object[])new ParameterWrapper[]{BTParameterTypes.INTERSECT_BIOMES_PACKAGE.getSpecialWrapper()}), BiomesScriptObject.class.getDeclaredConstructor(new Class[0]));
            ScriptParser.registerValidObjectInst("intersectionOf", listing);
            listing = new ConstructorListing();
            listing.addEntry(Lists.newArrayList((Object[])new ParameterWrapper[]{BTParameterTypes.SUBTRACT_BIOMES_PACKAGE.getSpecialWrapper()}), BiomesScriptObject.class.getDeclaredConstructor(new Class[0]));
            ScriptParser.registerValidObjectInst("subtractFrom", listing);
        }
        catch (Exception e2) {
            LogHelper.error("Failed to populate object listings! Some tweaks may not be applied.");
            e2.printStackTrace();
        }
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
    }

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent e) {
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"BiomeTweaker PreInitialization", (int)4, (boolean)true);
        bar.step("Pre-Initializing Integration");
        IntegrationManager.INSTANCE.preInit();
        bar.step("Parsing scripts");
        this.parseScripts();
        bar.step("Registering handlers");
        proxy.registerHandlers();
        bar.step("Applying scripts");
        Config.INSTANCE.getCommandManager().applyCommandsFor(ScriptCommandManager.ApplicationStage.PRE_INIT);
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
    }

    public void parseScripts() {
        try {
            LogHelper.info("Beginning script parsing...");
            long diff = 0L;
            long time = System.currentTimeMillis();
            for (JsonElement listElement : Config.INSTANCE.getIncludes()) {
                File subFile = null;
                try {
                    String item = listElement.getAsString();
                    subFile = new File(Config.INSTANCE.getWhereAreWe(), item);
                    this.parseScript(subFile);
                }
                catch (Exception e1) {
                    LogHelper.error("Failed to parse a script file! File: " + subFile);
                    e1.printStackTrace();
                }
            }
            File scripts = new File(Config.INSTANCE.getWhereAreWe(), "scripts/");
            for (File script : scripts.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".cfg");
                }
            })) {
                try {
                    this.parseScript(script);
                }
                catch (Exception e1) {
                    LogHelper.error("Failed to parse a script file! File: " + script);
                    e1.printStackTrace();
                }
            }
            diff = System.currentTimeMillis() - time;
            LogHelper.info("Finished script parsing.");
            LogHelper.debug("Script parsing took " + diff + "ms.");
        }
        catch (Exception e) {
            throw new RuntimeException("An unexpected error occurred while processing script files. Parsing may be incomplete. Ensure BiomeTweakerCore was called successfully.", e);
        }
    }

    public void parseScript(File file) throws IOException {
        if (!file.exists()) {
            LogHelper.debug(String.format("Subfile %s not found. A blank one will be generated.", file.getName()));
            file.createNewFile();
        }
        ScriptParser.parseScriptFile(file);
        Config.INSTANCE.getCommandManager().setCurrentStage(ScriptCommandManager.ApplicationStage.FINISHED_LOAD);
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent e) throws InterruptedException {
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"BiomeTweaker Initialization", (int)2, (boolean)true);
        bar.step("Initializing Integration");
        IntegrationManager.INSTANCE.init();
        bar.step("Applying scripts");
        Config.INSTANCE.getCommandManager().applyCommandsFor(ScriptCommandManager.ApplicationStage.INIT);
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent e) {
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"BiomeTweaker Initialization", (int)2, (boolean)true);
        bar.step("Post-Initializing Integration");
        IntegrationManager.INSTANCE.postInit();
        bar.step("Applying scripts");
        Config.INSTANCE.getCommandManager().applyCommandsFor(ScriptCommandManager.ApplicationStage.POST_INIT);
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
    }

    @Mod.EventHandler
    public void onLoadComplete(FMLLoadCompleteEvent e) throws IOException {
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"BiomeTweaker Initialization", (int)2, (boolean)true);
        bar.step("Applying scripts");
        Config.INSTANCE.getCommandManager().applyCommandsFor(ScriptCommandManager.ApplicationStage.FINISHED_LOAD);
        bar.step("Generating biome output files");
        this.generateOutputFiles();
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateOutputFiles() throws IOException {
        LogHelper.info("Generating biome status report...");
        JsonArray array = new JsonArray();
        for (Biome gen : Biome.field_185377_q) {
            if (gen == null) continue;
            array.add((JsonElement)BiomeHelper.fillJsonObject(gen, new int[0]));
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        File dir = new File(BiomeTweakerCore.mcLocation, "/config/BiomeTweaker/output/");
        dir.mkdirs();
        for (File file : dir.listFiles()) {
            if (!file.getName().endsWith(".json")) continue;
            file.delete();
        }
        if (Config.INSTANCE.isOutputSeperateFiles()) {
            for (JsonElement element : array) {
                JsonObject obj = (JsonObject)element;
                File output = new File(dir, obj.get("Name").getAsString().replaceAll("[^a-zA-Z0-9.-]", "_") + ".json");
                if (output.exists()) {
                    output.delete();
                }
                output.createNewFile();
                BufferedWriter writer = new BufferedWriter(new FileWriter(output));
                try {
                    writer.newLine();
                    writer.write(gson.toJson((JsonElement)obj));
                }
                finally {
                    if (Collections.singletonList(writer).get(0) == null) continue;
                    writer.close();
                }
            }
        } else {
            File output = new File(dir, "BiomeTweaker - Biome Status Report.json");
            if (output.exists()) {
                output.delete();
            }
            output.createNewFile();
            BufferedWriter writer = new BufferedWriter(new FileWriter(output));
            try {
                writer.write("//Yeah, it's a doozy.");
                writer.newLine();
                writer.write(gson.toJson((JsonElement)array));
            }
            finally {
                if (Collections.singletonList(writer).get(0) != null) {
                    writer.close();
                }
            }
        }
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent e) {
        e.registerServerCommand((ICommand)new CommandReload());
        e.registerServerCommand((ICommand)new CommandInfo());
        e.registerServerCommand((ICommand)new CommandOutput());
        e.registerServerCommand((ICommand)new CommandListBiomes());
        e.registerServerCommand((ICommand)new CommandSetBiome());
        e.registerServerCommand((ICommand)new CommandReloadScript());
        Config.INSTANCE.getCommandManager().applyCommandsFor(ScriptCommandManager.ApplicationStage.SERVER_STARTING);
    }

    @Mod.EventHandler
    public void onServerStarted(FMLServerStartedEvent e) {
        Config.INSTANCE.getCommandManager().applyCommandsFor(ScriptCommandManager.ApplicationStage.SERVER_STARTED);
    }

    public static BiomeTweaker getInstance() {
        return instance;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public static IProxy getProxy() {
        return proxy;
    }
}

