/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.api.superscript.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import me.superckl.api.superscript.ScriptHandler;
import me.superckl.api.superscript.util.ParameterType;
import org.apache.commons.lang3.tuple.Pair;

public class ParameterWrapper {
    private final ParameterType type;
    private final int minNum;
    private final int maxNum;
    private final boolean varArgs;

    protected ParameterWrapper(ParameterType type, int minNum, int maxNum, boolean varArgs) {
        this.type = type;
        this.minNum = minNum;
        this.maxNum = maxNum;
        this.varArgs = varArgs;
    }

    public Pair<Object[], String[]> parseArgs(ScriptHandler handler, String ... args) throws Exception {
        ArrayList parsed = Lists.newArrayList();
        int i = 0;
        while (true) {
            Object obj;
            if (!this.shouldCont(i, args.length) || (obj = this.type.tryParse(args[i], handler)) == null) break;
            if (obj instanceof Collection) {
                parsed.addAll((Collection)obj);
            } else if (obj != null) {
                parsed.add(obj);
            }
            ++i;
        }
        String[] newArgs = new String[args.length - i];
        System.arraycopy(args, i, newArgs, 0, newArgs.length);
        args = newArgs;
        return Pair.of((Object)parsed.toArray(), (Object)args);
    }

    private boolean shouldCont(int index, int argsLength) {
        if (!this.varArgs && index < argsLength) {
            if (index < this.minNum) {
                return true;
            }
            if (index >= this.maxNum) {
                return false;
            }
        }
        return index < argsLength;
    }

    public boolean canReturnNothing() {
        return this.minNum <= 0;
    }

    public ParameterType getType() {
        return this.type;
    }

    public int getMinNum() {
        return this.minNum;
    }

    public int getMaxNum() {
        return this.maxNum;
    }

    public boolean isVarArgs() {
        return this.varArgs;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ParameterType type;
        private int minNum;
        private int maxNum;
        private boolean varArgs;

        private Builder() {
        }

        public ParameterType type() {
            return this.type;
        }

        public Builder type(ParameterType type) {
            this.type = type;
            return this;
        }

        public int minNum() {
            return this.minNum;
        }

        public Builder minNum(int minNum) {
            this.minNum = minNum;
            return this;
        }

        public int maxNum() {
            return this.maxNum;
        }

        public Builder maxNum(int maxNum) {
            this.maxNum = maxNum;
            return this;
        }

        public boolean varArgs() {
            return this.varArgs;
        }

        public Builder varArgs(boolean varArgs) {
            this.varArgs = varArgs;
            return this;
        }

        public ParameterWrapper build() {
            return new ParameterWrapper(this.type, this.minNum, this.maxNum, this.varArgs);
        }
    }
}

